/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.AlfrescoConfigSection;
import org.alfresco.filesys.ExtendedServerConfigurationAccessor;
import org.alfresco.filesys.alfresco.AlfrescoClientInfoFactory;
import org.alfresco.filesys.alfresco.ExtendedDiskInterface;
import org.alfresco.jlan.debug.DebugConfigSection;
import org.alfresco.jlan.netbios.NetBIOSName;
import org.alfresco.jlan.netbios.NetBIOSNameList;
import org.alfresco.jlan.netbios.NetBIOSSession;
import org.alfresco.jlan.netbios.win32.Win32NetBIOS;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.auth.ClientInfoFactory;
import org.alfresco.jlan.server.config.GlobalConfigSection;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.util.IPAddress;
import org.alfresco.jlan.util.Platform;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerConfigurationBean
extends ServerConfiguration
implements ExtendedServerConfigurationAccessor,
ApplicationListener,
ApplicationContextAware {
    protected static final Log logger = LogFactory.getLog((String)"org.alfresco.fileserver");
    public static final String BIND_TO_IGNORE = "0.0.0.0";
    protected static final String[] m_sessDbgStr = new String[]{"NETBIOS", "STATE", "RXDATA", "TXDATA", "DUMPDATA", "NEGOTIATE", "TREE", "SEARCH", "INFO", "FILE", "FILEIO", "TRANSACT", "ECHO", "ERROR", "IPC", "LOCK", "PKTTYPE", "DCERPC", "STATECACHE", "TIMING", "NOTIFY", "STREAMS", "SOCKET", "PKTPOOL", "PKTSTATS", "THREADPOOL", "BENCHMARK", "OPLOCK"};
    protected static final String[] m_ftpDebugStr = new String[]{"STATE", "RXDATA", "TXDATA", "DUMPDATA", "SEARCH", "INFO", "FILE", "FILEIO", "ERROR", "PKTTYPE", "TIMING", "DATAPORT", "DIRECTORY", "SSL"};
    protected static final int DefaultFTPServerPort = 21;
    protected static final String DefaultFTPAnonymousAccount = "anonymous";
    protected static final String[] m_nfsDebugStr = new String[]{"RXDATA", "TXDATA", "DUMPDATA", "SEARCH", "INFO", "FILE", "FILEIO", "ERROR", "TIMING", "DIRECTORY", "SESSION"};
    protected static final String TokenLocalName = "${localname}";
    protected static final int DefaultThreadPoolInit = 25;
    protected static final int DefaultThreadPoolMax = 50;
    protected static final int[] DefaultMemoryPoolBufSizes = new int[]{256, 4096, 16384, 66000};
    protected static final int[] DefaultMemoryPoolInitAlloc = new int[]{20, 20, 5, 5};
    protected static final int[] DefaultMemoryPoolMaxAlloc = new int[]{100, 50, 50, 50};
    protected static final int MemoryPoolMinimumAllocation = 5;
    protected static final int MemoryPoolMaximumAllocation = 500;
    protected static final int MaxSessionTimeout = 3600;
    private ExtendedDiskInterface m_repoDiskInterface;
    private ExtendedDiskInterface m_avmDiskInterface;
    private Platform.Type m_platform = Platform.Type.Unchecked;
    private boolean m_initialised;
    private AuthenticationService m_authenticationService;
    protected AuthenticationComponent m_authenticationComponent;
    private NodeService m_nodeService;
    private PersonService m_personService;
    private TransactionService m_transactionService;
    protected TenantService m_tenantService;
    private SearchService m_searchService;
    private NamespaceService m_namespaceService;
    private AuthorityService m_authorityService;
    private String m_localName;
    private String m_localNameFull;
    private String m_localDomain;
    protected boolean m_disableNativeCode = false;
    private ApplicationContext applicationContext = null;

    public AbstractServerConfigurationBean() {
        super("");
    }

    public AbstractServerConfigurationBean(String srvName) {
        super(srvName);
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.m_authenticationService = authenticationService;
    }

    public void setDiskInterface(ExtendedDiskInterface diskInterface) {
        this.m_repoDiskInterface = diskInterface;
    }

    public void setAvmDiskInterface(ExtendedDiskInterface diskInterface) {
        this.m_avmDiskInterface = diskInterface;
    }

    public void setAuthenticationComponent(AuthenticationComponent component) {
        this.m_authenticationComponent = component;
    }

    public void setNodeService(NodeService service) {
        this.m_nodeService = service;
    }

    public void setPersonService(PersonService service) {
        this.m_personService = service;
    }

    public void setTransactionService(TransactionService service) {
        this.m_transactionService = service;
    }

    public void setTenantService(TenantService tenantService) {
        this.m_tenantService = tenantService;
    }

    public void setSearchService(SearchService searchService) {
        this.m_searchService = searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.m_namespaceService = namespaceService;
    }

    public void setAuthorityService(AuthorityService authService) {
        this.m_authorityService = authService;
    }

    public boolean isInitialised() {
        return this.m_initialised;
    }

    public final boolean isSMBServerEnabled() {
        return this.hasConfigSection("CIFS");
    }

    public final boolean isFTPServerEnabled() {
        return this.hasConfigSection("FTP");
    }

    public final boolean isNFSServerEnabled() {
        return this.hasConfigSection("NFS");
    }

    public final ExtendedDiskInterface getRepoDiskInterface() {
        return this.m_repoDiskInterface;
    }

    public final ExtendedDiskInterface getAvmDiskInterface() {
        return this.m_avmDiskInterface;
    }

    public void init() {
        if (this.m_authenticationComponent == null) {
            throw new AlfrescoRuntimeException("Property 'authenticationComponent' not set");
        }
        if (this.m_authenticationService == null) {
            throw new AlfrescoRuntimeException("Property 'authenticationService' not set");
        }
        if (this.m_nodeService == null) {
            throw new AlfrescoRuntimeException("Property 'nodeService' not set");
        }
        if (this.m_personService == null) {
            throw new AlfrescoRuntimeException("Property 'personService' not set");
        }
        if (this.m_transactionService == null) {
            throw new AlfrescoRuntimeException("Property 'transactionService' not set");
        }
        if (this.m_repoDiskInterface == null) {
            throw new AlfrescoRuntimeException("Property 'diskInterface' not set");
        }
        if (this.m_authorityService == null) {
            throw new AlfrescoRuntimeException("Property 'authorityService' not set");
        }
        this.determinePlatformType();
        DebugConfigSection debugConfig = new DebugConfigSection((ServerConfiguration)this);
        try {
            debugConfig.setDebug("org.alfresco.filesys.debug.FileServerDebugInterface", null);
        }
        catch (InvalidConfigurationException ex) {
            // empty catch block
        }
        new GlobalConfigSection((ServerConfiguration)this);
        new AlfrescoConfigSection(this);
        ClientInfo.setFactory((ClientInfoFactory)new AlfrescoClientInfoFactory());
        try {
            this.processWINSServerConfig();
        }
        catch (Exception ex) {
            logger.error((Object)("File server configuration error (WINS), " + ex.getMessage()), (Throwable)ex);
        }
        try {
            this.processCoreServerConfig();
            this.processSecurityConfig();
            this.processFilesystemsConfig();
        }
        catch (Exception ex) {
            throw new AlfrescoRuntimeException("File server configuration error, " + ex.getMessage(), (Throwable)ex);
        }
        try {
            this.processCIFSServerConfig();
            logger.info((Object)("CIFS server " + (this.isSMBServerEnabled() ? "" : "NOT ") + "started"));
        }
        catch (UnsatisfiedLinkError ex) {
            logger.error((Object)"Error accessing Win32 NetBIOS, check DLL is on the path");
            this.removeConfigSection("CIFS");
        }
        catch (Throwable ex) {
            logger.error((Object)("CIFS server configuration error, " + ex.getMessage()), ex);
            this.removeConfigSection("CIFS");
        }
        try {
            this.processFTPServerConfig();
            logger.info((Object)("FTP server " + (this.isFTPServerEnabled() ? "" : "NOT ") + "started"));
        }
        catch (Exception ex) {
            logger.error((Object)("FTP server configuration error, " + ex.getMessage()), (Throwable)ex);
        }
        try {
            this.processNFSServerConfig();
            logger.info((Object)("NFS server " + (this.isNFSServerEnabled() ? "" : "NOT ") + "started"));
        }
        catch (Exception ex) {
            logger.error((Object)("NFS server configuration error, " + ex.getMessage()), (Throwable)ex);
        }
    }

    protected abstract void processCoreServerConfig() throws InvalidConfigurationException;

    protected abstract void processSecurityConfig();

    protected abstract void processFilesystemsConfig();

    protected abstract void processCIFSServerConfig();

    protected abstract void processNFSServerConfig();

    protected abstract void processFTPServerConfig();

    protected void processWINSServerConfig() {
    }

    public final void closeConfiguration() {
        super.closeConfiguration();
    }

    private final void determinePlatformType() {
        if (this.m_platform == Platform.Type.Unchecked) {
            this.m_platform = Platform.isPlatformType();
        }
    }

    protected final EnumSet<Platform.Type> parsePlatformString(String platformStr) {
        EnumSet<Platform.Type> platformTypes = EnumSet.noneOf(Platform.Type.class);
        if (platformStr == null || platformStr.length() == 0) {
            return platformTypes;
        }
        StringTokenizer token = new StringTokenizer(platformStr.toUpperCase(Locale.ENGLISH), ",");
        String typ = null;
        try {
            while (token.hasMoreTokens()) {
                typ = token.nextToken().trim();
                Platform.Type platform = Platform.Type.valueOf((String)typ);
                if (platform != Platform.Type.Unknown) {
                    platformTypes.add(platform);
                    continue;
                }
                throw new AlfrescoRuntimeException("Invalid platform type, " + typ);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new AlfrescoRuntimeException("Invalid platform type, " + typ);
        }
        return platformTypes;
    }

    @Override
    public final String getLocalServerName(boolean trimDomain) {
        int pos;
        if (!trimDomain) {
            return this.getLocalServerName();
        }
        if (this.m_localName != null) {
            return this.m_localName;
        }
        String srvName = this.getLocalServerName();
        if (trimDomain && srvName != null && (pos = srvName.indexOf(".")) != -1) {
            srvName = srvName.substring(0, pos);
        }
        this.m_localName = srvName;
        return srvName;
    }

    private String getLocalServerName() {
        if (this.m_localNameFull != null) {
            return this.m_localNameFull;
        }
        String srvName = null;
        if (this.getPlatformType() == Platform.Type.WINDOWS && !this.isNativeCodeDisabled()) {
            srvName = Win32NetBIOS.GetLocalNetBIOSName();
        } else {
            try {
                srvName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        this.m_localNameFull = srvName;
        return srvName;
    }

    @Override
    public final String getLocalDomainName() {
        if (this.m_localDomain != null) {
            return this.m_localDomain;
        }
        String domainName = null;
        if (this.getPlatformType() == Platform.Type.WINDOWS && !this.isNativeCodeDisabled()) {
            domainName = Win32NetBIOS.GetLocalDomainName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Local domain name is " + domainName + " (via JNI)"));
            }
        } else {
            NetBIOSName nbName = null;
            try {
                NetBIOSNameList nbNameList;
                nbName = NetBIOSSession.FindName((String)"\u0001\u0002__MSBROWSE__\u0002", (char)'\u0001', (int)5000);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found browse master at " + nbName.getIPAddressString(0)));
                }
                if ((nbNameList = NetBIOSSession.FindNamesForAddress((String)nbName.getIPAddressString(0))) != null && (nbName = nbNameList.findName('\u001d', false)) != null) {
                    domainName = nbName.getName();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_localDomain = domainName;
        return domainName;
    }

    protected final InetAddress parseAdapterName(String adapter) throws InvalidConfigurationException {
        NetworkInterface ni = null;
        try {
            ni = NetworkInterface.getByName(adapter);
        }
        catch (SocketException ex) {
            throw new InvalidConfigurationException("Invalid adapter name, " + adapter);
        }
        if (ni == null) {
            throw new InvalidConfigurationException("Invalid network adapter name, " + adapter);
        }
        InetAddress adapAddr = null;
        Enumeration<InetAddress> addrEnum = ni.getInetAddresses();
        while (addrEnum.hasMoreElements() && adapAddr == null) {
            InetAddress addr = addrEnum.nextElement();
            if (!IPAddress.isNumericAddress((String)addr.getHostAddress())) continue;
            adapAddr = addr;
        }
        if (adapAddr == null) {
            throw new InvalidConfigurationException("Adapter " + adapter + " does not have a valid IP address");
        }
        return adapAddr;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        ContextRefreshedEvent refreshEvent;
        ApplicationContext refreshContext;
        if (event instanceof ContextRefreshedEvent && (refreshContext = (refreshEvent = (ContextRefreshedEvent)event).getApplicationContext()) != null && refreshContext.equals(this.applicationContext)) {
            this.init();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected final AuthenticationService getAuthenticationService() {
        return this.m_authenticationService;
    }

    protected final AuthenticationComponent getAuthenticationComponent() {
        return this.m_authenticationComponent;
    }

    protected final NodeService getNodeService() {
        return this.m_nodeService;
    }

    protected final PersonService getPersonService() {
        return this.m_personService;
    }

    protected final TransactionService getTransactionService() {
        return this.m_transactionService;
    }

    protected final TenantService getTenantService() {
        return this.m_tenantService;
    }

    protected final SearchService getSearchService() {
        return this.m_searchService;
    }

    protected final NamespaceService getNamespaceService() {
        return this.m_namespaceService;
    }

    public final boolean isNativeCodeDisabled() {
        return this.m_disableNativeCode;
    }

    public final Object getBean(String beanName) {
        return this.applicationContext.getBean(beanName);
    }

    public final ApplicationContext getApplicationsContext() {
        return this.applicationContext;
    }

    public final AuthorityService getAuthorityService() {
        return this.m_authorityService;
    }
}

