/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.avm;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.alfresco.AlfrescoNetworkFile;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DiskFullException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.usage.ContentQuotaException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AVMNetworkFile
extends AlfrescoNetworkFile {
    private static final Log logger = LogFactory.getLog(AVMNetworkFile.class);
    private NodeService m_nodeService;
    private AVMService m_avmService;
    private String m_avmPath;
    private int m_avmVersion;
    private boolean m_modified;
    private FileChannel m_channel;
    private ContentWriter m_content;
    private boolean m_writable;
    private String m_mimeType;

    public AVMNetworkFile(AVMNodeDescriptor details, String avmPath, int avmVersion, NodeService nodeService, AVMService avmService) {
        super(details.getName());
        this.m_nodeService = nodeService;
        this.m_avmService = avmService;
        this.m_avmPath = avmPath;
        this.m_avmVersion = avmVersion;
        this.setAccessDate(details.getAccessDate());
        this.setCreationDate(details.getCreateDate());
        this.setModifyDate(details.getModDate());
        if (details.isFile()) {
            this.setFileSize(details.getLength());
        } else {
            this.setFileSize(0L);
        }
        int attr = 0;
        if (details.isDirectory()) {
            attr += 16;
        }
        if (avmVersion != -1) {
            ++attr;
        }
        this.setAttributes(attr);
    }

    public final boolean hasContentChannel() {
        return this.m_channel != null;
    }

    public final String getMimeType() {
        return this.m_mimeType;
    }

    public final void setMimeType(String mimeType) {
        this.m_mimeType = mimeType;
    }

    public void openFile(boolean createFlag) throws IOException {
    }

    public int readFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Read file " + this.getName() + ", len=" + len + ", offset=" + fileOff));
        }
        this.openContent(false, false);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buf, pos, len);
        int count = this.m_channel.read(byteBuffer, fileOff);
        if (count < 0) {
            count = 0;
        }
        return count;
    }

    public void writeFile(byte[] buf, int len, int pos, long fileOff) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Write file " + this.getName() + ", len=" + len + ", offset=" + fileOff));
        }
        this.openContent(true, false);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buf, pos, len);
        this.m_channel.write(byteBuffer, fileOff);
        this.m_modified = true;
        this.incrementWriteCount();
        this.setFileSize(this.m_channel.size());
    }

    public long seekFile(long pos, int typ) throws IOException {
        this.openContent(false, false);
        long curPos = this.m_channel.position();
        switch (typ) {
            case 0: {
                if (curPos == pos) break;
                this.m_channel.position(pos);
                break;
            }
            case 1: {
                this.m_channel.position(curPos + pos);
                break;
            }
            case 2: {
                long newPos = this.m_channel.size() + pos;
                this.m_channel.position(newPos);
            }
        }
        return this.m_channel.position();
    }

    public void flushFile() throws IOException {
        if (this.m_channel != null && this.m_writable) {
            this.m_channel.force(false);
        }
    }

    public void truncateFile(long siz) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Truncate file " + this.getName() + ", size=" + siz));
        }
        if (this.m_channel == null && siz == 0L) {
            this.openContent(true, true);
        } else {
            this.openContent(true, false);
            this.m_channel.truncate(siz);
        }
        this.m_modified = true;
        this.incrementWriteCount();
    }

    public void closeFile() throws IOException {
        if (this.isDirectory() || this.m_channel == null && this.m_content == null) {
            return;
        }
        if (this.m_channel != null) {
            try {
                this.m_channel.close();
                this.m_channel = null;
            }
            catch (IOException ex) {
                if (RetryingTransactionHelper.extractRetryCause(ex) != null) {
                    throw ex;
                }
                logger.error((Object)("Failed to close file channel for " + this.getName()), (Throwable)ex);
            }
        }
        if (this.m_content != null) {
            ContentData contentData = this.m_content.getContentData();
            try {
                NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, this.m_avmPath);
                this.m_nodeService.setProperty(nodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
            }
            catch (ContentQuotaException qe) {
                throw new DiskFullException(qe.getMessage());
            }
            AlfrescoTransactionSupport.bindListener(new TransactionListenerAdapter(){

                public void afterCommit() {
                    AVMNetworkFile.this.m_content = null;
                }
            });
        }
    }

    private void openContent(boolean write, boolean trunc) throws AccessDeniedException, AlfrescoRuntimeException {
        if (this.isDirectory()) {
            throw new AlfrescoRuntimeException("Unable to open channel for a directory network file: " + (Object)((Object)this));
        }
        long curPos = 0L;
        if (write && !this.m_writable && this.m_channel != null) {
            try {
                curPos = this.m_channel.position();
                this.m_channel.close();
                this.m_channel = null;
            }
            catch (IOException ex) {
                logger.error((Object)"Error closing read-only channel", (Throwable)ex);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Switching to writable channel for " + this.getName()));
            }
        } else if (this.m_channel != null) {
            return;
        }
        if (write && this.getGrantedAccess() == 0) {
            throw new AccessDeniedException("The network file was created for read-only: " + (Object)((Object)this));
        }
        if (write) {
            this.m_content = null;
            try {
                this.m_content = this.m_avmService.getContentWriter(this.m_avmPath, false);
                this.m_content.setMimetype(this.getMimeType());
            }
            catch (Exception ex) {
                logger.debug((Object)ex);
                ex.printStackTrace();
            }
            this.m_writable = true;
            this.m_channel = this.m_content.getFileChannel(trunc);
            if (curPos != 0L && !trunc) {
                try {
                    this.m_channel.position(curPos);
                }
                catch (IOException ex) {
                    logger.error((Object)("Failed to set file position for " + this.getName()), (Throwable)ex);
                }
            }
        } else {
            ContentReader cReader = this.m_avmService.getContentReader(this.m_avmVersion, this.m_avmPath);
            this.m_writable = false;
            this.m_channel = cReader.getFileChannel();
        }
    }

    public final boolean isWritable() {
        return this.m_writable;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getName());
        str.append(":");
        str.append(this.isDirectory() ? "Dir," : "File,");
        str.append(this.getFileSize());
        str.append("-Channel=");
        str.append(this.m_channel);
        str.append(this.m_writable ? ",Write" : ",Read");
        str.append(this.m_modified ? ",Modified" : "");
        str.append("]");
        return str.toString();
    }
}

