/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.config;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.AbstractServerConfigurationBean;
import org.alfresco.filesys.alfresco.ExtendedDiskInterface;
import org.alfresco.filesys.avm.AVMContext;
import org.alfresco.filesys.avm.AVMDiskDriver;
import org.alfresco.filesys.config.CIFSConfigBean;
import org.alfresco.filesys.config.CoreServerConfigBean;
import org.alfresco.filesys.config.DomainMappingConfigBean;
import org.alfresco.filesys.config.FTPConfigBean;
import org.alfresco.filesys.config.MemoryPacketConfigBean;
import org.alfresco.filesys.config.NFSConfigBean;
import org.alfresco.filesys.config.SecurityConfigBean;
import org.alfresco.filesys.config.acl.AccessControlListBean;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.jlan.ftp.FTPAuthenticator;
import org.alfresco.jlan.ftp.FTPConfigSection;
import org.alfresco.jlan.ftp.FTPPath;
import org.alfresco.jlan.ftp.InvalidPathException;
import org.alfresco.jlan.netbios.NetBIOSSession;
import org.alfresco.jlan.netbios.win32.Win32NetBIOS;
import org.alfresco.jlan.oncrpc.RpcAuthenticator;
import org.alfresco.jlan.oncrpc.nfs.NFSConfigSection;
import org.alfresco.jlan.server.auth.acl.AccessControlList;
import org.alfresco.jlan.server.auth.passthru.DomainMapping;
import org.alfresco.jlan.server.auth.passthru.RangeDomainMapping;
import org.alfresco.jlan.server.auth.passthru.SubnetDomainMapping;
import org.alfresco.jlan.server.config.CoreServerConfigSection;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.SecurityConfigSection;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.core.DeviceInterface;
import org.alfresco.jlan.server.core.ShareMapper;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FilesystemsConfigSection;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.util.IPAddress;
import org.alfresco.jlan.util.MemorySize;
import org.alfresco.jlan.util.Platform;
import org.alfresco.jlan.util.StringList;
import org.alfresco.jlan.util.X64;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.element.GenericConfigElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConfigurationBean
extends AbstractServerConfigurationBean {
    private CIFSConfigBean cifsConfigBean;
    private FTPConfigBean ftpConfigBean;
    private NFSConfigBean nfsConfigBean;
    private List<DeviceContext> filesystemContexts;
    private boolean avmAllStores;
    private SecurityConfigBean securityConfigBean;
    private CoreServerConfigBean coreServerConfigBean;

    public ServerConfigurationBean() {
        super("");
    }

    public ServerConfigurationBean(String srvName) {
        super(srvName);
    }

    public void setCifsConfigBean(CIFSConfigBean cifsConfigBean) {
        this.cifsConfigBean = cifsConfigBean;
    }

    public void setFtpConfigBean(FTPConfigBean ftpConfigBean) {
        this.ftpConfigBean = ftpConfigBean;
    }

    public void setNfsConfigBean(NFSConfigBean nfsConfigBean) {
        this.nfsConfigBean = nfsConfigBean;
    }

    public void setFilesystemContexts(List<DeviceContext> filesystemContexts) {
        this.filesystemContexts = filesystemContexts;
    }

    public void setAvmAllStores(boolean avmAllStores) {
        this.avmAllStores = avmAllStores;
    }

    public void setSecurityConfigBean(SecurityConfigBean securityConfigBean) {
        this.securityConfigBean = securityConfigBean;
    }

    public void setCoreServerConfigBean(CoreServerConfigBean coreServerConfigBean) {
        this.coreServerConfigBean = coreServerConfigBean;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void processCIFSServerConfig() {
        if (this.cifsConfigBean == null) {
            this.removeConfigSection("CIFS");
            return;
        }
        if (!this.cifsConfigBean.getServerEnabled()) {
            this.removeConfigSection("CIFS");
            return;
        }
        authenticator = this.cifsConfigBean.getAuthenticator();
        if (authenticator == null || authenticator instanceof ActivateableBean && !((ActivateableBean)authenticator).isActive()) {
            ServerConfigurationBean.logger.warn((Object)"No enabled CIFS authenticator found in authentication chain. CIFS Server disabled");
            this.removeConfigSection("CIFS");
            return;
        }
        cifsConfig = new CIFSConfigSection((ServerConfiguration)this);
        try {
            block129: {
                if (this.cifsConfigBean.getDisableNativeCode()) {
                    cifsConfig.setNativeCodeDisabled(true);
                    this.m_disableNativeCode = true;
                    ServerConfigurationBean.logger.warn((Object)"CIFS server native calls disabled, JNI code will not be used");
                }
                if ((broadcastAddess = this.cifsConfigBean.getBroadcastAddress()) != null && broadcastAddess.length() > 0) {
                    if (!IPAddress.isNumericAddress((String)broadcastAddess)) {
                        throw new AlfrescoRuntimeException("Invalid broadcast mask, must be n.n.n.n format");
                    }
                    cifsConfig.setBroadcastMask(broadcastAddess);
                }
                if ((hostName = this.cifsConfigBean.getServerName()) == null || hostName.length() == 0) {
                    throw new AlfrescoRuntimeException("Host name not specified or invalid");
                }
                pos = hostName.indexOf("${localname}");
                if (pos != -1) {
                    srvName = this.getLocalServerName(true);
                    hostStr = new StringBuilder();
                    hostStr.append(hostName.substring(0, pos));
                    hostStr.append(srvName);
                    if ((pos += "${localname}".length()) < hostName.length()) {
                        hostStr.append(hostName.substring(pos));
                    }
                    if ((hostName = hostStr.toString()).equals(srvName) && this.getPlatformType() == Platform.Type.WINDOWS) {
                        throw new AlfrescoRuntimeException("CIFS server name must be unique");
                    }
                }
                if (hostName.length() > 15) {
                    hostName = hostName.substring(0, 15);
                    ServerConfigurationBean.logger.warn((Object)("CIFS server name is longer than 15 characters, truncated to " + hostName));
                }
                cifsConfig.setServerName(hostName.toUpperCase());
                this.setServerName(hostName.toUpperCase());
                domain = this.cifsConfigBean.getDomainName();
                if (domain != null && domain.length() > 0) {
                    cifsConfig.setDomainName(domain.toUpperCase());
                } else {
                    localDomain = this.getLocalDomainName();
                    if (localDomain == null && (this.getPlatformType() != Platform.Type.WINDOWS || this.isNativeCodeDisabled())) {
                        localDomain = "WORKGROUP";
                        ServerConfigurationBean.logger.error((Object)("Failed to get local domain/workgroup name, using default of " + localDomain));
                        ServerConfigurationBean.logger.error((Object)"(This may be due to firewall settings or incorrect <broadcast> setting)");
                    }
                    cifsConfig.setDomainName(localDomain);
                }
                comment = this.cifsConfigBean.getServerComment();
                if (comment != null && comment.length() > 0) {
                    cifsConfig.setComment(comment);
                }
                if ((bindToAdapter = this.cifsConfigBean.getBindToAdapter()) != null && bindToAdapter.length() > 0) {
                    bindAddr = this.parseAdapterName(bindToAdapter);
                    cifsConfig.setSMBBindAddress(bindAddr);
                } else {
                    bindTo = this.cifsConfigBean.getBindToAddress();
                    if (bindTo != null && bindTo.length() > 0 && !bindTo.equals("0.0.0.0")) {
                        try {
                            bindAddr = InetAddress.getByName(bindTo);
                            cifsConfig.setSMBBindAddress(bindAddr);
                        }
                        catch (UnknownHostException ex) {
                            throw new AlfrescoRuntimeException("Invalid CIFS server bind address");
                        }
                    }
                }
                if (authenticator == null) {
                    throw new AlfrescoRuntimeException("CIFS authenticator not specified");
                }
                cifsConfig.setAuthenticator(authenticator);
                if (!this.cifsConfigBean.getHostAccouncerEnabled()) {
                    cifsConfig.setHostAnnouncer(false);
                    ServerConfigurationBean.logger.info((Object)"Host announcements not enabled");
                } else {
                    interval = this.cifsConfigBean.getHostAccounceInterval();
                    if (interval != null) {
                        cifsConfig.setHostAnnounceInterval(interval.intValue());
                    }
                    if (cifsConfig.getDomainName() == null) {
                        throw new AlfrescoRuntimeException("Domain name must be specified if host announcement is enabled");
                    }
                    cifsConfig.setHostAnnouncer(true);
                }
                netBIOSSMBConfigBean = this.cifsConfigBean.getNetBIOSSMB();
                if (netBIOSSMBConfigBean != null) {
                    platformsStr = netBIOSSMBConfigBean.getPlatforms();
                    platformOK = false;
                    if (platformsStr != null && platformsStr.length() > 0) {
                        enabledPlatforms = this.parsePlatformString(platformsStr);
                        if (enabledPlatforms.contains(this.getPlatformType())) {
                            platformOK = true;
                        }
                    } else {
                        platformOK = true;
                    }
                    cifsConfig.setNetBIOSSMB(platformOK);
                    if (cifsConfig.hasNetBIOSSMB()) {
                        if (cifsConfig.getBroadcastMask() == null) {
                            throw new AlfrescoRuntimeException("Network broadcast mask not specified");
                        }
                        bindto = netBIOSSMBConfigBean.getBindTo();
                        if (bindto != null && bindto.length() > 0 && !bindto.equals("0.0.0.0")) {
                            try {
                                bindAddr = InetAddress.getByName(bindto);
                                cifsConfig.setNetBIOSBindAddress(bindAddr);
                            }
                            catch (UnknownHostException ex) {
                                throw new AlfrescoRuntimeException("Invalid NetBIOS bind address");
                            }
                        }
                        if (cifsConfig.hasSMBBindAddress()) {
                            cifsConfig.setNetBIOSBindAddress(cifsConfig.getSMBBindAddress());
                        } else {
                            addrs = null;
                            try {
                                addrs = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                            }
                            catch (UnknownHostException ex) {
                                ServerConfigurationBean.logger.error((Object)"Failed to get local address list", (Throwable)ex);
                            }
                            addrCnt = 0;
                            if (addrs != null) {
                                for (i = 0; i < addrs.length; ++i) {
                                    if (addrs[i].getHostAddress().equals("127.0.0.1") || addrs[i].getHostAddress().equals("0.0.0.0")) continue;
                                    ++addrCnt;
                                }
                            }
                            if (addrCnt == 0) {
                                niEnum = null;
                                try {
                                    niEnum = NetworkInterface.getNetworkInterfaces();
                                }
                                catch (SocketException ex) {
                                    // empty catch block
                                }
                                if (niEnum != null) {
                                    while (niEnum.hasMoreElements()) {
                                        ni = niEnum.nextElement();
                                        niAddrs = ni.getInetAddresses();
                                        if (niAddrs == null) continue;
                                        while (niAddrs.hasMoreElements()) {
                                            curAddr = niAddrs.nextElement();
                                            if (curAddr.getHostAddress().equals("127.0.0.1") || curAddr.getHostAddress().equals("0.0.0.0")) continue;
                                            ++addrCnt;
                                        }
                                    }
                                    if (addrCnt > 0 && ServerConfigurationBean.logger.isDebugEnabled()) {
                                        ServerConfigurationBean.logger.debug((Object)"Found valid IP address from interface list");
                                    }
                                }
                                if (addrCnt == 0) {
                                    if (ServerConfigurationBean.logger.isDebugEnabled()) {
                                        ServerConfigurationBean.logger.debug((Object)"Local address list dump :-");
                                        if (addrs != null) {
                                            for (i = 0; i < addrs.length; ++i) {
                                                ServerConfigurationBean.logger.debug((Object)("  Address: " + addrs[i]));
                                            }
                                        } else {
                                            ServerConfigurationBean.logger.debug((Object)"  No addresses");
                                        }
                                    }
                                    throw new AlfrescoRuntimeException("Failed to get IP address(es) for the local server, check hosts file and/or DNS setup");
                                }
                            }
                        }
                        portNum = netBIOSSMBConfigBean.getSessionPort();
                        if (portNum != null) {
                            cifsConfig.setSessionPort(portNum.intValue());
                            if (cifsConfig.getSessionPort() <= 0 || cifsConfig.getSessionPort() >= 65535) {
                                throw new AlfrescoRuntimeException("NetBIOS session port out of valid range");
                            }
                        }
                        if ((portNum = netBIOSSMBConfigBean.getNamePort()) != null) {
                            cifsConfig.setNameServerPort(portNum.intValue());
                            if (cifsConfig.getNameServerPort() <= 0 || cifsConfig.getNameServerPort() >= 65535) {
                                throw new AlfrescoRuntimeException("NetBIOS name port out of valid range");
                            }
                        }
                        if ((portNum = netBIOSSMBConfigBean.getDatagramPort()) != null) {
                            cifsConfig.setDatagramPort(portNum.intValue());
                            if (cifsConfig.getDatagramPort() <= 0 || cifsConfig.getDatagramPort() >= 65535) {
                                throw new AlfrescoRuntimeException("NetBIOS datagram port out of valid range");
                            }
                        }
                        if ((attr = netBIOSSMBConfigBean.getBindTo()) != null && attr.length() > 0 && !attr.equals("0.0.0.0")) {
                            try {
                                bindAddr = InetAddress.getByName(attr);
                                cifsConfig.setNetBIOSBindAddress(bindAddr);
                            }
                            catch (UnknownHostException ex) {
                                throw new InvalidConfigurationException(ex.toString());
                            }
                        } else {
                            attr = netBIOSSMBConfigBean.getAdapter();
                            if (attr != null && attr.length() > 0) {
                                bindAddr = this.parseAdapterName(attr);
                                cifsConfig.setNetBIOSBindAddress(bindAddr);
                            } else if (cifsConfig.hasSMBBindAddress()) {
                                cifsConfig.setNetBIOSBindAddress(cifsConfig.getSMBBindAddress());
                            }
                        }
                    }
                } else {
                    cifsConfig.setNetBIOSSMB(false);
                }
                tcpipSMBConfigBean = this.cifsConfigBean.getTcpipSMB();
                if (tcpipSMBConfigBean != null) {
                    platformsStr = tcpipSMBConfigBean.getPlatforms();
                    platformOK = false;
                    if (platformsStr != null) {
                        enabledPlatforms = this.parsePlatformString(platformsStr);
                        if (enabledPlatforms.contains(this.getPlatformType())) {
                            platformOK = true;
                        }
                    } else {
                        platformOK = true;
                    }
                    cifsConfig.setTcpipSMB(platformOK);
                    portNum = tcpipSMBConfigBean.getPort();
                    if (portNum != null) {
                        cifsConfig.setTcpipSMBPort(portNum.intValue());
                        if (cifsConfig.getTcpipSMBPort() <= 0 || cifsConfig.getTcpipSMBPort() >= 65535) {
                            throw new AlfrescoRuntimeException("TCP/IP SMB port out of valid range");
                        }
                    }
                    if (tcpipSMBConfigBean.getIpv6Enabled()) {
                        try {
                            cifsConfig.setSMBBindAddress(InetAddress.getByName("::"));
                            if (!ServerConfigurationBean.logger.isInfoEnabled()) ** GOTO lbl231
                            ServerConfigurationBean.logger.info((Object)"Enabled CIFS IPv6 bind address for native SMB");
                        }
                        catch (UnknownHostException ex) {
                            throw new AlfrescoRuntimeException("Failed to enable IPv6 bind address, " + ex.getMessage());
                        }
                    }
                } else {
                    cifsConfig.setTcpipSMB(false);
                }
lbl231:
                // 4 sources

                win32NetBIOSConfigBean = this.cifsConfigBean.getWin32NetBIOS();
                if (win32NetBIOSConfigBean != null) {
                    win32Name = win32NetBIOSConfigBean.getName();
                    if (win32Name != null && win32Name.length() > 0) {
                        if (win32Name.length() > 16) {
                            throw new AlfrescoRuntimeException("Invalid Win32 NetBIOS name, " + win32Name);
                        }
                        cifsConfig.setWin32NetBIOSName(win32Name);
                    }
                    if ((lanaStr = win32NetBIOSConfigBean.getLana()) != null && lanaStr.length() > 0) {
                        lana = -1;
                        if (IPAddress.isNumericAddress((String)lanaStr)) {
                            lana = Win32NetBIOS.getLANAForIPAddress((String)lanaStr);
                            if (lana == -1) {
                                throw new AlfrescoRuntimeException("Failed to convert IP address " + lanaStr + " to a LANA");
                            }
                        } else if (lanaStr.length() > 1 && Character.isLetter(lanaStr.charAt(0))) {
                            lana = Win32NetBIOS.getLANAForAdapterName((String)lanaStr);
                            if (lana == -1) {
                                throw new AlfrescoRuntimeException("Failed to convert network adapter " + lanaStr + " to a LANA");
                            }
                        } else {
                            try {
                                lana = Integer.parseInt(lanaStr);
                            }
                            catch (NumberFormatException ex) {
                                throw new AlfrescoRuntimeException("Invalid win32 NetBIOS LANA specified");
                            }
                        }
                        if (lana < 0 || lana > 255) {
                            throw new AlfrescoRuntimeException("Invalid Win32 NetBIOS LANA number, " + lana);
                        }
                        cifsConfig.setWin32LANA(lana);
                    }
                    if ((nativeAPI = win32NetBIOSConfigBean.getApi()) != null && nativeAPI.length() > 0) {
                        useWinsock = true;
                        if (nativeAPI.equalsIgnoreCase("netbios")) {
                            useWinsock = false;
                        } else if (!nativeAPI.equalsIgnoreCase("winsock")) {
                            throw new AlfrescoRuntimeException("Invalid NetBIOS API type, spefify 'winsock' or 'netbios'");
                        }
                        cifsConfig.setWin32WinsockNetBIOS(useWinsock);
                    }
                    if (cifsConfig.useWinsockNetBIOS() && X64.isWindows64()) {
                        if (ServerConfigurationBean.logger.isDebugEnabled()) {
                            ServerConfigurationBean.logger.debug((Object)"Using older Netbios() API code");
                        }
                        cifsConfig.setWin32WinsockNetBIOS(false);
                    }
                    if (!(!(osName = System.getProperty("os.name")).startsWith("Windows") || osName.endsWith("95") || osName.endsWith("98") || osName.endsWith("ME") || this.isNativeCodeDisabled())) {
                        if (Win32NetBIOS.LanaEnumerate() != null) {
                            cifsConfig.setWin32NetBIOS(true);
                        } else {
                            ServerConfigurationBean.logger.warn((Object)"No NetBIOS LANAs available");
                        }
                    } else {
                        cifsConfig.setWin32NetBIOS(false);
                    }
                } else {
                    cifsConfig.setWin32NetBIOS(false);
                }
                if (!this.cifsConfigBean.getWin32HostAnnouncerEnabled()) {
                    cifsConfig.setWin32HostAnnouncer(false);
                    ServerConfigurationBean.logger.info((Object)"Win32 host announcements not enabled");
                } else {
                    interval = this.cifsConfigBean.getWin32HostAnnounceInterval();
                    if (interval != null) {
                        cifsConfig.setWin32HostAnnounceInterval(interval.intValue());
                    }
                    if (cifsConfig.getDomainName() == null) {
                        throw new AlfrescoRuntimeException("Domain name must be specified if host announcement is enabled");
                    }
                    cifsConfig.setWin32HostAnnouncer(true);
                }
                if (!(cifsConfig.hasNetBIOSSMB() || cifsConfig.hasTcpipSMB() || cifsConfig.hasWin32NetBIOS())) {
                    throw new AlfrescoRuntimeException("NetBIOS SMB, TCP/IP SMB or Win32 NetBIOS must be enabled");
                }
                winsConfigBean = this.cifsConfigBean.getWINSConfig();
                if (winsConfigBean != null && !winsConfigBean.isAutoDetectEnabled()) {
                    priWins = winsConfigBean.getPrimary();
                    if (priWins == null || priWins.length() == 0) {
                        throw new AlfrescoRuntimeException("No primary WINS server configured");
                    }
                    primaryWINS = null;
                    try {
                        primaryWINS = InetAddress.getByName(priWins);
                    }
                    catch (UnknownHostException ex) {
                        throw new AlfrescoRuntimeException("Invalid primary WINS server address, " + priWins);
                    }
                    secWins = winsConfigBean.getSecondary();
                    secondaryWINS = null;
                    if (secWins != null && secWins.length() > 0) {
                        try {
                            secondaryWINS = InetAddress.getByName(secWins);
                        }
                        catch (UnknownHostException ex) {
                            throw new AlfrescoRuntimeException("Invalid secondary WINS server address, " + secWins);
                        }
                    }
                    cifsConfig.setPrimaryWINSServer(primaryWINS);
                    if (secondaryWINS != null) {
                        cifsConfig.setSecondaryWINSServer(secondaryWINS);
                    }
                    NetBIOSSession.setDefaultWINSServer((InetAddress)primaryWINS);
                } else if (cifsConfig.hasNetBIOSSMB() && this.getPlatformType() == Platform.Type.WINDOWS && !this.isNativeCodeDisabled() && (winsServers = Win32NetBIOS.getWINSServerList()) != null) {
                    tokens = new StringTokenizer(winsServers, ",");
                    addr = tokens.nextToken();
                    try {
                        winsAddr = InetAddress.getByName(addr);
                        winsSocket = new Socket();
                        sockAddr = new InetSocketAddress(winsAddr, 137);
                        winsSocket.connect(sockAddr, 3000);
                        winsSocket.close();
                        cifsConfig.setPrimaryWINSServer(winsAddr);
                        if (ServerConfigurationBean.logger.isDebugEnabled()) {
                            ServerConfigurationBean.logger.debug((Object)("Configuring to use WINS server " + addr));
                        }
                    }
                    catch (UnknownHostException ex) {
                        throw new AlfrescoRuntimeException("Invalid auto WINS server address, " + addr);
                    }
                    catch (IOException ex) {
                        if (!ServerConfigurationBean.logger.isDebugEnabled()) break block129;
                        ServerConfigurationBean.logger.debug((Object)("Failed to connect to auto WINS server " + addr));
                    }
                }
            }
            flags = this.cifsConfigBean.getSessionDebugFlags();
            sessDbg = 0;
            if (flags != null && flags.length() > 0) {
                flags = flags.toUpperCase();
                token = new StringTokenizer(flags, ",");
                while (token.hasMoreTokens()) {
                    dbg = token.nextToken().trim();
                    for (idx = 0; idx < ServerConfigurationBean.m_sessDbgStr.length && !ServerConfigurationBean.m_sessDbgStr[idx].equalsIgnoreCase(dbg); ++idx) {
                    }
                    if (idx > ServerConfigurationBean.m_sessDbgStr.length) {
                        throw new AlfrescoRuntimeException("Invalid session debug flag, " + dbg);
                    }
                    sessDbg += 1 << idx;
                }
            }
            cifsConfig.setSessionDebugFlags(sessDbg);
            if (this.cifsConfigBean.getDisableNIO()) {
                cifsConfig.setDisableNIOCode(true);
                if (ServerConfigurationBean.logger.isDebugEnabled()) {
                    ServerConfigurationBean.logger.debug((Object)"NIO based code disabled for CIFS server");
                }
            }
            if ((tmo = this.cifsConfigBean.getSessionTimeout()) != null) {
                if (tmo < 0 || tmo > 3600) {
                    throw new AlfrescoRuntimeException("Session timeout out of range (0 - 3600)");
                }
                cifsConfig.setSocketTimeout(tmo * 1000);
            }
        }
        catch (InvalidConfigurationException ex) {
            throw new AlfrescoRuntimeException(ex.getMessage());
        }
    }

    @Override
    protected void processFTPServerConfig() {
        if (this.ftpConfigBean == null) {
            this.removeConfigSection("FTP");
            return;
        }
        if (!this.ftpConfigBean.getServerEnabled()) {
            this.removeConfigSection("FTP");
            return;
        }
        FTPConfigSection ftpConfig = new FTPConfigSection((ServerConfiguration)this);
        try {
            FTPAuthenticator auth;
            Integer port;
            String bindText = this.ftpConfigBean.getBindTo();
            if (bindText != null && bindText.length() > 0 && !bindText.equals("0.0.0.0")) {
                try {
                    InetAddress bindAddr = InetAddress.getByName(bindText);
                    ftpConfig.setFTPBindAddress(bindAddr);
                }
                catch (UnknownHostException ex) {
                    throw new AlfrescoRuntimeException("Invalid FTP bindto address, " + bindText);
                }
            }
            if ((port = this.ftpConfigBean.getPort()) != null) {
                ftpConfig.setFTPPort(port.intValue());
                if (ftpConfig.getFTPPort() <= 0 || ftpConfig.getFTPPort() >= 65535) {
                    throw new AlfrescoRuntimeException("FTP server port out of valid range");
                }
            } else {
                ftpConfig.setFTPPort(21);
            }
            if (this.ftpConfigBean.getAllowAnonymous()) {
                ftpConfig.setAllowAnonymousFTP(true);
                String anonAcc = this.ftpConfigBean.getAnonymousAccount();
                if (anonAcc != null && anonAcc.length() > 0) {
                    ftpConfig.setAnonymousFTPAccount(anonAcc);
                    if (ftpConfig.getAnonymousFTPAccount() == null || ftpConfig.getAnonymousFTPAccount().length() == 0) {
                        throw new AlfrescoRuntimeException("Anonymous FTP account invalid");
                    }
                } else {
                    ftpConfig.setAnonymousFTPAccount("anonymous");
                }
            } else {
                ftpConfig.setAllowAnonymousFTP(false);
            }
            String rootPath = this.ftpConfigBean.getRootDirectory();
            if (rootPath != null && rootPath.length() > 0) {
                try {
                    new FTPPath(rootPath);
                    ftpConfig.setFTPRootPath(rootPath);
                }
                catch (InvalidPathException ex) {
                    throw new AlfrescoRuntimeException("Invalid FTP root directory, " + rootPath);
                }
            }
            String flags = this.ftpConfigBean.getDebugFlags();
            int ftpDbg = 0;
            if (flags != null) {
                flags = flags.toUpperCase();
                StringTokenizer token = new StringTokenizer(flags, ",");
                while (token.hasMoreTokens()) {
                    int idx;
                    String dbg = token.nextToken().trim();
                    for (idx = 0; idx < m_ftpDebugStr.length && !m_ftpDebugStr[idx].equalsIgnoreCase(dbg); ++idx) {
                    }
                    if (idx >= m_ftpDebugStr.length) {
                        throw new AlfrescoRuntimeException("Invalid FTP debug flag, " + dbg);
                    }
                    ftpDbg += 1 << idx;
                }
                ftpConfig.setFTPDebug(ftpDbg);
            }
            ftpConfig.setIPv6Enabled(this.ftpConfigBean.getIpv6Enabled());
            String charSet = this.ftpConfigBean.getCharSet();
            if (charSet != null && charSet.length() > 0) {
                try {
                    Charset.forName(charSet);
                    ftpConfig.setFTPCharacterSet(charSet);
                }
                catch (IllegalCharsetNameException ex) {
                    throw new AlfrescoRuntimeException("Illegal character set name, " + charSet);
                }
                catch (UnsupportedCharsetException ex) {
                    throw new AlfrescoRuntimeException("Unsupported character set name, " + charSet);
                }
            }
            if ((auth = this.ftpConfigBean.getAuthenticator()) == null) {
                throw new AlfrescoRuntimeException("FTP authenticator not specified");
            }
            ftpConfig.setAuthenticator(auth);
            if (this.ftpConfigBean.getDataPortFrom() != 0 && this.ftpConfigBean.getDataPortTo() != 0) {
                int rangeFrom = this.ftpConfigBean.getDataPortFrom();
                int rangeTo = this.ftpConfigBean.getDataPortTo();
                if (rangeFrom != 0 && rangeTo != 0) {
                    if (rangeFrom < 1024 || rangeFrom > 65535) {
                        throw new InvalidConfigurationException("Invalid FTP data port range from value, " + rangeFrom);
                    }
                    if (rangeTo < 1024 || rangeTo > 65535) {
                        throw new InvalidConfigurationException("Invalid FTP data port range to value, " + rangeTo);
                    }
                    if (rangeFrom >= rangeTo) {
                        throw new InvalidConfigurationException("Invalid FTP data port range, " + rangeFrom + "-" + rangeTo);
                    }
                    ftpConfig.setFTPDataPortLow(rangeFrom);
                    ftpConfig.setFTPDataPortHigh(rangeTo);
                    logger.info((Object)("FTP server data ports restricted to range " + rangeFrom + ":" + rangeTo));
                }
            }
            if (this.ftpConfigBean.getKeyStorePath() != null && this.ftpConfigBean.getKeyStorePath().length() > 0) {
                String keyStorePath = this.ftpConfigBean.getKeyStorePath();
                File keyStoreFile = new File(keyStorePath);
                if (!keyStoreFile.exists()) {
                    throw new InvalidConfigurationException("FTPS key store file does not exist, " + keyStorePath);
                }
                if (keyStoreFile.isDirectory()) {
                    throw new InvalidConfigurationException("FTPS key store path is a directory, " + keyStorePath);
                }
                ftpConfig.setKeyStorePath(keyStorePath);
            }
            if (this.ftpConfigBean.getTrustStorePath() != null && this.ftpConfigBean.getTrustStorePath().length() > 0) {
                String trustStorePath = this.ftpConfigBean.getTrustStorePath();
                File trustStoreFile = new File(trustStorePath);
                if (!trustStoreFile.exists()) {
                    throw new InvalidConfigurationException("FTPS trust store file does not exist, " + trustStorePath);
                }
                if (trustStoreFile.isDirectory()) {
                    throw new InvalidConfigurationException("FTPS trust store path is a directory, " + trustStorePath);
                }
                ftpConfig.setTrustStorePath(trustStorePath);
            }
            if (this.ftpConfigBean.getPassphrase() != null && this.ftpConfigBean.getPassphrase().length() > 0) {
                ftpConfig.setPassphrase(this.ftpConfigBean.getPassphrase());
            }
            if (this.ftpConfigBean.hasRequireSecureSession()) {
                ftpConfig.setRequireSecureSession(true);
            }
            if (!(ftpConfig.getKeyStorePath() == null && ftpConfig.getTrustStorePath() == null && ftpConfig.getPassphrase() == null || ftpConfig.getKeyStorePath() != null && ftpConfig.getTrustStorePath() != null && ftpConfig.getPassphrase() != null)) {
                throw new InvalidConfigurationException("FTPS configuration requires keyStore, trustStore and storePassphrase to be set");
            }
            if (this.ftpConfigBean.hasSslEngineDebug()) {
                System.setProperty("javax.net.debug", "ssl,handshake");
            }
        }
        catch (InvalidConfigurationException ex) {
            throw new AlfrescoRuntimeException(ex.getMessage());
        }
    }

    @Override
    protected void processNFSServerConfig() {
        if (this.nfsConfigBean == null) {
            this.removeConfigSection("NFS");
            return;
        }
        if (!this.nfsConfigBean.getServerEnabled()) {
            this.removeConfigSection("NFS");
            return;
        }
        NFSConfigSection nfsConfig = new NFSConfigSection((ServerConfiguration)this);
        try {
            RpcAuthenticator rpcAuthenticator;
            Integer rpcRegisterPort;
            Integer nfsServerPort;
            Integer mountServerPort;
            Integer portMapperPort;
            Integer pktPoolSize;
            Integer poolSize;
            if (this.nfsConfigBean.getPortMapperEnabled()) {
                nfsConfig.setNFSPortMapper(true);
            }
            if ((poolSize = this.nfsConfigBean.getThreadPool()) != null) {
                if (poolSize < 4) {
                    throw new AlfrescoRuntimeException("NFS thread pool size is below minimum of 4");
                }
                nfsConfig.setNFSThreadPoolSize(poolSize.intValue());
            }
            if ((pktPoolSize = this.nfsConfigBean.getPacketPool()) != null) {
                if (pktPoolSize < 10) {
                    throw new AlfrescoRuntimeException("NFS packet pool size is below minimum of 10");
                }
                if (pktPoolSize < nfsConfig.getNFSThreadPoolSize() + 1) {
                    throw new AlfrescoRuntimeException("NFS packet pool must be at least thread pool size plus one");
                }
                nfsConfig.setNFSPacketPoolSize(pktPoolSize.intValue());
            }
            if ((portMapperPort = this.nfsConfigBean.getPortMapperPort()) != null) {
                nfsConfig.setPortMapperPort(portMapperPort.intValue());
                if (nfsConfig.getPortMapperPort() == -1) {
                    logger.info((Object)"NFS portmapper registration disabled");
                } else if (nfsConfig.getPortMapperPort() <= 0 || nfsConfig.getPortMapperPort() >= 65535) {
                    throw new AlfrescoRuntimeException("Port mapper server port out of valid range");
                }
            }
            if ((mountServerPort = this.nfsConfigBean.getMountServerPort()) != null) {
                nfsConfig.setMountServerPort(mountServerPort.intValue());
                if (nfsConfig.getMountServerPort() < 0 || nfsConfig.getMountServerPort() >= 65535) {
                    throw new AlfrescoRuntimeException("Mount server port out of valid range");
                }
            }
            if ((nfsServerPort = this.nfsConfigBean.getNfsServerPort()) != null) {
                nfsConfig.setNFSServerPort(nfsServerPort.intValue());
                if (nfsConfig.getNFSServerPort() < 0 || nfsConfig.getNFSServerPort() >= 65535) {
                    throw new AlfrescoRuntimeException("NFS server port out of valid range");
                }
            }
            if ((rpcRegisterPort = this.nfsConfigBean.getRpcRegisterPort()) != null) {
                nfsConfig.setRPCRegistrationPort(rpcRegisterPort.intValue());
                if (nfsConfig.getRPCRegistrationPort() < 0 || nfsConfig.getRPCRegistrationPort() >= 65535) {
                    throw new AlfrescoRuntimeException("RPC registrtion port out of valid range");
                }
            }
            String flags = this.nfsConfigBean.getDebugFlags();
            int nfsDbg = 0;
            if (flags != null && flags.length() > 0) {
                flags = flags.toUpperCase();
                StringTokenizer token = new StringTokenizer(flags, ",");
                while (token.hasMoreTokens()) {
                    int idx;
                    String dbg = token.nextToken().trim();
                    for (idx = 0; idx < m_nfsDebugStr.length && !m_nfsDebugStr[idx].equalsIgnoreCase(dbg); ++idx) {
                    }
                    if (idx >= m_nfsDebugStr.length) {
                        throw new AlfrescoRuntimeException("Invalid NFS debug flag, " + dbg);
                    }
                    nfsDbg += 1 << idx;
                }
                nfsConfig.setNFSDebug(nfsDbg);
            }
            if (this.nfsConfigBean.getMountServerDebug()) {
                nfsConfig.setMountServerDebug(true);
            }
            if (this.nfsConfigBean.getPortMapperDebug()) {
                nfsConfig.setPortMapperDebug(true);
            }
            if ((rpcAuthenticator = this.nfsConfigBean.getRpcAuthenticator()) == null) {
                throw new AlfrescoRuntimeException("RPC authenticator configuration missing, require user mappings");
            }
            nfsConfig.setRpcAuthenticator(rpcAuthenticator);
        }
        catch (InvalidConfigurationException ex) {
            throw new AlfrescoRuntimeException(ex.getMessage());
        }
    }

    @Override
    protected void processFilesystemsConfig() {
        AVMDiskDriver avmDriver;
        StringList storeNames;
        FilesystemsConfigSection fsysConfig = new FilesystemsConfigSection((ServerConfiguration)this);
        SecurityConfigSection secConfig = (SecurityConfigSection)this.getConfigSection("Security");
        if (this.filesystemContexts != null) {
            for (DeviceContext filesystem : this.filesystemContexts) {
                try {
                    ExtendedDiskInterface filesysDriver;
                    DiskSharedDevice filesys = null;
                    if (filesystem instanceof AVMContext) {
                        filesysDriver = this.getAvmDiskInterface();
                        filesysDriver.registerContext(filesystem);
                        filesys = new DiskSharedDevice(filesystem.getDeviceName(), (DeviceInterface)filesysDriver, (DiskDeviceContext)((AVMContext)filesystem));
                        filesys.setConfiguration((ServerConfiguration)this);
                        DiskDeviceContext diskCtx = (DiskDeviceContext)filesystem;
                        if (diskCtx.hasStateCache()) {
                            fsysConfig.addFileStateCache(filesystem.getDeviceName(), diskCtx.getStateCache());
                        }
                        ((AVMContext)filesystem).startFilesystem(filesys);
                    } else {
                        filesysDriver = this.getRepoDiskInterface();
                        ContentContext filesysContext = (ContentContext)filesystem;
                        filesysDriver.registerContext(filesystem);
                        AccessControlList acls = null;
                        AccessControlListBean accessControls = filesysContext.getAccessControlList();
                        if (accessControls != null) {
                            acls = accessControls.toAccessControlList(secConfig);
                        } else if (secConfig.hasGlobalAccessControls()) {
                            acls = secConfig.getGlobalAccessControls();
                        }
                        filesys = new DiskSharedDevice(filesystem.getDeviceName(), (DeviceInterface)filesysDriver, (DiskDeviceContext)filesysContext);
                        filesys.setConfiguration((ServerConfiguration)this);
                        filesys.setAccessControlList(acls);
                        if (filesysContext.hasStateCache()) {
                            fsysConfig.addFileStateCache(filesystem.getDeviceName(), filesysContext.getStateCache());
                        }
                        filesysContext.startFilesystem(filesys);
                    }
                    fsysConfig.addShare((SharedDevice)filesys);
                }
                catch (DeviceContextException ex) {
                    throw new AlfrescoRuntimeException("Error creating filesystem " + filesystem.getDeviceName(), (Throwable)ex);
                }
                catch (InvalidConfigurationException ex) {
                    throw new AlfrescoRuntimeException(ex.getMessage(), (Throwable)ex);
                }
            }
        } else {
            logger.warn((Object)"No filesystems defined");
        }
        if (this.avmAllStores && this.getAvmDiskInterface() != null && (storeNames = (avmDriver = (AVMDiskDriver)this.getAvmDiskInterface()).getAVMStoreNames()) != null && storeNames.numberOfStrings() > 0) {
            for (int i = 0; i < storeNames.numberOfStrings(); ++i) {
                String storeName = storeNames.getStringAt(i);
                if (fsysConfig.getShares().findShare(storeName, 0, true) != null) continue;
                AVMContext avmContext = new AVMContext(storeName, storeName + ":/", -1);
                avmContext.enableStateCache(true);
                DiskSharedDevice filesys = new DiskSharedDevice(storeName, (DeviceInterface)avmDriver, (DiskDeviceContext)avmContext);
                filesys.setConfiguration((ServerConfiguration)this);
                fsysConfig.addShare((SharedDevice)filesys);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Added AVM share " + storeName));
            }
        }
    }

    @Override
    protected void processSecurityConfig() {
        SecurityConfigSection secConfig = new SecurityConfigSection((ServerConfiguration)this);
        try {
            String jceProvider;
            AccessControlList acls;
            AccessControlListBean accessControls = this.securityConfigBean.getGlobalAccessControl();
            if (accessControls != null && (acls = accessControls.toAccessControlList(secConfig)) != null) {
                secConfig.setGlobalAccessControls(acls);
            }
            if ((jceProvider = this.securityConfigBean.getJCEProvider()) != null && jceProvider.length() > 0) {
                secConfig.setJCEProvider(jceProvider);
            } else {
                secConfig.setJCEProvider("org.bouncycastle.jce.provider.BouncyCastleProvider");
            }
            ShareMapper shareMapper = this.securityConfigBean.getShareMapper();
            if (shareMapper != null) {
                secConfig.setShareMapper(shareMapper);
            } else if (this.m_tenantService != null && this.m_tenantService.isEnabled()) {
                secConfig.setShareMapper("org.alfresco.filesys.alfresco.MultiTenantShareMapper", (ConfigElement)new GenericConfigElement("shareMapper"));
            }
            List<DomainMappingConfigBean> mappings = this.securityConfigBean.getDomainMappings();
            if (mappings != null) {
                SubnetDomainMapping mapping = null;
                for (DomainMappingConfigBean domainMap : mappings) {
                    String name = domainMap.getName();
                    String subnetStr = domainMap.getSubnet();
                    if (subnetStr != null && subnetStr.length() > 0) {
                        String maskStr = domainMap.getMask();
                        int subnet = IPAddress.parseNumericAddress((String)subnetStr);
                        int mask = IPAddress.parseNumericAddress((String)maskStr);
                        if (subnet == 0 || mask == 0) {
                            throw new AlfrescoRuntimeException("Invalid subnet/mask for domain mapping " + name);
                        }
                        mapping = new SubnetDomainMapping(name, subnet, mask);
                    } else {
                        String rangeFromStr = domainMap.getRangeFrom();
                        if (rangeFromStr != null && rangeFromStr.length() > 0) {
                            String rangeToStr = domainMap.getRangeTo();
                            int rangeFrom = IPAddress.parseNumericAddress((String)rangeFromStr);
                            int rangeTo = IPAddress.parseNumericAddress((String)rangeToStr);
                            if (rangeFrom == 0 || rangeTo == 0) {
                                throw new AlfrescoRuntimeException("Invalid address range domain mapping " + name);
                            }
                            mapping = new RangeDomainMapping(name, rangeFrom, rangeTo);
                        } else {
                            throw new AlfrescoRuntimeException("Invalid domain mapping specified");
                        }
                    }
                    secConfig.addDomainMapping((DomainMapping)mapping);
                }
            }
        }
        catch (InvalidConfigurationException ex) {
            throw new AlfrescoRuntimeException(ex.getMessage());
        }
    }

    @Override
    protected void processCoreServerConfig() throws InvalidConfigurationException {
        List<MemoryPacketConfigBean> packetSizes;
        Integer maxSize;
        CoreServerConfigSection coreConfig = new CoreServerConfigSection((ServerConfiguration)this);
        if (this.cifsConfigBean == null || !this.cifsConfigBean.getServerEnabled()) {
            return;
        }
        if (this.coreServerConfigBean == null) {
            coreConfig.setMemoryPool(DefaultMemoryPoolBufSizes, DefaultMemoryPoolInitAlloc, DefaultMemoryPoolMaxAlloc);
            coreConfig.setThreadPool(25, 50);
            return;
        }
        Integer initSize = this.coreServerConfigBean.getThreadPoolInit();
        if (initSize == null) {
            initSize = 25;
        }
        if ((maxSize = this.coreServerConfigBean.getThreadPoolMax()) == null) {
            maxSize = 50;
        }
        if (initSize < 4) {
            throw new InvalidConfigurationException("Thread pool size below minimum allowed size");
        }
        if (initSize > 250) {
            throw new InvalidConfigurationException("Thread pool size above maximum allowed size");
        }
        if (maxSize < 4) {
            throw new InvalidConfigurationException("Thread pool maximum size below minimum allowed size");
        }
        if (maxSize > 250) {
            throw new InvalidConfigurationException("Thread pool maximum size above maximum allowed size");
        }
        if (maxSize < initSize) {
            throw new InvalidConfigurationException("Initial size is larger than maxmimum size");
        }
        coreConfig.setThreadPool(initSize.intValue(), maxSize.intValue());
        if (this.coreServerConfigBean.getThreadPoolDebug()) {
            coreConfig.getThreadPool().setDebug(true);
        }
        if ((packetSizes = this.coreServerConfigBean.getMemoryPacketSizes()) != null) {
            int elemCnt = packetSizes.size();
            int[] pktSizes = new int[elemCnt];
            int[] initSizes = new int[elemCnt];
            int[] maxSizes = new int[elemCnt];
            int elemIdx = 0;
            for (MemoryPacketConfigBean curChild : packetSizes) {
                int pktSize = -1;
                Long pktSizeLong = curChild.getSize();
                if (pktSizeLong == null) {
                    throw new InvalidConfigurationException("Memory pool packet size not specified");
                }
                try {
                    pktSize = MemorySize.getByteValueInt((String)pktSizeLong.toString());
                }
                catch (NumberFormatException ex) {
                    throw new InvalidConfigurationException("Memory pool packet size, invalid size value, " + pktSizeLong);
                }
                if (elemIdx > 0 && pktSizes[elemIdx - 1] >= pktSize) {
                    throw new InvalidConfigurationException("Invalid packet size specified, less than/equal to previous packet size");
                }
                Integer initAlloc = curChild.getInit();
                if (initAlloc == null) {
                    throw new InvalidConfigurationException("Memory pool initial allocation not specified");
                }
                if (initAlloc < 5) {
                    throw new InvalidConfigurationException("Initial memory pool allocation below minimum of 5");
                }
                if (initAlloc > 500) {
                    throw new InvalidConfigurationException("Initial memory pool allocation above maximum of 500");
                }
                Integer maxAlloc = curChild.getMax();
                if (maxAlloc == null) {
                    throw new InvalidConfigurationException("Memory pool maximum allocation not specified");
                }
                if (maxAlloc < 5) {
                    throw new InvalidConfigurationException("Maximum memory pool allocation below minimum of 5");
                }
                if (initAlloc > 500) {
                    throw new InvalidConfigurationException("Maximum memory pool allocation above maximum of 500");
                }
                pktSizes[elemIdx] = pktSize;
                initSizes[elemIdx] = initAlloc;
                maxSizes[elemIdx] = maxAlloc;
                ++elemIdx;
            }
            if (elemIdx < pktSizes.length) {
                int[] newPktSizes = new int[elemIdx];
                int[] newInitSizes = new int[elemIdx];
                int[] newMaxSizes = new int[elemIdx];
                System.arraycopy(pktSizes, 0, newPktSizes, 0, elemIdx);
                System.arraycopy(initSizes, 0, newInitSizes, 0, elemIdx);
                System.arraycopy(maxSizes, 0, newMaxSizes, 0, elemIdx);
                pktSizes = newPktSizes;
                initSizes = newInitSizes;
                maxSizes = newMaxSizes;
            }
            coreConfig.setMemoryPool(pktSizes, initSizes, maxSizes);
        } else {
            coreConfig.setMemoryPool(DefaultMemoryPoolBufSizes, DefaultMemoryPoolInitAlloc, DefaultMemoryPoolMaxAlloc);
        }
    }
}

