/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.constraint;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.action.constraint.BaseParameterConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumParameterConstraint
extends BaseParameterConstraint {
    private String enumClassName;
    private Class<?> enumClass;

    public void setEnumClassName(String enumClassName) {
        this.enumClassName = enumClassName;
    }

    @Override
    protected Map<String, String> getAllowableValuesImpl() {
        Class<?> enumClass = this.getEnumClass();
        ?[] enumValues = enumClass.getEnumConstants();
        HashMap<String, String> allowableValues = new HashMap<String, String>(enumValues.length);
        for (Object enumValue : enumValues) {
            String displayLabel = this.getI18NLabel(enumValue.toString());
            allowableValues.put(enumValue.toString(), displayLabel);
        }
        return allowableValues;
    }

    private Class<?> getEnumClass() {
        if (this.enumClass == null) {
            try {
                if (this.enumClassName == null || this.enumClassName.length() == 0) {
                    throw new AlfrescoRuntimeException("No enum class has been defined");
                }
                Class<?> enumClass = Class.forName(this.enumClassName);
                if (enumClass.isEnum()) {
                    this.enumClass = enumClass;
                }
            }
            catch (ClassNotFoundException e) {
                throw new AlfrescoRuntimeException("Unable to find enum class " + this.enumClassName, (Throwable)e);
            }
        }
        return this.enumClass;
    }
}

