/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.constraint;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.constraint.BaseParameterConstraint;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderContentsParameterConstraint
extends BaseParameterConstraint {
    private NodeService nodeService;
    private SearchService searchService;
    private DictionaryService dictionaryService;
    private String searchPath;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setSearchPath(String searchPath) {
        this.searchPath = searchPath;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    protected Map<String, String> getAllowableValuesImpl() {
        ResultSet resultSet = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "lucene", "PATH:\"" + this.searchPath + "\"");
        NodeRef rootFolder = null;
        if (resultSet.length() == 0) {
            throw new AlfrescoRuntimeException("The path '" + this.searchPath + "' did not return any results.");
        }
        rootFolder = resultSet.getNodeRef(0);
        HashMap<String, String> result = new HashMap<String, String>(23);
        this.buildMap(result, rootFolder);
        return result;
    }

    private void buildMap(Map<String, String> result, NodeRef folderNodeRef) {
        List assocs = this.nodeService.getChildAssocs(folderNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef assoc : assocs) {
            NodeRef nodeRef = assoc.getChildRef();
            QName className = this.nodeService.getType(nodeRef);
            if (this.dictionaryService.isSubClass(className, ContentModel.TYPE_CONTENT)) {
                result.put(nodeRef.toString(), (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_TITLE)));
                continue;
            }
            if (!this.dictionaryService.isSubClass(className, ContentModel.TYPE_FOLDER)) continue;
            this.buildMap(result, nodeRef);
        }
    }
}

