/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.post.cleanup;

import java.sql.SQLException;
import java.util.Date;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.domain.activities.ActivityPostEntity;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;

public class PostCleaner {
    private static Log logger = LogFactory.getLog(PostCleaner.class);
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener(PostCleaner.class.getName());
    private int maxAgeMins = 0;
    private ActivityPostDAO postDAO;

    public void setPostDAO(ActivityPostDAO postDAO) {
        this.postDAO = postDAO;
    }

    public void setMaxAgeMins(int mins) {
        this.maxAgeMins = mins;
    }

    private void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"postDAO", (Object)this.postDAO);
        if (this.maxAgeMins <= 0) {
            throw new AlfrescoRuntimeException("Property 'maxAgeMins' must be greater than 0");
        }
    }

    public void execute() throws JobExecutionException {
        block4: {
            this.checkProperties();
            try {
                long nowTimeOffset = new Date().getTime();
                long keepTimeOffset = nowTimeOffset - (long)(this.maxAgeMins * 60 * 1000);
                Date keepDate = new Date(keepTimeOffset);
                int deletedCount = this.postDAO.deletePosts(keepDate, ActivityPostEntity.STATUS.PROCESSED);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Cleaned " + deletedCount + " entries (upto " + keepDate + ", max age " + this.maxAgeMins + " mins)"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Exception during cleanup of posts", (Throwable)e);
                throw new JobExecutionException((Throwable)e);
            }
            catch (Throwable e) {
                if (vmShutdownListener.isVmShuttingDown()) break block4;
                logger.error((Object)"Exception during cleanup of posts", e);
            }
        }
    }
}

