/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class MigrateAttrDeletePatch
extends AbstractPatch {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String MSG_SUCCESS = "patch.migrateAttrDelete.result";
    private PatchDAO patchDAO;

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    protected String applyInternal() throws Exception {
        List<String> results = this.patchDAO.getOldAttrCustomNames();
        if (results.size() > 0) {
            for (String custom : results) {
                this.logger.warn((Object)("Custom global attribute found: " + custom));
            }
            throw new AlfrescoRuntimeException("Custom attributes found - will require custom migration patch: " + results);
        }
        this.patchDAO.deleteAllOldAttrs();
        String msg = I18NUtil.getMessage((String)MSG_SUCCESS);
        return msg;
    }
}

