/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMRepository;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.BasicAttributes;
import org.alfresco.repo.avm.DirectoryNode;
import org.alfresco.repo.avm.FileNode;
import org.alfresco.repo.avm.FileNodeImpl;
import org.alfresco.repo.avm.LayeredFileNode;
import org.alfresco.repo.avm.Lookup;
import org.alfresco.repo.avm.PlainFileNodeImpl;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.security.permissions.ACLCopyMode;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.repository.ContentData;

public class LayeredFileNodeImpl
extends FileNodeImpl
implements LayeredFileNode {
    static final long serialVersionUID = 9208423010479156363L;
    private String fIndirection;
    private int fIndirectionVersion;

    public LayeredFileNodeImpl() {
    }

    public LayeredFileNodeImpl(LayeredFileNode other, AVMStore store, Long parentAcl, ACLCopyMode mode) {
        super(store);
        this.setIndirection(other.getIndirection());
        this.setIndirectionVersion(-1);
        this.setVersionID(other.getVersionID() + 1);
        this.copyACLs(other, parentAcl, mode);
        this.copyCreationAndOwnerBasicAttributes(other);
        AVMDAOs.Instance().fAVMNodeDAO.save(this);
        this.copyProperties(other);
        this.copyAspects(other);
    }

    public LayeredFileNodeImpl(String indirection, AVMStore store, Acl acl) {
        super(store);
        this.setIndirection(indirection);
        this.setIndirectionVersion(-1);
        this.setVersionID(1);
        if (acl != null) {
            this.setAcl(acl);
        } else if (indirection != null) {
            Lookup lookup = AVMRepository.GetInstance().lookup(-1, indirection, false);
            if (lookup != null) {
                AVMNode node = lookup.getCurrentNode();
                if (node.getAcl() != null) {
                    this.setAcl(AVMDAOs.Instance().fAclDAO.createLayeredAcl(node.getAcl().getId()));
                } else {
                    this.setAcl(AVMDAOs.Instance().fAclDAO.createLayeredAcl(null));
                }
            } else {
                this.setAcl(AVMDAOs.Instance().fAclDAO.createLayeredAcl(null));
            }
        } else {
            this.setAcl(AVMDAOs.Instance().fAclDAO.createLayeredAcl(null));
        }
    }

    public AVMNode copy(Lookup lPath) {
        Lookup lookup = AVMRepository.GetInstance().lookup(-1, this.getIndirection(), false);
        if (lookup == null) {
            throw new AVMException("Unbacked layered file node.");
        }
        AVMNode indirect = lookup.getCurrentNode();
        if (indirect.getType() != 1 && indirect.getType() != 0) {
            throw new AVMException("Unbacked layered file node.");
        }
        DirectoryNode dir = lPath.getCurrentNodeDirectory();
        Acl parentAcl = null;
        if (dir != null && dir.getAcl() != null) {
            parentAcl = dir.getAcl();
        }
        PlainFileNodeImpl newMe = new PlainFileNodeImpl(lPath.getAVMStore(), this.getBasicAttributes(), this.getContentData(lPath), indirect.getProperties(), indirect.getAspects(), indirect.getAcl(), this.getVersionID(), parentAcl, ACLCopyMode.COPY);
        newMe.setAncestor(this);
        return newMe;
    }

    public int getType() {
        return 1;
    }

    public String getUnderlying(Lookup lookup) {
        return this.getIndirection();
    }

    public String toString(Lookup lPath) {
        return "[LF:" + this.getId() + ":" + this.getIndirection() + "]";
    }

    public AVMNodeDescriptor getDescriptor(Lookup lPath, String name) {
        BasicAttributes attrs = this.getBasicAttributes();
        String path = lPath.getRepresentedPath();
        path = path.endsWith("/") ? path + name : path + "/" + name;
        return new AVMNodeDescriptor(path, name, 1, attrs.getCreator(), attrs.getOwner(), attrs.getLastModifier(), attrs.getCreateDate(), attrs.getModDate(), attrs.getAccessDate(), this.getId(), this.getGuid(), this.getVersionID(), this.getUnderlying(lPath), this.getUnderlyingVersion(lPath), false, -1L, false, 0L, -1);
    }

    public AVMNodeDescriptor getDescriptor(Lookup lPath) {
        BasicAttributes attrs = this.getBasicAttributes();
        String path = lPath.getRepresentedPath();
        return new AVMNodeDescriptor(path, path.substring(path.lastIndexOf("/") + 1), 1, attrs.getCreator(), attrs.getOwner(), attrs.getLastModifier(), attrs.getCreateDate(), attrs.getModDate(), attrs.getAccessDate(), this.getId(), this.getGuid(), this.getVersionID(), this.getUnderlying(lPath), this.getUnderlyingVersion(lPath), false, -1L, false, 0L, -1);
    }

    public AVMNodeDescriptor getDescriptor(String parentPath, String name, String parentIndirection, int parentIndirectionVersion) {
        BasicAttributes attrs = this.getBasicAttributes();
        String path = parentPath.endsWith("/") ? parentPath + name : parentPath + "/" + name;
        return new AVMNodeDescriptor(path, name, 1, attrs.getCreator(), attrs.getOwner(), attrs.getLastModifier(), attrs.getCreateDate(), attrs.getModDate(), attrs.getAccessDate(), this.getId(), this.getGuid(), this.getVersionID(), this.getIndirection(), this.getIndirectionVersion(), false, -1L, false, 0L, -1);
    }

    public String getIndirection() {
        return this.fIndirection;
    }

    public void setIndirection(String indirection) {
        this.fIndirection = indirection;
    }

    public void setContentData(ContentData contentData) {
        throw new AVMException("Should not be called.");
    }

    public ContentData getContentData(Lookup lPath) {
        Lookup lookup = null;
        lookup = lPath != null ? lPath.getAVMStore().getAVMRepository().lookup(this.getUnderlyingVersion(lPath), this.getIndirection(), false) : AVMRepository.GetInstance().lookup(this.getUnderlyingVersion(null), this.getIndirection(), false);
        if (lookup == null) {
            throw new AVMException("Invalid target.");
        }
        AVMNode node = lookup.getCurrentNode();
        if (!(node instanceof FileNode)) {
            throw new AVMException("Invalid target.");
        }
        FileNode file = (FileNode)node;
        return file.getContentData(lookup);
    }

    public int getUnderlyingVersion(Lookup lookup) {
        if (lookup != null && lookup.getVersion() == -1) {
            return -1;
        }
        return this.getIndirectionVersion();
    }

    public Integer getIndirectionVersion() {
        return this.fIndirectionVersion;
    }

    public void setIndirectionVersion(Integer version) {
        this.fIndirectionVersion = version == null ? -1 : version;
    }

    public LayeredFileNode copyLiterally(Lookup lookup) {
        DirectoryNode dir = lookup.getCurrentNodeDirectory();
        Long parentAclId = null;
        if (dir != null && dir.getAcl() != null) {
            parentAclId = dir.getAcl().getId();
        }
        return new LayeredFileNodeImpl(this, lookup.getAVMStore(), parentAclId, ACLCopyMode.COPY);
    }
}

