/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import org.alfresco.repo.avm.AVMServiceTestBase;
import org.alfresco.repo.avm.util.BulkLoader;

public class SimultaneousLoadTest
extends AVMServiceTestBase {
    public void testSimulLoadB() throws Throwable {
        this.testSimultaneousLoad(5, 3);
    }

    private void testSimultaneousLoad(int n, int m) throws Throwable {
        try {
            int i;
            fReaper.setActiveBaseSleep(60000L);
            for (int i2 = 0; i2 < n; ++i2) {
                fService.createDirectory("main:/", "d" + i2);
            }
            fService.createSnapshot("main", null, null);
            Thread[] threads = new Thread[n];
            for (i = 0; i < n; ++i) {
                Loader loader = new Loader("source/java/org/alfresco/repo/avm/actions", "main:/d" + i, m);
                threads[i] = new Thread(loader);
                threads[i].start();
            }
            for (i = 0; i < n; ++i) {
                threads[i].join();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    private class Loader
    implements Runnable {
        private BulkLoader fLoader = new BulkLoader();
        private String fSource;
        private String fDestination;
        private int fCount;

        public Loader(String source, String destination, int count) {
            this.fLoader.setAvmService(AVMServiceTestBase.fService);
            this.fSource = source;
            this.fDestination = destination;
            this.fCount = count;
        }

        public void run() {
            for (int i = 0; i < this.fCount; ++i) {
                AVMServiceTestBase.fService.createDirectory(this.fDestination, "" + i);
                this.fLoader.recursiveLoad(this.fSource, this.fDestination + "/" + i);
            }
        }
    }
}

