/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.cleanup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.cleanup.ContentStoreCleaner;
import org.alfresco.repo.content.cleanup.ContentStoreCleanerListener;
import org.alfresco.repo.content.cleanup.EagerContentStoreCleaner;
import org.alfresco.repo.domain.avm.AVMNodeDAO;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentStoreCleanerTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private ContentService contentService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private JobLockService jobLockService;
    private ContentStoreCleaner cleaner;
    private EagerContentStoreCleaner eagerCleaner;
    private ContentStore store;
    private ContentStoreCleanerListener listener;
    private List<String> deletedUrls;

    public void setUp() throws Exception {
        AuthenticationUtil.setRunAsUserSystem();
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.contentService = serviceRegistry.getContentService();
        this.nodeService = serviceRegistry.getNodeService();
        this.transactionService = serviceRegistry.getTransactionService();
        this.jobLockService = serviceRegistry.getJobLockService();
        TransactionService transactionService = serviceRegistry.getTransactionService();
        DictionaryService dictionaryService = serviceRegistry.getDictionaryService();
        AVMNodeDAO avmNodeDAO = (AVMNodeDAO)ctx.getBean("newAvmNodeDAO");
        ContentDataDAO contentDataDAO = (ContentDataDAO)ctx.getBean("contentDataDAO");
        this.store = (ContentStore)ctx.getBean("fileContentStore");
        this.listener = new DummyCleanerListener();
        this.deletedUrls = new ArrayList<String>(5);
        this.eagerCleaner = (EagerContentStoreCleaner)ctx.getBean("eagerContentStoreCleaner");
        this.eagerCleaner.setEagerOrphanCleanup(false);
        this.eagerCleaner.setStores(Collections.singletonList(this.store));
        this.eagerCleaner.setListeners(Collections.singletonList(this.listener));
        this.cleaner = new ContentStoreCleaner();
        this.cleaner.setEagerContentStoreCleaner(this.eagerCleaner);
        this.cleaner.setJobLockService(this.jobLockService);
        this.cleaner.setContentDataDAO(contentDataDAO);
        this.cleaner.setTransactionService(transactionService);
        this.cleaner.setDictionaryService(dictionaryService);
        this.cleaner.setContentService(this.contentService);
        this.cleaner.setAvmNodeDAO(avmNodeDAO);
    }

    public void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    private void checkForExistence(Set<String> urls, boolean mustExist) {
        for (String url : urls) {
            ContentReader rawReader = this.contentService.getRawReader(url);
            if (mustExist && !rawReader.exists()) {
                ContentStoreCleanerTest.fail((String)("Content URL should have existed but did not: " + url));
                continue;
            }
            if (mustExist || !rawReader.exists()) continue;
            ContentStoreCleanerTest.fail((String)("Content URL should not have existed but did: " + url));
        }
    }

    public void testEagerCleanupOnCommit() throws Exception {
        NodeRef contentNodeRef;
        HashSet<String> urlsToMiss;
        HashSet<String> urlsToExist;
        block2: {
            this.eagerCleaner.setEagerOrphanCleanup(true);
            urlsToExist = new HashSet<String>();
            urlsToMiss = new HashSet<String>();
            RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> makeContentCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Throwable {
                    StoreRef storeRef = ContentStoreCleanerTest.this.nodeService.createStore("test", "testEagerCleanupOnCommit-" + GUID.generate());
                    NodeRef rootNodeRef = ContentStoreCleanerTest.this.nodeService.getRootNode(storeRef);
                    Map<QName, String> properties = Collections.singletonMap(ContentModel.PROP_NAME, "test.txt");
                    NodeRef contentNodeRef = ContentStoreCleanerTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, properties).getChildRef();
                    ContentWriter writer = ContentStoreCleanerTest.this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
                    writer.setMimetype("text/plain");
                    writer.putContent("INITIAL CONTENT");
                    urlsToExist.add(writer.getContentUrl());
                    return contentNodeRef;
                }
            };
            contentNodeRef = this.transactionService.getRetryingTransactionHelper().doInTransaction(makeContentCallback);
            this.checkForExistence(urlsToExist, true);
            this.checkForExistence(urlsToMiss, false);
            RetryingTransactionHelper.RetryingTransactionCallback<String> failUpdateCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                @Override
                public String execute() throws Throwable {
                    ContentWriter writer = ContentStoreCleanerTest.this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
                    writer.setMimetype("text/plain");
                    writer.putContent("CONTENT FOR FAIL");
                    urlsToMiss.add(writer.getContentUrl());
                    throw new RuntimeException("FAIL");
                }
            };
            try {
                this.transactionService.getRetryingTransactionHelper().doInTransaction(failUpdateCallback);
                ContentStoreCleanerTest.fail((String)"Transaction was meant to fail");
            }
            catch (RuntimeException e) {
                if (e.getMessage().equals("FAIL")) break block2;
                throw e;
            }
        }
        this.checkForExistence(urlsToExist, true);
        this.checkForExistence(urlsToMiss, false);
        RetryingTransactionHelper.RetryingTransactionCallback<String> successUpdateCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Throwable {
                ContentWriter writer = ContentStoreCleanerTest.this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/plain");
                writer.putContent("CONTENT FOR SUCCESS");
                urlsToMiss.addAll(urlsToExist);
                urlsToExist.clear();
                urlsToExist.add(writer.getContentUrl());
                return writer.getContentUrl();
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(successUpdateCallback);
        this.checkForExistence(urlsToExist, true);
        this.checkForExistence(urlsToMiss, false);
        RetryingTransactionHelper.RetryingTransactionCallback<ContentData> pointlessUpdateCallback = new RetryingTransactionHelper.RetryingTransactionCallback<ContentData>(){

            @Override
            public ContentData execute() throws Throwable {
                ContentData contentData = (ContentData)ContentStoreCleanerTest.this.nodeService.getProperty(contentNodeRef, ContentModel.PROP_CONTENT);
                ContentStoreCleanerTest.this.nodeService.setProperty(contentNodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
                return contentData;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(pointlessUpdateCallback);
        this.checkForExistence(urlsToExist, true);
        this.checkForExistence(urlsToMiss, false);
        RetryingTransactionHelper.RetryingTransactionCallback<Object> deleteNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                ContentStoreCleanerTest.this.nodeService.deleteNode(contentNodeRef);
                urlsToMiss.addAll(urlsToExist);
                urlsToExist.clear();
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(deleteNodeCallback);
        this.checkForExistence(urlsToExist, true);
        this.checkForExistence(urlsToMiss, false);
    }

    public void testEagerCleanupDereferencing() throws Exception {
        this.eagerCleaner.setEagerOrphanCleanup(true);
        final StoreRef storeRef = this.nodeService.createStore("test", this.getName() + "-" + GUID.generate());
        RetryingTransactionHelper.RetryingTransactionCallback<ContentData> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<ContentData>(){

            @Override
            public ContentData execute() throws Throwable {
                NodeRef rootNodeRef = ContentStoreCleanerTest.this.nodeService.getRootNode(storeRef);
                HashMap<QName, String> properties = new HashMap<QName, String>(13);
                properties.put(ContentModel.PROP_NAME, "test.txt");
                NodeRef contentNodeRef = ContentStoreCleanerTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, properties).getChildRef();
                ContentWriter writer = ContentStoreCleanerTest.this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/plain");
                writer.putContent("INITIAL CONTENT");
                ContentData contentData = writer.getContentData();
                ContentStoreCleanerTest.this.nodeService.deleteNode(contentNodeRef);
                ContentReader reader = ContentStoreCleanerTest.this.contentService.getRawReader(contentData.getContentUrl());
                Assert.assertNotNull((Object)reader);
                Assert.assertTrue((String)"Content was cleaned before end of transaction", (boolean)reader.exists());
                properties.put(ContentModel.PROP_NAME, "test2.txt");
                properties.put(ContentModel.PROP_CONTENT, (String)contentData);
                contentNodeRef = ContentStoreCleanerTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, properties).getChildRef();
                reader = ContentStoreCleanerTest.this.contentService.getRawReader(contentData.getContentUrl());
                Assert.assertNotNull((Object)reader);
                Assert.assertTrue((String)"Content was cleaned before end of transaction", (boolean)reader.exists());
                return contentData;
            }
        };
        ContentData contentData = this.transactionService.getRetryingTransactionHelper().doInTransaction(testCallback);
        ContentReader reader = this.contentService.getRawReader(contentData.getContentUrl());
        ContentStoreCleanerTest.assertNotNull((Object)reader);
        ContentStoreCleanerTest.assertTrue((String)"Content was cleaned despite being re-referenced in the transaction", (boolean)reader.exists());
    }

    public void testImmediateRemoval() throws Exception {
        this.eagerCleaner.setEagerOrphanCleanup(false);
        final StoreRef storeRef = this.nodeService.createStore("test", this.getName() + "-" + GUID.generate());
        RetryingTransactionHelper.RetryingTransactionCallback<ContentData> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<ContentData>(){

            @Override
            public ContentData execute() throws Throwable {
                NodeRef rootNodeRef = ContentStoreCleanerTest.this.nodeService.getRootNode(storeRef);
                HashMap<QName, String> properties = new HashMap<QName, String>(13);
                properties.put(ContentModel.PROP_NAME, "test.txt");
                NodeRef contentNodeRef = ContentStoreCleanerTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, properties).getChildRef();
                ContentWriter writer = ContentStoreCleanerTest.this.contentService.getWriter(contentNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("text/plain");
                writer.putContent("INITIAL CONTENT");
                ContentData contentData = writer.getContentData();
                ContentStoreCleanerTest.this.nodeService.addAspect(contentNodeRef, ContentModel.ASPECT_TEMPORARY, null);
                ContentStoreCleanerTest.this.nodeService.deleteNode(contentNodeRef);
                return contentData;
            }
        };
        ContentData contentData = this.transactionService.getRetryingTransactionHelper().doInTransaction(testCallback);
        ContentReader reader = this.contentService.getRawReader(contentData.getContentUrl());
        ContentStoreCleanerTest.assertNotNull((Object)reader);
        ContentStoreCleanerTest.assertTrue((String)"Content should not have been eagerly deleted.", (boolean)reader.exists());
        this.cleaner.setProtectDays(0);
        this.cleaner.execute();
        reader = this.contentService.getRawReader(contentData.getContentUrl());
        ContentStoreCleanerTest.assertFalse((String)"Unprotected content was not deleted", (boolean)reader.exists());
        ContentStoreCleanerTest.assertTrue((String)"Content listener was not called", (boolean)this.deletedUrls.contains(reader.getContentUrl()));
    }

    public void testProtectedRemoval() throws Exception {
        this.cleaner.setProtectDays(1);
        ContentWriter writer = this.store.getWriter(ContentStore.NEW_CONTENT_CONTEXT);
        writer.putContent("ABC");
        String contentUrl = writer.getContentUrl();
        this.cleaner.execute();
        ContentStoreCleanerTest.assertTrue((String)"Protected content was deleted", (boolean)this.store.exists(contentUrl));
        ContentStoreCleanerTest.assertFalse((String)"Content listener was called with deletion of protected URL", (boolean)this.deletedUrls.contains(contentUrl));
    }

    private class DummyCleanerListener
    implements ContentStoreCleanerListener {
        private DummyCleanerListener() {
        }

        public void beforeDelete(ContentStore store, String contentUrl) throws ContentIOException {
            ContentStoreCleanerTest.this.deletedUrls.add(contentUrl);
        }
    }
}

