/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.http;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.alfresco.repo.content.AbstractContentStore;
import org.alfresco.repo.content.http.HttpAlfrescoContentReader;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class HttpAlfrescoStore
extends AbstractContentStore {
    private TransactionService transactionService;
    private AuthenticationService authenticationService;
    private String baseHttpUrl;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setBaseHttpUrl(String baseHttpUrl) {
        if (baseHttpUrl.endsWith("/")) {
            baseHttpUrl = baseHttpUrl.substring(0, baseHttpUrl.length() - 1);
        }
        this.baseHttpUrl = baseHttpUrl;
    }

    public boolean isWriteSupported() {
        return false;
    }

    public ContentReader getReader(String contentUrl) {
        HttpAlfrescoContentReader reader = new HttpAlfrescoContentReader(this.transactionService, this.authenticationService, this.baseHttpUrl, contentUrl);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block11: {
            String baseUrl = null;
            String contentUrl = null;
            if (args.length != 2) {
                HttpAlfrescoStore.printUsage(System.err);
                System.exit(1);
            } else if (args[0].equalsIgnoreCase("help")) {
                HttpAlfrescoStore.printUsage(System.out);
                System.exit(0);
            }
            baseUrl = args[0];
            contentUrl = args[1];
            ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
            System.out.println("Starting test of " + HttpAlfrescoStore.class.getName() + " using server " + baseUrl + ".");
            HttpAlfrescoStore.doTest(ctx, baseUrl, contentUrl);
            System.out.println("Completed test of " + HttpAlfrescoStore.class.getName() + " using server " + baseUrl + ".");
            System.exit(0);
            Object var5_5 = null;
            try {
                ApplicationContextHelper.closeApplicationContext();
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
            break block11;
            {
                catch (Throwable e) {
                    e.printStackTrace();
                    System.err.println("Test of " + HttpAlfrescoStore.class.getName() + " using server " + baseUrl + " failed.");
                    System.exit(1);
                    Object var5_6 = null;
                    try {
                        ApplicationContextHelper.closeApplicationContext();
                    }
                    catch (Throwable e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    ApplicationContextHelper.closeApplicationContext();
                }
                catch (Throwable e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void doTest(ApplicationContext ctx, String baseUrl, String contentUrl) throws Exception {
        FileChannel channel;
        block3: {
            ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
            TransactionService transactionService = serviceRegistry.getTransactionService();
            MutableAuthenticationService authenticationService = serviceRegistry.getAuthenticationService();
            HttpAlfrescoStore store = new HttpAlfrescoStore();
            store.setTransactionService(transactionService);
            store.setAuthenticationService(authenticationService);
            store.setBaseHttpUrl(baseUrl);
            System.out.println("   Retrieving reader for URL " + contentUrl);
            ContentReader reader = store.getReader(contentUrl);
            System.out.println("   Retrieved reader for URL " + contentUrl);
            boolean exists = reader.exists();
            if (!exists) {
                System.out.println("   Content doesn't exist: " + contentUrl);
                return;
            }
            System.out.println("   Content exists: " + contentUrl);
            ContentData contentData = reader.getContentData();
            System.out.println("   Retrieved content data: " + contentData);
            ByteBuffer buffer = ByteBuffer.allocate((int)reader.getSize());
            channel = reader.getFileChannel();
            try {
                int count = channel.read(buffer);
                if ((long)count == reader.getSize()) break block3;
                System.err.println("The number of bytes read was " + count + " but expected " + reader.getSize());
                Object var14_13 = null;
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                channel.close();
                throw throwable;
            }
            channel.close();
            return;
        }
        Object var14_14 = null;
        channel.close();
    }

    private static void printUsage(OutputStream os) throws IOException {
        String msg = "Usage: \n   HttpAlfrescoStore <server-ip> <content-url>\n      server-ip: the remote HTTP server running Alfresco \n      content-url: the content URL to retrieve \n      Run the test against a server. \n   HttpAlfrescoStore help \n      Print the usage message";
        os.write(msg.getBytes());
        os.flush();
    }
}

