/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexContentTransformer
extends AbstractContentTransformer2
implements InitializingBean {
    private List<ContentTransformer> transformers;
    private List<String> intermediateMimetypes;

    public void setTransformers(List<ContentTransformer> transformers) {
        this.transformers = transformers;
    }

    public void setIntermediateMimetypes(List<String> intermediateMimetypes) {
        this.intermediateMimetypes = intermediateMimetypes;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.transformers == null || this.transformers.size() == 0) {
            throw new AlfrescoRuntimeException("At least one inner transformer must be supplied: " + this);
        }
        if (this.intermediateMimetypes == null || this.intermediateMimetypes.size() != this.transformers.size() - 1) {
            throw new AlfrescoRuntimeException("There must be n-1 intermediate mimetypes, where n is the number of transformers");
        }
        if (this.getMimetypeService() == null) {
            throw new AlfrescoRuntimeException("'mimetypeService' is a required property");
        }
    }

    @Override
    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        boolean result = true;
        String currentSourceMimetype = sourceMimetype;
        Iterator<ContentTransformer> transformerIterator = this.transformers.iterator();
        Iterator<String> intermediateMimetypeIterator = this.intermediateMimetypes.iterator();
        while (transformerIterator.hasNext()) {
            ContentTransformer transformer = transformerIterator.next();
            String currentTargetMimetype = null;
            currentTargetMimetype = !transformerIterator.hasNext() ? targetMimetype : intermediateMimetypeIterator.next();
            if (!transformer.isTransformable(currentSourceMimetype, currentTargetMimetype, options)) {
                result = false;
                break;
            }
            currentSourceMimetype = currentTargetMimetype;
        }
        return result;
    }

    @Override
    public void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        ContentReader currentReader = reader;
        Iterator<ContentTransformer> transformerIterator = this.transformers.iterator();
        Iterator<String> intermediateMimetypeIterator = this.intermediateMimetypes.iterator();
        while (transformerIterator.hasNext()) {
            ContentTransformer transformer = transformerIterator.next();
            ContentWriter currentWriter = null;
            if (!transformerIterator.hasNext()) {
                currentWriter = writer;
            } else {
                String nextMimetype = intermediateMimetypeIterator.next();
                String sourceExt = this.getMimetypeService().getExtension(currentReader.getMimetype());
                String targetExt = this.getMimetypeService().getExtension(nextMimetype);
                File tempFile = TempFileProvider.createTempFile((String)("ComplextTransformer_intermediate_" + sourceExt + "_"), (String)("." + targetExt));
                currentWriter = new FileContentWriter(tempFile);
                currentWriter.setMimetype(nextMimetype);
            }
            transformer.transform(currentReader, currentWriter, options);
            currentReader = currentWriter.getReader();
        }
    }
}

