/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.pdfbox.TextToPDF;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class TextToPdfContentTransformer
extends AbstractContentTransformer2 {
    private TextToPDF transformer = new TextToPDF();

    public void setStandardFont(String fontName) {
        try {
            this.transformer.setFont((PDSimpleFont)PDType1Font.getStandardFont((String)fontName));
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Unable to set Standard Font for PDF generation: " + fontName, e);
        }
    }

    public void setTrueTypeFont(String fontName) {
        try {
            this.transformer.setFont((PDSimpleFont)PDTrueTypeFont.loadTTF(null, (String)fontName));
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Unable to set True Type Font for PDF generation: " + fontName, e);
        }
    }

    public void setFontSize(int fontSize) {
        try {
            this.transformer.setFontSize(fontSize);
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Unable to set Font Size for PDF generation: " + fontSize);
        }
    }

    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return ("text/plain".equals(sourceMimetype) || "text/xml".equals(sourceMimetype)) && "application/pdf".equals(targetMimetype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        Throwable e22;
        OutputStream os;
        InputStream is;
        block16: {
            PDDocument pdf = null;
            is = null;
            os = null;
            try {
                is = reader.getContentInputStream();
                pdf = this.transformer.createPDFFromText((Reader)new InputStreamReader(is));
                os = writer.getContentOutputStream();
                pdf.save(os);
                Object var8_7 = null;
                if (pdf == null) break block16;
            }
            catch (Throwable throwable) {
                Throwable e22;
                Object var8_8 = null;
                if (pdf != null) {
                    try {
                        pdf.close();
                    }
                    catch (Throwable e22) {
                        e22.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable e22) {
                        e22.printStackTrace();
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable e22) {
                        e22.printStackTrace();
                    }
                }
                throw throwable;
            }
            try {
                pdf.close();
            }
            catch (Throwable e22) {
                e22.printStackTrace();
            }
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (Throwable e22) {
                e22.printStackTrace();
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (Throwable e22) {
                e22.printStackTrace();
            }
        }
    }
}

