/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditableProperties {
    private static Set<QName> auditablePropertyQNames = new HashSet<QName>(13);
    private String auditCreator;
    private String auditCreated;
    private String auditModifier;
    private String auditModified;
    private String auditAccessed;

    public static boolean isAuditableProperty(QName qname) {
        return auditablePropertyQNames.contains(qname);
    }

    public Serializable getAuditableProperty(QName qname) {
        if (qname.equals((Object)ContentModel.PROP_CREATOR)) {
            return this.auditCreator;
        }
        if (qname.equals((Object)ContentModel.PROP_CREATED)) {
            return (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditCreated);
        }
        if (qname.equals((Object)ContentModel.PROP_MODIFIER)) {
            return this.auditModifier == null ? this.auditCreator : this.auditModifier;
        }
        if (qname.equals((Object)ContentModel.PROP_MODIFIED)) {
            String dateStr = this.auditModified == null ? this.auditCreated : this.auditModified;
            return (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)dateStr);
        }
        if (qname.equals((Object)ContentModel.PROP_ACCESSED)) {
            return (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditAccessed);
        }
        return null;
    }

    private boolean setAuditableProperty(QName qname, Serializable value) {
        if (qname.equals((Object)ContentModel.PROP_CREATOR)) {
            this.auditCreator = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            return true;
        }
        if (qname.equals((Object)ContentModel.PROP_MODIFIER)) {
            this.auditModifier = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            return true;
        }
        if (qname.equals((Object)ContentModel.PROP_CREATED)) {
            this.auditCreated = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            return true;
        }
        if (qname.equals((Object)ContentModel.PROP_MODIFIED)) {
            this.auditModified = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            return true;
        }
        if (qname.equals((Object)ContentModel.PROP_ACCESSED)) {
            this.auditAccessed = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
            return true;
        }
        return false;
    }

    public Map<QName, Serializable> getAuditableProperties() {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>(7);
        properties.put(ContentModel.PROP_CREATOR, (Serializable)((Object)this.auditCreator));
        properties.put(ContentModel.PROP_CREATED, (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditCreated));
        if (this.auditModifier != null) {
            properties.put(ContentModel.PROP_MODIFIER, (Serializable)((Object)this.auditModifier));
        } else {
            properties.put(ContentModel.PROP_MODIFIER, (Serializable)((Object)this.auditCreator));
        }
        if (this.auditModified != null) {
            properties.put(ContentModel.PROP_MODIFIED, (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditModified));
        } else {
            properties.put(ContentModel.PROP_MODIFIED, (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditCreated));
        }
        if (this.auditAccessed != null) {
            properties.put(ContentModel.PROP_ACCESSED, (Serializable)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.auditAccessed));
        }
        return properties;
    }

    public void setAuditValues(String user, Date date, boolean force) {
        String dateStr = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date);
        if (force || this.auditCreator == null) {
            this.auditCreator = user;
        }
        if (force || this.auditCreated == null) {
            this.auditCreated = dateStr;
        }
        this.auditModifier = user;
        this.auditModified = dateStr;
    }

    public void setAuditValues(String user, Date date, Map<QName, Serializable> properties) {
        String dateStr = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)date);
        if (properties.containsKey(ContentModel.PROP_CREATOR)) {
            this.auditCreator = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_CREATOR));
        } else if (this.auditCreator == null) {
            this.auditCreator = user;
        }
        if (properties.containsKey(ContentModel.PROP_MODIFIER)) {
            this.auditModifier = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_MODIFIER));
        } else if (this.auditModifier == null) {
            this.auditModifier = user;
        }
        if (properties.containsKey(ContentModel.PROP_CREATED)) {
            this.auditCreated = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_CREATED));
        } else if (this.auditCreated == null) {
            this.auditCreated = dateStr;
        }
        if (properties.containsKey(ContentModel.PROP_MODIFIED)) {
            this.auditModified = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_MODIFIED));
        } else if (this.auditModified == null) {
            this.auditModified = dateStr;
        }
        if (properties.containsKey(ContentModel.PROP_ACCESSED)) {
            this.auditAccessed = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_ACCESSED));
        }
    }

    private String getAuditCreator() {
        return this.auditCreator;
    }

    private void setAuditCreator(String auditCreator) {
        this.auditCreator = auditCreator;
    }

    private String getAuditCreated() {
        return this.auditCreated;
    }

    private void setAuditCreated(String auditCreated) {
        this.auditCreated = auditCreated;
    }

    private String getAuditModifier() {
        return this.auditModifier;
    }

    private void setAuditModifier(String auditModifier) {
        this.auditModifier = auditModifier;
    }

    private String getAuditModified() {
        return this.auditModified;
    }

    private void setAuditModified(String auditModified) {
        this.auditModified = auditModified;
    }

    private String getAuditAccessed() {
        return this.auditAccessed;
    }

    private void setAuditAccessed(String auditAccessed) {
        this.auditAccessed = auditAccessed;
    }

    static {
        auditablePropertyQNames.add(ContentModel.PROP_CREATOR);
        auditablePropertyQNames.add(ContentModel.PROP_CREATED);
        auditablePropertyQNames.add(ContentModel.PROP_MODIFIER);
        auditablePropertyQNames.add(ContentModel.PROP_MODIFIED);
        auditablePropertyQNames.add(ContentModel.PROP_ACCESSED);
    }
}

