/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.avm;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.cache.NullCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.domain.avm.AVMNodeDAO;
import org.alfresco.repo.domain.avm.AVMNodeEntity;
import org.alfresco.repo.domain.avm.AVMNodePropertyEntity;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAVMNodeDAOImpl
implements AVMNodeDAO {
    private static final String CACHE_REGION_AVM_NODE = "AVMNode";
    private static final String CACHE_REGION_AVM_NODE_PROP = "AVMNodeProp";
    private final AVMNodeEntityCallbackDAO avmNodeEntityDaoCallback = new AVMNodeEntityCallbackDAO();
    private final AVMNodePropertyEntityCallbackDAO avmNodePropEntityDaoCallback;
    private QNameDAO qnameDAO;
    private EntityLookupCache<Long, AVMNodeEntity, Serializable> avmNodeCache = new EntityLookupCache<Long, AVMNodeEntity, Serializable>(this.avmNodeEntityDaoCallback);
    private EntityLookupCache<Pair<Long, Long>, AVMNodePropertyEntity, Serializable> avmNodePropCache;
    private SimpleCache<Serializable, Object> avmNodeAspectsCache;

    public void setAvmNodeCache(SimpleCache<Serializable, Object> avmNodeCache) {
        this.avmNodeCache = new EntityLookupCache<Long, AVMNodeEntity, Serializable>(avmNodeCache, CACHE_REGION_AVM_NODE, this.avmNodeEntityDaoCallback);
    }

    public void setAvmNodePropertyCache(SimpleCache<Serializable, Object> avmNodePropCache) {
        this.avmNodePropCache = new EntityLookupCache<Pair<Long, Long>, AVMNodePropertyEntity, Serializable>(avmNodePropCache, CACHE_REGION_AVM_NODE_PROP, this.avmNodePropEntityDaoCallback);
    }

    public void setAvmNodeAspectsCache(SimpleCache<Serializable, Object> avmNodeAspectsCache) {
        this.avmNodeAspectsCache = avmNodeAspectsCache;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public AbstractAVMNodeDAOImpl() {
        this.avmNodePropEntityDaoCallback = new AVMNodePropertyEntityCallbackDAO();
        this.avmNodePropCache = new EntityLookupCache<Pair<Long, Long>, AVMNodePropertyEntity, Serializable>(this.avmNodePropEntityDaoCallback);
        this.avmNodeAspectsCache = new NullCache<Serializable, Object>();
    }

    @Override
    public AVMNodeEntity createNode(AVMNodeEntity nodeEntity) {
        ParameterCheck.mandatory((String)"nodeEntity", (Object)nodeEntity);
        nodeEntity.setVers(0L);
        Pair<Long, AVMNodeEntity> entityPair = this.avmNodeCache.getOrCreateByValue(nodeEntity);
        return (AVMNodeEntity)entityPair.getSecond();
    }

    @Override
    public AVMNodeEntity getNode(long nodeId) {
        Pair<Long, AVMNodeEntity> entityPair = this.avmNodeCache.getByKey(nodeId);
        if (entityPair == null) {
            return null;
        }
        return (AVMNodeEntity)entityPair.getSecond();
    }

    @Override
    public void clearNodeEntityCache() {
        this.avmNodeCache.clear();
    }

    @Override
    public void updateNode(AVMNodeEntity nodeEntity) {
        ParameterCheck.mandatory((String)"nodeEntity", (Object)nodeEntity);
        ParameterCheck.mandatory((String)"nodeEntity.getId()", (Object)nodeEntity.getId());
        ParameterCheck.mandatory((String)"nodeEntity.getVers()", (Object)nodeEntity.getVers());
        int updated = this.avmNodeCache.updateValue(nodeEntity.getId(), nodeEntity);
        if (updated < 1) {
            throw new ConcurrencyFailureException("AVMNode with ID (" + nodeEntity.getId() + ") no longer exists or has been updated concurrently");
        }
    }

    @Override
    public void updateNodeModTimeAndGuid(AVMNodeEntity nodeEntity) {
        ParameterCheck.mandatory((String)"nodeEntity", (Object)nodeEntity);
        ParameterCheck.mandatory((String)"nodeEntity.getId()", (Object)nodeEntity.getId());
        ParameterCheck.mandatory((String)"nodeEntity.getGuid()", (Object)nodeEntity.getGuid());
        ParameterCheck.mandatory((String)"nodeEntity.getModifiedDate()", (Object)nodeEntity.getModifiedDate());
        ParameterCheck.mandatory((String)"nodeEntity.getVers()", (Object)nodeEntity.getVers());
        int updated = this.updateNodeEntityModTimeAndGuid(nodeEntity);
        if (updated < 1) {
            throw new ConcurrencyFailureException("AVMNode with ID (" + nodeEntity.getId() + ") no longer exists or has been updated concurrently");
        }
        this.avmNodeCache.removeByKey(nodeEntity.getId());
        this.avmNodeCache.getByKey(nodeEntity.getId());
    }

    @Override
    public void updateNodeModTimeAndContentData(AVMNodeEntity nodeEntity) {
        ParameterCheck.mandatory((String)"nodeEntity", (Object)nodeEntity);
        ParameterCheck.mandatory((String)"nodeEntity.getId()", (Object)nodeEntity.getId());
        ParameterCheck.mandatory((String)"nodeEntity.getModifiedDate()", (Object)nodeEntity.getModifiedDate());
        ParameterCheck.mandatory((String)"nodeEntity.getVers()", (Object)nodeEntity.getVers());
        int updated = this.updateNodeEntityModTimeAndContentData(nodeEntity);
        if (updated < 1) {
            throw new ConcurrencyFailureException("AVMNode with ID (" + nodeEntity.getId() + ") no longer exists or has been updated concurrently");
        }
        this.avmNodeCache.removeByKey(nodeEntity.getId());
        this.avmNodeCache.getByKey(nodeEntity.getId());
    }

    @Override
    public List<AVMNodeEntity> getNodesNewInStore(long storeId) {
        return this.getNodeEntitiesNewInStore(storeId);
    }

    @Override
    public List<AVMNodeEntity> getLayeredNodesNewInStore(long storeId) {
        return this.getLayeredNodeEntitiesNewInStore(storeId);
    }

    @Override
    public List<Long> getLayeredNodesNewInStoreIDs(long storeId) {
        return this.getLayeredNodeEntityIdsNewInStore(storeId);
    }

    @Override
    public List<AVMNodeEntity> getNodeOrphans(int maxSize) {
        return this.getNodeEntityOrphans(maxSize);
    }

    @Override
    public void updateNodesClearNewInStore(long storeId) {
        this.updateNodeEntitiesClearNewInStore(storeId);
    }

    @Override
    public void deleteNode(long nodeId) {
        Pair<Long, AVMNodeEntity> entityPair = this.avmNodeCache.getByKey(nodeId);
        if (entityPair == null) {
            return;
        }
        int deleted = this.avmNodeCache.deleteByKey(nodeId);
        if (deleted < 1) {
            throw new ConcurrencyFailureException("AVMNode with ID " + nodeId + " no longer exists");
        }
    }

    @Override
    public List<AVMNodeEntity> getAllLayeredDirectories() {
        return this.getAllLayeredDirectoryNodeEntities();
    }

    @Override
    public List<AVMNodeEntity> getAllLayeredFiles() {
        return this.getAllLayeredFileNodeEntities();
    }

    @Override
    public void getContentUrls(AVMNodeDAO.ContentUrlHandler handler) {
        this.getPlainFileContentUrls(handler);
    }

    protected abstract AVMNodeEntity createNodeEntity(AVMNodeEntity var1);

    protected abstract AVMNodeEntity getNodeEntity(long var1);

    protected abstract int updateNodeEntity(AVMNodeEntity var1);

    protected abstract int updateNodeEntityModTimeAndGuid(AVMNodeEntity var1);

    protected abstract int updateNodeEntityModTimeAndContentData(AVMNodeEntity var1);

    protected abstract int deleteNodeEntity(long var1);

    protected abstract void updateNodeEntitiesClearNewInStore(long var1);

    protected abstract List<AVMNodeEntity> getNodeEntitiesNewInStore(long var1);

    protected abstract List<AVMNodeEntity> getLayeredNodeEntitiesNewInStore(long var1);

    protected abstract List<Long> getLayeredNodeEntityIdsNewInStore(long var1);

    protected abstract List<AVMNodeEntity> getNodeEntityOrphans(int var1);

    protected abstract List<AVMNodeEntity> getAllLayeredDirectoryNodeEntities();

    protected abstract List<AVMNodeEntity> getAllLayeredFileNodeEntities();

    protected abstract void getPlainFileContentUrls(AVMNodeDAO.ContentUrlHandler var1);

    @Override
    public Set<QName> getAspects(long nodeId) {
        Set aspects = (Set)this.avmNodeAspectsCache.get((Serializable)Long.valueOf(nodeId));
        if (aspects != null) {
            return aspects;
        }
        Set<Object> aspectQNames = null;
        List<Long> aspectIds = this.getAspectEntities(nodeId);
        aspectQNames = aspectIds != null ? this.qnameDAO.convertIdsToQNames(new HashSet<Long>(aspectIds)) : new HashSet(0);
        this.avmNodeAspectsCache.put((Serializable)Long.valueOf(nodeId), aspectQNames);
        return aspectQNames;
    }

    @Override
    public void createAspect(long nodeId, QName qname) {
        Set<QName> aspects = this.getAspects(nodeId);
        if (aspects.contains(qname)) {
            return;
        }
        Pair<Long, QName> qnamePair = this.qnameDAO.getOrCreateQName(qname);
        if (qnamePair != null) {
            Long qnameId = (Long)qnamePair.getFirst();
            this.createAspectEntity(nodeId, qnameId);
            aspects.add(qname);
            this.avmNodeAspectsCache.put((Serializable)new Long(nodeId), aspects);
        }
    }

    @Override
    public void deleteAspect(long nodeId, QName qname) {
        Set<QName> aspects = this.getAspects(nodeId);
        if (!aspects.contains(qname)) {
            return;
        }
        Pair<Long, QName> qnamePair = this.qnameDAO.getQName(qname);
        if (qnamePair != null) {
            Long qnameId = (Long)qnamePair.getFirst();
            int deleted = this.deleteAspectEntity(nodeId, qnameId);
            if (deleted < 1) {
                throw new ConcurrencyFailureException("AVMNodeAspect (" + nodeId + ", " + qnameId + ") no longer exists");
            }
            aspects.remove(qname);
            this.avmNodeAspectsCache.put((Serializable)new Long(nodeId), aspects);
        }
    }

    @Override
    public void deleteAspects(long nodeId) {
        Set<QName> naEntities = this.getAspects(nodeId);
        if (naEntities.size() == 0) {
            return;
        }
        int deleted = this.deleteAspectEntities(nodeId);
        if (deleted < 1) {
            throw new ConcurrencyFailureException("AVMNodeAspects for node ID " + nodeId + " no longer exist");
        }
        this.avmNodeAspectsCache.remove((Serializable)Long.valueOf(nodeId));
    }

    protected abstract List<Long> getAspectEntities(long var1);

    protected abstract void createAspectEntity(long var1, long var3);

    protected abstract int deleteAspectEntity(long var1, long var3);

    protected abstract int deleteAspectEntities(long var1);

    @Override
    public void createOrUpdateNodeProperty(long nodeId, QName qname, PropertyValue value) {
        ParameterCheck.mandatory((String)"qname", (Object)qname);
        Pair<Long, QName> qnamePair = this.qnameDAO.getOrCreateQName(qname);
        Long qnameId = (Long)qnamePair.getFirst();
        AVMNodePropertyEntity propEntity = new AVMNodePropertyEntity(nodeId, qnameId, value);
        Pair key = new Pair((Object)nodeId, (Object)propEntity.getQnameId());
        Pair<Pair<Long, Long>, AVMNodePropertyEntity> entityPair = this.avmNodePropCache.getByKey((Pair<Long, Long>)key);
        if (entityPair != null) {
            int updated = this.avmNodePropCache.updateValue((Pair<Long, Long>)key, propEntity);
            if (updated < 1) {
                throw new ConcurrencyFailureException("AVMNodePropertyEntity with key (" + propEntity.getNodeId() + ", " + propEntity.getQnameId() + ") no longer exists");
            }
        } else {
            this.avmNodePropCache.getOrCreateByValue(propEntity);
        }
    }

    @Override
    public Map<QName, PropertyValue> getNodeProperties(long nodeId) {
        List<AVMNodePropertyEntity> npEntities = this.getNodePropertyEntities(nodeId);
        HashMap<QName, PropertyValue> nProps = new HashMap<QName, PropertyValue>(npEntities.size());
        for (AVMNodePropertyEntity npEntity : npEntities) {
            Pair<Long, QName> qnamePair = this.qnameDAO.getQName(npEntity.getQnameId());
            if (qnamePair == null) continue;
            nProps.put((QName)qnamePair.getSecond(), npEntity);
        }
        return nProps;
    }

    @Override
    public void deleteNodeProperty(long nodeId, QName qname) {
        Pair<Long, QName> qnamePair = this.qnameDAO.getQName(qname);
        if (qnamePair != null) {
            Long qnameId = (Long)qnamePair.getFirst();
            Pair key = new Pair((Object)nodeId, (Object)qnameId);
            Pair<Pair<Long, Long>, AVMNodePropertyEntity> entityPair = this.avmNodePropCache.getByKey((Pair<Long, Long>)key);
            if (entityPair == null) {
                return;
            }
            int deleted = this.avmNodePropCache.deleteByKey((Pair<Long, Long>)key);
            if (deleted < 1) {
                throw new ConcurrencyFailureException("AVMNodeProperty (" + nodeId + ", " + qnameId + ") no longer exists");
            }
        }
    }

    @Override
    public void deleteNodeProperties(long nodeId) {
        Map<QName, PropertyValue> nProps = this.getNodeProperties(nodeId);
        if (nProps.size() == 0) {
            return;
        }
        for (QName propQName : nProps.keySet()) {
            this.deleteNodeProperty(nodeId, propQName);
        }
    }

    protected abstract void insertNodePropertyEntity(AVMNodePropertyEntity var1);

    protected abstract int updateNodePropertyEntity(AVMNodePropertyEntity var1);

    protected abstract AVMNodePropertyEntity getNodePropertyEntity(long var1, long var3);

    protected abstract List<AVMNodePropertyEntity> getNodePropertyEntities(long var1);

    protected abstract int deleteNodePropertyEntity(long var1, long var3);

    protected abstract int deleteNodePropertyEntities(long var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AVMNodePropertyEntityCallbackDAO
    implements EntityLookupCache.EntityLookupCallbackDAO<Pair<Long, Long>, AVMNodePropertyEntity, Serializable> {
        private AVMNodePropertyEntityCallbackDAO() {
        }

        private final Pair<Pair<Long, Long>, AVMNodePropertyEntity> convertEntityToPair(AVMNodePropertyEntity nodePropEntity) {
            if (nodePropEntity == null) {
                return null;
            }
            Pair key = new Pair((Object)nodePropEntity.getNodeId(), (Object)nodePropEntity.getQnameId());
            return new Pair((Object)key, (Object)nodePropEntity);
        }

        @Override
        public Serializable getValueKey(AVMNodePropertyEntity value) {
            return null;
        }

        @Override
        public Pair<Pair<Long, Long>, AVMNodePropertyEntity> createValue(AVMNodePropertyEntity value) {
            AbstractAVMNodeDAOImpl.this.insertNodePropertyEntity(value);
            return this.convertEntityToPair(value);
        }

        @Override
        public Pair<Pair<Long, Long>, AVMNodePropertyEntity> findByKey(Pair<Long, Long> key) {
            AVMNodePropertyEntity entity = AbstractAVMNodeDAOImpl.this.getNodePropertyEntity((Long)key.getFirst(), (Long)key.getSecond());
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Pair<Long, Long>, AVMNodePropertyEntity> findByValue(AVMNodePropertyEntity value) {
            if (value.getNodeId() != null && value.getQnameId() != null) {
                return this.findByKey((Pair<Long, Long>)new Pair((Object)value.getNodeId(), (Object)value.getQnameId()));
            }
            return null;
        }

        @Override
        public int updateValue(Pair<Long, Long> key, AVMNodePropertyEntity value) {
            return AbstractAVMNodeDAOImpl.this.updateNodePropertyEntity(value);
        }

        @Override
        public int deleteByKey(Pair<Long, Long> key) {
            return AbstractAVMNodeDAOImpl.this.deleteNodePropertyEntity((Long)key.getFirst(), (Long)key.getSecond());
        }

        @Override
        public int deleteByValue(AVMNodePropertyEntity value) {
            throw new UnsupportedOperationException("deleteByValue(AVMNodePropertyEntity)");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AVMNodeEntityCallbackDAO
    implements EntityLookupCache.EntityLookupCallbackDAO<Long, AVMNodeEntity, Serializable> {
        private AVMNodeEntityCallbackDAO() {
        }

        private final Pair<Long, AVMNodeEntity> convertEntityToPair(AVMNodeEntity nodeEntity) {
            if (nodeEntity == null) {
                return null;
            }
            return new Pair((Object)nodeEntity.getId(), (Object)nodeEntity);
        }

        @Override
        public Serializable getValueKey(AVMNodeEntity value) {
            return null;
        }

        @Override
        public Pair<Long, AVMNodeEntity> createValue(AVMNodeEntity value) {
            AVMNodeEntity entity = AbstractAVMNodeDAOImpl.this.createNodeEntity(value);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, AVMNodeEntity> findByKey(Long key) {
            AVMNodeEntity entity = AbstractAVMNodeDAOImpl.this.getNodeEntity(key);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, AVMNodeEntity> findByValue(AVMNodeEntity value) {
            if (value != null && value.getId() != null) {
                return this.findByKey(value.getId());
            }
            return null;
        }

        @Override
        public int updateValue(Long key, AVMNodeEntity value) {
            return AbstractAVMNodeDAOImpl.this.updateNodeEntity(value);
        }

        @Override
        public int deleteByKey(Long key) {
            return AbstractAVMNodeDAOImpl.this.deleteNodeEntity(key);
        }

        @Override
        public int deleteByValue(AVMNodeEntity value) {
            throw new UnsupportedOperationException("deleteByValue(AVMNodeEntity)");
        }
    }
}

