/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.usage.ibatis;

import com.ibatis.sqlmap.client.event.RowHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.usage.AbstractUsageDAOImpl;
import org.alfresco.repo.domain.usage.UsageDAO;
import org.alfresco.repo.domain.usage.UsageDeltaEntity;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsageDAOImpl
extends AbstractUsageDAOImpl {
    private static Log logger = LogFactory.getLog(UsageDAOImpl.class);
    private static final String INSERT_USAGE_DELTA = "alfresco.usage.insert_UsageDelta";
    private static final String SELECT_USAGE_DELTA_TOTAL_SIZE_BY_NODE = "alfresco.usage.select_GetTotalDeltaSizeByNodeId";
    private static final String SELECT_USAGE_DELTA_NODES = "alfresco.usage.select_GetUsageDeltaNodes";
    private static final String SELECT_USERS_WITH_USAGE = "alfresco.usage.select_GetUsersWithUsage";
    private static final String SELECT_USERS_WITHOUT_USAGE = "alfresco.usage.select_GetUsersWithoutUsage";
    private static final String SELECT_CONTENT_SIZES_NEW = "alfresco.usage.select_GetContentSizesForStoreNew";
    private static final String DELETE_USAGE_DELTAS_BY_NODE = "alfresco.usage.delete_UsageDeltasByNodeId";
    private SqlMapClientTemplate template;
    private QNameDAO qnameDAO;

    public void setSqlMapClientTemplate(SqlMapClientTemplate sqlMapClientTemplate) {
        this.template = sqlMapClientTemplate;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    @Override
    protected UsageDeltaEntity insertUsageDeltaEntity(UsageDeltaEntity entity) {
        entity.setVersion(0L);
        Long id = (Long)this.template.insert(INSERT_USAGE_DELTA, (Object)entity);
        entity.setId(id);
        return entity;
    }

    @Override
    protected UsageDeltaEntity selectTotalUsageDeltaSize(long nodeEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", nodeEntityId);
        return (UsageDeltaEntity)this.template.queryForObject(SELECT_USAGE_DELTA_TOTAL_SIZE_BY_NODE, params);
    }

    @Override
    protected List<Long> selectUsageDeltaNodes() {
        return this.template.queryForList(SELECT_USAGE_DELTA_NODES);
    }

    @Override
    protected int deleteUsageDeltaEntitiesByNodeId(long nodeEntityId) {
        HashMap<String, Long> params = new HashMap<String, Long>(1);
        params.put("id", nodeEntityId);
        return this.template.delete(DELETE_USAGE_DELTAS_BY_NODE, params);
    }

    @Override
    protected void selectUsersWithoutUsage(StoreRef storeRef, UsageDAO.MapHandler resultsCallback) {
        Pair<Long, QName> personTypeQNamePair = this.qnameDAO.getQName(ContentModel.TYPE_PERSON);
        Pair<Long, QName> usernamePropQNamePair = this.qnameDAO.getQName(ContentModel.PROP_USERNAME);
        Pair<Long, QName> sizeCurrentPropQNamePair = this.qnameDAO.getQName(ContentModel.PROP_SIZE_CURRENT);
        if (personTypeQNamePair == null || usernamePropQNamePair == null || sizeCurrentPropQNamePair == null) {
            return;
        }
        Long personTypeQNameEntityId = (Long)personTypeQNamePair.getFirst();
        Long usernamePropQNameEntityId = (Long)usernamePropQNamePair.getFirst();
        Long sizeCurrentPropQNameEntityId = (Long)sizeCurrentPropQNamePair.getFirst();
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("personTypeQNameID", personTypeQNameEntityId);
        params.put("usernamePropQNameID", usernamePropQNameEntityId);
        params.put("sizeCurrentPropQNameID", sizeCurrentPropQNameEntityId);
        params.put("storeProtocol", storeRef.getProtocol());
        params.put("storeIdentifier", storeRef.getIdentifier());
        MapRowHandler rowHandler = new MapRowHandler(resultsCallback);
        this.template.queryWithRowHandler(SELECT_USERS_WITHOUT_USAGE, params, (RowHandler)rowHandler);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("   Listed " + rowHandler.total + " users without usage"));
        }
    }

    @Override
    protected void selectUsersWithUsage(StoreRef storeRef, UsageDAO.MapHandler resultsCallback) {
        Pair<Long, QName> personTypeQNamePair = this.qnameDAO.getQName(ContentModel.TYPE_PERSON);
        Pair<Long, QName> usernamePropQNamePair = this.qnameDAO.getQName(ContentModel.PROP_USERNAME);
        Pair<Long, QName> sizeCurrentPropQNamePair = this.qnameDAO.getQName(ContentModel.PROP_SIZE_CURRENT);
        if (personTypeQNamePair == null || usernamePropQNamePair == null || sizeCurrentPropQNamePair == null) {
            return;
        }
        Long personTypeQNameEntityId = (Long)personTypeQNamePair.getFirst();
        Long usernamePropQNameEntityId = (Long)usernamePropQNamePair.getFirst();
        Long sizeCurrentPropQNameEntityId = (Long)sizeCurrentPropQNamePair.getFirst();
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("personTypeQNameID", personTypeQNameEntityId);
        params.put("usernamePropQNameID", usernamePropQNameEntityId);
        params.put("sizeCurrentPropQNameID", sizeCurrentPropQNameEntityId);
        params.put("storeProtocol", storeRef.getProtocol());
        params.put("storeIdentifier", storeRef.getIdentifier());
        MapRowHandler rowHandler = new MapRowHandler(resultsCallback);
        this.template.queryWithRowHandler(SELECT_USERS_WITH_USAGE, params, (RowHandler)rowHandler);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("   Listed " + rowHandler.total + " users with usage"));
        }
    }

    @Override
    protected void selectUserContentSizesForStore(StoreRef storeRef, UsageDAO.MapHandler resultsCallback) {
        Pair<Long, QName> contentTypeQNamePair = this.qnameDAO.getQName(ContentModel.TYPE_CONTENT);
        Pair<Long, QName> ownerPropQNamePair = this.qnameDAO.getQName(ContentModel.PROP_OWNER);
        Pair<Long, QName> contentPropQNamePair = this.qnameDAO.getQName(ContentModel.PROP_CONTENT);
        if (contentTypeQNamePair == null || ownerPropQNamePair == null || contentPropQNamePair == null) {
            return;
        }
        Long contentTypeQNameEntityId = (Long)contentTypeQNamePair.getFirst();
        Long ownerPropQNameEntityId = (Long)ownerPropQNamePair.getFirst();
        Long contentPropQNameEntityId = (Long)contentPropQNamePair.getFirst();
        MapRowHandler rowHandler = new MapRowHandler(resultsCallback);
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("contentTypeQNameID", contentTypeQNameEntityId);
        params.put("ownerPropQNameID", ownerPropQNameEntityId);
        params.put("contentPropQNameID", contentPropQNameEntityId);
        params.put("storeProtocol", storeRef.getProtocol());
        params.put("storeIdentifier", storeRef.getIdentifier());
        this.template.queryWithRowHandler(SELECT_CONTENT_SIZES_NEW, params, (RowHandler)rowHandler);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("   Listed " + rowHandler.total + " old content sizes"));
        }
    }

    private static class MapRowHandler
    implements RowHandler {
        private final UsageDAO.MapHandler handler;
        private int total = 0;

        private MapRowHandler(UsageDAO.MapHandler handler) {
            this.handler = handler;
        }

        public void handleRow(Object valueObject) {
            this.handler.handle((Map)valueObject);
            ++this.total;
            if (logger.isDebugEnabled() && (this.total == 0 || this.total % 1000 == 0)) {
                logger.debug((Object)("   Listed " + this.total + " map entries"));
            }
        }
    }
}

