/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.forms.Field;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.FormException;
import org.alfresco.repo.forms.processor.FilteredFormProcessor;
import org.alfresco.repo.forms.processor.FormCreationData;
import org.alfresco.repo.forms.processor.node.AbstractAssocCommand;
import org.alfresco.repo.forms.processor.node.AddAssocCommand;
import org.alfresco.repo.forms.processor.node.AddChildAssocCommand;
import org.alfresco.repo.forms.processor.node.ContentModelItemData;
import org.alfresco.repo.forms.processor.node.DefaultFieldBuilder;
import org.alfresco.repo.forms.processor.node.PropertyFieldProcessor;
import org.alfresco.repo.forms.processor.node.RemoveAssocCommand;
import org.alfresco.repo.forms.processor.node.RemoveChildAssocCommand;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.json.JSONArray;
import org.json.JSONException;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentModelFormProcessor<ItemType, PersistType>
extends FilteredFormProcessor<ItemType, PersistType> {
    protected NodeService nodeService;
    protected FileFolderService fileFolderService;
    protected DictionaryService dictionaryService;
    protected NamespaceService namespaceService;
    protected ContentService contentService;
    protected Pattern propertyNamePattern = Pattern.compile("prop_([a-zA-Z0-9]+)_(.*)");
    protected Pattern transientPropertyPattern = Pattern.compile("prop_(.*){1}?");
    protected Pattern associationNamePattern = Pattern.compile("assoc_([a-zA-Z0-9]+)_(.*)(_[a-zA-Z]+)");

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    protected void addPropertyDataIfRequired(QName propName, Form form, ContentModelItemData<?> itemData) {
        String dataKey = this.makePropDataKey(propName);
        if (!form.dataExists(dataKey)) {
            PropertyFieldProcessor processor = new PropertyFieldProcessor(this.namespaceService, this.dictionaryService);
            Object value = processor.getValue(propName, itemData);
            form.addData(dataKey, value);
        }
    }

    private String makePropDataKey(QName propName) {
        String propPrefixName = propName.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = "prop_" + propPrefixName.replace(':', '_');
        return dataKey;
    }

    @Override
    protected List<Field> generateDefaultFields(FormCreationData data, List<String> fieldsToIgnore) {
        DefaultFieldBuilder defaultFieldBuilder = new DefaultFieldBuilder(data, this.fieldProcessorRegistry, this.namespaceService, fieldsToIgnore);
        return defaultFieldBuilder.buildDefaultFields();
    }

    @Override
    protected ContentModelItemData<ItemType> makeItemData(ItemType item) {
        TypeDefinition baseType = this.getBaseType(item);
        Set<QName> aspects = this.getAspectNames(item);
        TypeDefinition anonType = this.dictionaryService.getAnonymousType(baseType.getName(), aspects);
        Map propDefs = anonType.getProperties();
        Map assocDefs = anonType.getAssociations();
        Map<QName, Serializable> propValues = this.getPropertyValues(item);
        Map<QName, Serializable> assocValues = this.getAssociationValues(item);
        Map<String, Object> transientValues = this.getTransientValues(item);
        return new ContentModelItemData<ItemType>(item, propDefs, assocDefs, propValues, assocValues, transientValues);
    }

    protected Set<QName> getAspectNames(ItemType item) {
        return this.getBaseType(item).getDefaultAspectNames();
    }

    protected abstract Map<QName, Serializable> getAssociationValues(ItemType var1);

    protected abstract Map<QName, Serializable> getPropertyValues(ItemType var1);

    protected abstract Map<String, Object> getTransientValues(ItemType var1);

    protected abstract TypeDefinition getBaseType(ItemType var1);

    protected void persistNode(NodeRef nodeRef, FormData data) {
        QName type = this.nodeService.getType(nodeRef);
        TypeDefinition typeDef = this.dictionaryService.getAnonymousType(type, (Collection)this.nodeService.getAspects(nodeRef));
        Map assocDefs = typeDef.getAssociations();
        Map childAssocDefs = typeDef.getChildAssociations();
        Map propDefs = typeDef.getProperties();
        HashMap<QName, Serializable> propsToPersist = new HashMap<QName, Serializable>(data.getNumberOfFields());
        ArrayList<AbstractAssocCommand> assocsToPersist = new ArrayList<AbstractAssocCommand>();
        for (FormData.FieldData fieldData : data) {
            if (fieldData.isFile()) continue;
            String fieldName = fieldData.getName();
            if (fieldName.startsWith("prop_")) {
                this.processPropertyPersist(nodeRef, propDefs, fieldData, propsToPersist, data);
                continue;
            }
            if (fieldName.startsWith("assoc_")) {
                this.processAssociationPersist(nodeRef, assocDefs, childAssocDefs, fieldData, assocsToPersist);
                continue;
            }
            if (!this.getLogger().isWarnEnabled()) continue;
            this.getLogger().warn((Object)("Ignoring unrecognised field '" + fieldName + "'"));
        }
        this.nodeService.addProperties(nodeRef, propsToPersist);
        for (AbstractAssocCommand cmd : assocsToPersist) {
            cmd.updateAssociations(this.nodeService);
        }
    }

    protected void processPropertyPersist(NodeRef nodeRef, Map<QName, PropertyDefinition> propDefs, FormData.FieldData fieldData, Map<QName, Serializable> propsToPersist, FormData data) {
        block27: {
            block24: {
                block25: {
                    ArrayList<String> value;
                    QName fullQName;
                    block31: {
                        PropertyDefinition propDef;
                        block32: {
                            block29: {
                                block30: {
                                    block28: {
                                        block26: {
                                            String localName;
                                            Matcher m;
                                            if (this.getLogger().isDebugEnabled()) {
                                                this.getLogger().debug((Object)("Processing field " + fieldData + " for property persistence"));
                                            }
                                            if (!(m = this.propertyNamePattern.matcher(fieldData.getName())).matches()) break block24;
                                            String qNamePrefix = m.group(1);
                                            fullQName = QName.createQName((String)qNamePrefix, (String)(localName = m.group(2)), (NamespacePrefixResolver)this.namespaceService);
                                            propDef = propDefs.get(fullQName);
                                            if (propDef == null) {
                                                propDef = this.dictionaryService.getProperty(fullQName);
                                            }
                                            if (propDef == null) break block25;
                                            if (!fullQName.equals((Object)ContentModel.PROP_NAME)) break block26;
                                            this.processNamePropertyPersist(nodeRef, fieldData);
                                            break block27;
                                        }
                                        if (!propDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) break block28;
                                        this.processContentPropertyPersist(nodeRef, fieldData, propsToPersist, data);
                                        break block27;
                                    }
                                    value = fieldData.getValue();
                                    if (!propDef.isMultiValued()) break block29;
                                    if (!(value instanceof String)) break block30;
                                    if (((String)((Object)value)).length() == 0) {
                                        value = null;
                                    } else {
                                        StringTokenizer tokenizer = new StringTokenizer((String)((Object)value), ",");
                                        ArrayList<String> list = new ArrayList<String>(8);
                                        while (tokenizer.hasMoreTokens()) {
                                            list.add(tokenizer.nextToken());
                                        }
                                        value = list;
                                    }
                                    break block31;
                                }
                                if (!(value instanceof JSONArray)) break block31;
                                JSONArray jsonArr = (JSONArray)value;
                                int arrLength = jsonArr.length();
                                ArrayList<Object> list = new ArrayList<Object>(arrLength);
                                try {
                                    for (int x = 0; x < arrLength; ++x) {
                                        list.add(jsonArr.get(x));
                                    }
                                }
                                catch (JSONException je) {
                                    throw new FormException("Failed to convert JSONArray to List", je);
                                }
                                value = list;
                                break block31;
                            }
                            if (!propDef.getDataType().getName().equals((Object)DataTypeDefinition.BOOLEAN)) break block32;
                            if (!(value instanceof String) || !"on".equals(value)) break block31;
                            value = Boolean.TRUE;
                            break block31;
                        }
                        if (propDef.getDataType().getName().equals((Object)DataTypeDefinition.LOCALE)) {
                            value = I18NUtil.parseLocale((String)((String)((Object)value)));
                        } else if (value instanceof String && ((String)((Object)value)).length() == 0) {
                            if (!propDef.getDataType().getName().equals((Object)DataTypeDefinition.TEXT) && !propDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT)) {
                                value = null;
                            } else {
                                List constraints = propDef.getConstraints();
                                if (constraints != null && constraints.size() > 0) {
                                    for (ConstraintDefinition constraintDef : constraints) {
                                        if (!"REGEX".equals(constraintDef.getConstraint().getType())) continue;
                                        value = null;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    propsToPersist.put(fullQName, value);
                    break block27;
                }
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn((Object)("Ignoring field '" + fieldData.getName() + "' as a property definition can not be found"));
                }
                break block27;
            }
            Matcher tppm = this.transientPropertyPattern.matcher(fieldData.getName());
            if (tppm.matches()) {
                String fieldName = tppm.group(1);
                if (fieldName.equals("mimetype")) {
                    this.processMimetypePropertyPersist(nodeRef, fieldData, propsToPersist);
                } else if (fieldName.equals("encoding")) {
                    this.processEncodingPropertyPersist(nodeRef, fieldData, propsToPersist);
                } else if (!fieldName.equals("size") && this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn((Object)("Ignoring unrecognised field '" + fieldData.getName() + "'"));
                }
            } else if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn((Object)("Ignoring unrecognised field '" + fieldData.getName() + "'"));
            }
        }
    }

    protected void processAssociationPersist(NodeRef nodeRef, Map<QName, AssociationDefinition> assocDefs, Map<QName, ChildAssociationDefinition> childAssocDefs, FormData.FieldData fieldData, List<AbstractAssocCommand> assocCommands) {
        String fieldName;
        Matcher m;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Processing field " + fieldData + " for association persistence"));
        }
        if ((m = this.associationNamePattern.matcher(fieldName = fieldData.getName())).matches()) {
            String[] nodeRefs;
            String qNamePrefix = m.group(1);
            String localName = m.group(2);
            String assocSuffix = m.group(3);
            QName fullQName = QName.createQName((String)qNamePrefix, (String)localName, (NamespacePrefixResolver)this.namespaceService);
            AssociationDefinition assocDef = assocDefs.get(fullQName);
            if (assocDef == null) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn((Object)("Ignoring field '" + fieldName + "' as an association definition can not be found"));
                }
                return;
            }
            String value = (String)fieldData.getValue();
            for (String nextTargetNode : nodeRefs = value.split(",")) {
                StringBuilder msg;
                if (nextTargetNode.length() <= 0) continue;
                if (NodeRef.isNodeRef((String)nextTargetNode)) {
                    if (assocSuffix.equals("_added")) {
                        if (assocDef.isChild()) {
                            assocCommands.add(new AddChildAssocCommand(nodeRef, new NodeRef(nextTargetNode), fullQName));
                            continue;
                        }
                        assocCommands.add(new AddAssocCommand(nodeRef, new NodeRef(nextTargetNode), fullQName));
                        continue;
                    }
                    if (assocSuffix.equals("_removed")) {
                        if (assocDef.isChild()) {
                            assocCommands.add(new RemoveChildAssocCommand(nodeRef, new NodeRef(nextTargetNode), fullQName));
                            continue;
                        }
                        assocCommands.add(new RemoveAssocCommand(nodeRef, new NodeRef(nextTargetNode), fullQName));
                        continue;
                    }
                    if (!this.getLogger().isWarnEnabled()) continue;
                    msg = new StringBuilder();
                    msg.append("Ignoring 'fieldName ").append(fieldName).append("' as it does not have one of the expected suffixes (").append("_added").append(" or ").append("_removed").append(")");
                    this.getLogger().warn((Object)msg.toString());
                    continue;
                }
                if (!this.getLogger().isWarnEnabled()) continue;
                msg = new StringBuilder();
                msg.append("targetNode ").append(nextTargetNode).append(" is not a valid NodeRef and has been ignored.");
                this.getLogger().warn((Object)msg.toString());
            }
        } else if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn((Object)("Ignoring unrecognised field '" + fieldName + "'"));
        }
    }

    protected void processNamePropertyPersist(NodeRef nodeRef, FormData.FieldData fieldData) {
        try {
            this.fileFolderService.rename(nodeRef, (String)fieldData.getValue());
        }
        catch (FileExistsException fee) {
            throw new FormException("Failed to persist field '" + fieldData.getName() + "'", fee);
        }
        catch (FileNotFoundException fnne) {
            throw new FormException("Failed to persist field '" + fieldData.getName() + "'", fnne);
        }
    }

    protected void processMimetypePropertyPersist(NodeRef nodeRef, FormData.FieldData fieldData, Map<QName, Serializable> propsToPersist) {
        ContentData contentData = (ContentData)propsToPersist.get(ContentModel.PROP_CONTENT);
        if (contentData == null) {
            contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
        }
        if (contentData != null) {
            contentData = ContentData.setMimetype((ContentData)contentData, (String)((String)fieldData.getValue()));
            propsToPersist.put(ContentModel.PROP_CONTENT, (Serializable)contentData);
        }
    }

    protected void processEncodingPropertyPersist(NodeRef nodeRef, FormData.FieldData fieldData, Map<QName, Serializable> propsToPersist) {
        ContentData contentData = (ContentData)propsToPersist.get(ContentModel.PROP_CONTENT);
        if (contentData == null) {
            contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
        }
        if (contentData != null) {
            contentData = ContentData.setEncoding((ContentData)contentData, (String)((String)fieldData.getValue()));
            propsToPersist.put(ContentModel.PROP_CONTENT, (Serializable)contentData);
        }
    }

    protected void processContentPropertyPersist(NodeRef nodeRef, FormData.FieldData fieldData, Map<QName, Serializable> propsToPersist, FormData data) {
        ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        ContentData contentData = null;
        if (writer != null) {
            boolean defaultMimetypeRequired = this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT) == null;
            writer.putContent((String)fieldData.getValue());
            if (defaultMimetypeRequired) {
                contentData = (ContentData)propsToPersist.get(ContentModel.PROP_CONTENT);
                if (contentData != null) {
                    String mimetype = contentData.getMimetype();
                    if (mimetype == null) {
                        contentData = ContentData.setMimetype((ContentData)contentData, (String)this.determineDefaultMimetype(data));
                    }
                } else {
                    contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
                    if (contentData != null) {
                        contentData = ContentData.setMimetype((ContentData)contentData, (String)this.determineDefaultMimetype(data));
                    }
                }
            } else {
                contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
                if (contentData != null && propsToPersist.containsKey(ContentModel.PROP_CONTENT)) {
                    ContentData mimetypeEncoding = (ContentData)propsToPersist.get(ContentModel.PROP_CONTENT);
                    contentData = ContentData.setMimetype((ContentData)contentData, (String)mimetypeEncoding.getMimetype());
                    contentData = ContentData.setEncoding((ContentData)contentData, (String)mimetypeEncoding.getEncoding());
                }
            }
            if (contentData != null) {
                propsToPersist.put(ContentModel.PROP_CONTENT, (Serializable)contentData);
            }
        }
    }

    protected String determineDefaultMimetype(FormData data) {
        String mimetypeFieldValue;
        FormData.FieldData mimetypeField;
        String mimetype = "text/plain";
        if (data != null && (mimetypeField = data.getFieldData("prop_mimetype")) != null && (mimetypeFieldValue = (String)mimetypeField.getValue()) != null && mimetypeFieldValue.length() > 0) {
            mimetype = mimetypeFieldValue;
        }
        return mimetype;
    }
}

