/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.workflow;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.alfresco.repo.forms.processor.node.ContentModelItemData;
import org.alfresco.repo.forms.processor.workflow.AbstractWorkflowFormProcessor;
import org.alfresco.repo.forms.processor.workflow.ContentModelFormPersister;
import org.alfresco.repo.forms.processor.workflow.WorkflowFormPersister;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowFormProcessor
extends AbstractWorkflowFormProcessor<WorkflowDefinition, WorkflowInstance> {
    private static final Log logger = LogFactory.getLog(WorkflowFormProcessor.class);

    @Override
    protected Map<QName, Serializable> getAssociationValues(WorkflowDefinition item) {
        return null;
    }

    @Override
    protected TypeDefinition getBaseType(WorkflowDefinition item) {
        WorkflowTaskDefinition startTask = item.getStartTaskDefinition();
        return startTask.getMetadata();
    }

    @Override
    protected Map<QName, Serializable> getPropertyValues(WorkflowDefinition item) {
        return null;
    }

    @Override
    protected Map<String, Object> getTransientValues(WorkflowDefinition item) {
        return Collections.singletonMap("packageItems", Collections.emptyList());
    }

    @Override
    protected String getItemType(WorkflowDefinition item) {
        return item.name;
    }

    @Override
    protected String getItemURI(WorkflowDefinition item) {
        return "api/workflow-definitions/" + item.id;
    }

    @Override
    protected Log getLogger() {
        return logger;
    }

    @Override
    protected WorkflowDefinition getTypedItemForDecodedId(String itemId) {
        String workflowDefName = this.decodeWorkflowDefinitionName(itemId);
        WorkflowDefinition workflowDef = this.workflowService.getDefinitionByName(workflowDefName);
        if (workflowDef == null) {
            String msg = "Workflow definition does not exist: " + itemId;
            throw new IllegalArgumentException(msg);
        }
        return workflowDef;
    }

    private String decodeWorkflowDefinitionName(String name) {
        if (!name.contains(":")) {
            name = name.replaceFirst("_", ":");
        }
        return name;
    }

    @Override
    protected ContentModelFormPersister<WorkflowInstance> makeFormPersister(WorkflowDefinition item) {
        Object itemData = this.makeItemData(item);
        return new WorkflowFormPersister((ContentModelItemData<?>)itemData, this.namespaceService, this.dictionaryService, this.workflowService, this.nodeService, logger);
    }
}

