/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.googledocs;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.coci.CheckOutCheckInServicePolicies;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.googledocs.GoogleDocsModel;
import org.alfresco.repo.googledocs.GoogleDocsPermissionContext;
import org.alfresco.repo.googledocs.GoogleDocsService;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleEditableAspect
implements NodeServicePolicies.OnAddAspectPolicy,
CheckOutCheckInServicePolicies.OnCheckOut,
CheckOutCheckInServicePolicies.BeforeCheckIn,
NodeServicePolicies.BeforeDeleteNodePolicy {
    boolean enabled = false;
    private PolicyComponent policyComponent;
    private GoogleDocsService googleDocsService;
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private ContentService contentService;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setGoogleDocsService(GoogleDocsService googleDocsService) {
        this.googleDocsService = googleDocsService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void init() {
        if (this.enabled) {
            this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnAddAspectPolicy.QNAME, GoogleDocsModel.ASPECT_GOOGLEEDITABLE, (Behaviour)new JavaBehaviour(this, "onAddAspect", Behaviour.NotificationFrequency.FIRST_EVENT));
            this.policyComponent.bindClassBehaviour(CheckOutCheckInServicePolicies.OnCheckOut.QNAME, GoogleDocsModel.ASPECT_GOOGLEEDITABLE, (Behaviour)new JavaBehaviour(this, "onCheckOut", Behaviour.NotificationFrequency.FIRST_EVENT));
            this.policyComponent.bindClassBehaviour(CheckOutCheckInServicePolicies.BeforeCheckIn.QNAME, GoogleDocsModel.ASPECT_GOOGLERESOURCE, (Behaviour)new JavaBehaviour(this, "beforeCheckIn", Behaviour.NotificationFrequency.FIRST_EVENT));
            this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, GoogleDocsModel.ASPECT_GOOGLERESOURCE, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode", Behaviour.NotificationFrequency.FIRST_EVENT));
            this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), GoogleDocsModel.ASPECT_GOOGLEEDITABLE, (Behaviour)new JavaBehaviour(this, "getGoogleEditableCopyCallback"));
            this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), GoogleDocsModel.ASPECT_GOOGLERESOURCE, (Behaviour)new JavaBehaviour(this, "getGoogleResourceCopyCallback"));
        }
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        QName type;
        if (this.nodeService.exists(nodeRef) && !this.dictionaryService.isSubClass(type = this.nodeService.getType(nodeRef), ContentModel.TYPE_CONTENT)) {
            throw new AlfrescoRuntimeException("The node (" + nodeRef.toString() + ") can not be made google editable, because it is not a sub type of cm:content.");
        }
    }

    @Override
    public void onCheckOut(NodeRef workingCopy) {
        if (this.nodeService.exists(workingCopy) && !this.isUpload()) {
            this.googleDocsService.createGoogleDoc(workingCopy, GoogleDocsPermissionContext.SHARE_WRITE);
        }
    }

    private boolean isUpload() {
        boolean result = false;
        String value = (String)AlfrescoTransactionSupport.getResource("checkoutforupload");
        if (value != null) {
            result = Boolean.parseBoolean(value);
        }
        return result;
    }

    @Override
    public void beforeCheckIn(NodeRef workingCopyNodeRef, Map<String, Serializable> versionProperties, String contentUrl, boolean keepCheckedOut) {
        if (this.nodeService.exists(workingCopyNodeRef) && this.nodeService.hasAspect(workingCopyNodeRef, GoogleDocsModel.ASPECT_GOOGLERESOURCE) && !this.isUpload()) {
            InputStream is = this.googleDocsService.getGoogleDocContent(workingCopyNodeRef);
            if (is == null) {
                throw new AlfrescoRuntimeException("Unable to complete check in, because the working copy content could not be retrieved from google docs.");
            }
            ContentWriter writer = this.contentService.getWriter(workingCopyNodeRef, ContentModel.PROP_CONTENT, true);
            writer.putContent(is);
        }
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        if (this.nodeService.exists(nodeRef) && !this.isUpload()) {
            this.googleDocsService.deleteGoogleResource(nodeRef);
        }
    }

    public CopyBehaviourCallback getGoogleEditableCopyCallback(QName classRef, CopyDetails copyDetails) {
        return GoogleEditableCopyBehaviourCallback.INSTANCE;
    }

    public CopyBehaviourCallback getGoogleResourceCopyCallback(QName classRef, CopyDetails copyDetails) {
        return GoogleResourceCopyBehaviourCallback.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GoogleResourceCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new GoogleEditableCopyBehaviourCallback();

        private GoogleResourceCopyBehaviourCallback() {
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            return Collections.emptyMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GoogleEditableCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new GoogleEditableCopyBehaviourCallback();

        private GoogleEditableCopyBehaviourCallback() {
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            return Collections.emptyMap();
        }
    }
}

