/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.Flags;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ImapModel;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.imap.AlfrescoImapConst;
import org.alfresco.repo.imap.AlfrescoImapFolder;
import org.alfresco.repo.imap.AlfrescoImapUser;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.imap.config.ImapConfigMountPointsBean;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.site.SiteServiceException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.SubFolderFilter;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.Utf7;
import org.alfresco.util.config.RepositoryFolderConfigBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImapServiceImpl
implements ImapService {
    private Log logger = LogFactory.getLog(ImapServiceImpl.class);
    private static final String ERROR_PERMISSION_DENIED = "imap.server.error.permission_denied";
    private static final String ERROR_FOLDER_ALREADY_EXISTS = "imap.server.error.folder_already_exist";
    private static final String ERROR_MAILBOX_NAME_IS_MANDATORY = "imap.server.error.mailbox_name_is_mandatory";
    private static final String ERROR_CANNOT_GET_A_FOLDER = "imap.server.error.cannot_get_a_folder";
    private static final String CHECKED_NODES = "imap.flaggable.aspect.checked.list";
    private static final String FAVORITE_SITES = "imap.favorite.sites.list";
    private SysAdminParams sysAdminParams;
    private FileFolderService fileFolderService;
    private NodeService nodeService;
    private PermissionService permissionService;
    private ServiceRegistry serviceRegistry;
    private Map<String, ImapConfigMountPointsBean> imapConfigMountPoints;
    private RepositoryFolderConfigBean[] ignoreExtractionFoldersBeans;
    private RepositoryFolderConfigBean imapHomeConfigBean;
    private NodeRef imapHomeNodeRef;
    private Set<NodeRef> ignoreExtractionFolders;
    private String defaultFromAddress;
    private String repositoryTemplatePath;
    private boolean extractAttachmentsEnabled = true;
    private Map<ImapService.EmailBodyType, String> defaultBodyTemplates;
    private static final Map<QName, Flags.Flag> qNameToFlag = new HashMap<QName, Flags.Flag>();
    private static final Map<Flags.Flag, QName> flagToQname;

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public FileFolderService getFileFolderService() {
        return this.fileFolderService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setImapHome(RepositoryFolderConfigBean imapHomeConfigBean) {
        this.imapHomeConfigBean = imapHomeConfigBean;
    }

    @Override
    public String getDefaultFromAddress() {
        return this.defaultFromAddress;
    }

    public void setDefaultFromAddress(String defaultFromAddress) {
        this.defaultFromAddress = defaultFromAddress;
    }

    @Override
    public String getWebApplicationContextUrl() {
        return this.sysAdminParams.getAlfrescoProtocol() + "://" + this.sysAdminParams.getAlfrescoHost() + ":" + this.sysAdminParams.getAlfrescoPort() + "/" + this.sysAdminParams.getAlfrescoContext();
    }

    @Override
    public String getRepositoryTemplatePath() {
        return this.repositoryTemplatePath;
    }

    public void setRepositoryTemplatePath(String repositoryTemplatePath) {
        this.repositoryTemplatePath = repositoryTemplatePath;
    }

    public void setImapConfigMountPoints(ImapConfigMountPointsBean[] imapConfigMountPointsBeans) {
        this.imapConfigMountPoints = new LinkedHashMap<String, ImapConfigMountPointsBean>(imapConfigMountPointsBeans.length * 2);
        for (ImapConfigMountPointsBean bean : imapConfigMountPointsBeans) {
            this.imapConfigMountPoints.put(bean.getMountPointName(), bean);
        }
    }

    public void setIgnoreExtractionFolders(RepositoryFolderConfigBean[] ignoreExtractionFolders) {
        this.ignoreExtractionFoldersBeans = ignoreExtractionFolders;
    }

    public void setExtractAttachmentsEnabled(boolean extractAttachmentsEnabled) {
        this.extractAttachmentsEnabled = extractAttachmentsEnabled;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"imapConfigMountPoints", this.imapConfigMountPoints);
        PropertyCheck.mandatory((Object)this, (String)"ignoreExtractionFoldersBeans", (Object)this.ignoreExtractionFoldersBeans);
        PropertyCheck.mandatory((Object)this, (String)"imapHome", (Object)this.imapHomeConfigBean);
        PropertyCheck.mandatory((Object)this, (String)"fileFolderService", (Object)this.fileFolderService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"permissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"serviceRegistry", (Object)this.serviceRegistry);
        PropertyCheck.mandatory((Object)this, (String)"defaultFromAddress", (Object)this.defaultFromAddress);
        PropertyCheck.mandatory((Object)this, (String)"repositoryTemplatePath", (Object)this.repositoryTemplatePath);
    }

    public void startup() {
        final NamespaceService namespaceService = this.serviceRegistry.getNamespaceService();
        final SearchService searchService = this.serviceRegistry.getSearchService();
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                ImapServiceImpl.this.getMountPoints();
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        this.ignoreExtractionFolders = (Set)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Set<NodeRef>>(){

            public Set<NodeRef> doWork() throws Exception {
                HashSet<NodeRef> result = new HashSet<NodeRef>(ImapServiceImpl.this.ignoreExtractionFoldersBeans.length * 2);
                for (RepositoryFolderConfigBean ignoreExtractionFoldersBean : ImapServiceImpl.this.ignoreExtractionFoldersBeans) {
                    NodeRef nodeRef = ignoreExtractionFoldersBean.getFolderPath(namespaceService, ImapServiceImpl.this.nodeService, searchService, ImapServiceImpl.this.fileFolderService);
                    if (result.add(nodeRef)) continue;
                    throw new AlfrescoRuntimeException("The folder extraction path has been referenced already: \n   Folder: " + ignoreExtractionFoldersBean);
                }
                return result;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        this.imapHomeNodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return ImapServiceImpl.this.imapHomeConfigBean.getOrCreateFolderPath(namespaceService, ImapServiceImpl.this.nodeService, searchService, ImapServiceImpl.this.fileFolderService);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public void shutdown() {
    }

    @Override
    public List<AlfrescoImapFolder> listSubscribedMailboxes(AlfrescoImapUser user, String mailboxPattern) {
        mailboxPattern = Utf7.decode(mailboxPattern, "X-MODIFIED-UTF-7");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Listing subscribed mailboxes: mailboxPattern=" + mailboxPattern));
        }
        mailboxPattern = this.getMailPathInRepo(mailboxPattern);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Listing subscribed mailboxes: mailboxPattern in Alfresco=" + mailboxPattern));
        }
        return this.listMailboxes(user, mailboxPattern, true);
    }

    @Override
    public List<AlfrescoImapFolder> listMailboxes(AlfrescoImapUser user, String mailboxPattern) {
        mailboxPattern = Utf7.decode(mailboxPattern, "X-MODIFIED-UTF-7");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Listing  mailboxes: mailboxPattern=" + mailboxPattern));
        }
        mailboxPattern = this.getMailPathInRepo(mailboxPattern);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Listing  mailboxes: mailboxPattern in Alfresco=" + mailboxPattern));
        }
        return this.listMailboxes(user, mailboxPattern, false);
    }

    @Override
    public AlfrescoImapFolder createMailbox(AlfrescoImapUser user, String mailboxName) {
        NodeRef root;
        if (mailboxName == null) {
            throw new IllegalArgumentException(I18NUtil.getMessage((String)ERROR_MAILBOX_NAME_IS_MANDATORY));
        }
        mailboxName = Utf7.decode(mailboxName, "X-MODIFIED-UTF-7");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating mailbox: " + mailboxName));
        }
        NodeRef parentNodeRef = root = this.getMailboxRootRef(mailboxName, user.getLogin());
        for (String folderName : this.getMailPathInRepo(mailboxName).split(String.valueOf('/'))) {
            NodeRef child = this.fileFolderService.searchSimple(parentNodeRef, folderName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Trying to create folder '" + folderName + "'"));
            }
            if (child == null) {
                AccessStatus status = this.permissionService.hasPermission(parentNodeRef, "CreateChildren");
                if (status == AccessStatus.DENIED) {
                    throw new AlfrescoRuntimeException(ERROR_PERMISSION_DENIED);
                }
                FileInfo mailFolder = this.serviceRegistry.getFileFolderService().create(parentNodeRef, folderName, ContentModel.TYPE_FOLDER);
                return new AlfrescoImapFolder(user.getQualifiedMailboxName(), mailFolder, folderName, this.getViewMode(mailboxName), root, this.getMountPointName(mailboxName), this.isExtractionEnabled(mailFolder.getNodeRef()), this.serviceRegistry);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Folder '" + folderName + "' already exists"));
            }
            parentNodeRef = child;
        }
        throw new AlfrescoRuntimeException(ERROR_FOLDER_ALREADY_EXISTS);
    }

    @Override
    public void deleteMailbox(AlfrescoImapUser user, String mailboxName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleting mailbox: mailboxName=" + mailboxName));
        }
        if (mailboxName == null) {
            throw new IllegalArgumentException(I18NUtil.getMessage((String)ERROR_MAILBOX_NAME_IS_MANDATORY));
        }
        AlfrescoImapFolder folder = this.getFolder(user, mailboxName);
        NodeRef nodeRef = folder.getFolderInfo().getNodeRef();
        List<FileInfo> childFolders = this.fileFolderService.listFolders(nodeRef);
        if (childFolders.isEmpty()) {
            folder.signalDeletion();
            this.fileFolderService.delete(nodeRef);
        } else if (folder.isSelectable()) {
            List<FileInfo> messages = this.fileFolderService.listFiles(nodeRef);
            for (FileInfo message : messages) {
                this.fileFolderService.delete(message.getNodeRef());
            }
            this.nodeService.addAspect(nodeRef, ImapModel.ASPECT_IMAP_FOLDER_NONSELECTABLE, null);
        } else {
            throw new AlfrescoRuntimeException(mailboxName + " - Can't delete a non-selectable store with children.");
        }
    }

    @Override
    public void renameMailbox(AlfrescoImapUser user, String oldMailboxName, String newMailboxName) {
        if (oldMailboxName == null || newMailboxName == null) {
            throw new IllegalArgumentException(ERROR_MAILBOX_NAME_IS_MANDATORY);
        }
        oldMailboxName = Utf7.decode(oldMailboxName, "X-MODIFIED-UTF-7");
        newMailboxName = Utf7.decode(newMailboxName, "X-MODIFIED-UTF-7");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Renaming folder oldMailboxName=" + oldMailboxName + " newMailboxName=" + newMailboxName));
        }
        AlfrescoImapFolder sourceNode = this.getFolder(user, oldMailboxName);
        NodeRef root = this.getMailboxRootRef(oldMailboxName, user.getLogin());
        String[] folderNames = this.getMailPathInRepo(newMailboxName).split(String.valueOf('/'));
        String folderName = null;
        NodeRef parentNodeRef = root;
        try {
            for (int i = 0; i < folderNames.length; ++i) {
                folderName = folderNames[i];
                if (i == folderNames.length - 1) {
                    if (oldMailboxName.equalsIgnoreCase("INBOX")) {
                        this.fileFolderService.copy(sourceNode.getFolderInfo().getNodeRef(), parentNodeRef, folderName);
                        continue;
                    }
                    this.fileFolderService.move(sourceNode.getFolderInfo().getNodeRef(), parentNodeRef, folderName);
                    continue;
                }
                NodeRef child = this.fileFolderService.searchSimple(parentNodeRef, folderName);
                if (child == null) {
                    AccessStatus status = this.permissionService.hasPermission(parentNodeRef, "CreateChildren");
                    if (status == AccessStatus.DENIED) {
                        throw new AlfrescoRuntimeException(ERROR_PERMISSION_DENIED);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Creating folder '" + folderName + "'"));
                    }
                    this.serviceRegistry.getFileFolderService().create(parentNodeRef, folderName, ContentModel.TYPE_FOLDER);
                    continue;
                }
                parentNodeRef = child;
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Folder '" + folderName + "' already exists"));
            }
        }
        catch (Exception e) {
            if (e instanceof AlfrescoRuntimeException) {
                throw (AlfrescoRuntimeException)((Object)e);
            }
            throw new AlfrescoRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public AlfrescoImapFolder getFolder(AlfrescoImapUser user, String mailboxName) {
        NodeRef root;
        mailboxName = Utf7.decode(mailboxName, "X-MODIFIED-UTF-7");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Get folder '" + mailboxName + "'"));
        }
        if ("".equals(mailboxName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Request for the hierarchy delimiter");
            }
            return new AlfrescoImapFolder(user.getQualifiedMailboxName(), this.serviceRegistry);
        }
        AlfrescoImapConst.ImapViewMode viewMode = this.getViewMode(mailboxName);
        String mountPointName = this.getMountPointName(mailboxName);
        NodeRef nodeRef = root = this.getMailboxRootRef(mailboxName, user.getLogin());
        String[] folderNames = this.getMailPathInRepo(mailboxName).split(String.valueOf('/'));
        if (folderNames.length == 1 && folderNames[0].length() == 0) {
            FileInfo folderFileInfo = this.fileFolderService.getFileInfo(root);
            AlfrescoImapFolder folder = new AlfrescoImapFolder(user.getQualifiedMailboxName(), folderFileInfo, mountPointName, viewMode, root, mountPointName, this.isExtractionEnabled(folderFileInfo.getNodeRef()), this.serviceRegistry);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Returning root folder '" + mailboxName + "'"));
            }
            return folder;
        }
        for (int i = 0; i < folderNames.length; ++i) {
            NodeRef targetNode;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing of " + folderNames[i]));
            }
            if ((targetNode = this.fileFolderService.searchSimple(nodeRef, folderNames[i])) == null) {
                AlfrescoImapFolder folder = new AlfrescoImapFolder(user.getQualifiedMailboxName(), this.serviceRegistry);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Returning empty folder '" + folderNames[i]));
                }
                return folder;
            }
            if (i == folderNames.length - 1) {
                FileInfo folderFileInfo = this.fileFolderService.getFileInfo(targetNode);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found folder to list: " + folderFileInfo.getName()));
                }
                AlfrescoImapFolder folder = new AlfrescoImapFolder(user.getQualifiedMailboxName(), folderFileInfo, folderFileInfo.getName(), viewMode, root, mountPointName, this.isExtractionEnabled(folderFileInfo.getNodeRef()), this.serviceRegistry);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Returning folder '" + mailboxName + "'"));
                }
                return folder;
            }
            nodeRef = targetNode;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Cannot get a folder '" + mailboxName + "'"));
        }
        throw new AlfrescoRuntimeException(ERROR_CANNOT_GET_A_FOLDER, (Object[])new String[]{mailboxName});
    }

    private List<FileInfo> searchDeep(NodeRef contextNodeRef, AlfrescoImapConst.ImapViewMode viewMode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[searchDeep] Start. nodeRef=" + contextNodeRef + ", viewMode=" + (Object)((Object)viewMode)));
        }
        List<FileInfo> searchResult = this.fileFolderService.listDeepFolders(contextNodeRef, new ImapSubFolderFilter(viewMode));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"[searchDeep] End");
        }
        return new ArrayList<FileInfo>(searchResult);
    }

    private List<FileInfo> searchByPattern(NodeRef contextNodeRef, AlfrescoImapConst.ImapViewMode viewMode, String namePattern) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[searchByPattern] Start. nodeRef=" + contextNodeRef + ", namePattern=" + namePattern));
        }
        List<FileInfo> searchResult = "*".equals(namePattern) ? this.fileFolderService.listFolders(contextNodeRef) : this.fileFolderService.listDeepFolders(contextNodeRef, new ImapSubFolderFilter(viewMode, namePattern));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[searchByPattern] End. namePattern=" + namePattern));
        }
        return searchResult;
    }

    @Override
    public List<FileInfo> searchMails(NodeRef contextNodeRef, AlfrescoImapConst.ImapViewMode viewMode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Search mails contextNodeRef=" + contextNodeRef + ", viewMode=" + (Object)((Object)viewMode)));
        }
        List<FileInfo> searchResult = this.fileFolderService.listFiles(contextNodeRef);
        List<Object> result = new LinkedList();
        switch (viewMode) {
            case MIXED: {
                result = searchResult;
                break;
            }
            case ARCHIVE: {
                for (FileInfo fileInfo : searchResult) {
                    if (!this.nodeService.hasAspect(fileInfo.getNodeRef(), ImapModel.ASPECT_IMAP_CONTENT)) continue;
                    result.add(fileInfo);
                }
                break;
            }
            case VIRTUAL: {
                for (FileInfo fileInfo : searchResult) {
                    if (this.nodeService.hasAspect(fileInfo.getNodeRef(), ImapModel.ASPECT_IMAP_CONTENT)) continue;
                    result.add(fileInfo);
                }
                break;
            }
        }
        this.logger.debug((Object)("Found files:" + result.size()));
        return result;
    }

    @Override
    public void subscribe(AlfrescoImapUser user, String mailbox) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Subscribing: " + user + ", " + mailbox));
        }
        AlfrescoImapFolder mailFolder = this.getFolder(user, mailbox);
        this.nodeService.removeAspect(mailFolder.getFolderInfo().getNodeRef(), ImapModel.ASPECT_IMAP_FOLDER_NONSUBSCRIBED);
    }

    @Override
    public void unsubscribe(AlfrescoImapUser user, String mailbox) {
        AlfrescoImapFolder mailFolder;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Unsubscribing: " + user + ", " + mailbox));
        }
        if ((mailFolder = this.getFolder(user, mailbox)).getFolderInfo() != null) {
            this.logger.debug((Object)"Unsubscribing by ASPECT_IMAP_FOLDER_NONSUBSCRIBED");
            this.nodeService.addAspect(mailFolder.getFolderInfo().getNodeRef(), ImapModel.ASPECT_IMAP_FOLDER_NONSUBSCRIBED, null);
        } else {
            this.logger.debug((Object)"Unable to find folder to unsubscribe");
        }
    }

    @Override
    public synchronized Flags getFlags(FileInfo messageInfo) {
        Flags flags = new Flags();
        this.checkForFlaggableAspect(messageInfo.getNodeRef());
        Map props = this.nodeService.getProperties(messageInfo.getNodeRef());
        for (QName key : qNameToFlag.keySet()) {
            Boolean value = (Boolean)props.get(key);
            if (value == null || !value.booleanValue()) continue;
            flags.add(qNameToFlag.get(key));
        }
        return flags;
    }

    @Override
    public synchronized void setFlags(FileInfo messageInfo, Flags flags, boolean value) {
        this.checkForFlaggableAspect(messageInfo.getNodeRef());
        for (Flags.Flag flag : flags.getSystemFlags()) {
            this.setFlag(messageInfo, flag, value);
        }
    }

    @Override
    public void setFlag(FileInfo messageInfo, Flags.Flag flag, boolean value) {
        NodeRef nodeRef = messageInfo.getNodeRef();
        this.checkForFlaggableAspect(nodeRef);
        AccessStatus status = this.permissionService.hasPermission(nodeRef, "WriteProperties");
        if (status == AccessStatus.DENIED) {
            this.logger.debug((Object)("[setFlag] Access denied to add FLAG to " + nodeRef));
        } else {
            this.nodeService.setProperty(messageInfo.getNodeRef(), flagToQname.get(flag), (Serializable)Boolean.valueOf(value));
        }
    }

    private List<AlfrescoImapFolder> listMailboxes(AlfrescoImapUser user, String mailboxPattern, boolean listSubscribed) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[listMailboxes] user:" + user.getLogin() + ", mailboxPattern:" + mailboxPattern + ", listSubscribed:" + listSubscribed));
        }
        LinkedList<AlfrescoImapFolder> result = new LinkedList<AlfrescoImapFolder>();
        Map<String, NodeRef> mountPoints = this.getMountPoints();
        for (String mountPointName : mountPoints.keySet()) {
            NodeRef mountPoint = mountPoints.get(mountPointName);
            FileInfo mountPointFileInfo = this.fileFolderService.getFileInfo(mountPoint);
            NodeRef mountParent = ((ChildAssociationRef)this.nodeService.getParentAssocs(mountPoint).get(0)).getParentRef();
            AlfrescoImapConst.ImapViewMode viewMode = this.imapConfigMountPoints.get(mountPointName).getMode();
            List<AlfrescoImapFolder> folders = this.expandFolder(mountPoint, mountPoint, user, mailboxPattern, listSubscribed, viewMode);
            if (folders != null) {
                Iterator<AlfrescoImapFolder> i$ = folders.iterator();
                while (i$.hasNext()) {
                    AlfrescoImapFolder mailFolder;
                    AlfrescoImapFolder folder = mailFolder = i$.next();
                    folder.setMountPointName(mountPointName);
                    folder.setViewMode(viewMode);
                    folder.setMountParent(mountParent);
                }
                result.addAll(folders);
            }
            if (!mailboxPattern.equals("*")) continue;
            if (listSubscribed && this.isSubscribed(mountPointFileInfo, user.getLogin()) || !listSubscribed) {
                result.add(new AlfrescoImapFolder(user.getQualifiedMailboxName(), mountPointFileInfo, mountPointName, viewMode, mountParent, mountPointName, this.isExtractionEnabled(mountPointFileInfo.getNodeRef()), this.serviceRegistry));
                continue;
            }
            if (!listSubscribed || !this.hasSubscribedChild(mountPointFileInfo, user.getLogin(), viewMode)) continue;
            result.add(new AlfrescoImapFolder(user.getQualifiedMailboxName(), mountPointFileInfo, mountPointName, viewMode, mountParent, mountPointName, this.serviceRegistry, false, this.isExtractionEnabled(mountPointFileInfo.getNodeRef())));
        }
        NodeRef root = this.getUserImapHomeRef(user.getLogin());
        List<AlfrescoImapFolder> imapFolders = this.expandFolder(root, root, user, mailboxPattern, listSubscribed, AlfrescoImapConst.ImapViewMode.ARCHIVE);
        if (imapFolders != null) {
            for (AlfrescoImapFolder mailFolder : imapFolders) {
                mailFolder.setViewMode(AlfrescoImapConst.ImapViewMode.ARCHIVE);
                mailFolder.setMountParent(root);
            }
            result.addAll(imapFolders);
        }
        this.logger.debug((Object)("listMailboxes returning size:" + result.size()));
        return result;
    }

    private List<AlfrescoImapFolder> expandFolder(NodeRef mailboxRoot, NodeRef root, AlfrescoImapUser user, String mailboxPattern, boolean listSubscribed, AlfrescoImapConst.ImapViewMode viewMode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("List folder: mailboxPattern=" + mailboxPattern));
        }
        if (mailboxPattern == null) {
            return null;
        }
        int index = mailboxPattern.indexOf(47);
        String name = null;
        String remainName = null;
        if (index < 0) {
            name = mailboxPattern;
        } else {
            name = mailboxPattern.substring(0, index);
            remainName = mailboxPattern.substring(index + 1);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Listing mailboxes: name=" + name));
        }
        if (index < 0) {
            List<FileInfo> list;
            if ("*".equals(name)) {
                Collection<FileInfo> list2 = this.searchDeep(root, viewMode);
                if (listSubscribed) {
                    list2 = this.getSubscribed(list2, user.getLogin());
                }
                if (list2.size() > 0) {
                    return this.createMailFolderList(user, list2, mailboxRoot);
                }
                return null;
            }
            if (name.endsWith("*")) {
                List<FileInfo> list3;
                LinkedList<FileInfo> fullList = new LinkedList<FileInfo>();
                Collection<FileInfo> subscribedList = list3 = this.searchByPattern(root, viewMode, name.replace('%', '*'));
                if (listSubscribed) {
                    subscribedList = this.getSubscribed(list3, user.getLogin());
                }
                if (list3.size() > 0) {
                    fullList.addAll(subscribedList);
                    for (FileInfo fileInfo : list3) {
                        List<FileInfo> childList = this.searchDeep(fileInfo.getNodeRef(), viewMode);
                        if (listSubscribed) {
                            fullList.addAll(this.getSubscribed(childList, user.getLogin()));
                            continue;
                        }
                        fullList.addAll(childList);
                    }
                    return this.createMailFolderList(user, fullList, mailboxRoot);
                }
                return null;
            }
            if ("%".equals(name)) {
                LinkedList<AlfrescoImapFolder> subscribedList = new LinkedList<AlfrescoImapFolder>();
                List<FileInfo> list4 = this.searchByPattern(root, viewMode, "*");
                if (listSubscribed) {
                    for (FileInfo fileInfo : list4) {
                        if (this.isSubscribed(fileInfo, user.getLogin())) {
                            subscribedList.add(new AlfrescoImapFolder(user.getQualifiedMailboxName(), fileInfo, null, null, mailboxRoot, null, this.isExtractionEnabled(fileInfo.getNodeRef()), this.serviceRegistry));
                            continue;
                        }
                        if (!this.hasSubscribedChild(fileInfo, user.getLogin(), viewMode)) continue;
                        subscribedList.add(new AlfrescoImapFolder(user.getQualifiedMailboxName(), fileInfo, null, null, mailboxRoot, null, this.serviceRegistry, false, this.isExtractionEnabled(fileInfo.getNodeRef())));
                    }
                } else {
                    return this.createMailFolderList(user, list4, mailboxRoot);
                }
                return subscribedList;
            }
            if (name.contains("%") || name.contains("*")) {
                List<FileInfo> list5;
                Collection<FileInfo> subscribedList = list5 = this.searchByPattern(root, viewMode, name.replace('%', '*'));
                if (listSubscribed) {
                    subscribedList = this.getSubscribed(list5, user.getLogin());
                }
                if (subscribedList.size() > 0) {
                    return this.createMailFolderList(user, subscribedList, mailboxRoot);
                }
                return null;
            }
            Collection<FileInfo> subscribedList = list = this.searchByPattern(root, viewMode, name);
            if (listSubscribed) {
                subscribedList = this.getSubscribed(list, user.getLogin());
            }
            if (subscribedList.size() > 0) {
                return this.createMailFolderList(user, subscribedList, mailboxRoot);
            }
            return null;
        }
        LinkedList<AlfrescoImapFolder> result = new LinkedList<AlfrescoImapFolder>();
        List<FileInfo> list = this.searchByPattern(root, viewMode, name.replace('%', '*'));
        for (FileInfo folder : list) {
            List<AlfrescoImapFolder> childFolders = this.expandFolder(mailboxRoot, folder.getNodeRef(), user, remainName, listSubscribed, viewMode);
            if (childFolders == null) continue;
            result.addAll(childFolders);
        }
        return !result.isEmpty() ? result : null;
    }

    private String getMailPathInRepo(String mailPath) {
        String rootFolder;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[getMailPathInRepo] Path: " + mailPath));
        }
        String remain = "";
        int index = mailPath.indexOf(47);
        if (index > 0) {
            rootFolder = mailPath.substring(0, index);
            remain = mailPath.substring(index + 1);
        } else {
            rootFolder = mailPath;
        }
        if (this.imapConfigMountPoints.keySet().contains(rootFolder)) {
            String path = remain;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("[getMailPathInRepo] Mounted point returning: " + path));
            }
            return path;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[getMailPathInRepo] Not mounted. Returning path as is: " + mailPath));
        }
        return mailPath;
    }

    private String getMountPointName(String mailboxName) {
        int index = mailboxName.indexOf(47);
        String rootFolder = index > 0 ? mailboxName.substring(0, index) : mailboxName;
        if (this.imapConfigMountPoints.keySet().contains(rootFolder)) {
            return rootFolder;
        }
        return null;
    }

    private Map<String, NodeRef> getMountPoints() {
        HashSet<NodeRef> mountPointNodeRefs = new HashSet<NodeRef>(5);
        HashMap<String, NodeRef> mountPoints = new HashMap<String, NodeRef>();
        NamespaceService namespaceService = this.serviceRegistry.getNamespaceService();
        SearchService searchService = this.serviceRegistry.getSearchService();
        for (ImapConfigMountPointsBean config : this.imapConfigMountPoints.values()) {
            NodeRef nodeRef = config.getFolderPath(namespaceService, this.nodeService, searchService, this.fileFolderService);
            if (!mountPointNodeRefs.add(nodeRef)) {
                throw new IllegalArgumentException("A mount point has been defined twice: \n   Mount point: " + config);
            }
            mountPoints.put(config.getMountPointName(), nodeRef);
        }
        return mountPoints;
    }

    @Override
    public NodeRef getMailboxRootRef(String mailboxName, String userName) {
        int index = mailboxName.indexOf(47);
        String rootFolder = index > 0 ? mailboxName.substring(0, index) : mailboxName;
        Map<String, ImapConfigMountPointsBean> imapConfigs = this.imapConfigMountPoints;
        if (imapConfigs.keySet().contains(rootFolder)) {
            Map<String, NodeRef> mountPoints = this.getMountPoints();
            NodeRef mountRef = mountPoints.get(rootFolder);
            this.logger.debug((Object)("getMailboxRootRef mounted, " + mountRef));
            return mountRef;
        }
        NodeRef ret = this.getUserImapHomeRef(userName);
        this.logger.debug((Object)("getMailboxRootRef using userImapHome, " + ret));
        return ret;
    }

    private NodeRef getUserImapHomeRef(final String userName) {
        NodeRef userHome = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef userHome = ImapServiceImpl.this.fileFolderService.searchSimple(ImapServiceImpl.this.imapHomeNodeRef, userName);
                if (userHome == null) {
                    NodeRef result = ImapServiceImpl.this.fileFolderService.create(ImapServiceImpl.this.imapHomeNodeRef, userName, ContentModel.TYPE_FOLDER).getNodeRef();
                    ImapServiceImpl.this.nodeService.setProperty(result, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)userName));
                    ImapServiceImpl.this.fileFolderService.create(result, "INBOX", ContentModel.TYPE_FOLDER);
                    ImapServiceImpl.this.permissionService.setInheritParentPermissions(result, false);
                    ImapServiceImpl.this.permissionService.setPermission(result, "ROLE_OWNER", "All", true);
                    return result;
                }
                return userHome;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        return userHome;
    }

    private boolean isSubscribed(FileInfo fileInfo, String userName) {
        return !this.nodeService.hasAspect(fileInfo.getNodeRef(), ImapModel.ASPECT_IMAP_FOLDER_NONSUBSCRIBED);
    }

    private Collection<FileInfo> getSubscribed(Collection<FileInfo> list, String userName) {
        LinkedList<FileInfo> result = new LinkedList<FileInfo>();
        for (FileInfo folderInfo : list) {
            if (!this.isSubscribed(folderInfo, userName)) continue;
            result.add(folderInfo);
        }
        return result;
    }

    private boolean hasSubscribedChild(FileInfo parent, String userName, AlfrescoImapConst.ImapViewMode viewMode) {
        List<FileInfo> list = this.searchDeep(parent.getNodeRef(), viewMode);
        for (FileInfo fileInfo : list) {
            if (!this.isSubscribed(fileInfo, userName)) continue;
            return true;
        }
        return false;
    }

    private List<AlfrescoImapFolder> createMailFolderList(AlfrescoImapUser user, Collection<FileInfo> list, NodeRef imapUserHomeRef) {
        LinkedList<AlfrescoImapFolder> result = new LinkedList<AlfrescoImapFolder>();
        for (FileInfo folderInfo : list) {
            result.add(new AlfrescoImapFolder(user.getQualifiedMailboxName(), folderInfo, null, null, imapUserHomeRef, null, this.isExtractionEnabled(folderInfo.getNodeRef()), this.serviceRegistry));
        }
        return result;
    }

    private AlfrescoImapConst.ImapViewMode getViewMode(String mailboxName) {
        int index = mailboxName.indexOf(47);
        String rootFolder = index > 0 ? mailboxName.substring(0, index) : mailboxName;
        if (this.imapConfigMountPoints.keySet().contains(rootFolder)) {
            return this.imapConfigMountPoints.get(rootFolder).getMode();
        }
        return AlfrescoImapConst.ImapViewMode.ARCHIVE;
    }

    private String getCurrentUser() {
        return AuthenticationUtil.getFullyAuthenticatedUser();
    }

    private List<NodeRef> getFavouriteSites(final String userName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[getFavouriteSites] entry for user: " + userName));
        }
        LinkedList<NodeRef> favSites = (LinkedList<NodeRef>)AlfrescoTransactionSupport.getResource(FAVORITE_SITES);
        if (this.logger.isDebugEnabled()) {
            if (favSites == null) {
                this.logger.debug((Object)("[getFavouriteSites] There is no Favorite sites' list bound to transaction " + AlfrescoTransactionSupport.getTransactionId()));
            } else {
                this.logger.debug((Object)("[getFavouriteSites] Found Favorite sites' list bound to transaction " + AlfrescoTransactionSupport.getTransactionId()));
            }
        }
        if (favSites == null) {
            favSites = new LinkedList<NodeRef>();
            PreferenceService preferenceService = (PreferenceService)this.serviceRegistry.getService(ServiceRegistry.PREFERENCE_SERVICE);
            Map<String, Serializable> prefs = preferenceService.getPreferences(userName, "org.alfresco.share.sites.imapFavourites");
            List<SiteInfo> sites = this.serviceRegistry.getTransactionService().getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<SiteInfo>>(){

                @Override
                public List<SiteInfo> execute() throws Exception {
                    ArrayList<SiteInfo> res;
                    block4: {
                        res = new ArrayList();
                        try {
                            res = ImapServiceImpl.this.serviceRegistry.getSiteService().listSites(userName);
                        }
                        catch (SiteServiceException e) {
                            if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                                ImapServiceImpl.this.logger.warn((Object)"[getFavouriteSites] Root sites folder was not created.");
                            }
                        }
                        catch (InvalidNodeRefException e) {
                            if (!ImapServiceImpl.this.logger.isDebugEnabled()) break block4;
                            ImapServiceImpl.this.logger.warn((Object)"[getFavouriteSites] Root sites folder was deleted.");
                        }
                    }
                    return res;
                }
            }, false, true);
            for (SiteInfo siteInfo : sites) {
                String key = "org.alfresco.share.sites.imapFavourites." + siteInfo.getShortName();
                Boolean isImapFavourite = (Boolean)prefs.get(key);
                if (isImapFavourite == null || !isImapFavourite.booleanValue()) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("[getFavouriteSites] User: " + userName + " Favourite site: " + siteInfo.getShortName()));
                }
                favSites.add(siteInfo.getNodeRef());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("[getFavouriteSites] Bind new Favorite sites' list to transaction " + AlfrescoTransactionSupport.getTransactionId()));
            }
            AlfrescoTransactionSupport.bindResource(FAVORITE_SITES, favSites);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[getFavouriteSites] end for user: " + userName));
        }
        return favSites;
    }

    private void checkForFlaggableAspect(NodeRef nodeRef) {
        HashSet<NodeRef> alreadyChecked = (HashSet<NodeRef>)AlfrescoTransactionSupport.getResource(CHECKED_NODES);
        if (alreadyChecked == null) {
            alreadyChecked = new HashSet<NodeRef>();
        }
        if (alreadyChecked.contains(nodeRef)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("[checkForFlaggableAspect] Flaggable aspect has been already checked for {" + nodeRef + "}"));
            }
            return;
        }
        try {
            this.serviceRegistry.getLockService().checkForLock(nodeRef);
        }
        catch (NodeLockedException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("[checkForFlaggableAspect] Node {" + nodeRef + "} is locked"));
            }
            alreadyChecked.add(nodeRef);
            return;
        }
        if (!this.nodeService.hasAspect(nodeRef, ImapModel.ASPECT_FLAGGABLE)) {
            AccessStatus status = this.permissionService.hasPermission(nodeRef, "WriteProperties");
            if (status == AccessStatus.DENIED) {
                this.logger.debug((Object)("[checkForFlaggableAspect] No permissions to add FLAGGABLE aspect" + nodeRef));
            } else {
                this.logger.debug((Object)("[checkForFlaggableAspect] Adding flaggable aspect to nodeRef: " + nodeRef));
                HashMap aspectProperties = new HashMap();
                this.nodeService.addAspect(nodeRef, ImapModel.ASPECT_FLAGGABLE, aspectProperties);
            }
        }
        alreadyChecked.add(nodeRef);
        AlfrescoTransactionSupport.bindResource(CHECKED_NODES, alreadyChecked);
    }

    private boolean isExtractionEnabled(NodeRef nodeRef) {
        return this.extractAttachmentsEnabled && !this.ignoreExtractionFolders.contains(nodeRef);
    }

    @Override
    public String getDefaultEmailBodyTemplate(ImapService.EmailBodyType type) {
        if (this.defaultBodyTemplates == null) {
            this.defaultBodyTemplates = new HashMap<ImapService.EmailBodyType, String>(2);
            for (ImapService.EmailBodyType onetype : ImapService.EmailBodyType.values()) {
                String result = onetype.getClasspathTempltePath();
                try {
                    StringBuilder templateName = new StringBuilder("emailbody").append("-").append(onetype.getTypeSubtype()).append(".ftl");
                    String repositoryTemplatePath = this.getRepositoryTemplatePath();
                    int indexOfStoreDelim = repositoryTemplatePath.indexOf("://");
                    if (indexOfStoreDelim == -1) {
                        throw new IllegalArgumentException("Bad path format, :// not found");
                    }
                    int indexOfPathDelim = repositoryTemplatePath.indexOf("/", indexOfStoreDelim += "://".length());
                    if (indexOfPathDelim == -1) {
                        throw new IllegalArgumentException("Bad path format, '/' not found");
                    }
                    String storePath = repositoryTemplatePath.substring(0, indexOfPathDelim);
                    String rootPathInStore = repositoryTemplatePath.substring(indexOfPathDelim);
                    String query = rootPathInStore + "/" + "cm" + ":" + templateName;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("[getDefaultEmailBodyTemplate] Query: " + query));
                    }
                    StoreRef storeRef = new StoreRef(storePath);
                    ResultSet resultSet = this.serviceRegistry.getSearchService().query(storeRef, "xpath", query);
                    if (resultSet == null || resultSet.length() == 0) {
                        throw new IllegalArgumentException(String.format("[getDefaultEmailBodyTemplate] IMAP message template '%1$s' does not exist in the path '%2$s'.", templateName, repositoryTemplatePath));
                    }
                    result = resultSet.getNodeRef(0).toString();
                    resultSet.close();
                }
                catch (Exception e) {
                    this.logger.error((Object)"[getDefaultEmailBodyTemplate]", (Throwable)e);
                }
                this.defaultBodyTemplates.put(onetype, result);
            }
        }
        return this.defaultBodyTemplates.get((Object)type);
    }

    public String getAlfrescoServerUID() {
        return "Not-Implemented";
    }

    static {
        qNameToFlag.put(ImapModel.PROP_FLAG_ANSWERED, Flags.Flag.ANSWERED);
        qNameToFlag.put(ImapModel.PROP_FLAG_DELETED, Flags.Flag.DELETED);
        qNameToFlag.put(ImapModel.PROP_FLAG_DRAFT, Flags.Flag.DRAFT);
        qNameToFlag.put(ImapModel.PROP_FLAG_SEEN, Flags.Flag.SEEN);
        qNameToFlag.put(ImapModel.PROP_FLAG_RECENT, Flags.Flag.RECENT);
        qNameToFlag.put(ImapModel.PROP_FLAG_FLAGGED, Flags.Flag.FLAGGED);
        flagToQname = new HashMap<Flags.Flag, QName>();
        flagToQname.put(Flags.Flag.ANSWERED, ImapModel.PROP_FLAG_ANSWERED);
        flagToQname.put(Flags.Flag.DELETED, ImapModel.PROP_FLAG_DELETED);
        flagToQname.put(Flags.Flag.DRAFT, ImapModel.PROP_FLAG_DRAFT);
        flagToQname.put(Flags.Flag.SEEN, ImapModel.PROP_FLAG_SEEN);
        flagToQname.put(Flags.Flag.RECENT, ImapModel.PROP_FLAG_RECENT);
        flagToQname.put(Flags.Flag.FLAGGED, ImapModel.PROP_FLAG_FLAGGED);
    }

    private class ImapSubFolderFilter
    implements SubFolderFilter {
        private Collection<QName> typesToExclude;
        private List<NodeRef> favs;
        private String mailboxPattern;
        private AlfrescoImapConst.ImapViewMode imapViewMode;

        ImapSubFolderFilter(AlfrescoImapConst.ImapViewMode imapViewMode) {
            this.imapViewMode = imapViewMode;
            this.typesToExclude = ImapServiceImpl.this.getServiceRegistry().getDictionaryService().getSubTypes(SiteModel.TYPE_SITE, true);
            this.favs = ImapServiceImpl.this.getFavouriteSites(ImapServiceImpl.this.getCurrentUser());
        }

        ImapSubFolderFilter(AlfrescoImapConst.ImapViewMode imapViewMode, String mailboxPattern) {
            this(imapViewMode);
            this.mailboxPattern = mailboxPattern.replaceAll("\\*", "(.)*");
        }

        public boolean isEnterSubfolder(ChildAssociationRef subfolderRef) {
            QName typeOfFolder;
            NodeRef folder = subfolderRef.getChildRef();
            if (this.mailboxPattern != null) {
                ImapServiceImpl.this.logger.debug((Object)("Child QName: " + subfolderRef.getQName()));
                String name = (String)((Object)ImapServiceImpl.this.nodeService.getProperty(folder, ContentModel.PROP_NAME));
                if (ImapServiceImpl.this.logger.isDebugEnabled()) {
                    ImapServiceImpl.this.logger.debug((Object)("Folder name: " + name + ". Pattern: " + this.mailboxPattern + ". Matches: " + name.matches(this.mailboxPattern)));
                }
                if (!name.matches(this.mailboxPattern)) {
                    return false;
                }
            }
            if (this.typesToExclude.contains(typeOfFolder = ImapServiceImpl.this.nodeService.getType(folder))) {
                if (this.imapViewMode == AlfrescoImapConst.ImapViewMode.VIRTUAL || this.imapViewMode == AlfrescoImapConst.ImapViewMode.MIXED) {
                    if (this.favs.contains(folder)) {
                        ImapServiceImpl.this.logger.debug((Object)("[ImapSubFolderFilter] (VIRTUAL) including fav site folder :" + subfolderRef.getQName()));
                        return true;
                    }
                    ImapServiceImpl.this.logger.debug((Object)("[ImapSubFolderFilter] (VIRTUAL) excluding non fav site folder :" + subfolderRef.getQName()));
                    return false;
                }
                ImapServiceImpl.this.logger.debug((Object)("[ImapSubFolderFilter] (ARCHIVE) excluding site folder :" + subfolderRef.getQName()));
                return false;
            }
            return true;
        }
    }

    public static class ImapServiceBootstrap
    extends AbstractLifecycleBean {
        private ImapServiceImpl service;
        private boolean imapServerEnabled;

        public void setService(ImapServiceImpl service) {
            this.service = service;
        }

        public void setImapServerEnabled(boolean imapServerEnabled) {
            this.imapServerEnabled = imapServerEnabled;
        }

        protected void onBootstrap(ApplicationEvent event) {
            if (this.imapServerEnabled) {
                this.service.startup();
            }
        }

        protected void onShutdown(ApplicationEvent event) {
            if (this.imapServerEnabled) {
                this.service.shutdown();
            }
        }
    }
}

