/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation.site;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.invitation.WorkflowModelNominatedInvitation;
import org.alfresco.repo.invitation.site.InviteInfo;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InviteHelper {
    public static WorkflowTask findInviteStartTask(String inviteId, WorkflowService workflowService) {
        WorkflowTaskQuery wfTaskQuery = new WorkflowTaskQuery();
        wfTaskQuery.setProcessId(inviteId);
        wfTaskQuery.setProcessName(WorkflowModelNominatedInvitation.WF_PROCESS_INVITE);
        wfTaskQuery.setTaskState(WorkflowTaskState.COMPLETED);
        wfTaskQuery.setTaskName(WorkflowModelNominatedInvitation.WF_INVITE_TASK_INVITE_TO_SITE);
        List<WorkflowTask> inviteStartTasks = workflowService.queryTasks(wfTaskQuery);
        if (inviteStartTasks.size() < 1) {
            return null;
        }
        return inviteStartTasks.get(0);
    }

    public static List<WorkflowTask> findInvitePendingTasks(String inviteeUserName, WorkflowService workflowService) {
        WorkflowTaskQuery wfTaskQuery = new WorkflowTaskQuery();
        wfTaskQuery.setProcessName(WorkflowModelNominatedInvitation.WF_PROCESS_INVITE);
        HashMap<QName, Object> processCustomProps = new HashMap<QName, Object>(1, 1.0f);
        processCustomProps.put(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_USER_NAME, inviteeUserName);
        wfTaskQuery.setProcessCustomProps(processCustomProps);
        wfTaskQuery.setTaskState(WorkflowTaskState.IN_PROGRESS);
        wfTaskQuery.setTaskName(WorkflowModelNominatedInvitation.WF_INVITE_TASK_INVITE_PENDING);
        List<WorkflowTask> inviteStartTasks = workflowService.queryTasks(wfTaskQuery);
        return inviteStartTasks;
    }

    public static InviteInfo getPendingInviteInfo(WorkflowTask startInviteTask, ServiceRegistry serviceRegistry, SiteService siteService) {
        PersonService personService = serviceRegistry.getPersonService();
        String inviterUserNameProp = (String)((Object)startInviteTask.properties.get(WorkflowModelNominatedInvitation.WF_PROP_INVITER_USER_NAME));
        String inviteeUserNameProp = (String)((Object)startInviteTask.properties.get(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_USER_NAME));
        String role = (String)((Object)startInviteTask.properties.get(WorkflowModelNominatedInvitation.WF_PROP_INVITEE_ROLE));
        String siteShortNameProp = (String)((Object)startInviteTask.properties.get(WorkflowModelNominatedInvitation.WF_PROP_RESOURCE_NAME));
        SiteInfo siteInfo = siteService.getSite(siteShortNameProp);
        String workflowId = startInviteTask.path.instance.id;
        Date sentInviteDate = startInviteTask.path.instance.startDate;
        String invitationStatus = "pending";
        NodeRef inviterRef = personService.getPerson(inviterUserNameProp);
        TemplateNode inviterPerson = null;
        if (inviterRef != null) {
            inviterPerson = new TemplateNode(inviterRef, serviceRegistry, null);
        }
        NodeRef inviteeRef = personService.getPerson(inviteeUserNameProp);
        TemplateNode inviteePerson = null;
        if (inviteeRef != null) {
            inviteePerson = new TemplateNode(inviteeRef, serviceRegistry, null);
        }
        InviteInfo inviteInfo = new InviteInfo(invitationStatus, inviterUserNameProp, inviterPerson, inviteeUserNameProp, inviteePerson, role, siteShortNameProp, siteInfo, sentInviteDate, workflowId);
        return inviteInfo;
    }

    public static void cleanUpStaleInviteeResources(final String inviteeUserName, final MutableAuthenticationDao authenticationDao, final PersonService personService, final WorkflowService workflowService) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                boolean invitesPending;
                List<WorkflowTask> pendingTasks = InviteHelper.findInvitePendingTasks(inviteeUserName, workflowService);
                boolean bl = invitesPending = pendingTasks != null && pendingTasks.size() > 0;
                if (authenticationDao.userExists(inviteeUserName) && !authenticationDao.getEnabled(inviteeUserName) && !invitesPending) {
                    authenticationDao.deleteUser(inviteeUserName);
                    if (personService.personExists(inviteeUserName)) {
                        personService.deletePerson(inviteeUserName);
                    }
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public static void completeInviteTask(String inviteId, QName fullTaskName, String transitionId, WorkflowService workflowService) {
        WorkflowTaskQuery wfTaskQuery = new WorkflowTaskQuery();
        wfTaskQuery.setProcessId(inviteId);
        wfTaskQuery.setActive(Boolean.TRUE);
        wfTaskQuery.setTaskState(WorkflowTaskState.IN_PROGRESS);
        wfTaskQuery.setTaskName(fullTaskName);
        wfTaskQuery.setProcessName(WorkflowModelNominatedInvitation.WF_PROCESS_INVITE);
        List<WorkflowTask> wf_invite_tasks = workflowService.queryTasks(wfTaskQuery);
        for (WorkflowTask workflowTask : wf_invite_tasks) {
            workflowService.endTask(workflowTask.id, transitionId);
        }
    }
}

