/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module.tool;

import de.schlichtherle.io.DefaultRaesZipDetector;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.ZipControllerException;
import de.schlichtherle.io.ZipDetector;
import de.schlichtherle.io.ZipWarningException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.module.tool.InstalledFiles;
import org.alfresco.repo.module.tool.ModuleDetailsHelper;
import org.alfresco.repo.module.tool.ModuleManagementToolException;
import org.alfresco.service.cmr.module.ModuleDependency;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.service.cmr.module.ModuleInstallState;
import org.alfresco.util.VersionNumber;
import org.safehaus.uuid.UUIDGenerator;

public class ModuleManagementTool {
    private static final String DEFAULT_FILE_MAPPING_PROPERTIES = "org/alfresco/repo/module/tool/default-file-mapping.properties";
    private static final String FILE_MAPPING_PROPERTIES = "file-mapping.properties";
    private static final String PROP_INHERIT_DEFAULT = "include.default";
    public static final String MODULE_DIR = "/WEB-INF/classes/alfresco/module";
    public static final String BACKUP_DIR = "/WEB-INF/classes/alfresco/module/backup";
    private static final String OP_INSTALL = "install";
    private static final String OP_LIST = "list";
    private static final String OPTION_VERBOSE = "-verbose";
    private static final String OPTION_FORCE = "-force";
    private static final String OPTION_PREVIEW = "-preview";
    private static final String OPTION_NOBACKUP = "-nobackup";
    private static final String OPTION_DIRECTORY = "-directory";
    public static final ZipDetector DETECTOR_AMP_AND_WAR = new DefaultRaesZipDetector("amp|war");
    private Properties defaultFileMappingProperties = new Properties();
    private boolean verbose = false;

    public ModuleManagementTool() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_FILE_MAPPING_PROPERTIES);
        try {
            this.defaultFileMappingProperties.load(is);
        }
        catch (IOException exception) {
            throw new ModuleManagementToolException("Unable to load default extension file mapping properties.", exception);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void installModules(String directory, String warFileLocation) {
        this.installModules(directory, warFileLocation, false, false, true);
    }

    public void installModules(String directoryLocation, String warFileLocation, boolean preview, boolean forceInstall, boolean backupWAR) {
        File dir = new File(directoryLocation);
        if (!dir.exists()) {
            throw new ModuleManagementToolException("Invalid directory '" + directoryLocation + "'");
        }
        this.installModules(dir, warFileLocation, preview, forceInstall, backupWAR);
    }

    private void installModules(File dir, String warFileLocation, boolean preview, boolean forceInstall, boolean backupWAR) {
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isFile() && child.getName().toLowerCase().endsWith(".amp")) {
                    this.installModule(child.getPath(), warFileLocation, preview, forceInstall, backupWAR);
                    continue;
                }
                this.installModules(child, warFileLocation, preview, forceInstall, backupWAR);
            }
        }
    }

    public void installModule(String ampFileLocation, String warFileLocation) {
        this.installModule(ampFileLocation, warFileLocation, false, false, true);
    }

    public void installModule(String ampFileLocation, String warFileLocation, boolean preview, boolean forceInstall, boolean backupWAR) {
        try {
            String propertiesLocation;
            ModuleDetails installingModuleDetails;
            this.outputMessage("Installing AMP '" + ampFileLocation + "' into WAR '" + warFileLocation + "'");
            if (!preview) {
                de.schlichtherle.io.File backUpDir;
                de.schlichtherle.io.File moduleDir = new de.schlichtherle.io.File(warFileLocation + MODULE_DIR, DETECTOR_AMP_AND_WAR);
                if (!moduleDir.exists()) {
                    moduleDir.mkdir();
                }
                if (!(backUpDir = new de.schlichtherle.io.File(warFileLocation + BACKUP_DIR, DETECTOR_AMP_AND_WAR)).exists()) {
                    backUpDir.mkdir();
                }
                if (backupWAR) {
                    File warFile = new File(warFileLocation);
                    if (!warFile.exists()) {
                        throw new ModuleManagementToolException("The war file '" + warFileLocation + "' does not exist.");
                    }
                    String backupLocation = warFileLocation + "-" + System.currentTimeMillis() + ".bak";
                    File backup = new File(backupLocation);
                    ModuleManagementTool.copyFile(warFile, backup);
                    this.outputMessage("WAR has been backed up to '" + backupLocation + "'");
                }
            }
            if ((installingModuleDetails = ModuleDetailsHelper.createModuleDetailsFromPropertyLocation(propertiesLocation = ampFileLocation + "/module.properties")) == null) {
                throw new ModuleManagementToolException("No module.properties file has been found in the installing .amp file '" + ampFileLocation + "'");
            }
            String installingId = installingModuleDetails.getId();
            VersionNumber installingVersion = installingModuleDetails.getVersion();
            List<ModuleDependency> installingModuleDependencies = installingModuleDetails.getDependencies();
            ArrayList<ModuleDependency> missingDependencies = new ArrayList<ModuleDependency>(0);
            for (ModuleDependency dependency : installingModuleDependencies) {
                String dependencyId;
                ModuleDetails dependencyModuleDetails;
                if (dependency.isValidDependency(dependencyModuleDetails = ModuleDetailsHelper.createModuleDetailsFromWarAndId(warFileLocation, dependencyId = dependency.getDependencyId()))) continue;
                missingDependencies.add(dependency);
            }
            if (missingDependencies.size() > 0) {
                throw new ModuleManagementToolException("The following modules must first be installed: " + missingDependencies);
            }
            ModuleDetails installedModuleDetails = ModuleDetailsHelper.createModuleDetailsFromWarAndId(warFileLocation, installingId);
            if (installedModuleDetails == null) {
                List<String> installingAliases = installingModuleDetails.getAliases();
                for (String installingAlias : installingAliases) {
                    ModuleDetails installedAliasModuleDetails = ModuleDetailsHelper.createModuleDetailsFromWarAndId(warFileLocation, installingAlias);
                    if (installedAliasModuleDetails == null) continue;
                    installedModuleDetails = installedAliasModuleDetails;
                    this.outputMessage("Module '" + installingAlias + "' is installed and is an alias of '" + installingId + "'");
                    break;
                }
            }
            if (installedModuleDetails != null) {
                String installedId = installedModuleDetails.getId();
                VersionNumber installedVersion = installedModuleDetails.getVersion();
                int compareValue = installedVersion.compareTo(installingVersion);
                if (forceInstall || compareValue == -1) {
                    if (forceInstall) {
                        this.outputMessage("WARNING: The installation of this module is being forced.  All files will be removed and replaced regardless of exiting versions present.");
                    }
                    this.outputMessage("Clearing out files relating to version '" + installedVersion + "' of module '" + installedId + "'");
                    this.cleanWAR(warFileLocation, installedId, preview);
                } else {
                    if (compareValue == 0) {
                        this.outputMessage("WARNING: This version of this module is already installed in the WAR");
                        throw new ModuleManagementToolException("This version of this module is alreay installed.  Use the 'force' parameter if you want to overwrite the current installation.");
                    }
                    if (compareValue == 1) {
                        this.outputMessage("WARNING: A later version of this module is already installed in the WAR");
                        throw new ModuleManagementToolException("A later version of this module is already installed.  You must first unistall the current version before installing this version of the module.");
                    }
                }
            }
            Properties fileMappingProperties = null;
            Properties customFileMappingProperties = this.getCustomFileMappings(ampFileLocation);
            if (customFileMappingProperties == null) {
                fileMappingProperties = this.defaultFileMappingProperties;
            } else {
                fileMappingProperties = new Properties();
                String inheritDefaultStr = customFileMappingProperties.getProperty(PROP_INHERIT_DEFAULT, "true");
                if (inheritDefaultStr.equalsIgnoreCase("true")) {
                    fileMappingProperties.putAll((Map<?, ?>)this.defaultFileMappingProperties);
                }
                fileMappingProperties.putAll((Map<?, ?>)customFileMappingProperties);
                fileMappingProperties.remove(PROP_INHERIT_DEFAULT);
            }
            this.outputMessage("Adding files relating to version '" + installingVersion + "' of module '" + installingId + "'");
            InstalledFiles installedFiles = new InstalledFiles(warFileLocation, installingId);
            for (Map.Entry<Object, Object> entry : fileMappingProperties.entrySet()) {
                de.schlichtherle.io.File source;
                String mappingSource = (String)entry.getKey();
                if (mappingSource.length() == 0 || !mappingSource.startsWith("/")) {
                    throw new AlfrescoRuntimeException("File mapping sources must start with '/', but was: " + mappingSource);
                }
                String mappingTarget = (String)entry.getValue();
                if (mappingTarget.length() == 0 || !mappingTarget.startsWith("/")) {
                    throw new AlfrescoRuntimeException("File mapping targets must start with '/' but was '" + mappingTarget + "'");
                }
                this.copyToWar(ampFileLocation, warFileLocation, mappingSource, mappingTarget, installedFiles, preview);
                if (preview || (source = new de.schlichtherle.io.File(ampFileLocation + "/" + mappingSource, DETECTOR_AMP_AND_WAR)) == null || source.list() == null) continue;
                de.schlichtherle.io.File destination = new de.schlichtherle.io.File(warFileLocation + "/" + mappingTarget, DETECTOR_AMP_AND_WAR);
                if (destination == null) {
                    throw new ModuleManagementToolException("The destination folder '" + mappingTarget + "' as specified in mapping properties does not exist in the war");
                }
                destination.copyAllFrom((File)source);
            }
            if (!preview) {
                installedFiles.save();
                installingModuleDetails.setInstallState(ModuleInstallState.INSTALLED);
                installingModuleDetails.setInstallDate(new Date());
                ModuleDetailsHelper.saveModuleDetails(warFileLocation, installingModuleDetails);
                de.schlichtherle.io.File.update();
                File warFile = new File(warFileLocation);
                if (warFile.exists()) {
                    warFile.setLastModified(System.currentTimeMillis());
                }
            }
        }
        catch (ZipWarningException ignore) {
        }
        catch (ZipControllerException exception) {
            throw new ModuleManagementToolException("A Zip error was encountered during deployment of the AEP into the WAR", exception);
        }
        catch (IOException exception) {
            throw new ModuleManagementToolException("An IO error was encountered during deployment of the AEP into the WAR", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getCustomFileMappings(String ampFileLocation) {
        de.schlichtherle.io.File file = new de.schlichtherle.io.File(ampFileLocation + "/" + FILE_MAPPING_PROPERTIES, DETECTOR_AMP_AND_WAR);
        if (!file.exists()) {
            return null;
        }
        Properties mappingProperties = new Properties();
        BufferedInputStream is = null;
        try {
            try {
                is = new BufferedInputStream((InputStream)new FileInputStream((File)file));
                mappingProperties.load(is);
            }
            catch (IOException exception) {
                throw new ModuleManagementToolException("Unable to load default extension file mapping properties.", exception);
            }
            Object var7_5 = null;
            if (is == null) return mappingProperties;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable e) {}
        ((InputStream)is).close();
        return mappingProperties;
    }

    private void cleanWAR(String warFileLocation, String moduleId, boolean preview) {
        InstalledFiles installedFiles = new InstalledFiles(warFileLocation, moduleId);
        installedFiles.load();
        for (String string : installedFiles.getAdds()) {
            this.removeFile(warFileLocation, string, preview);
        }
        for (String string : installedFiles.getMkdirs()) {
            this.removeFile(warFileLocation, string, preview);
        }
        for (Map.Entry entry : installedFiles.getUpdates().entrySet()) {
            if (!preview) {
                de.schlichtherle.io.File modified = new de.schlichtherle.io.File(warFileLocation + (String)entry.getKey(), DETECTOR_AMP_AND_WAR);
                de.schlichtherle.io.File backup = new de.schlichtherle.io.File(warFileLocation + (String)entry.getValue(), DETECTOR_AMP_AND_WAR);
                modified.copyFrom((File)backup);
                backup.delete();
            }
            this.outputMessage("Recovering file '" + (String)entry.getKey() + "' from backup '" + (String)entry.getValue() + "'", true);
        }
        String installedFilesPathInWar = installedFiles.getFilePathInWar();
        this.removeFile(warFileLocation, installedFilesPathInWar, preview);
        String string = ModuleDetailsHelper.getModulePropertiesFilePathInWar(moduleId);
        this.removeFile(warFileLocation, string, preview);
    }

    private void removeFile(String warLocation, String filePath, boolean preview) {
        de.schlichtherle.io.File removeFile = new de.schlichtherle.io.File(warLocation + filePath, DETECTOR_AMP_AND_WAR);
        if (removeFile.exists()) {
            this.outputMessage("Removing file '" + filePath + "' from war", true);
            if (!preview) {
                removeFile.delete();
            }
        } else {
            this.outputMessage("The file '" + filePath + "' was expected for removal but was not present in the war", true);
        }
    }

    private void copyToWar(String ampFileLocation, String warFileLocation, String sourceDir, String destinationDir, InstalledFiles installedFiles, boolean preview) throws IOException {
        String sourceLocation;
        de.schlichtherle.io.File ampConfig;
        File[] files;
        if (sourceDir.length() == 0 || !sourceDir.startsWith("/")) {
            throw new IllegalArgumentException("sourceDir must start with '/'");
        }
        if (destinationDir.length() == 0 || !destinationDir.startsWith("/")) {
            throw new IllegalArgumentException("destinationDir must start with '/'");
        }
        if (sourceDir.equals("/")) {
            sourceDir = "";
        }
        if (destinationDir.equals("/")) {
            destinationDir = "";
        }
        if ((files = (ampConfig = new de.schlichtherle.io.File(sourceLocation = ampFileLocation + sourceDir, DETECTOR_AMP_AND_WAR)).listFiles()) != null) {
            for (File sourceChild : files) {
                String destinationFileLocation = warFileLocation + destinationDir + "/" + sourceChild.getName();
                de.schlichtherle.io.File destinationChild = new de.schlichtherle.io.File(destinationFileLocation, DETECTOR_AMP_AND_WAR);
                if (sourceChild.isFile()) {
                    String backupLocation = null;
                    boolean createFile = false;
                    if (!destinationChild.exists()) {
                        createFile = true;
                    } else {
                        backupLocation = "/WEB-INF/classes/alfresco/module/backup/" + ModuleManagementTool.generateGuid() + ".bin";
                        if (!preview) {
                            de.schlichtherle.io.File backupFile = new de.schlichtherle.io.File(warFileLocation + backupLocation, DETECTOR_AMP_AND_WAR);
                            backupFile.copyFrom((File)destinationChild);
                        }
                    }
                    if (createFile) {
                        installedFiles.addAdd(destinationDir + "/" + sourceChild.getName());
                        this.outputMessage("File '" + destinationDir + "/" + sourceChild.getName() + "' added to war from amp", true);
                        continue;
                    }
                    installedFiles.addUpdate(destinationDir + "/" + sourceChild.getName(), backupLocation);
                    this.outputMessage("WARNING: The file '" + destinationDir + "/" + sourceChild.getName() + "' is being updated by this module and has been backed-up to '" + backupLocation + "'", true);
                    continue;
                }
                boolean mkdir = false;
                if (!destinationChild.exists()) {
                    mkdir = true;
                }
                this.copyToWar(ampFileLocation, warFileLocation, sourceDir + "/" + sourceChild.getName(), destinationDir + "/" + sourceChild.getName(), installedFiles, preview);
                if (!mkdir) continue;
                installedFiles.addMkdir(destinationDir + "/" + sourceChild.getName());
                this.outputMessage("Directory '" + destinationDir + "/" + sourceChild.getName() + "' added to war", true);
            }
        }
    }

    public void disableModule(String moduleId, String warLocation) {
        throw new UnsupportedOperationException("Disable module is not currently supported");
    }

    public void enableModule(String moduleId, String warLocation) {
        throw new UnsupportedOperationException("Enable module is not currently supported");
    }

    public void uninstallModule(String moduleId, String warLocation) {
        throw new UnsupportedOperationException("Uninstall module is not currently supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listModules(String warLocation) {
        ModuleDetails moduleDetails = null;
        boolean previous = this.verbose;
        this.verbose = true;
        try {
            File[] dirs;
            de.schlichtherle.io.File moduleDir = new de.schlichtherle.io.File(warLocation + MODULE_DIR, DETECTOR_AMP_AND_WAR);
            if (!moduleDir.exists()) {
                this.outputMessage("No modules are installed in this WAR file");
            }
            if ((dirs = moduleDir.listFiles()) != null && dirs.length != 0) {
                for (File dir : dirs) {
                    de.schlichtherle.io.File moduleProperties;
                    if (!dir.isDirectory() || !(moduleProperties = new de.schlichtherle.io.File(dir.getPath() + "/module.properties", DETECTOR_AMP_AND_WAR)).exists()) continue;
                    try {
                        FileInputStream is = new FileInputStream((File)moduleProperties);
                        moduleDetails = ModuleDetailsHelper.createModuleDetailsFromPropertiesStream((InputStream)is);
                    }
                    catch (IOException exception) {
                        throw new ModuleManagementToolException("Unable to open module properties file '" + moduleProperties.getPath() + "'", exception);
                    }
                    this.outputMessage("Module '" + moduleDetails.getId() + "' installed in '" + warLocation + "'");
                    this.outputMessage("   Title:        " + moduleDetails.getTitle(), true);
                    this.outputMessage("   Version:      " + moduleDetails.getVersion(), true);
                    this.outputMessage("   Install Date: " + moduleDetails.getInstallDate(), true);
                    this.outputMessage("   Desription:   " + moduleDetails.getDescription(), true);
                }
            } else {
                this.outputMessage("No modules are installed in this WAR file");
            }
            Object var13_13 = null;
            this.verbose = previous;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.verbose = previous;
            throw throwable;
        }
    }

    private void outputMessage(String message) {
        this.outputMessage(message, false);
    }

    private void outputMessage(String message, boolean indent) {
        if (indent) {
            message = "   - " + message;
        }
        if (this.verbose) {
            System.out.println(message);
        }
    }

    public static void main(String[] args) {
        block14: {
            if (args.length <= 1) {
                ModuleManagementTool.outputUsage();
                return;
            }
            ModuleManagementTool manager = new ModuleManagementTool();
            String operation = args[0];
            if (operation.equals(OP_INSTALL) && args.length >= 3) {
                String aepFileLocation = args[1];
                String warFileLocation = args[2];
                boolean forceInstall = false;
                boolean previewInstall = false;
                boolean backup = true;
                boolean directory = false;
                if (args.length > 3) {
                    for (int i = 3; i < args.length; ++i) {
                        String option = args[i];
                        if (OPTION_VERBOSE.equals(option)) {
                            manager.setVerbose(true);
                            continue;
                        }
                        if (OPTION_FORCE.equals(option)) {
                            forceInstall = true;
                            continue;
                        }
                        if (OPTION_PREVIEW.equals(option)) {
                            previewInstall = true;
                            manager.setVerbose(true);
                            continue;
                        }
                        if (OPTION_NOBACKUP.equals(option)) {
                            backup = false;
                            continue;
                        }
                        if (!OPTION_DIRECTORY.equals(option)) continue;
                        directory = true;
                    }
                }
                try {
                    if (!directory) {
                        manager.installModule(aepFileLocation, warFileLocation, previewInstall, forceInstall, backup);
                        break block14;
                    }
                    manager.installModules(aepFileLocation, warFileLocation, previewInstall, forceInstall, backup);
                }
                catch (ModuleManagementToolException e) {
                    manager.outputMessage(e.getMessage());
                    ModuleManagementTool.outputUsage();
                }
            } else if (OP_LIST.equals(operation) && args.length == 2) {
                String warFileLocation = args[1];
                manager.listModules(warFileLocation);
            } else {
                ModuleManagementTool.outputUsage();
            }
        }
    }

    private static String generateGuid() {
        return UUIDGenerator.getInstance().generateTimeBasedUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File in, File out) throws IOException {
        Throwable e22;
        BufferedOutputStream os;
        block12: {
            BufferedInputStream is = new BufferedInputStream((InputStream)new FileInputStream(in));
            os = new BufferedOutputStream(new FileOutputStream(out));
            try {
                int byteCount = 0;
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = ((InputStream)is).read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, bytesRead);
                    byteCount += bytesRead;
                }
                ((OutputStream)os).flush();
                Object var8_7 = null;
                if (is == null) break block12;
            }
            catch (Throwable throwable) {
                Throwable e22;
                Object var8_8 = null;
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable e22) {
                        e22.printStackTrace();
                    }
                }
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (Throwable e22) {
                        e22.printStackTrace();
                    }
                }
                throw throwable;
            }
            try {
                ((InputStream)is).close();
            }
            catch (Throwable e22) {
                e22.printStackTrace();
            }
        }
        if (os != null) {
            try {
                ((OutputStream)os).close();
            }
            catch (Throwable e22) {
                e22.printStackTrace();
            }
        }
    }

    private static void outputUsage() {
        System.out.println("Module managment tool available commands:");
        System.out.println("-----------------------------------------------------------\n");
        System.out.println("install: Installs a AMP file(s) into an Alfresco WAR file, updates if an older version is already installed.");
        System.out.println("usage:   install <AMPFileLocation> <WARFileLocation> [options]");
        System.out.println("valid options: ");
        System.out.println("   -verbose   : enable verbose output");
        System.out.println("   -directory : indicates that the amp file location specified is a directory.");
        System.out.println("                All amp files found in the directory and its sub directories are installed.");
        System.out.println("   -force     : forces installation of AMP regardless of currently installed module version");
        System.out.println("   -preview   : previews installation of AMP without modifying WAR file");
        System.out.println("   -nobackup  : indicates that no backup should be made of the WAR\n");
        System.out.println("-----------------------------------------------------------\n");
        System.out.println("list:  Lists all the modules currently installed in an Alfresco WAR file.");
        System.out.println("usage: list <WARFileLocation>\n");
        System.out.println("-----------------------------------------------------------\n");
    }
}

