/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.transaction.UserTransaction;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.node.MLPropertyInterceptor;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullNodeServiceTest
extends BaseNodeServiceTest {
    @Override
    protected NodeService getNodeService() {
        return (NodeService)this.applicationContext.getBean("NodeService");
    }

    @Override
    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
    }

    public void testMLTextValues() throws Exception {
        Locale.setDefault(Locale.ENGLISH);
        MLText mlTextProperty = new MLText();
        mlTextProperty.addValue(Locale.ENGLISH, "Very good!");
        mlTextProperty.addValue(Locale.FRENCH, "Tr\u00e8s bon!");
        mlTextProperty.addValue(Locale.GERMAN, "Sehr gut!");
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)mlTextProperty);
        Serializable textValueFiltered = this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        FullNodeServiceTest.assertEquals((String)"Default locale value not taken for ML text", (Object)mlTextProperty.getValue(Locale.ENGLISH), (Object)textValueFiltered);
        Map propertiesFiltered = this.nodeService.getProperties(this.rootNodeRef);
        FullNodeServiceTest.assertEquals((String)"Default locale value not taken for ML text in Map", (Object)mlTextProperty.getValue(Locale.ENGLISH), propertiesFiltered.get(BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
    }

    public void testLongMLTextValues() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4096; ++i) {
            sb.append(" ").append(i);
        }
        String longString = sb.toString();
        Locale.setDefault(Locale.ENGLISH);
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)longString));
        MLText mlTextProperty = new MLText();
        mlTextProperty.addValue(Locale.ENGLISH, longString);
        mlTextProperty.addValue(Locale.FRENCH, longString);
        mlTextProperty.addValue(Locale.GERMAN, longString);
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)mlTextProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullMLText() throws Exception {
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, null);
        Serializable mlTextSer = this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        MLText mlText = (MLText)DefaultTypeConverter.INSTANCE.convert(MLText.class, (Object)mlTextSer);
        FullNodeServiceTest.assertNull((String)"Value returned is not null", (Object)mlText);
        mlText = new MLText(null);
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)mlText);
        MLText mlTextCheck = (MLText)this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
        FullNodeServiceTest.assertNull((String)"MLText value should have been converted to a null String", (Object)mlTextCheck);
        this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, null);
        MLPropertyInterceptor.setMLAware(true);
        try {
            mlText = new MLText(null);
            this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)mlText);
            mlTextCheck = (MLText)this.nodeService.getProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE);
            FullNodeServiceTest.assertEquals((String)"MLText value was not pulled out the same as it went in", (Object)mlText, (Object)mlTextCheck);
            this.nodeService.setProperty(this.rootNodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, null);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            MLPropertyInterceptor.setMLAware(false);
            throw throwable;
        }
        MLPropertyInterceptor.setMLAware(false);
    }

    public void testMLValuesOnCreate() throws Exception {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        this.fillProperties(BaseNodeServiceTest.TYPE_QNAME_TEST_MANY_PROPERTIES, properties);
        properties.put(BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)"Bonjour"));
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, BaseNodeServiceTest.ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)this.getName()), BaseNodeServiceTest.TYPE_QNAME_TEST_MANY_PROPERTIES, properties).getChildRef();
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)"Hello"));
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        FullNodeServiceTest.assertEquals((String)"Expected French value property", (Object)"Bonjour", (Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        FullNodeServiceTest.assertEquals((String)"Expected English value property", (Object)"Hello", (Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
    }

    public void testMLValuesOnAddAspect() throws Exception {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        this.fillProperties(BaseNodeServiceTest.TYPE_QNAME_TEST_MANY_PROPERTIES, properties);
        properties.put(BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)"Bonjour"));
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        NodeRef nodeRef = this.rootNodeRef;
        this.nodeService.addAspect(nodeRef, BaseNodeServiceTest.ASPECT_QNAME_TEST_TITLED, properties);
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)"Hello"));
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        FullNodeServiceTest.assertEquals((String)"Expected French value property", (Object)"Bonjour", (Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        FullNodeServiceTest.assertEquals((String)"Expected English value property", (Object)"Hello", (Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
    }

    public void testMLValuesOnAddProperties() throws Exception {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        this.fillProperties(BaseNodeServiceTest.TYPE_QNAME_TEST_MANY_PROPERTIES, properties);
        properties.put(BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)"Bonjour"));
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        NodeRef nodeRef = this.rootNodeRef;
        this.nodeService.addProperties(nodeRef, properties);
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        this.nodeService.setProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)"Hello"));
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        FullNodeServiceTest.assertEquals((String)"Expected French value property", (Object)"Bonjour", (Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        FullNodeServiceTest.assertEquals((String)"Expected English value property", (Object)"Hello", (Object)this.nodeService.getProperty(nodeRef, BaseNodeServiceTest.PROP_QNAME_ML_TEXT_VALUE));
    }

    @Override
    protected void getExpectedPropertyValues(Map<QName, Serializable> checkProperties) {
        MLText mlTextValue = (MLText)checkProperties.get(PROP_QNAME_ML_TEXT_VALUE);
        String strValue = mlTextValue.getDefaultValue();
        checkProperties.put(PROP_QNAME_ML_TEXT_VALUE, (Serializable)((Object)strValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void testMultiProp() throws Exception {
        UserTransaction txn;
        ArrayList<Object> values;
        NodeRef nodeRef;
        block13: {
            QName undeclaredPropQName = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)this.getName());
            nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), TYPE_QNAME_TEST_MULTIPLE_TESTER).getChildRef();
            values = new ArrayList<Object>(1);
            values.add("ABC");
            values.add("DEF");
            this.nodeService.setProperty(nodeRef, PROP_QNAME_STRING_PROP_SINGLE, (Serializable)((Object)"ABC"));
            this.nodeService.setProperty(nodeRef, PROP_QNAME_STRING_PROP_MULTIPLE, (Serializable)((Object)"ABC"));
            this.nodeService.setProperty(nodeRef, PROP_QNAME_STRING_PROP_MULTIPLE, values);
            this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_SINGLE, (Serializable)((Object)"ABC"));
            this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_SINGLE, values);
            this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_MULTIPLE, (Serializable)((Object)"ABC"));
            this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_MULTIPLE, values);
            this.nodeService.setProperty(nodeRef, undeclaredPropQName, (Serializable)((Object)"ABC"));
            this.nodeService.setProperty(nodeRef, undeclaredPropQName, values);
            this.setComplete();
            this.endTransaction();
            txn = this.transactionService.getUserTransaction();
            txn.begin();
            this.nodeService.setProperty(nodeRef, PROP_QNAME_STRING_PROP_SINGLE, values);
            Object var7_5 = null;
            try {
                txn.rollback();
            }
            catch (Throwable e2) {}
            break block13;
            {
                catch (DictionaryException e) {
                    var7_5 = null;
                    try {
                        txn.rollback();
                    }
                    catch (Throwable e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    txn.rollback();
                }
                catch (Throwable e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        txn = this.transactionService.getUserTransaction();
        try {
            txn.begin();
            values.clear();
            values.add(new MLText("ABC"));
            values.add(new MLText("DEF"));
            this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE, values);
            List checkValues = (List)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE));
            FullNodeServiceTest.assertEquals((String)"Expected 2 MLText values back", (int)2, (int)checkValues.size());
            FullNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(0) instanceof String));
            FullNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(1) instanceof String));
            values.clear();
            ArrayList<String> arrayListVal = new ArrayList<String>(2);
            HashSet<String> hashSetVal = new HashSet<String>(2);
            values.add(arrayListVal);
            values.add(hashSetVal);
            this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_MULTIPLE, values);
            checkValues = (List)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_ANY_PROP_MULTIPLE));
            FullNodeServiceTest.assertEquals((String)"Expected 2 Collection values back", (int)2, (int)checkValues.size());
            FullNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(0) instanceof ArrayList));
            FullNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(1) instanceof HashSet));
            arrayListVal.add("ONE");
            arrayListVal.add("TWO");
            hashSetVal.add("ONE");
            hashSetVal.add("TWO");
            values.clear();
            values.add(arrayListVal);
            values.add(hashSetVal);
            this.nodeService.setProperty(nodeRef, PROP_QNAME_ANY_PROP_MULTIPLE, values);
            checkValues = (List)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_ANY_PROP_MULTIPLE));
            FullNodeServiceTest.assertEquals((String)"Expected 2 Collection values back", (int)2, (int)checkValues.size());
            FullNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(0) instanceof ArrayList));
            FullNodeServiceTest.assertTrue((String)"Incorrect type in collection", (boolean)(checkValues.get(1) instanceof HashSet));
            FullNodeServiceTest.assertEquals((String)"First collection incorrect", (int)2, (int)((Collection)checkValues.get(0)).size());
            FullNodeServiceTest.assertEquals((String)"Second collection incorrect", (int)2, (int)((Collection)checkValues.get(1)).size());
            Object var10_14 = null;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            try {
                txn.rollback();
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            txn.rollback();
        }
        catch (Throwable e) {}
    }

    @Override
    public void testMultiValueMLTextProperties() throws Exception {
        NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME_TEST_CHILDREN, QName.createQName((String)"pathA"), TYPE_QNAME_TEST_MANY_ML_PROPERTIES).getChildRef();
        ArrayList<MLText> mlTextCollection = new ArrayList<MLText>(2);
        MLText mlText0 = new MLText();
        mlText0.addValue(Locale.ENGLISH, "Hello");
        mlText0.addValue(Locale.FRENCH, "Bonjour");
        mlTextCollection.add(mlText0);
        MLText mlText1 = new MLText();
        mlText1.addValue(Locale.ENGLISH, "Bye bye");
        mlText1.addValue(Locale.FRENCH, "Au revoir");
        mlTextCollection.add(mlText1);
        this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE, (Serializable)mlTextCollection);
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        Collection mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("Hello", "Bye bye"), (Object)mlTextCollectionCheck);
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("Bonjour", "Au revoir"), (Object)mlTextCollectionCheck);
        I18NUtil.setContentLocale((Locale)Locale.GERMAN);
        this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE, (Serializable)((Object)Arrays.asList("eins", "zwei", "drie", "vier")));
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("Hello", "Bye bye"), (Object)mlTextCollectionCheck);
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("Bonjour", "Au revoir"), (Object)mlTextCollectionCheck);
        I18NUtil.setContentLocale((Locale)Locale.GERMAN);
        mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("eins", "zwei", "drie", "vier"), (Object)mlTextCollectionCheck);
        I18NUtil.setContentLocale((Locale)Locale.GERMAN);
        this.nodeService.setProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE, (Serializable)((Object)Arrays.asList("eins")));
        I18NUtil.setContentLocale((Locale)Locale.ENGLISH);
        mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("Hello", "Bye bye"), (Object)mlTextCollectionCheck);
        I18NUtil.setContentLocale((Locale)Locale.FRENCH);
        mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("Bonjour", "Au revoir"), (Object)mlTextCollectionCheck);
        I18NUtil.setContentLocale((Locale)Locale.GERMAN);
        mlTextCollectionCheck = (Collection)((Object)this.nodeService.getProperty(nodeRef, PROP_QNAME_MULTI_ML_VALUE));
        FullNodeServiceTest.assertEquals((String)"MLText collection didn't come back correctly.", Arrays.asList("eins"), (Object)mlTextCollectionCheck);
    }
}

