/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rating;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.rating.Rating;
import org.alfresco.service.cmr.rating.RatingScheme;
import org.alfresco.service.cmr.rating.RatingService;
import org.alfresco.service.cmr.rating.RatingServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.PropertyMap;

public class RatingServiceIntegrationTest
extends BaseAlfrescoSpringTest {
    private static final String USER_ONE = "UserOne";
    private static final String USER_TWO = "UserTwo";
    private CopyService copyService;
    private PersonService personService;
    private RatingService ratingService;
    private Repository repositoryHelper;
    private ScriptService scriptService;
    private RetryingTransactionHelper transactionHelper;
    private NodeRef companyHome;
    private NodeRef testFolder;
    private NodeRef testFolderCopyDest;
    private NodeRef testDoc_Admin;
    private NodeRef testDoc_UserOne;
    private NodeRef testDoc_UserTwo;
    private static final String LIKES_SCHEME_NAME = "likesRatingScheme";
    private static final String FIVE_STAR_SCHEME_NAME = "fiveStarRatingScheme";

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.copyService = (CopyService)this.applicationContext.getBean("CopyService");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.ratingService = (RatingService)this.applicationContext.getBean("ratingService");
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.transactionHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        this.scriptService = (ScriptService)this.applicationContext.getBean("scriptService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.companyHome = this.repositoryHelper.getCompanyHome();
        this.testFolder = this.createNode(this.companyHome, "testFolder", ContentModel.TYPE_FOLDER);
        this.testFolderCopyDest = this.createNode(this.companyHome, "testFolderCopyDest", ContentModel.TYPE_FOLDER);
        this.testDoc_Admin = this.createNode(this.testFolder, "testDocInFolder", ContentModel.TYPE_CONTENT);
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        this.testDoc_UserOne = this.createNode(this.testFolder, "userOnesDoc", ContentModel.TYPE_CONTENT);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        this.testDoc_UserTwo = this.createNode(this.testFolder, "userTwosDoc", ContentModel.TYPE_CONTENT);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
    }

    protected void onTearDownInTransaction() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.deleteUser(USER_TWO);
        this.deleteUser(USER_ONE);
    }

    private NodeRef createNode(NodeRef parentNode, String name, QName type) {
        HashMap<QName, String> props = new HashMap<QName, String>();
        String fullName = name + System.currentTimeMillis();
        props.put(ContentModel.PROP_NAME, fullName);
        QName docContentQName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)fullName);
        NodeRef node = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, docContentQName, type, props).getChildRef();
        return node;
    }

    public void testOutOfTheBoxRatingSchemes() throws Exception {
        Map<String, RatingScheme> schemes = this.ratingService.getRatingSchemes();
        RatingServiceIntegrationTest.assertNotNull((String)"rating scheme collection was null.", schemes);
        RatingServiceIntegrationTest.assertTrue((String)"rating scheme collection was empty.", (!schemes.isEmpty() ? 1 : 0) != 0);
        RatingScheme likesRS = schemes.get(LIKES_SCHEME_NAME);
        RatingServiceIntegrationTest.assertNotNull((String)"'likes' rating scheme was missing.", (Object)likesRS);
        RatingServiceIntegrationTest.assertEquals((String)"'likes' rating scheme had wrong name.", (String)LIKES_SCHEME_NAME, (String)likesRS.getName());
        RatingServiceIntegrationTest.assertEquals((String)"'likes' rating scheme had wrong min.", (Object)Float.valueOf(1.0f), (Object)Float.valueOf(likesRS.getMinRating()));
        RatingServiceIntegrationTest.assertEquals((String)"'likes' rating scheme had wrong max.", (Object)Float.valueOf(1.0f), (Object)Float.valueOf(likesRS.getMaxRating()));
        RatingScheme fiveStarRS = schemes.get(FIVE_STAR_SCHEME_NAME);
        RatingServiceIntegrationTest.assertNotNull((String)"'5*' rating scheme was missing.", (Object)fiveStarRS);
        RatingServiceIntegrationTest.assertEquals((String)"'5*' rating scheme had wrong name.", (String)FIVE_STAR_SCHEME_NAME, (String)fiveStarRS.getName());
        RatingServiceIntegrationTest.assertEquals((String)"'5*' rating scheme had wrong min.", (Object)Float.valueOf(1.0f), (Object)Float.valueOf(fiveStarRS.getMinRating()));
        RatingServiceIntegrationTest.assertEquals((String)"'5*' rating scheme had wrong max.", (Object)Float.valueOf(5.0f), (Object)Float.valueOf(fiveStarRS.getMaxRating()));
    }

    public void testApplyIllegalRatings() throws Exception {
        float[] illegalRatings;
        for (float illegalRating : illegalRatings = new float[]{0.0f, 2.0f}) {
            this.applyIllegalRating(this.testDoc_Admin, illegalRating, LIKES_SCHEME_NAME);
        }
    }

    private void applyIllegalRating(NodeRef nodeRef, float illegalRating, String schemeName) {
        try {
            this.ratingService.applyRating(nodeRef, illegalRating, schemeName);
        }
        catch (RatingServiceException expectedException) {
            return;
        }
        RatingServiceIntegrationTest.fail((String)("Illegal rating " + illegalRating + " should have caused exception."));
    }

    public void testApplyUpdateDeleteRatings() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        Rating nullRating = this.ratingService.getRatingByCurrentUser(this.testDoc_Admin, LIKES_SCHEME_NAME);
        RatingServiceIntegrationTest.assertNull((String)"Expected a null rating,", (Object)nullRating);
        RatingServiceIntegrationTest.assertNull((String)"Expected a null remove result.", (Object)this.ratingService.removeRatingByCurrentUser(this.testDoc_Admin, LIKES_SCHEME_NAME));
        float fiveStarScore = 5.0f;
        this.ratingService.applyRating(this.testDoc_Admin, 5.0f, FIVE_STAR_SCHEME_NAME);
        RatingServiceIntegrationTest.assertTrue((String)(ContentModel.ASPECT_RATEABLE + " aspect missing."), (boolean)this.nodeService.hasAspect(this.testDoc_Admin, ContentModel.ASPECT_RATEABLE));
        List allChildren = this.nodeService.getChildAssocs(this.testDoc_Admin, (QNamePattern)ContentModel.ASSOC_RATINGS, RegexQNamePattern.MATCH_ALL);
        RatingServiceIntegrationTest.assertEquals((String)"Wrong number of ratings nodes.", (int)1, (int)allChildren.size());
        RatingServiceIntegrationTest.assertEquals((String)"Wrong type qname on ratings assoc", (Object)ContentModel.ASSOC_RATINGS, (Object)((ChildAssociationRef)allChildren.get(0)).getTypeQName());
        QName expectedAssocName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)AuthenticationUtil.getFullyAuthenticatedUser());
        RatingServiceIntegrationTest.assertEquals((String)"Wrong qname on ratings assoc", (Object)expectedAssocName, (Object)((ChildAssociationRef)allChildren.get(0)).getQName());
        Rating fiveStarRating = this.ratingService.getRatingByCurrentUser(this.testDoc_Admin, FIVE_STAR_SCHEME_NAME);
        RatingServiceIntegrationTest.assertNotNull((String)"'5*' rating was null.", (Object)fiveStarRating);
        RatingServiceIntegrationTest.assertEquals((String)"Wrong score for rating", (Object)Float.valueOf(5.0f), (Object)Float.valueOf(fiveStarRating.getScore()));
        RatingServiceIntegrationTest.assertEquals((String)"Wrong user for rating", (String)AuthenticationUtil.getFullyAuthenticatedUser(), (String)fiveStarRating.getAppliedBy());
        Date fiveStarRatingAppliedAt = fiveStarRating.getAppliedAt();
        this.assertDateIsCloseToNow(fiveStarRatingAppliedAt);
        float updatedFiveStarScore = 3.0f;
        this.ratingService.applyRating(this.testDoc_Admin, 3.0f, FIVE_STAR_SCHEME_NAME);
        allChildren = this.nodeService.getChildAssocs(this.testDoc_Admin, (QNamePattern)ContentModel.ASSOC_RATINGS, RegexQNamePattern.MATCH_ALL);
        RatingServiceIntegrationTest.assertEquals((String)"Wrong number of ratings nodes.", (int)1, (int)allChildren.size());
        RatingServiceIntegrationTest.assertEquals((String)"Wrong type qname on ratings assoc", (Object)ContentModel.ASSOC_RATINGS, (Object)((ChildAssociationRef)allChildren.get(0)).getTypeQName());
        RatingServiceIntegrationTest.assertEquals((String)"Wrong qname on ratings assoc", (Object)expectedAssocName, (Object)((ChildAssociationRef)allChildren.get(0)).getQName());
        Rating updatedFiveStarRating = this.ratingService.getRatingByCurrentUser(this.testDoc_Admin, FIVE_STAR_SCHEME_NAME);
        RatingServiceIntegrationTest.assertNotNull((String)"'5*' rating was null.", (Object)updatedFiveStarRating);
        RatingServiceIntegrationTest.assertEquals((String)"Wrong score for rating", (Object)Float.valueOf(3.0f), (Object)Float.valueOf(updatedFiveStarRating.getScore()));
        RatingServiceIntegrationTest.assertEquals((String)"Wrong user for rating", (String)AuthenticationUtil.getFullyAuthenticatedUser(), (String)updatedFiveStarRating.getAppliedBy());
        RatingServiceIntegrationTest.assertTrue((String)"five star rating date was unchanged.", (!fiveStarRatingAppliedAt.equals(updatedFiveStarRating.getAppliedAt()) ? 1 : 0) != 0);
        this.assertDateIsCloseToNow(updatedFiveStarRating.getAppliedAt());
        Rating deletedStarRating = this.ratingService.removeRatingByCurrentUser(this.testDoc_Admin, FIVE_STAR_SCHEME_NAME);
        RatingServiceIntegrationTest.assertNotNull((String)"'5*' rating was null.", (Object)deletedStarRating);
        RatingServiceIntegrationTest.assertEquals((String)"Wrong score for rating", (Object)Float.valueOf(3.0f), (Object)Float.valueOf(deletedStarRating.getScore()));
        RatingServiceIntegrationTest.assertEquals((String)"Wrong user for rating", (String)AuthenticationUtil.getFullyAuthenticatedUser(), (String)deletedStarRating.getAppliedBy());
        RatingServiceIntegrationTest.assertEquals((String)"Wrong date for rating", (Object)updatedFiveStarRating.getAppliedAt(), (Object)deletedStarRating.getAppliedAt());
        RatingServiceIntegrationTest.assertNull((String)"5* rating not null.", (Object)this.ratingService.getRatingByCurrentUser(this.testDoc_Admin, FIVE_STAR_SCHEME_NAME));
    }

    private void assertDateIsCloseToNow(Date d) {
    }

    public void testOneUserRatesAndRerates() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        this.ratingService.applyRating(this.testDoc_Admin, 1.0f, FIVE_STAR_SCHEME_NAME);
        this.ratingService.applyRating(this.testDoc_Admin, 2.0f, FIVE_STAR_SCHEME_NAME);
        float meanRating = this.ratingService.getAverageRating(this.testDoc_Admin, FIVE_STAR_SCHEME_NAME);
        RatingServiceIntegrationTest.assertEquals((String)"Document had wrong mean rating.", (Object)Float.valueOf(2.0f), (Object)Float.valueOf(meanRating));
        float totalRating = this.ratingService.getTotalRating(this.testDoc_Admin, FIVE_STAR_SCHEME_NAME);
        RatingServiceIntegrationTest.assertEquals((String)"Document had wrong total rating.", (Object)Float.valueOf(2.0f), (Object)Float.valueOf(totalRating));
        int ratingsCount = this.ratingService.getRatingsCount(this.testDoc_Admin, FIVE_STAR_SCHEME_NAME);
        RatingServiceIntegrationTest.assertEquals((String)"Document had wrong ratings count.", (int)1, (int)ratingsCount);
        RatingServiceIntegrationTest.assertEquals((String)"Wrong number of child nodes", (int)1, (int)this.nodeService.getChildAssocs(this.testDoc_Admin).size());
    }

    public void testOneUserRatesInTwoSchemes() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        this.ratingService.applyRating(this.testDoc_Admin, 1.0f, FIVE_STAR_SCHEME_NAME);
        boolean correctExceptionThrown = false;
        try {
            this.ratingService.applyRating(this.testDoc_Admin, 2.0f, LIKES_SCHEME_NAME);
        }
        catch (RatingServiceException expected) {
            correctExceptionThrown = true;
        }
        if (!correctExceptionThrown) {
            RatingServiceIntegrationTest.fail((String)"Expected exception not thrown.");
        }
        float meanRating = this.ratingService.getAverageRating(this.testDoc_Admin, FIVE_STAR_SCHEME_NAME);
        RatingServiceIntegrationTest.assertEquals((String)"Document had wrong mean rating.", (Object)Float.valueOf(1.0f), (Object)Float.valueOf(meanRating));
        float totalRating = this.ratingService.getTotalRating(this.testDoc_Admin, FIVE_STAR_SCHEME_NAME);
        RatingServiceIntegrationTest.assertEquals((String)"Document had wrong total rating.", (Object)Float.valueOf(1.0f), (Object)Float.valueOf(totalRating));
        int ratingsCount = this.ratingService.getRatingsCount(this.testDoc_Admin, FIVE_STAR_SCHEME_NAME);
        RatingServiceIntegrationTest.assertEquals((String)"Document had wrong ratings count.", (int)1, (int)ratingsCount);
        RatingServiceIntegrationTest.assertEquals((String)"Wrong number of child nodes", (int)1, (int)this.nodeService.getChildAssocs(this.testDoc_Admin).size());
    }

    public void testApplyRating_MultipleUsers() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        this.ratingService.applyRating(this.testDoc_Admin, 4.0f, FIVE_STAR_SCHEME_NAME);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        this.ratingService.applyRating(this.testDoc_Admin, 2.0f, FIVE_STAR_SCHEME_NAME);
        float meanRating = this.ratingService.getAverageRating(this.testDoc_Admin, FIVE_STAR_SCHEME_NAME);
        RatingServiceIntegrationTest.assertEquals((String)"Document had wrong mean rating.", (Object)Float.valueOf(3.0f), (Object)Float.valueOf(meanRating));
        float totalRating = this.ratingService.getTotalRating(this.testDoc_Admin, FIVE_STAR_SCHEME_NAME);
        RatingServiceIntegrationTest.assertEquals((String)"Document had wrong total rating.", (Object)Float.valueOf(6.0f), (Object)Float.valueOf(totalRating));
        int ratingsCount = this.ratingService.getRatingsCount(this.testDoc_Admin, FIVE_STAR_SCHEME_NAME);
        RatingServiceIntegrationTest.assertEquals((String)"Document had wrong ratings count.", (int)2, (int)ratingsCount);
    }

    public void testUsersCantRateTheirOwnContent() throws Exception {
        try {
            AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
            this.ratingService.applyRating(this.testDoc_UserTwo, 4.0f, FIVE_STAR_SCHEME_NAME);
        }
        catch (RatingServiceException expected) {
            return;
        }
        RatingServiceIntegrationTest.fail((String)"Expected exception not thrown");
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put(ContentModel.PROP_USERNAME, userName);
            ppOne.put(ContentModel.PROP_FIRSTNAME, "firstName");
            ppOne.put(ContentModel.PROP_LASTNAME, "lastName");
            ppOne.put(ContentModel.PROP_EMAIL, "email@email.com");
            ppOne.put(ContentModel.PROP_JOBTITLE, "jobTitle");
            this.personService.createPerson(ppOne);
        }
    }

    private void deleteUser(String userName) {
        if (this.personService.personExists(userName)) {
            this.personService.deletePerson(userName);
        }
    }

    public void testJavascriptAPI() throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("testNode", this.testDoc_UserOne);
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/rating/script/test_ratingService.js");
        this.scriptService.executeScript(location, model);
    }
}

