/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remote;

import java.io.IOException;
import java.io.InputStream;
import org.alfresco.repo.remote.ClientTicketHolder;
import org.alfresco.service.cmr.remote.RepoRemoteTransport;

public class RepoRemoteInputStream
extends InputStream {
    private RepoRemoteTransport fRepoRemote;
    private ClientTicketHolder fTicketHolder;
    private String fHandle;

    public RepoRemoteInputStream(String handle, RepoRemoteTransport remote, ClientTicketHolder ticketHolder) {
        this.fHandle = handle;
        this.fRepoRemote = remote;
        this.fTicketHolder = ticketHolder;
    }

    public int read() throws IOException {
        try {
            byte[] buff = this.fRepoRemote.readInput(this.fTicketHolder.getTicket(), this.fHandle, 1);
            if (buff.length == 0) {
                return -1;
            }
            return buff[0] & 0xFF;
        }
        catch (Exception e) {
            throw new IOException("Remote I/O Error.");
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            byte[] buff = this.fRepoRemote.readInput(this.fTicketHolder.getTicket(), this.fHandle, len);
            if (buff.length == 0) {
                return -1;
            }
            System.arraycopy(buff, 0, b, off, buff.length);
            return buff.length;
        }
        catch (Exception e) {
            throw new IOException("Remote I/O Error.");
        }
    }

    public void close() throws IOException {
        try {
            this.fRepoRemote.closeInputHandle(this.fTicketHolder.getTicket(), this.fHandle);
        }
        catch (Exception e) {
            throw new IOException("Remote Error closing input stream.");
        }
    }
}

