/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.io.Serializable;
import java.util.List;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class PerformRenditionActionExecuter
extends ActionExecuterAbstractBase {
    private static final Log log = LogFactory.getLog(PerformRenditionActionExecuter.class);
    public static final String NAME = "perform-rendition";
    public static final String PARAM_RENDITION_DEFINITION = "renditionDefinition";
    private ActionService actionService;

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    @Override
    protected void executeImpl(Action containingAction, NodeRef actionedUponNodeRef) {
        RenditionDefinition renditionDefinition = this.getRenditionDefinition(containingAction);
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Rendering node ").append(actionedUponNodeRef).append(" with rendition definition ").append(renditionDefinition.getRenditionName());
            msg.append("\n").append("  parameters:").append("\n");
            if (!renditionDefinition.getParameterValues().isEmpty()) {
                for (String paramKey : renditionDefinition.getParameterValues().keySet()) {
                    msg.append("    ").append(paramKey).append("=").append(renditionDefinition.getParameterValue(paramKey)).append("\n");
                }
            } else {
                msg.append("    [None]");
            }
            log.debug((Object)msg.toString());
        }
        ChildAssociationRef result = this.executeRendition(actionedUponNodeRef, renditionDefinition);
        containingAction.setParameterValue("result", (Serializable)result);
    }

    private RenditionDefinition getRenditionDefinition(Action containingAction) {
        Serializable rendDefObj = containingAction.getParameterValue(PARAM_RENDITION_DEFINITION);
        ParameterCheck.mandatory((String)PARAM_RENDITION_DEFINITION, (Object)rendDefObj);
        return (RenditionDefinition)rendDefObj;
    }

    private ChildAssociationRef executeRendition(NodeRef sourceNode, RenditionDefinition definition) {
        this.actionService.executeAction(definition, sourceNode);
        Serializable serializableResult = definition.getParameterValue("result");
        return (ChildAssociationRef)serializableResult;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_RENDITION_DEFINITION, DataTypeDefinition.ANY, true, this.getParamDisplayLabel(PARAM_RENDITION_DEFINITION)));
        paramList.add(new ParameterDefinitionImpl("result", DataTypeDefinition.CHILD_ASSOC_REF, false, this.getParamDisplayLabel("result")));
    }
}

