/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.rendition.executer.HTMLRenderingEngine;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HTMLRenderingEngineTest
extends BaseAlfrescoSpringTest {
    private static final Log log = LogFactory.getLog(HTMLRenderingEngineTest.class);
    private NodeRef companyHome;
    private DictionaryService dictionaryService;
    private RenditionService renditionService;
    private Repository repositoryHelper;
    private NodeRef sourceDoc;
    private NodeRef targetFolder;
    private String targetFolderPath;
    private static final String MIMETYPE_DOC = "application/msword";
    private static final String MIMETYPE_DOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("ContentService");
        this.renditionService = (RenditionService)this.applicationContext.getBean("RenditionService");
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.dictionaryService = (DictionaryService)this.applicationContext.getBean("dictionaryService");
        this.companyHome = this.repositoryHelper.getCompanyHome();
        this.createTargetFolder();
    }

    protected void onTearDownInTransaction() throws Exception {
        super.onTearDownInTransaction();
        this.tidyUpSourceDoc();
    }

    private void createTargetFolder() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_NAME, "TestFolder");
        this.targetFolder = this.nodeService.createNode(this.companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"TestFolder"), ContentModel.TYPE_FOLDER, properties).getChildRef();
        this.targetFolderPath = "/" + (String)((Object)this.nodeService.getProperty(this.companyHome, ContentModel.PROP_NAME)) + "/" + (String)((Object)this.nodeService.getProperty(this.targetFolder, ContentModel.PROP_NAME));
    }

    private void tidyUpSourceDoc() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        if (this.sourceDoc != null) {
            this.nodeService.deleteNode(this.sourceDoc);
        }
        this.nodeService.deleteNode(this.targetFolder);
        this.targetFolder = null;
        this.sourceDoc = null;
        this.createTargetFolder();
    }

    private NodeRef createForDoc(String docname) throws IOException {
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_NAME, docname);
        NodeRef node = this.nodeService.createNode(this.companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)docname), ContentModel.TYPE_CONTENT, properties).getChildRef();
        File f = AbstractContentTransformerTest.loadNamedQuickTestFile(docname);
        if (f == null) {
            HTMLRenderingEngineTest.fail((String)("Unable to find test file for " + docname));
        }
        ContentWriter writer = this.contentService.getWriter(node, ContentModel.PROP_CONTENT, true);
        if (docname.endsWith(".doc")) {
            writer.setMimetype(MIMETYPE_DOC);
        }
        if (docname.endsWith(".docx")) {
            writer.setMimetype(MIMETYPE_DOCX);
        }
        writer.putContent(f);
        return node;
    }

    public void testBasics() throws Exception {
        RenditionDefinition def = this.renditionService.createRenditionDefinition(QName.createQName((String)"Test"), "htmlRenderingEngine");
        def.setParameterValue("destination-path-template", (Serializable)((Object)(this.targetFolderPath + "/${name}.html")));
        this.sourceDoc = this.createForDoc("quick.doc");
        ChildAssociationRef rendition = this.renditionService.render(this.sourceDoc, def);
        HTMLRenderingEngineTest.assertNotNull((Object)rendition);
        NodeRef htmlNode = rendition.getChildRef();
        HTMLRenderingEngineTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(htmlNode));
        HTMLRenderingEngineTest.assertEquals((Object)"quick.html", (Object)this.nodeService.getProperty(htmlNode, ContentModel.PROP_NAME));
        ContentReader reader = this.contentService.getReader(htmlNode, ContentModel.PROP_CONTENT);
        String html = reader.getContentString();
        HTMLRenderingEngineTest.assertEquals((String)"<?xml", (String)html.substring(0, 5));
        HTMLRenderingEngineTest.assertTrue((String)("HTML wrong:\n" + html), (boolean)html.contains("<html"));
        HTMLRenderingEngineTest.assertTrue((String)("HTML wrong:\n" + html), (boolean)html.contains("<head>"));
        HTMLRenderingEngineTest.assertTrue((String)("HTML wrong:\n" + html), (boolean)html.contains("<body>"));
        HTMLRenderingEngineTest.assertTrue((String)("HTML wrong:\n" + html), (boolean)html.contains("<p>The quick brown fox"));
        def.setParameterValue("bodyContentsOnly", Boolean.TRUE);
        rendition = this.renditionService.render(this.sourceDoc, def);
        HTMLRenderingEngineTest.assertNotNull((Object)rendition);
        htmlNode = rendition.getChildRef();
        HTMLRenderingEngineTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(htmlNode));
        reader = this.contentService.getReader(htmlNode, ContentModel.PROP_CONTENT);
        html = reader.getContentString();
        HTMLRenderingEngineTest.assertEquals((String)"<?xml", (String)html.substring(0, 5));
        HTMLRenderingEngineTest.assertFalse((String)("Body wrong:\n" + html), (boolean)html.contains("<html"));
        HTMLRenderingEngineTest.assertFalse((String)("Body wrong:\n" + html), (boolean)html.contains("<head>"));
        HTMLRenderingEngineTest.assertFalse((String)("Body wrong:\n" + html), (boolean)html.contains("<body>"));
        HTMLRenderingEngineTest.assertTrue((String)("HTML wrong:\n" + html), (boolean)html.contains("<p>The quick brown fox"));
        HTMLRenderingEngineTest.assertTrue((String)("HTML wrong:\n" + html), (boolean)html.contains("</p>"));
    }

    public void testDocWithoutImages() throws Exception {
        RenditionDefinition def = this.renditionService.createRenditionDefinition(QName.createQName((String)"Test"), "htmlRenderingEngine");
        def.setParameterValue("destination-path-template", (Serializable)((Object)(this.targetFolderPath + "/${name}.html")));
        for (String name : new String[]{"quick.doc", "quick.docx"}) {
            this.sourceDoc = this.createForDoc(name);
            int numItemsStart = this.nodeService.getChildAssocs(this.targetFolder).size();
            ChildAssociationRef rendition = this.renditionService.render(this.sourceDoc, def);
            HTMLRenderingEngineTest.assertNotNull((Object)rendition);
            NodeRef htmlNode = rendition.getChildRef();
            HTMLRenderingEngineTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(htmlNode));
            HTMLRenderingEngineTest.assertEquals((Object)(name.substring(0, name.lastIndexOf(46)) + ".html"), (Object)this.nodeService.getProperty(htmlNode, ContentModel.PROP_NAME));
            HTMLRenderingEngineTest.assertEquals((String)("Should have been in " + this.targetFolderPath + " but was  in" + this.nodeService.getPath(htmlNode)), (Object)this.targetFolder, (Object)this.nodeService.getPrimaryParent(htmlNode).getParentRef());
            ContentReader reader = this.contentService.getReader(htmlNode, ContentModel.PROP_CONTENT);
            String html = reader.getContentString();
            HTMLRenderingEngineTest.assertEquals((String)"<?xml", (String)html.substring(0, 5));
            int numItems = this.nodeService.getChildAssocs(this.targetFolder).size();
            HTMLRenderingEngineTest.assertEquals((int)(numItemsStart + 1), (int)numItems);
            HTMLRenderingEngineTest.assertEquals((String)("Unexpected img tag in html:\n" + html), (boolean)false, (boolean)html.contains("<img"));
            for (ChildAssociationRef ref : this.nodeService.getChildAssocs(htmlNode)) {
                if (ref.getTypeQName().equals((Object)HTMLRenderingEngine.PRIMARY_IMAGE)) {
                    HTMLRenderingEngineTest.fail((String)"Found unexpected primary image of rendered html");
                }
                if (!ref.getTypeQName().equals((Object)HTMLRenderingEngine.SECONDARY_IMAGE)) continue;
                HTMLRenderingEngineTest.fail((String)"Found unexpected secondary image of rendered html");
            }
            this.tidyUpSourceDoc();
        }
    }

    public void testDocWithOneImages() throws Exception {
        RenditionDefinition def = this.renditionService.createRenditionDefinition(QName.createQName((String)"Test"), "htmlRenderingEngine");
        def.setParameterValue("destination-path-template", (Serializable)((Object)(this.targetFolderPath + "/${name}.html")));
        for (String name : new String[]{"quickImg1.doc", "quickImg1.docx"}) {
            this.sourceDoc = this.createForDoc(name);
            String baseName = name.substring(0, name.lastIndexOf(46));
            int numItemsStart = this.nodeService.getChildAssocs(this.targetFolder).size();
            ChildAssociationRef rendition = this.renditionService.render(this.sourceDoc, def);
            HTMLRenderingEngineTest.assertNotNull((Object)rendition);
            NodeRef htmlNode = rendition.getChildRef();
            HTMLRenderingEngineTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(htmlNode));
            HTMLRenderingEngineTest.assertEquals((Object)(baseName + ".html"), (Object)this.nodeService.getProperty(htmlNode, ContentModel.PROP_NAME));
            HTMLRenderingEngineTest.assertEquals((String)("Should have been in " + this.targetFolderPath + " but was  in" + this.nodeService.getPath(htmlNode)), (Object)this.targetFolder, (Object)this.nodeService.getPrimaryParent(htmlNode).getParentRef());
            ContentReader reader = this.contentService.getReader(htmlNode, ContentModel.PROP_CONTENT);
            String html = reader.getContentString();
            HTMLRenderingEngineTest.assertEquals((String)"<?xml", (String)html.substring(0, 5));
            HTMLRenderingEngineTest.assertEquals((String)("Couldn't find img tag in html:\n" + html), (boolean)true, (boolean)html.contains("<img"));
            String expSource = "src=\"" + baseName + "_files" + "/image";
            HTMLRenderingEngineTest.assertEquals((String)("Couldn't find correct img src in html:\n" + expSource + "\n" + html), (boolean)true, (boolean)html.contains(expSource));
            int numItems = this.nodeService.getChildAssocs(this.targetFolder).size();
            HTMLRenderingEngineTest.assertEquals((int)(numItemsStart + 2), (int)numItems);
            NodeRef imgFolder = null;
            for (ChildAssociationRef ref : this.nodeService.getChildAssocs(this.targetFolder)) {
                if (!this.nodeService.getProperty(ref.getChildRef(), ContentModel.PROP_NAME).equals(baseName + "_files")) continue;
                imgFolder = ref.getChildRef();
            }
            HTMLRenderingEngineTest.assertNotNull((String)("Couldn't find new folder named " + baseName + "_files"), imgFolder);
            HTMLRenderingEngineTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(imgFolder).size());
            if (this.dictionaryService.getAssociation(HTMLRenderingEngine.PRIMARY_IMAGE) != null) {
                boolean hasPrimary = false;
                boolean hasSecondary = false;
                for (ChildAssociationRef ref : this.nodeService.getChildAssocs(htmlNode)) {
                    if (ref.getTypeQName().equals((Object)HTMLRenderingEngine.PRIMARY_IMAGE)) {
                        hasPrimary = true;
                    }
                    if (!ref.getTypeQName().equals((Object)HTMLRenderingEngine.SECONDARY_IMAGE)) continue;
                    hasSecondary = true;
                }
                HTMLRenderingEngineTest.assertEquals((boolean)true, (boolean)hasPrimary);
                HTMLRenderingEngineTest.assertEquals((boolean)false, (boolean)hasSecondary);
            }
            this.tidyUpSourceDoc();
        }
    }

    public void testDocWithManyImages() throws Exception {
    }
}

