/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.util.HashSet;
import java.util.Set;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.rule.ruletrigger.RuleTrigger;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleType;

public abstract class RuleTriggerAbstractBase
implements RuleTrigger {
    private Set<RuleType> ruleTypes = new HashSet<RuleType>();
    protected PolicyComponent policyComponent;
    protected NodeService nodeService;
    protected ContentService contentService;
    protected AuthenticationComponent authenticationComponent;
    protected DictionaryService dictionaryService;
    protected boolean executeRuleImmediately = false;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setExecuteRuleImmediately(boolean executeRuleImmediately) {
        this.executeRuleImmediately = executeRuleImmediately;
    }

    public void registerRuleType(RuleType ruleType) {
        this.ruleTypes.add(ruleType);
    }

    protected void triggerRules(NodeRef nodeRef, NodeRef actionedUponNodeRef) {
        for (RuleType ruleType : this.ruleTypes) {
            ruleType.triggerRuleType(nodeRef, actionedUponNodeRef, this.executeRuleImmediately);
        }
    }
}

