/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.alfresco.repo.search.impl.lucene.PagingLuceneResultSetRowIteratorImpl;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagingLuceneResultSet
implements ResultSet,
Serializable {
    ResultSet wrapped;
    SearchParameters searchParameters;
    NodeService nodeService;

    public PagingLuceneResultSet(ResultSet wrapped, SearchParameters searchParameters, NodeService nodeService) {
        this.wrapped = wrapped;
        this.searchParameters = searchParameters;
        this.nodeService = nodeService;
    }

    public void close() {
        this.wrapped.close();
    }

    public ResultSetRow getRow(int i) {
        return this.wrapped.getRow(this.getStart() + i);
    }

    public boolean hasMore() {
        if (this.wrapped.getResultSetMetaData().getLimitedBy() != LimitBy.UNLIMITED) {
            return true;
        }
        return this.wrapped.length() - this.getStart() > this.getLength();
    }

    public int getLength() {
        int max = this.searchParameters.getMaxItems();
        int skip = this.searchParameters.getSkipCount();
        if (max >= 0 && max < this.wrapped.length() - skip) {
            return this.searchParameters.getMaxItems();
        }
        return this.wrapped.length() - skip;
    }

    public int getStart() {
        return this.searchParameters.getSkipCount();
    }

    public Iterator<ResultSetRow> iterator() {
        return new PagingLuceneResultSetRowIteratorImpl(this);
    }

    public ChildAssociationRef getChildAssocRef(int n) {
        NodeRef nodeRef = this.getNodeRef(n);
        return this.nodeService.getPrimaryParent(nodeRef);
    }

    public List<ChildAssociationRef> getChildAssocRefs() {
        ArrayList<ChildAssociationRef> cars = new ArrayList<ChildAssociationRef>(this.length());
        Iterator<ResultSetRow> i$ = this.iterator();
        while (i$.hasNext()) {
            ResultSetRow row = i$.next();
            cars.add(row.getChildAssocRef());
        }
        return cars;
    }

    public NodeRef getNodeRef(int n) {
        return this.wrapped.getNodeRef(this.getStart() + n);
    }

    public List<NodeRef> getNodeRefs() {
        ArrayList<NodeRef> nodeRefs = new ArrayList<NodeRef>(this.length());
        Iterator<ResultSetRow> i$ = this.iterator();
        while (i$.hasNext()) {
            ResultSetRow row = i$.next();
            nodeRefs.add(row.getNodeRef());
        }
        return nodeRefs;
    }

    public ResultSetMetaData getResultSetMetaData() {
        return this.wrapped.getResultSetMetaData();
    }

    public float getScore(int n) {
        return this.wrapped.getScore(this.getStart() + n);
    }

    public int length() {
        return this.getLength();
    }

    public ResultSet getWrapped() {
        return this.wrapped;
    }

    public boolean setBulkFetch(boolean bulkFetch) {
        return this.wrapped.setBulkFetch(bulkFetch);
    }

    public boolean getBulkFetch() {
        return this.wrapped.getBulkFetch();
    }

    public int setBulkFetchSize(int bulkFetchSize) {
        return this.wrapped.setBulkFetchSize(bulkFetchSize);
    }

    public int getBulkFetchSize() {
        return this.wrapped.getBulkFetchSize();
    }
}

