/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.model;

import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.PermissionReferenceImpl;
import org.alfresco.repo.security.permissions.impl.model.PermissionModel;
import org.alfresco.repo.security.permissions.impl.model.PermissionModelException;
import org.alfresco.repo.security.permissions.impl.model.XMLModelInitialisable;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ModelPermissionEntry
implements PermissionEntry,
XMLModelInitialisable {
    private static final String PERMISSION_REFERENCE = "permissionReference";
    private static final String RECIPIENT = "recipient";
    private static final String ACCESS = "access";
    private static final String DENY = "deny";
    private static final String ALLOW = "allow";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private String recipient;
    private AccessStatus access;
    private PermissionReference permissionReference;
    private NodeRef nodeRef;

    public ModelPermissionEntry(NodeRef nodeRef) {
        this.nodeRef = nodeRef;
    }

    public PermissionReference getPermissionReference() {
        return this.permissionReference;
    }

    public String getAuthority() {
        return this.getRecipient();
    }

    public String getRecipient() {
        return this.recipient;
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public boolean isDenied() {
        return this.access == AccessStatus.DENIED;
    }

    public boolean isAllowed() {
        return this.access == AccessStatus.ALLOWED;
    }

    public AccessStatus getAccessStatus() {
        return this.access;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialise(Element element, NamespacePrefixResolver nspr, PermissionModel permissionModel) {
        Attribute recipientAttribute = element.attribute(RECIPIENT);
        this.recipient = recipientAttribute != null ? recipientAttribute.getStringValue() : null;
        Attribute accessAttribute = element.attribute(ACCESS);
        if (accessAttribute != null) {
            if (accessAttribute.getStringValue().equalsIgnoreCase(ALLOW)) {
                this.access = AccessStatus.ALLOWED;
            } else {
                if (!accessAttribute.getStringValue().equalsIgnoreCase(DENY)) throw new PermissionModelException("The default permission must be deny or allow");
                this.access = AccessStatus.DENIED;
            }
        } else {
            this.access = AccessStatus.DENIED;
        }
        Element permissionReferenceElement = element.element(PERMISSION_REFERENCE);
        QName typeQName = QName.createQName((String)permissionReferenceElement.attributeValue(TYPE), (NamespacePrefixResolver)nspr);
        String name = permissionReferenceElement.attributeValue(NAME);
        this.permissionReference = PermissionReferenceImpl.getPermissionReference(typeQName, name);
    }

    public int getPosition() {
        return 0;
    }

    public boolean isInherited() {
        return false;
    }
}

