/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.repo.security.permissions.impl.RequiredPermission;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.security.permissions.impl.model.GlobalPermissionEntry;
import org.alfresco.repo.security.permissions.impl.model.Permission;
import org.alfresco.repo.security.permissions.impl.model.PermissionGroup;
import org.alfresco.repo.security.permissions.impl.model.PermissionModelException;
import org.alfresco.repo.security.permissions.impl.model.PermissionSet;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionModel
extends AbstractLifecycleBean
implements ModelDAO {
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private static final String NAMESPACES = "namespaces";
    private static final String NAMESPACE = "namespace";
    private static final String NAMESPACE_URI = "uri";
    private static final String NAMESPACE_PREFIX = "prefix";
    private static final String PERMISSION_SET = "permissionSet";
    private static final String GLOBAL_PERMISSION = "globalPermission";
    private static final String DENY = "deny";
    private static final String ALLOW = "allow";
    private static final String DEFAULT_PERMISSION = "defaultPermission";
    private String model;
    private ConcurrentHashMap<QName, PermissionSet> permissionSets = new ConcurrentHashMap(128, 1.0f, 16);
    private Set<GlobalPermissionEntry> globalPermissions = Collections.synchronizedSet(new HashSet());
    private AccessStatus defaultPermission;
    private ConcurrentHashMap<PermissionReference, Set<PermissionReference>> grantingPermissions = new ConcurrentHashMap(256, 1.0f, 32);
    private ConcurrentHashMap<PermissionReference, Set<PermissionReference>> granteePermissions = new ConcurrentHashMap(256, 1.0f, 32);
    private ConcurrentHashMap<PermissionGroup, PermissionGroup> groupsToBaseGroup = new ConcurrentHashMap(256, 1.0f, 32);
    private ConcurrentHashMap<String, PermissionReference> uniqueMap;
    private ConcurrentHashMap<PermissionReference, Permission> permissionMap;
    private ConcurrentHashMap<PermissionReference, PermissionGroup> permissionGroupMap;
    private ConcurrentHashMap<String, PermissionReference> permissionReferenceMap;
    private ConcurrentHashMap<QName, Set<PermissionReference>> cachedTypePermissionsExposed = new ConcurrentHashMap(256, 1.0f, 32);
    private ConcurrentHashMap<QName, Set<PermissionReference>> cachedTypePermissionsUnexposed = new ConcurrentHashMap(256, 1.0f, 32);
    private Collection<QName> allAspects;
    private ConcurrentHashMap<RequiredKey, Set<PermissionReference>> requiredPermissionsCache = new ConcurrentHashMap(1024);
    private PermissionGroup group;
    private ConcurrentHashMap<Pair<PermissionReference, RequiredPermission.On>, Set<PermissionReference>> unconditionalRequiredPermissionsCache = new ConcurrentHashMap(1024);
    private static PermissionReference ALL = SimplePermissionReference.getPermissionReference(QName.createQName((String)"http://www.alfresco.org/model/security/1.0", (String)"All"), "All");

    public void setModel(String model) {
        this.model = model;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.addPermissionModel(this.model);
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addPermissionModel(String model) {
        Document document = this.createDocument(model);
        Element root = document.getRootElement();
        Attribute defaultPermissionAttribute = root.attribute(DEFAULT_PERMISSION);
        if (defaultPermissionAttribute != null) {
            if (defaultPermissionAttribute.getStringValue().equalsIgnoreCase(ALLOW)) {
                this.defaultPermission = AccessStatus.ALLOWED;
            } else {
                if (!defaultPermissionAttribute.getStringValue().equalsIgnoreCase(DENY)) throw new PermissionModelException("The default permission must be deny or allow");
                this.defaultPermission = AccessStatus.DENIED;
            }
        } else {
            this.defaultPermission = AccessStatus.DENIED;
        }
        DynamicNamespacePrefixResolver nspr = new DynamicNamespacePrefixResolver();
        Iterator nsit = root.elementIterator(NAMESPACES);
        while (nsit.hasNext()) {
            Element namespacesElement = (Element)nsit.next();
            Iterator it = namespacesElement.elementIterator(NAMESPACE);
            while (it.hasNext()) {
                Element nameSpaceElement = (Element)it.next();
                nspr.registerNamespace(nameSpaceElement.attributeValue(NAMESPACE_PREFIX), nameSpaceElement.attributeValue(NAMESPACE_URI));
            }
        }
        Iterator psit = root.elementIterator(PERMISSION_SET);
        while (psit.hasNext()) {
            Element permissionSetElement = (Element)psit.next();
            PermissionSet permissionSet = new PermissionSet();
            permissionSet.initialise(permissionSetElement, (NamespacePrefixResolver)nspr, this);
            this.permissionSets.put(permissionSet.getQName(), permissionSet);
        }
        this.buildUniquePermissionMap();
        Iterator npit = root.elementIterator(GLOBAL_PERMISSION);
        while (npit.hasNext()) {
            Element globalPermissionElement = (Element)npit.next();
            GlobalPermissionEntry globalPermission = new GlobalPermissionEntry();
            globalPermission.initialise(globalPermissionElement, (NamespacePrefixResolver)nspr, this);
            this.globalPermissions.add(globalPermission);
        }
        this.allAspects = this.dictionaryService.getAllAspects();
    }

    private Document createDocument(String model) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(model);
        if (is == null) {
            throw new PermissionModelException("File not found: " + model);
        }
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(is);
            is.close();
            return document;
        }
        catch (DocumentException e) {
            throw new PermissionModelException("Failed to create permission model document ", e);
        }
        catch (IOException e) {
            throw new PermissionModelException("Failed to close permission model document ", e);
        }
    }

    public AccessStatus getDefaultPermission() {
        return this.defaultPermission;
    }

    public AccessStatus getDefaultPermission(PermissionReference pr) {
        Permission p = this.permissionMap.get(pr);
        if (p == null) {
            return this.defaultPermission;
        }
        return p.getDefaultPermission();
    }

    @Override
    public Set<? extends PermissionEntry> getGlobalPermissionEntries() {
        return Collections.unmodifiableSet(this.globalPermissions);
    }

    public Map<QName, PermissionSet> getPermissionSets() {
        return Collections.unmodifiableMap(this.permissionSets);
    }

    @Override
    public Set<PermissionReference> getAllPermissions(QName type) {
        return this.getAllPermissionsImpl(type, null, false);
    }

    @Override
    public Set<PermissionReference> getExposedPermissions(QName type) {
        return this.getAllPermissionsImpl(type, null, true);
    }

    private Set<PermissionReference> getAllPermissionsImpl(QName type, boolean exposedOnly) {
        ConcurrentHashMap<QName, Set<PermissionReference>> cache = exposedOnly ? this.cachedTypePermissionsExposed : this.cachedTypePermissionsUnexposed;
        Set<PermissionReference> permissions = cache.get(type);
        if (permissions == null) {
            permissions = new LinkedHashSet<PermissionReference>(256, 1.0f);
            ClassDefinition cd = this.dictionaryService.getClass(type);
            if (cd != null) {
                if (cd.isAspect()) {
                    this.addAspectPermissions(type, permissions, exposedOnly);
                } else {
                    this.mergeGeneralAspectPermissions(permissions, exposedOnly);
                    this.addTypePermissions(type, permissions, exposedOnly);
                }
            }
            permissions = Collections.unmodifiableSet(permissions);
            cache.put(type, permissions);
        }
        return permissions;
    }

    private void addTypePermissions(QName type, Set<PermissionReference> permissions, boolean exposedOnly) {
        TypeDefinition typeDef = this.dictionaryService.getType(type);
        if (typeDef == null) {
            return;
        }
        if (typeDef.getParentName() != null) {
            PermissionSet permissionSet = this.permissionSets.get(type);
            if (!exposedOnly || permissionSet == null || permissionSet.exposeAll()) {
                this.addTypePermissions(typeDef.getParentName(), permissions, exposedOnly);
            }
        }
        for (AspectDefinition ad : typeDef.getDefaultAspects()) {
            this.addAspectPermissions(ad.getName(), permissions, exposedOnly);
        }
        this.mergePermissions(permissions, type, exposedOnly, true);
    }

    private void addAspectPermissions(QName type, Set<PermissionReference> permissions, boolean exposedOnly) {
        AspectDefinition aspectDef = this.dictionaryService.getAspect(type);
        if (aspectDef == null) {
            return;
        }
        if (aspectDef.getParentName() != null) {
            PermissionSet permissionSet = this.permissionSets.get(type);
            if (!exposedOnly || permissionSet == null || permissionSet.exposeAll()) {
                this.addAspectPermissions(aspectDef.getParentName(), permissions, exposedOnly);
            }
        }
        this.mergePermissions(permissions, type, exposedOnly, true);
    }

    private void mergePermissions(Set<PermissionReference> target, QName type, boolean exposedOnly, boolean typeRequired) {
        PermissionSet permissionSet = this.permissionSets.get(type);
        if (permissionSet != null) {
            for (PermissionGroup pg : permissionSet.getPermissionGroups()) {
                if (exposedOnly && !permissionSet.exposeAll() && !pg.isExposed()) continue;
                if (!pg.isExtends()) {
                    if (pg.isTypeRequired() != typeRequired) continue;
                    target.add(SimplePermissionReference.getPermissionReference(pg.getQName(), pg.getName()));
                    continue;
                }
                if (!exposedOnly || pg.isTypeRequired() != typeRequired) continue;
                PermissionGroup base = this.getBasePermissionGroup(pg);
                target.add(SimplePermissionReference.getPermissionReference(base.getQName(), base.getName()));
            }
            for (Permission p : permissionSet.getPermissions()) {
                if (exposedOnly && !permissionSet.exposeAll() && !p.isExposed() || p.isTypeRequired() != typeRequired) continue;
                target.add(SimplePermissionReference.getPermissionReference(p.getQName(), p.getName()));
            }
        }
    }

    private void mergeGeneralAspectPermissions(Set<PermissionReference> target, boolean exposedOnly) {
        for (QName aspect : this.allAspects) {
            this.mergePermissions(target, aspect, exposedOnly, false);
        }
    }

    @Override
    public Set<PermissionReference> getAllPermissions(NodeRef nodeRef) {
        return this.getAllPermissionsImpl(this.nodeService.getType(nodeRef), this.nodeService.getAspects(nodeRef), false);
    }

    @Override
    public Set<PermissionReference> getExposedPermissions(NodeRef nodeRef) {
        return this.getAllPermissionsImpl(this.nodeService.getType(nodeRef), this.nodeService.getAspects(nodeRef), true);
    }

    @Override
    public Set<PermissionReference> getAllPermissions(QName typeName, Set<QName> aspects) {
        return this.getAllPermissionsImpl(typeName, aspects, false);
    }

    private Set<PermissionReference> getAllPermissionsImpl(QName typeName, Set<QName> aspects, boolean exposedOnly) {
        LinkedHashSet<PermissionReference> permissions = new LinkedHashSet<PermissionReference>(128, 1.0f);
        ClassDefinition cd = this.dictionaryService.getClass(typeName);
        permissions.addAll(this.getAllPermissionsImpl(typeName, exposedOnly));
        if (cd != null && aspects != null) {
            Set defaultAspects = cd.getDefaultAspectNames();
            for (QName aspect : aspects) {
                if (defaultAspects.contains(aspect)) continue;
                this.addAspectPermissions(aspect, permissions, exposedOnly);
            }
        }
        return permissions;
    }

    @Override
    public synchronized Set<PermissionReference> getGrantingPermissions(PermissionReference permissionReference) {
        if (permissionReference == null) {
            return Collections.emptySet();
        }
        Set<PermissionReference> granters = this.grantingPermissions.get(permissionReference);
        if (granters == null) {
            Set<PermissionReference> internal = this.getGrantingPermissionsImpl(permissionReference);
            granters = new HashSet<PermissionReference>();
            for (PermissionReference grantee : internal) {
                granters.add(SimplePermissionReference.getPermissionReference(grantee.getQName(), grantee.getName()));
            }
            granters = Collections.unmodifiableSet(granters);
            this.grantingPermissions.put(permissionReference, granters);
        }
        return granters;
    }

    private Set<PermissionReference> getGrantingPermissionsImpl(PermissionReference permissionReference) {
        HashSet<PermissionReference> permissions = new HashSet<PermissionReference>(256, 1.0f);
        permissions.add(permissionReference);
        for (PermissionSet ps : this.permissionSets.values()) {
            for (PermissionGroup pg : ps.getPermissionGroups()) {
                if (this.grants(pg, permissionReference)) {
                    permissions.add(this.getBasePermissionGroup(pg));
                }
                if (!pg.isAllowFullControl()) continue;
                permissions.add(pg);
            }
            block2: for (Permission p : ps.getPermissions()) {
                if (p.equals(permissionReference)) {
                    for (PermissionReference pg : p.getGrantedToGroups()) {
                        permissions.add(this.getBasePermissionGroup(this.getPermissionGroup(pg)));
                    }
                }
                for (RequiredPermission rp : p.getRequiredPermissions()) {
                    if (!rp.equals(permissionReference) || !rp.isImplies()) continue;
                    permissions.add(p);
                    continue block2;
                }
            }
        }
        return permissions;
    }

    private boolean grants(PermissionGroup pg, PermissionReference permissionReference) {
        if (pg.getIncludedPermissionGroups().contains(permissionReference)) {
            return true;
        }
        if (this.getGranteePermissions(pg).contains(permissionReference)) {
            return true;
        }
        for (PermissionReference nested : pg.getIncludedPermissionGroups()) {
            if (!this.grants(this.getPermissionGroup(nested), permissionReference)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Set<PermissionReference> getGranteePermissions(PermissionReference permissionReference) {
        if (permissionReference == null) {
            return Collections.emptySet();
        }
        Set<PermissionReference> grantees = this.granteePermissions.get(permissionReference);
        if (grantees == null) {
            Set<PermissionReference> internal = this.getGranteePermissionsImpl(permissionReference);
            grantees = new HashSet<PermissionReference>();
            for (PermissionReference grantee : internal) {
                grantees.add(SimplePermissionReference.getPermissionReference(grantee.getQName(), grantee.getName()));
            }
            grantees = Collections.unmodifiableSet(grantees);
            this.granteePermissions.put(permissionReference, grantees);
        }
        return grantees;
    }

    @Override
    public synchronized Set<PermissionReference> getImmediateGranteePermissions(PermissionReference permissionReference) {
        Set<PermissionReference> internal = this.getImmediateGranteePermissionsImpl(permissionReference);
        HashSet<PermissionReference> grantees = new HashSet();
        for (PermissionReference grantee : internal) {
            grantees.add(SimplePermissionReference.getPermissionReference(grantee.getQName(), grantee.getName()));
        }
        grantees = Collections.unmodifiableSet(grantees);
        return grantees;
    }

    private Set<PermissionReference> getGranteePermissionsImpl(PermissionReference permissionReference) {
        HashSet<PermissionReference> permissions = new HashSet<PermissionReference>(256, 1.0f);
        permissions.add(permissionReference);
        for (PermissionSet ps : this.permissionSets.values()) {
            for (PermissionGroup pg : ps.getPermissionGroups()) {
                if (!pg.equals(permissionReference)) continue;
                for (PermissionReference included : pg.getIncludedPermissionGroups()) {
                    permissions.addAll(this.getGranteePermissions(included));
                }
                if (pg.isExtends()) {
                    if (pg.getTypeQName() != null) {
                        permissions.addAll(this.getGranteePermissions(SimplePermissionReference.getPermissionReference(pg.getTypeQName(), pg.getName())));
                    } else {
                        ClassDefinition classDefinition = this.dictionaryService.getClass(pg.getQName());
                        QName parent = classDefinition.getParentName();
                        if (parent != null) {
                            classDefinition = this.dictionaryService.getClass(parent);
                            PermissionGroup attempt = this.getPermissionGroupOrNull(SimplePermissionReference.getPermissionReference(parent, pg.getName()));
                            if (attempt != null) {
                                permissions.addAll(this.getGranteePermissions(attempt));
                            }
                        }
                    }
                }
                if (!pg.isAllowFullControl()) continue;
                permissions.addAll(this.getAllPermissions());
            }
            PermissionGroup baseGroup = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(permissionReference));
            if (baseGroup == null) continue;
            for (Permission p : ps.getPermissions()) {
                for (PermissionReference grantedTo : p.getGrantedToGroups()) {
                    PermissionGroup base = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(grantedTo));
                    if (!baseGroup.equals(base)) continue;
                    permissions.add(p);
                }
            }
        }
        return permissions;
    }

    private Set<PermissionReference> getImmediateGranteePermissionsImpl(PermissionReference permissionReference) {
        HashSet<PermissionReference> permissions = new HashSet<PermissionReference>(256, 1.0f);
        for (PermissionSet ps : this.permissionSets.values()) {
            for (PermissionGroup pg : ps.getPermissionGroups()) {
                if (!pg.equals(permissionReference)) continue;
                for (PermissionReference included : pg.getIncludedPermissionGroups()) {
                    permissions.add(included);
                }
                if (pg.isExtends()) {
                    if (pg.getTypeQName() != null) {
                        permissions.addAll(this.getImmediateGranteePermissions(SimplePermissionReference.getPermissionReference(pg.getTypeQName(), pg.getName())));
                    } else {
                        ClassDefinition classDefinition = this.dictionaryService.getClass(pg.getQName());
                        QName parent = classDefinition.getParentName();
                        if (parent != null) {
                            classDefinition = this.dictionaryService.getClass(parent);
                            PermissionGroup attempt = this.getPermissionGroupOrNull(SimplePermissionReference.getPermissionReference(parent, pg.getName()));
                            if (attempt != null) {
                                permissions.addAll(this.getImmediateGranteePermissions(attempt));
                            }
                        }
                    }
                }
                if (!pg.isAllowFullControl()) continue;
                permissions.addAll(this.getAllPermissions());
            }
            PermissionGroup baseGroup = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(permissionReference));
            if (baseGroup == null) continue;
            for (Permission p : ps.getPermissions()) {
                for (PermissionReference grantedTo : p.getGrantedToGroups()) {
                    PermissionGroup base = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(grantedTo));
                    if (!baseGroup.equals(base)) continue;
                    permissions.add(p);
                }
            }
        }
        return permissions;
    }

    @Override
    public Set<PermissionReference> getAllPermissions() {
        HashSet<PermissionReference> permissions = new HashSet<PermissionReference>(256, 1.0f);
        for (PermissionSet ps : this.permissionSets.values()) {
            for (PermissionGroup pg : ps.getPermissionGroups()) {
                permissions.add(SimplePermissionReference.getPermissionReference(pg.getQName(), pg.getName()));
            }
            for (Permission p : ps.getPermissions()) {
                permissions.add(SimplePermissionReference.getPermissionReference(p.getQName(), p.getName()));
            }
        }
        return permissions;
    }

    private PermissionGroup getPermissionGroupOrNull(PermissionReference target) {
        PermissionGroup pg = this.permissionGroupMap.get(target);
        return pg == null ? null : pg;
    }

    private PermissionGroup getPermissionGroup(PermissionReference target) {
        PermissionGroup pg = this.getPermissionGroupOrNull(target);
        if (pg == null) {
            throw new PermissionModelException("There is no permission group :" + target.getQName() + " " + target.getName());
        }
        return pg;
    }

    private synchronized PermissionGroup getBasePermissionGroupOrNull(PermissionGroup pg) {
        if (pg == null) {
            return null;
        }
        PermissionGroup permissionGroup = this.groupsToBaseGroup.get(pg);
        if (permissionGroup == null) {
            permissionGroup = this.getBasePermissionGroupOrNullImpl(pg);
            this.groupsToBaseGroup.put(pg, permissionGroup);
        }
        return permissionGroup;
    }

    private PermissionGroup getBasePermissionGroupOrNullImpl(PermissionGroup pg) {
        if (pg == null) {
            return null;
        }
        if (pg.isExtends()) {
            QName parent;
            if (pg.getTypeQName() != null) {
                return this.getPermissionGroup(SimplePermissionReference.getPermissionReference(pg.getTypeQName(), pg.getName()));
            }
            ClassDefinition classDefinition = this.dictionaryService.getClass(pg.getQName());
            while ((parent = classDefinition.getParentName()) != null) {
                classDefinition = this.dictionaryService.getClass(parent);
                PermissionGroup attempt = this.getPermissionGroupOrNull(SimplePermissionReference.getPermissionReference(parent, pg.getName()));
                if (attempt == null || attempt.isExtends()) continue;
                return attempt;
            }
            return null;
        }
        return pg;
    }

    private PermissionGroup getBasePermissionGroup(PermissionGroup target) {
        PermissionGroup pg = this.getBasePermissionGroupOrNull(target);
        if (pg == null) {
            throw new PermissionModelException("There is no parent for permission group :" + target.getQName() + " " + target.getName());
        }
        return pg;
    }

    static RequiredKey generateKey(PermissionReference required, QName qName, Set<QName> aspectQNames, RequiredPermission.On on) {
        return RequiredKey.getRequiredKey(required, qName, aspectQNames, on);
    }

    @Override
    public Set<PermissionReference> getRequiredPermissions(PermissionReference required, QName qName, Set<QName> aspectQNames, RequiredPermission.On on) {
        if (required == null || qName == null) {
            return Collections.emptySet();
        }
        RequiredKey key = PermissionModel.generateKey(required, qName, aspectQNames, on);
        Set<PermissionReference> answer = this.requiredPermissionsCache.get(key);
        if (answer == null) {
            PermissionGroup pg = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(required));
            answer = pg == null ? this.getRequirementsForPermission(required, on) : this.getRequirementsForPermissionGroup(pg, on, qName, aspectQNames);
            answer = Collections.unmodifiableSet(answer);
            this.requiredPermissionsCache.put(key, answer);
        }
        return answer;
    }

    @Override
    public Set<PermissionReference> getUnconditionalRequiredPermissions(PermissionReference required, RequiredPermission.On on) {
        if (required == null) {
            return Collections.emptySet();
        }
        Pair key = new Pair((Object)required, (Object)on);
        Set<PermissionReference> answer = this.unconditionalRequiredPermissionsCache.get(key);
        if (answer == null) {
            PermissionGroup pg = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(required));
            answer = pg == null ? this.getRequirementsForPermission(required, on) : this.getUnconditionalRequirementsForPermissionGroup(pg, on);
            answer = Collections.unmodifiableSet(answer);
            this.unconditionalRequiredPermissionsCache.put((Pair<PermissionReference, RequiredPermission.On>)key, answer);
        }
        return answer;
    }

    private Set<PermissionReference> getRequirementsForPermission(PermissionReference required, RequiredPermission.On on) {
        HashSet<PermissionReference> requiredPermissions = new HashSet<PermissionReference>();
        Permission p = this.getPermissionOrNull(required);
        if (p != null) {
            for (RequiredPermission rp : p.getRequiredPermissions()) {
                if (rp.isImplies() || !rp.getOn().equals((Object)on)) continue;
                requiredPermissions.add(rp);
            }
        }
        return requiredPermissions;
    }

    private Set<PermissionReference> getRequirementsForPermissionGroup(PermissionGroup target, RequiredPermission.On on, QName qName, Set<QName> aspectQNames) {
        HashSet<PermissionReference> requiredPermissions = new HashSet<PermissionReference>(16, 1.0f);
        if (target == null) {
            return requiredPermissions;
        }
        for (PermissionSet ps : this.permissionSets.values()) {
            for (PermissionGroup pg : ps.getPermissionGroups()) {
                PermissionGroup base = this.getBasePermissionGroupOrNull(pg);
                if (!target.equals(base) && !target.isAllowFullControl() || base.isTypeRequired() && !this.isPartOfDynamicPermissionGroup(pg, qName, aspectQNames)) continue;
                for (PermissionReference pr : pg.getIncludedPermissionGroups()) {
                    requiredPermissions.addAll(this.getRequirementsForPermissionGroup(this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(pr)), on, qName, aspectQNames));
                }
            }
            for (Permission p : ps.getPermissions()) {
                for (PermissionReference grantedTo : p.getGrantedToGroups()) {
                    PermissionGroup base = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(grantedTo));
                    if (!target.equals(base) && !target.isAllowFullControl() || base.isTypeRequired() && !this.isPartOfDynamicPermissionGroup(grantedTo, qName, aspectQNames) || on != RequiredPermission.On.NODE) continue;
                    requiredPermissions.add(p);
                }
            }
        }
        return requiredPermissions;
    }

    private Set<PermissionReference> getUnconditionalRequirementsForPermissionGroup(PermissionGroup target, RequiredPermission.On on) {
        HashSet<PermissionReference> requiredPermissions = new HashSet<PermissionReference>(16, 1.0f);
        if (target == null) {
            return requiredPermissions;
        }
        for (PermissionSet ps : this.permissionSets.values()) {
            for (PermissionGroup pg : ps.getPermissionGroups()) {
                PermissionGroup base = this.getBasePermissionGroupOrNull(pg);
                if (!target.equals(base) && !target.isAllowFullControl() || base.isTypeRequired()) continue;
                for (PermissionReference pr : pg.getIncludedPermissionGroups()) {
                    requiredPermissions.addAll(this.getUnconditionalRequirementsForPermissionGroup(this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(pr)), on));
                }
            }
            for (Permission p : ps.getPermissions()) {
                for (PermissionReference grantedTo : p.getGrantedToGroups()) {
                    PermissionGroup base = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(grantedTo));
                    if (!target.equals(base) && !target.isAllowFullControl() || base.isTypeRequired() || on != RequiredPermission.On.NODE) continue;
                    requiredPermissions.add(p);
                }
            }
        }
        return requiredPermissions;
    }

    private boolean isPartOfDynamicPermissionGroup(PermissionReference pr, QName typeQname, Set<QName> aspects) {
        if (this.dictionaryService.isSubClass(typeQname, pr.getQName())) {
            return true;
        }
        for (QName aspect : aspects) {
            if (!this.dictionaryService.isSubClass(aspect, pr.getQName())) continue;
            return true;
        }
        return false;
    }

    private Permission getPermissionOrNull(PermissionReference perm) {
        Permission p = this.permissionMap.get(perm);
        return p == null ? null : p;
    }

    @Override
    public boolean checkPermission(PermissionReference required) {
        Permission permission = this.getPermissionOrNull(required);
        if (permission != null) {
            return true;
        }
        PermissionGroup pg = this.getPermissionGroupOrNull(required);
        if (pg != null) {
            if (pg.isExtends()) {
                QName parent;
                if (pg.getTypeQName() != null) {
                    return this.checkPermission(SimplePermissionReference.getPermissionReference(pg.getTypeQName(), pg.getName()));
                }
                ClassDefinition classDefinition = this.dictionaryService.getClass(pg.getQName());
                while ((parent = classDefinition.getParentName()) != null) {
                    classDefinition = this.dictionaryService.getClass(parent);
                    PermissionGroup attempt = this.getPermissionGroupOrNull(SimplePermissionReference.getPermissionReference(parent, pg.getName()));
                    if (attempt == null || !attempt.isAllowFullControl()) continue;
                    return true;
                }
                return false;
            }
            return pg.isAllowFullControl();
        }
        return false;
    }

    @Override
    public PermissionReference getPermissionReference(QName qname, String permissionName) {
        if (permissionName == null) {
            return null;
        }
        PermissionReference pr = this.uniqueMap.get(permissionName);
        if (pr == null && (pr = this.permissionReferenceMap.get(permissionName)) == null) {
            throw new UnsupportedOperationException("Can not find " + permissionName);
        }
        return pr;
    }

    @Override
    public boolean isUnique(PermissionReference permissionReference) {
        return this.uniqueMap.containsKey(permissionReference.getName());
    }

    private void buildUniquePermissionMap() {
        HashSet<String> excluded = new HashSet<String>(128, 1.0f);
        this.uniqueMap = new ConcurrentHashMap(256, 1.0f, 16);
        this.permissionReferenceMap = new ConcurrentHashMap(256, 1.0f, 16);
        this.permissionGroupMap = new ConcurrentHashMap(128, 1.0f, 16);
        this.permissionMap = new ConcurrentHashMap(64, 1.0f, 16);
        for (PermissionSet ps : this.permissionSets.values()) {
            for (PermissionGroup pg : ps.getPermissionGroups()) {
                this.permissionGroupMap.put(SimplePermissionReference.getPermissionReference(pg.getQName(), pg.getName()), pg);
                this.permissionReferenceMap.put(pg.toString(), SimplePermissionReference.getPermissionReference(pg.getQName(), pg.getName()));
            }
            for (Permission p : ps.getPermissions()) {
                this.permissionReferenceMap.put(p.toString(), SimplePermissionReference.getPermissionReference(p.getQName(), p.getName()));
                this.permissionMap.put(SimplePermissionReference.getPermissionReference(p.getQName(), p.getName()), p);
            }
        }
        for (PermissionSet ps : this.permissionSets.values()) {
            PermissionReference value;
            for (PermissionGroup pg : ps.getPermissionGroups()) {
                if (this.uniqueMap.containsKey(pg.getName()) && !excluded.contains(pg.getName())) {
                    value = this.uniqueMap.get(pg.getName());
                    if (value.equals(this.getBasePermissionGroup(pg))) continue;
                    this.uniqueMap.remove(pg.getName());
                    excluded.add(pg.getName());
                    continue;
                }
                PermissionGroup base = this.getBasePermissionGroup(pg);
                this.uniqueMap.put(pg.getName(), SimplePermissionReference.getPermissionReference(base.getQName(), base.getName()));
            }
            for (Permission p : ps.getPermissions()) {
                if (this.uniqueMap.containsKey(p.getName()) && !excluded.contains(p.getName())) {
                    value = this.uniqueMap.get(p.getName());
                    if (value.equals(p)) continue;
                    this.uniqueMap.remove(p.getName());
                    excluded.add(p.getName());
                    continue;
                }
                this.uniqueMap.put(p.getName(), SimplePermissionReference.getPermissionReference(p.getQName(), p.getName()));
            }
        }
        if (this.uniqueMap.containsKey("All")) {
            throw new IllegalStateException("There must not be a permission with the same name as the ALL_PERMISSION constant: All");
        }
        this.uniqueMap.put("All", SimplePermissionReference.getPermissionReference(QName.createQName((String)"http://www.alfresco.org/model/security/1.0", (String)"All"), "All"));
    }

    @Override
    public Set<PermissionReference> getAllExposedPermissions() {
        HashSet<PermissionReference> permissions = new HashSet<PermissionReference>(256, 1.0f);
        for (PermissionSet ps : this.permissionSets.values()) {
            for (PermissionGroup pg : ps.getPermissionGroups()) {
                if (!pg.isExposed()) continue;
                permissions.add(SimplePermissionReference.getPermissionReference(pg.getQName(), pg.getName()));
            }
            for (Permission p : ps.getPermissions()) {
                if (!p.isExposed()) continue;
                permissions.add(SimplePermissionReference.getPermissionReference(p.getQName(), p.getName()));
            }
        }
        return permissions;
    }

    @Override
    public boolean hasFull(PermissionReference permissionReference) {
        if (permissionReference == null) {
            return false;
        }
        if (permissionReference.equals(ALL)) {
            return true;
        }
        this.group = this.getPermissionGroupOrNull(permissionReference);
        if (this.group == null) {
            return false;
        }
        if (this.group.isAllowFullControl()) {
            return true;
        }
        if (this.group.isExtends()) {
            QName parent;
            if (this.group.getTypeQName() != null) {
                return this.hasFull(SimplePermissionReference.getPermissionReference(this.group.getTypeQName(), this.group.getName()));
            }
            ClassDefinition classDefinition = this.dictionaryService.getClass(this.group.getQName());
            while ((parent = classDefinition.getParentName()) != null) {
                classDefinition = this.dictionaryService.getClass(parent);
                PermissionGroup attempt = this.getPermissionGroupOrNull(SimplePermissionReference.getPermissionReference(parent, this.group.getName()));
                if (attempt == null || !attempt.isAllowFullControl()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RequiredKey {
        PermissionReference required;
        QName qName;
        Set<QName> aspectQNames;
        RequiredPermission.On on;
        int hashCode = 0;
        private static ReadWriteLock lock = new ReentrantReadWriteLock();
        private static ConcurrentHashMap<PermissionReference, ConcurrentHashMap<QName, ConcurrentHashMap<Set<QName>, EnumMap<RequiredPermission.On, RequiredKey>>>> instances = new ConcurrentHashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static RequiredKey getRequiredKey(PermissionReference required, QName qName, Set<QName> aspectQNames, RequiredPermission.On on) {
            RequiredKey instance;
            EnumMap<RequiredPermission.On, RequiredKey> byAspects;
            ConcurrentHashMap<Set<Object>, EnumMap<RequiredPermission.On, RequiredKey>> byType;
            ConcurrentHashMap<Object, ConcurrentHashMap<Set<Object>, EnumMap<RequiredPermission.On, RequiredKey>>> byPermRef;
            block9: {
                lock.readLock().lock();
                try {
                    byPermRef = instances.get(required);
                    if (byPermRef == null || (byType = byPermRef.get(qName)) == null || (byAspects = byType.get(aspectQNames)) == null || (instance = byAspects.get((Object)on)) == null) break block9;
                    RequiredKey requiredKey = instance;
                    Object var10_10 = null;
                    lock.readLock().unlock();
                    return requiredKey;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    lock.readLock().unlock();
                    throw throwable;
                }
            }
            Object var10_11 = null;
            lock.readLock().unlock();
            lock.writeLock().lock();
            try {
                byPermRef = instances.get(required);
                if (byPermRef == null) {
                    byPermRef = new ConcurrentHashMap();
                    instances.put(required, byPermRef);
                }
                if ((byType = byPermRef.get(qName)) == null) {
                    byType = new ConcurrentHashMap();
                    byPermRef.put(qName, byType);
                }
                if ((byAspects = byType.get(aspectQNames)) == null) {
                    byAspects = new EnumMap(RequiredPermission.On.class);
                    byType.put(aspectQNames, byAspects);
                }
                if ((instance = byAspects.get((Object)on)) == null) {
                    instance = new RequiredKey(required, qName, aspectQNames, on);
                    byAspects.put(on, instance);
                }
                RequiredKey requiredKey = instance;
                Object var12_14 = null;
                lock.writeLock().unlock();
                return requiredKey;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                lock.writeLock().unlock();
                throw throwable;
            }
        }

        RequiredKey(PermissionReference required, QName qName, Set<QName> aspectQNames, RequiredPermission.On on) {
            this.required = required;
            this.qName = qName;
            this.aspectQNames = aspectQNames;
            this.on = on;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int PRIME = 1000003;
                int result = 1;
                result = 1000003 * result + (this.aspectQNames == null ? 0 : ((Object)this.aspectQNames).hashCode());
                result = 1000003 * result + (this.on == null ? 0 : this.on.ordinal());
                result = 1000003 * result + (this.qName == null ? 0 : this.qName.hashCode());
                this.hashCode = result = 1000003 * result + (this.required == null ? 0 : this.required.hashCode());
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RequiredKey other = (RequiredKey)obj;
            if (this.required == null ? other.required != null : !this.required.equals(other.required)) {
                return false;
            }
            if (this.qName == null ? other.qName != null : !this.qName.equals((Object)other.qName)) {
                return false;
            }
            if (this.on == null ? other.on != null : !this.on.equals((Object)other.on)) {
                return false;
            }
            return !(this.aspectQNames == null ? other.aspectQNames != null : !((Object)this.aspectQNames).equals(other.aspectQNames));
        }
    }
}

