/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import org.alfresco.repo.security.person.UserNameMatcher;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserNameMatcherImpl
implements UserNameMatcher {
    private boolean userNamesAreCaseSensitive = false;
    private boolean domainNamesAreCaseSensitive = false;
    private String domainSeparator = "";

    @Override
    public boolean getUserNamesAreCaseSensitive() {
        return this.userNamesAreCaseSensitive;
    }

    public void setUserNamesAreCaseSensitive(boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
    }

    @Override
    public boolean getDomainNamesAreCaseSensitive() {
        return this.domainNamesAreCaseSensitive;
    }

    public void setDomainNamesAreCaseSensitive(boolean domainNamesAreCaseSensitive) {
        this.domainNamesAreCaseSensitive = domainNamesAreCaseSensitive;
    }

    @Override
    public String getDomainSeparator() {
        return this.domainSeparator;
    }

    public void setDomainSeparator(String domainSeparator) {
        this.domainSeparator = domainSeparator;
    }

    @Override
    public boolean matches(String realUserName, String searchUserName) {
        Pair<String, String> real = this.splitByDomain(realUserName, this.domainSeparator);
        Pair<String, String> search = this.splitByDomain(searchUserName, this.domainSeparator);
        return (this.userNamesAreCaseSensitive && ((String)real.getFirst()).equals(search.getFirst()) || !this.userNamesAreCaseSensitive && ((String)real.getFirst()).equalsIgnoreCase((String)search.getFirst())) && (this.domainNamesAreCaseSensitive && ((String)real.getSecond()).equals(search.getSecond()) || !this.domainNamesAreCaseSensitive && ((String)real.getSecond()).equalsIgnoreCase((String)search.getSecond()));
    }

    private Pair<String, String> splitByDomain(String name, String domainSeparator) {
        int idx = name.lastIndexOf(domainSeparator);
        if (idx != -1) {
            if (idx + 1 > name.length()) {
                return new Pair((Object)name.substring(0, idx), (Object)"");
            }
            return new Pair((Object)name.substring(0, idx), (Object)name.substring(idx + 1));
        }
        return new Pair((Object)name, (Object)"");
    }
}

