/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.sync;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.management.subsystems.ChildApplicationContextManager;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.sync.NodeDescription;
import org.alfresco.repo.security.sync.UserRegistry;
import org.alfresco.repo.security.sync.UserRegistrySynchronizer;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

public class ChainingUserRegistrySynchronizerTest
extends TestCase {
    private static final String[] CONFIG_LOCATIONS = new String[]{"classpath:alfresco/application-context.xml", "classpath:sync-test-context.xml"};
    private static ApplicationContext context = new ClassPathXmlApplicationContext(CONFIG_LOCATIONS);
    private UserRegistrySynchronizer synchronizer;
    private MockApplicationContextManager applicationContextManager;
    private PersonService personService;
    private AuthorityService authorityService;
    private NodeService nodeService;
    private AuthenticationContext authenticationContext;
    private RetryingTransactionHelper retryingTransactionHelper;

    protected void setUp() throws Exception {
        this.synchronizer = (UserRegistrySynchronizer)context.getBean("testUserRegistrySynchronizer");
        this.applicationContextManager = (MockApplicationContextManager)context.getBean("testApplicationContextManager");
        this.personService = (PersonService)context.getBean("personService");
        this.authorityService = (AuthorityService)context.getBean("authorityService");
        this.nodeService = (NodeService)context.getBean("nodeService");
        this.authenticationContext = (AuthenticationContext)context.getBean("authenticationContext");
        this.authenticationContext.setSystemUserAsCurrentUser();
        this.retryingTransactionHelper = (RetryingTransactionHelper)context.getBean("retryingTransactionHelper");
    }

    protected void tearDown() throws Exception {
        this.authenticationContext.clearCurrentSecurityContext();
    }

    private void setUpTestUsersAndGroups() throws Exception {
        this.applicationContextManager.setUserRegistries(new MockUserRegistry("Z0", new NodeDescription[]{this.newPerson("U6")}, new NodeDescription[]{this.newGroup("G1", new String[0])}), new MockUserRegistry("Z1", new NodeDescription[]{this.newPerson("U1"), this.newPerson("U2"), this.newPerson("U7")}, new NodeDescription[]{this.newGroup("G2", "U1", "G3"), this.newGroup("G3", "U2", "G4", "G5"), this.newGroup("G4", new String[0]), this.newGroup("G5", new String[0])}), new MockUserRegistry("Z2", new NodeDescription[]{this.newPerson("U1"), this.newPerson("U3"), this.newPerson("U4"), this.newPerson("U5")}, new NodeDescription[]{this.newGroup("G2", "U1", "U3", "U4"), this.newGroup("G6", "U3", "U4", "G7"), this.newGroup("G7", "U5")}));
        this.synchronizer.synchronize(true, true, true);
        this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z0", "U6", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z0", "G1", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U1", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U2", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G2", new String[]{"U1", "G3"});
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G3", new String[]{"U2", "G4", "G5"});
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G4", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G5", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U3", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U4", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U5", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G6", new String[]{"U3", "U4", "G7"});
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G7", new String[]{"U5"});
                return null;
            }
        }, false, true);
    }

    public void tearDownTestUsersAndGroups() throws Exception {
        this.applicationContextManager.setUserRegistries(new MockUserRegistry("Z0", new NodeDescription[0], new NodeDescription[0]), new MockUserRegistry("Z1", new NodeDescription[0], new NodeDescription[0]), new MockUserRegistry("Z2", new NodeDescription[0], new NodeDescription[0]));
        this.synchronizer.synchronize(true, true, true);
        this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U1");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U2");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U3");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U4");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U5");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U6");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U7");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G1");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G2");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G3");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G4");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G5");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G6");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G7");
                return null;
            }
        }, false, true);
    }

    public void testDifferentialUpdate() throws Exception {
        this.setUpTestUsersAndGroups();
        this.applicationContextManager.removeZone("Z0");
        this.applicationContextManager.updateZone("Z1", new NodeDescription[]{this.newPerson("U1", "changeofemail@alfresco.com"), this.newPerson("U6"), this.newPerson("U7")}, new NodeDescription[]{this.newGroup("G1", "U1", "U6", "UDangling"), this.newGroup("G2", "U1", "GDangling"), this.newGroupWithDisplayName("G5", "Amazing Group", "U6", "U7", "G4")});
        this.applicationContextManager.updateZone("Z2", new NodeDescription[]{this.newPerson("U1", "shouldbeignored@alfresco.com"), this.newPerson("U5", "u5email@alfresco.com"), this.newPerson("U6")}, new NodeDescription[]{this.newGroup("G2", "U1", "U3", "U4", "U6"), this.newGroup("G7", new String[0])});
        this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                ChainingUserRegistrySynchronizerTest.this.synchronizer.synchronize(false, false, false);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U1", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertEmailEquals("U1", "changeofemail@alfresco.com");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U2", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U6", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U7", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G1", new String[]{"U1", "U6"});
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G2", new String[]{"U1"});
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G3", new String[]{"U2", "G4", "G5"});
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G4", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G5", new String[]{"U6", "U7", "G4"});
                ChainingUserRegistrySynchronizerTest.this.assertGroupDisplayNameEquals("G5", "Amazing Group");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U3", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U4", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U5", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertEmailEquals("U5", "u5email@alfresco.com");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G6", new String[]{"U3", "U4", "G7"});
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G7", new String[0]);
                return null;
            }
        });
        this.tearDownTestUsersAndGroups();
    }

    public void testForcedUpdate() throws Exception {
        this.setUpTestUsersAndGroups();
        this.applicationContextManager.setUserRegistries(new MockUserRegistry("Z1", new NodeDescription[]{this.newPerson("U2"), this.newPerson("u3"), this.newPerson("U6")}, new NodeDescription[]{this.newGroup("G1", "U6"), this.newGroup("G2", new String[0]), this.newGroup("G3", "U2", "G5"), this.newGroup("G5", "U6"), this.newGroup("G6", "u3")}), new MockUserRegistry("Z2", new NodeDescription[]{this.newPerson("U1", "somenewemail@alfresco.com"), this.newPerson("U3"), this.newPerson("U6")}, new NodeDescription[]{this.newGroup("G2", "U1", "U3", "U4", "U6"), this.newGroup("G6", "U3", "U4", "G7"), this.newGroupWithDisplayName("G7", "Late Arrival", "U4", "U5")}));
        this.synchronizer.synchronize(true, true, true);
        this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U2", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "u3", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "U6", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G1", new String[]{"U6"});
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G2", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G3", new String[]{"U2", "G5"});
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("G4");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G5", new String[]{"U6"});
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G6", new String[]{"u3"});
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U1", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertEmailEquals("U1", "somenewemail@alfresco.com");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U4");
                ChainingUserRegistrySynchronizerTest.this.assertNotExists("U5");
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G7", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertGroupDisplayNameEquals("G7", "Late Arrival");
                return null;
            }
        }, false, true);
        this.tearDownTestUsersAndGroups();
    }

    public void testCaseChange() throws Exception {
        this.setUpTestUsersAndGroups();
        final TreeMap personNodes = new TreeMap();
        this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                personNodes.put("u1", ChainingUserRegistrySynchronizerTest.this.personService.getPerson("U1", false));
                personNodes.put("u2", ChainingUserRegistrySynchronizerTest.this.personService.getPerson("U2", false));
                personNodes.put("u6", ChainingUserRegistrySynchronizerTest.this.personService.getPerson("U6", false));
                return null;
            }
        }, false, true);
        this.applicationContextManager.setUserRegistries(new MockUserRegistry("Z1", new NodeDescription[]{this.newPerson("u1"), this.newPerson("u2"), this.newPerson("u6"), this.newPerson("U7")}, new NodeDescription[]{this.newGroup("g1", "u6"), this.newGroup("g2", "u1", "G3"), this.newGroup("G3", "u2", "g4", "g5"), this.newGroup("g4", new String[0]), this.newGroup("g5", new String[0])}), new MockUserRegistry("Z2", new NodeDescription[]{this.newPerson("U1"), this.newPerson("U3"), this.newPerson("U4"), this.newPerson("U5")}, new NodeDescription[]{this.newGroup("G2", "U1", "U3", "U4"), this.newGroup("G6", "U3", "U4", "G7"), this.newGroup("G7", "U5")}));
        this.synchronizer.synchronize(true, true, true);
        this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "u1", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "u2", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "u6", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "g1", new String[]{"u6"});
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "g2", new String[]{"u1", "G3"});
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "G3", new String[]{"u2", "g4", "g5"});
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "g4", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z1", "g5", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U3", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U4", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "U5", new String[0]);
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G2", new String[]{"U3", "U4"});
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G6", new String[]{"U3", "U4", "G7"});
                ChainingUserRegistrySynchronizerTest.this.assertExists("Z2", "G7", new String[]{"U5"});
                Assert.assertEquals(personNodes.get("u1"), (Object)ChainingUserRegistrySynchronizerTest.this.personService.getPerson("U1", false));
                Assert.assertEquals(personNodes.get("u2"), (Object)ChainingUserRegistrySynchronizerTest.this.personService.getPerson("U2", false));
                Assert.assertEquals(personNodes.get("u6"), (Object)ChainingUserRegistrySynchronizerTest.this.personService.getPerson("U6", false));
                return null;
            }
        }, false, true);
        this.tearDownTestUsersAndGroups();
    }

    public void testVolume() throws Exception {
        ArrayList<NodeDescription> persons = new ArrayList<NodeDescription>(new RandomPersonCollection(100));
        ArrayList<NodeDescription> groups = new ArrayList<NodeDescription>(new RandomGroupCollection(50, persons));
        this.applicationContextManager.setUserRegistries(new MockUserRegistry("Z0", persons, groups));
        this.synchronizer.synchronize(true, true, true);
        this.tearDownTestUsersAndGroups();
    }

    public void dontTestAssocs() throws Exception {
        List<NodeDescription> groups = this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<NodeDescription>>(){

            @Override
            public List<NodeDescription> execute() throws Throwable {
                return new ArrayList<NodeDescription>(new RandomGroupCollection(1000, ChainingUserRegistrySynchronizerTest.this.authorityService.getAllAuthoritiesInZone("AUTH.EXT.Z0", null)));
            }
        }, true, true);
        this.applicationContextManager.setUserRegistries(new MockUserRegistry("Z0", Collections.<NodeDescription>emptyList(), groups));
        this.synchronizer.synchronize(true, true, true);
        this.tearDownTestUsersAndGroups();
    }

    private NodeDescription newGroup(String name, String ... members) {
        return this.newGroupWithDisplayName(name, name, members);
    }

    private NodeDescription newGroupWithDisplayName(String name, String displayName, String ... members) {
        String longName = this.longName(name);
        NodeDescription group = new NodeDescription(longName);
        PropertyMap properties = group.getProperties();
        properties.put(ContentModel.PROP_AUTHORITY_NAME, longName);
        properties.put(ContentModel.PROP_AUTHORITY_DISPLAY_NAME, displayName);
        if (members.length > 0) {
            Set<String> assocs = group.getChildAssociations();
            for (String member : members) {
                assocs.add(this.longName(member));
            }
        }
        group.setLastModified(new Date());
        return group;
    }

    private NodeDescription newPerson(String userName) {
        return this.newPerson(userName, userName + "@alfresco.com");
    }

    private NodeDescription newPerson(String userName, String email) {
        NodeDescription person = new NodeDescription(userName);
        PropertyMap properties = person.getProperties();
        properties.put(ContentModel.PROP_USERNAME, userName);
        properties.put(ContentModel.PROP_FIRSTNAME, userName + "F");
        properties.put(ContentModel.PROP_LASTNAME, userName + "L");
        properties.put(ContentModel.PROP_EMAIL, email);
        person.setLastModified(new Date());
        return person;
    }

    private void assertExists(String zone, String name, String ... members) {
        String longName = this.longName(name);
        ChainingUserRegistrySynchronizerTest.assertTrue((boolean)this.authorityService.authorityExists(longName));
        ChainingUserRegistrySynchronizerTest.assertTrue((boolean)this.authorityService.getAuthorityZones(longName).contains("AUTH.EXT." + zone));
        if (AuthorityType.getAuthorityType((String)longName).equals((Object)AuthorityType.GROUP)) {
            HashSet<String> memberSet = new HashSet<String>(members.length * 2);
            for (String member : members) {
                memberSet.add(this.longName(member));
            }
            ChainingUserRegistrySynchronizerTest.assertEquals(memberSet, this.authorityService.getContainedAuthorities(null, longName, true));
        } else {
            ChainingUserRegistrySynchronizerTest.assertTrue((boolean)this.personService.personExists(name));
            ChainingUserRegistrySynchronizerTest.assertEquals((String)this.personService.getUserIdentifier(name), (String)name);
        }
    }

    private void assertNotExists(String name) {
        String longName = this.longName(name);
        ChainingUserRegistrySynchronizerTest.assertFalse((boolean)this.authorityService.authorityExists(longName));
        ChainingUserRegistrySynchronizerTest.assertNull(this.authorityService.getAuthorityZones(longName));
        if (!AuthorityType.getAuthorityType((String)longName).equals((Object)AuthorityType.GROUP)) {
            ChainingUserRegistrySynchronizerTest.assertFalse((boolean)this.personService.personExists(name));
        }
    }

    private void assertEmailEquals(String personName, String email) {
        NodeRef personRef = this.personService.getPerson(personName);
        ChainingUserRegistrySynchronizerTest.assertEquals((Object)email, (Object)this.nodeService.getProperty(personRef, ContentModel.PROP_EMAIL));
    }

    private void assertGroupDisplayNameEquals(String name, String displayName) {
        ChainingUserRegistrySynchronizerTest.assertEquals((String)displayName, (String)this.authorityService.getAuthorityDisplayName(this.longName(name)));
    }

    private String longName(String shortName) {
        return this.authorityService.getName(shortName.toLowerCase().startsWith("g") ? AuthorityType.GROUP : AuthorityType.USER, shortName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RandomGroupCollection
    extends AbstractCollection<NodeDescription> {
        private Random generator = new Random(1628876500L);
        private final int size;
        private final List<String> authorities;

        public RandomGroupCollection(int size, Set<String> authorities) {
            this.size = size;
            this.authorities = new ArrayList<String>(authorities);
        }

        public RandomGroupCollection(int size, Collection<NodeDescription> persons) {
            this.size = size;
            this.authorities = new ArrayList<String>(persons.size());
            for (NodeDescription nodeDescription : persons) {
                this.authorities.add((String)nodeDescription.getProperties().get(ContentModel.PROP_USERNAME));
            }
        }

        @Override
        public Iterator<NodeDescription> iterator() {
            return new Iterator<NodeDescription>(){
                private int pos;

                @Override
                public boolean hasNext() {
                    return this.pos < RandomGroupCollection.this.size;
                }

                @Override
                public NodeDescription next() {
                    ++this.pos;
                    String[] authorityNames = new String[17];
                    for (int i = 0; i < authorityNames.length; ++i) {
                        int index = RandomGroupCollection.this.generator.nextInt(RandomGroupCollection.this.authorities.size());
                        authorityNames[i] = ChainingUserRegistrySynchronizerTest.this.authorityService.getShortName((String)RandomGroupCollection.this.authorities.get(index));
                    }
                    NodeDescription group = ChainingUserRegistrySynchronizerTest.this.newGroup("G" + GUID.generate(), authorityNames);
                    RandomGroupCollection.this.authorities.add((String)group.getProperties().get(ContentModel.PROP_AUTHORITY_NAME));
                    return group;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RandomPersonCollection
    extends AbstractCollection<NodeDescription> {
        private final int size;

        public RandomPersonCollection(int size) {
            this.size = size;
        }

        @Override
        public Iterator<NodeDescription> iterator() {
            return new Iterator<NodeDescription>(){
                private int pos;

                @Override
                public boolean hasNext() {
                    return this.pos < RandomPersonCollection.this.size;
                }

                @Override
                public NodeDescription next() {
                    ++this.pos;
                    return ChainingUserRegistrySynchronizerTest.this.newPerson("U" + GUID.generate());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockApplicationContextManager
    implements ChildApplicationContextManager {
        private Map<String, ApplicationContext> contexts = Collections.emptyMap();

        public void setUserRegistries(MockUserRegistry ... registries) {
            this.contexts = new LinkedHashMap<String, ApplicationContext>(registries.length * 2);
            for (MockUserRegistry registry : registries) {
                StaticApplicationContext context = new StaticApplicationContext();
                context.getDefaultListableBeanFactory().registerSingleton("userRegistry", (Object)registry);
                this.contexts.put(registry.getZoneId(), (ApplicationContext)context);
            }
        }

        public void removeZone(String zoneId) {
            this.contexts.remove(zoneId);
        }

        public void updateZone(String zoneId, NodeDescription[] persons, NodeDescription[] groups) {
            ApplicationContext context = this.contexts.get(zoneId);
            MockUserRegistry registry = (MockUserRegistry)context.getBean("userRegistry");
            registry.updateState(Arrays.asList(persons), Arrays.asList(groups));
        }

        @Override
        public ApplicationContext getApplicationContext(String id) {
            return this.contexts.get(id);
        }

        @Override
        public Collection<String> getInstanceIds() {
            return this.contexts.keySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockUserRegistry
    implements UserRegistry {
        private String zoneId;
        private Collection<NodeDescription> persons;
        private Collection<NodeDescription> groups;

        public MockUserRegistry(String zoneId, Collection<NodeDescription> persons, Collection<NodeDescription> groups) {
            this.zoneId = zoneId;
            this.persons = persons;
            this.groups = groups;
        }

        public void updateState(Collection<NodeDescription> persons, Collection<NodeDescription> groups) {
            ArrayList<NodeDescription> newPersons = new ArrayList<NodeDescription>(this.persons);
            this.mergeNodeDescriptions(newPersons, persons, ContentModel.PROP_USERNAME, false);
            this.persons = newPersons;
            ArrayList<NodeDescription> newGroups = new ArrayList<NodeDescription>(this.groups);
            this.mergeNodeDescriptions(newGroups, groups, ContentModel.PROP_AUTHORITY_NAME, true);
            this.groups = newGroups;
        }

        private void mergeNodeDescriptions(List<NodeDescription> oldNodes, Collection<NodeDescription> newNodes, QName idProp, boolean caseSensitive) {
            String id;
            LinkedHashMap<String, NodeDescription> nodeMap = new LinkedHashMap<String, NodeDescription>(newNodes.size() * 2);
            for (NodeDescription node : newNodes) {
                id = (String)node.getProperties().get(idProp);
                if (!caseSensitive) {
                    id = id.toLowerCase();
                }
                nodeMap.put(id, node);
            }
            for (int i = 0; i < oldNodes.size(); ++i) {
                NodeDescription newNode;
                NodeDescription oldNode = oldNodes.get(i);
                id = (String)oldNode.getProperties().get(idProp);
                if (!caseSensitive) {
                    id = id.toLowerCase();
                }
                if ((newNode = (NodeDescription)nodeMap.remove(id)) == null) {
                    oldNodes.remove(i);
                    --i;
                    continue;
                }
                if (oldNode.getProperties().equals(newNode.getProperties()) && ((Object)oldNode.getChildAssociations()).equals(newNode.getChildAssociations())) continue;
                oldNodes.set(i, newNode);
            }
            oldNodes.addAll(nodeMap.values());
        }

        public MockUserRegistry(String zoneId, NodeDescription[] persons, NodeDescription[] groups) {
            this(zoneId, Arrays.asList(persons), Arrays.asList(groups));
        }

        public String getZoneId() {
            return this.zoneId;
        }

        @Override
        public Collection<String> getGroupNames() {
            LinkedList<String> groupNames = new LinkedList<String>();
            for (NodeDescription group : this.groups) {
                groupNames.add((String)group.getProperties().get(ContentModel.PROP_AUTHORITY_NAME));
            }
            return groupNames;
        }

        @Override
        public Collection<String> getPersonNames() {
            LinkedList<String> personNames = new LinkedList<String>();
            for (NodeDescription person : this.persons) {
                personNames.add((String)person.getProperties().get(ContentModel.PROP_USERNAME));
            }
            return personNames;
        }

        @Override
        public Collection<NodeDescription> getGroups(Date modifiedSince) {
            return this.filterNodeDescriptions(this.groups, modifiedSince);
        }

        private Collection<NodeDescription> filterNodeDescriptions(Collection<NodeDescription> nodes, Date modifiedSince) {
            if (modifiedSince == null) {
                return nodes;
            }
            LinkedList<NodeDescription> filteredNodes = new LinkedList<NodeDescription>();
            for (NodeDescription node : nodes) {
                Date modified = node.getLastModified();
                if (modifiedSince.compareTo(modified) >= 0) continue;
                filteredNodes.add(node);
            }
            return filteredNodes;
        }

        @Override
        public Collection<NodeDescription> getPersons(Date modifiedSince) {
            return this.filterNodeDescriptions(this.persons, modifiedSince);
        }

        @Override
        public Set<QName> getPersonMappedProperties() {
            return new HashSet<QName>(Arrays.asList(ContentModel.PROP_USERNAME, ContentModel.PROP_FIRSTNAME, ContentModel.PROP_LASTNAME, ContentModel.PROP_EMAIL, ContentModel.PROP_ORGID, ContentModel.PROP_ORGANIZATION, ContentModel.PROP_HOME_FOLDER_PROVIDER));
        }
    }
}

