/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.transfer.AbstractManifestProcessorBase;
import org.alfresco.repo.transfer.CorrespondingNodeResolver;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNodeHelper;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.namespace.RegexQNamePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoSecondaryManifestProcessorImpl
extends AbstractManifestProcessorBase {
    private NodeService nodeService;
    private CorrespondingNodeResolver nodeResolver;

    public RepoSecondaryManifestProcessorImpl(TransferReceiver receiver, String transferId) {
        super(receiver, transferId);
    }

    @Override
    protected void endManifest() {
    }

    @Override
    protected void processNode(TransferManifestDeletedNode node) {
    }

    @Override
    protected void processNode(TransferManifestNormalNode node) {
        NodeRef correspondingNodeRef = this.nodeResolver.resolveCorrespondingNode((NodeRef)node.getNodeRef(), (ChildAssociationRef)TransferManifestNodeHelper.getPrimaryParentAssoc((TransferManifestNormalNode)node), (Path)node.getParentPath()).resolvedChild;
        if (correspondingNodeRef == null) {
            correspondingNodeRef = node.getNodeRef();
        }
        List<ChildAssociationRef> requiredAssocs = node.getParentAssocs();
        List currentAssocs = this.nodeService.getParentAssocs(correspondingNodeRef);
        this.processParentChildAssociations(requiredAssocs, currentAssocs, correspondingNodeRef, false);
        requiredAssocs = node.getChildAssocs();
        currentAssocs = this.nodeService.getChildAssocs(correspondingNodeRef);
        this.processParentChildAssociations(requiredAssocs, currentAssocs, correspondingNodeRef, true);
        List<AssociationRef> requiredPeerAssocs = node.getTargetAssocs();
        List currentPeerAssocs = this.nodeService.getTargetAssocs(correspondingNodeRef, RegexQNamePattern.MATCH_ALL);
        this.processPeerAssociations(requiredPeerAssocs, currentPeerAssocs, correspondingNodeRef, true);
        requiredPeerAssocs = node.getSourceAssocs();
        currentPeerAssocs = this.nodeService.getSourceAssocs(correspondingNodeRef, RegexQNamePattern.MATCH_ALL);
        this.processPeerAssociations(requiredPeerAssocs, currentPeerAssocs, correspondingNodeRef, false);
    }

    private void processPeerAssociations(List<AssociationRef> requiredAssocs, List<AssociationRef> currentAssocs, NodeRef nodeRef, boolean isSource) {
        NodeRef otherNode;
        if (requiredAssocs == null) {
            requiredAssocs = new ArrayList<AssociationRef>();
        }
        if (currentAssocs == null) {
            currentAssocs = new ArrayList<AssociationRef>();
        }
        ArrayList<AssociationRef> assocsToAdd = new ArrayList<AssociationRef>();
        ArrayList<Object> assocsToRemove = new ArrayList<Object>();
        HashMap<NodeRef, AssociationRef> currentAssocMap = new HashMap<NodeRef, AssociationRef>();
        for (AssociationRef associationRef : currentAssocs) {
            otherNode = isSource ? associationRef.getTargetRef() : associationRef.getSourceRef();
            currentAssocMap.put(otherNode, associationRef);
        }
        for (AssociationRef associationRef : requiredAssocs) {
            otherNode = isSource ? associationRef.getTargetRef() : associationRef.getSourceRef();
            AssociationRef existingAssociation = (AssociationRef)currentAssocMap.remove(otherNode);
            if (existingAssociation != null) {
                if (existingAssociation.getTypeQName().equals((Object)associationRef.getTypeQName())) continue;
                assocsToRemove.add(existingAssociation);
                assocsToAdd.add(associationRef);
                continue;
            }
            if (!this.nodeService.exists(otherNode)) continue;
            assocsToAdd.add(associationRef);
        }
        assocsToRemove.addAll(currentAssocMap.values());
        for (AssociationRef associationRef : assocsToRemove) {
            this.nodeService.removeAssociation(associationRef.getSourceRef(), associationRef.getTargetRef(), associationRef.getTypeQName());
        }
        for (AssociationRef associationRef : assocsToAdd) {
            NodeRef source = isSource ? nodeRef : associationRef.getSourceRef();
            NodeRef target = isSource ? associationRef.getTargetRef() : nodeRef;
            this.nodeService.createAssociation(source, target, associationRef.getTypeQName());
        }
    }

    private void processParentChildAssociations(List<ChildAssociationRef> requiredAssocs, List<ChildAssociationRef> currentAssocs, NodeRef nodeRef, boolean isParent) {
        if (requiredAssocs == null) {
            requiredAssocs = new ArrayList<ChildAssociationRef>();
        }
        if (currentAssocs == null) {
            currentAssocs = new ArrayList<ChildAssociationRef>();
        }
        ArrayList<ChildAssociationRef> assocsToAdd = new ArrayList<ChildAssociationRef>();
        ArrayList<Object> assocsToRemove = new ArrayList<Object>();
        HashMap<NodeRef, ChildAssociationRef> currentAssocMap = new HashMap<NodeRef, ChildAssociationRef>();
        for (ChildAssociationRef childAssociationRef : currentAssocs) {
            if (childAssociationRef.isPrimary()) continue;
            NodeRef key = isParent ? childAssociationRef.getChildRef() : childAssociationRef.getParentRef();
            currentAssocMap.put(key, childAssociationRef);
        }
        for (ChildAssociationRef childAssociationRef : requiredAssocs) {
            if (childAssociationRef.isPrimary()) continue;
            NodeRef otherNode = isParent ? childAssociationRef.getChildRef() : childAssociationRef.getParentRef();
            ChildAssociationRef existingAssociation = (ChildAssociationRef)currentAssocMap.remove(otherNode);
            if (existingAssociation != null) {
                if (existingAssociation.getQName().equals((Object)childAssociationRef.getQName()) && existingAssociation.getTypeQName().equals((Object)childAssociationRef.getTypeQName())) continue;
                assocsToRemove.add(existingAssociation);
                assocsToAdd.add(childAssociationRef);
                continue;
            }
            if (!this.nodeService.exists(otherNode)) continue;
            assocsToAdd.add(childAssociationRef);
        }
        assocsToRemove.addAll(currentAssocMap.values());
        for (ChildAssociationRef childAssociationRef : assocsToRemove) {
            this.nodeService.removeChildAssociation(childAssociationRef);
        }
        for (ChildAssociationRef childAssociationRef : assocsToAdd) {
            NodeRef parent = isParent ? nodeRef : childAssociationRef.getParentRef();
            NodeRef child = isParent ? childAssociationRef.getChildRef() : nodeRef;
            this.nodeService.addChild(parent, child, childAssociationRef.getTypeQName(), childAssociationRef.getQName());
        }
    }

    @Override
    protected void processHeader(TransferManifestHeader header) {
    }

    @Override
    protected void startManifest() {
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNodeResolver(CorrespondingNodeResolver nodeResolver) {
        this.nodeResolver = nodeResolver;
    }
}

