/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.AlienProcessor;
import org.alfresco.repo.transfer.ChangeCapturingProgressMonitor;
import org.alfresco.repo.transfer.ManifestProcessorFactory;
import org.alfresco.repo.transfer.TransferCommitTransactionListener;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.TransferProgressMonitor;
import org.alfresco.repo.transfer.manifest.TransferManifestProcessor;
import org.alfresco.repo.transfer.manifest.XMLTransferManifestReader;
import org.alfresco.repo.transfer.requisite.XMLTransferRequsiteWriter;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.cmr.transfer.TransferServicePolicies;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.FileCopyUtils;
import org.xml.sax.helpers.DefaultHandler;

public class RepoTransferReceiverImpl
implements TransferReceiver,
NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnRestoreNodePolicy,
NodeServicePolicies.OnMoveNodePolicy {
    private static final Log log = LogFactory.getLog(RepoTransferReceiverImpl.class);
    private static final String MSG_FAILED_TO_CREATE_STAGING_FOLDER = "transfer_service.receiver.failed_to_create_staging_folder";
    private static final String MSG_TRANSFER_LOCK_FOLDER_NOT_FOUND = "transfer_service.receiver.lock_folder_not_found";
    private static final String MSG_TRANSFER_TEMP_FOLDER_NOT_FOUND = "transfer_service.receiver.temp_folder_not_found";
    private static final String MSG_TRANSFER_LOCK_UNAVAILABLE = "transfer_service.receiver.lock_unavailable";
    private static final String MSG_INBOUND_TRANSFER_FOLDER_NOT_FOUND = "transfer_service.receiver.record_folder_not_found";
    private static final String MSG_NOT_LOCK_OWNER = "transfer_service.receiver.not_lock_owner";
    private static final String MSG_ERROR_WHILE_ENDING_TRANSFER = "transfer_service.receiver.error_ending_transfer";
    private static final String MSG_ERROR_WHILE_STAGING_SNAPSHOT = "transfer_service.receiver.error_staging_snapshot";
    private static final String MSG_ERROR_WHILE_STAGING_CONTENT = "transfer_service.receiver.error_staging_content";
    private static final String MSG_NO_SNAPSHOT_RECEIVED = "transfer_service.receiver.no_snapshot_received";
    private static final String MSG_ERROR_WHILE_COMMITTING_TRANSFER = "transfer_service.receiver.error_committing_transfer";
    private static final String MSG_ERROR_WHILE_GENERATING_REQUISITE = "transfer_service.receiver.error_generating_requsite";
    private static final String LOCK_FILE_NAME = ".lock";
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)".lock");
    private static final String SNAPSHOT_FILE_NAME = "snapshot.xml";
    private NodeService nodeService;
    private SearchService searchService;
    private TransactionService transactionService;
    private String transferLockFolderPath;
    private String inboundTransferRecordsPath;
    private String rootStagingDirectory;
    private String transferTempFolderPath;
    private ManifestProcessorFactory manifestProcessorFactory;
    private BehaviourFilter behaviourFilter;
    private ChangeCapturingProgressMonitor progressMonitor;
    private ActionService actionService;
    private TenantService tenantService;
    private RuleService ruleService;
    private PolicyComponent policyComponent;
    private DescriptorService descriptorService;
    private AlienProcessor alienProcessor;
    private Map<String, NodeRef> transferLockFolderMap = new ConcurrentHashMap<String, NodeRef>();
    private Map<String, NodeRef> transferTempFolderMap = new ConcurrentHashMap<String, NodeRef>();
    private Map<String, NodeRef> inboundTransferRecordsFolderMap = new ConcurrentHashMap<String, NodeRef>();
    private ClassPolicyDelegate<TransferServicePolicies.BeforeStartInboundTransferPolicy> beforeStartInboundTransferDelegate;
    private ClassPolicyDelegate<TransferServicePolicies.OnStartInboundTransferPolicy> onStartInboundTransferDelegate;
    private ClassPolicyDelegate<TransferServicePolicies.OnEndInboundTransferPolicy> onEndInboundTransferDelegate;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"searchService", (Object)this.searchService);
        PropertyCheck.mandatory((Object)this, (String)"ruleService", (Object)this.ruleService);
        PropertyCheck.mandatory((Object)this, (String)"actionService", (Object)this.actionService);
        PropertyCheck.mandatory((Object)this, (String)"behaviourFilter", (Object)this.behaviourFilter);
        PropertyCheck.mandatory((Object)this, (String)"tennantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"transferLockFolderPath", (Object)this.transferLockFolderPath);
        PropertyCheck.mandatory((Object)this, (String)"inboundTransferRecordsPath", (Object)this.inboundTransferRecordsPath);
        PropertyCheck.mandatory((Object)this, (String)"rootStagingDirectory", (Object)this.rootStagingDirectory);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"descriptorService", (Object)this.descriptorService);
        PropertyCheck.mandatory((Object)this, (String)"alienProcessor", (Object)this.alienProcessor);
        this.beforeStartInboundTransferDelegate = this.policyComponent.registerClassPolicy(TransferServicePolicies.BeforeStartInboundTransferPolicy.class);
        this.onStartInboundTransferDelegate = this.policyComponent.registerClassPolicy(TransferServicePolicies.OnStartInboundTransferPolicy.class);
        this.onEndInboundTransferDelegate = this.policyComponent.registerClassPolicy(TransferServicePolicies.OnEndInboundTransferPolicy.class);
        this.getPolicyComponent().bindAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, TransferModel.ASPECT_TRANSFERRED, (Behaviour)new JavaBehaviour(this, "onCreateChildAssociation", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.getPolicyComponent().bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, TransferModel.ASPECT_TRANSFERRED, (Behaviour)new JavaBehaviour(this, "onCopyTransferred", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.getPolicyComponent().bindAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, TransferModel.ASPECT_ALIEN, (Behaviour)new JavaBehaviour(this, "onCreateChildAssociation", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.getPolicyComponent().bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, TransferModel.ASPECT_ALIEN, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.getPolicyComponent().bindClassBehaviour(NodeServicePolicies.OnRestoreNodePolicy.QNAME, TransferModel.ASPECT_ALIEN, (Behaviour)new JavaBehaviour(this, "onRestoreNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.getPolicyComponent().bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, TransferModel.ASPECT_ALIEN, (Behaviour)new JavaBehaviour(this, "onMoveNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.getPolicyComponent().bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, TransferModel.ASPECT_ALIEN, (Behaviour)new JavaBehaviour(this, "onCopyAlien", Behaviour.NotificationFrequency.EVERY_EVENT));
    }

    public File getStagingFolder(String transferId) {
        if (transferId == null) {
            throw new IllegalArgumentException("transferId = " + transferId);
        }
        NodeRef transferNodeRef = new NodeRef(transferId);
        String tempFolderPath = this.rootStagingDirectory + "/" + transferNodeRef.getId();
        File tempFolder = new File(tempFolderPath);
        if (!tempFolder.exists() && !tempFolder.mkdirs()) {
            tempFolder = null;
            throw new TransferException(MSG_FAILED_TO_CREATE_STAGING_FOLDER, new Object[]{transferId});
        }
        return tempFolder;
    }

    private NodeRef getLockFolder() {
        String tenantDomain = this.tenantService.getUserDomain(AuthenticationUtil.getRunAsUser());
        NodeRef transferLockFolder = this.transferLockFolderMap.get(tenantDomain);
        if (transferLockFolder == null) {
            ResultSet rs = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", this.transferLockFolderPath);
            if (rs.length() > 0) {
                transferLockFolder = rs.getNodeRef(0);
                this.transferLockFolderMap.put(tenantDomain, transferLockFolder);
            } else {
                throw new TransferException(MSG_TRANSFER_LOCK_FOLDER_NOT_FOUND, new Object[]{this.transferLockFolderPath});
            }
        }
        return transferLockFolder;
    }

    public NodeRef getTempFolder(String transferId) {
        String tenantDomain = this.tenantService.getUserDomain(AuthenticationUtil.getRunAsUser());
        NodeRef transferTempFolder = this.transferTempFolderMap.get(tenantDomain);
        if (transferTempFolder == null) {
            ResultSet rs = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", this.transferTempFolderPath);
            if (rs.length() > 0) {
                transferTempFolder = rs.getNodeRef(0);
                this.transferTempFolderMap.put(tenantDomain, transferTempFolder);
            } else {
                throw new TransferException(MSG_TRANSFER_TEMP_FOLDER_NOT_FOUND, new Object[]{transferId, this.transferTempFolderPath});
            }
        }
        NodeRef transferNodeRef = new NodeRef(transferId);
        String tempTransferFolderName = transferNodeRef.getId();
        NodeRef tempFolderNode = null;
        QName folderName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)tempTransferFolderName);
        List tempChildren = this.nodeService.getChildAssocs(transferTempFolder, RegexQNamePattern.MATCH_ALL, (QNamePattern)folderName);
        if (tempChildren.isEmpty()) {
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(ContentModel.PROP_NAME, tempTransferFolderName);
            tempFolderNode = this.nodeService.createNode(transferTempFolder, ContentModel.ASSOC_CONTAINS, folderName, TransferModel.TYPE_TEMP_TRANSFER_STORE, props).getChildRef();
        } else {
            tempFolderNode = ((ChildAssociationRef)tempChildren.get(0)).getChildRef();
        }
        return tempFolderNode;
    }

    public String start() {
        final NodeRef lockFolder = this.getLockFolder();
        String transferId = null;
        RetryingTransactionHelper txHelper = this.transactionService.getRetryingTransactionHelper();
        try {
            transferId = txHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                @Override
                public String execute() throws Throwable {
                    TransferServicePolicies.BeforeStartInboundTransferPolicy beforeStartPolicy = (TransferServicePolicies.BeforeStartInboundTransferPolicy)RepoTransferReceiverImpl.this.beforeStartInboundTransferDelegate.get(TransferModel.TYPE_TRANSFER_RECORD);
                    beforeStartPolicy.beforeStartInboundTransfer();
                    NodeRef relatedTransferRecord = RepoTransferReceiverImpl.this.createTransferRecord();
                    String transferId = relatedTransferRecord.toString();
                    RepoTransferReceiverImpl.this.getTempFolder(transferId);
                    HashMap<QName, String> props = new HashMap<QName, String>();
                    props.put(ContentModel.PROP_NAME, RepoTransferReceiverImpl.LOCK_FILE_NAME);
                    props.put(TransferModel.PROP_TRANSFER_ID, transferId);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Creating transfer lock associated with this transfer record: " + relatedTransferRecord));
                    }
                    ChildAssociationRef assoc = RepoTransferReceiverImpl.this.nodeService.createNode(lockFolder, ContentModel.ASSOC_CONTAINS, LOCK_QNAME, TransferModel.TYPE_TRANSFER_LOCK, props);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Transfer lock created as node " + assoc.getChildRef()));
                    }
                    TransferServicePolicies.OnStartInboundTransferPolicy onStartPolicy = (TransferServicePolicies.OnStartInboundTransferPolicy)RepoTransferReceiverImpl.this.onStartInboundTransferDelegate.get(TransferModel.TYPE_TRANSFER_RECORD);
                    onStartPolicy.onStartInboundTransfer(transferId);
                    return transferId;
                }
            }, false, true);
        }
        catch (DuplicateChildNodeNameException ex) {
            log.debug((Object)"lock is already taken");
            throw new TransferException(MSG_TRANSFER_LOCK_UNAVAILABLE);
        }
        this.getStagingFolder(transferId);
        return transferId;
    }

    private NodeRef createTransferRecord() {
        String tenantDomain = this.tenantService.getUserDomain(AuthenticationUtil.getRunAsUser());
        NodeRef inboundTransferRecordsFolder = this.inboundTransferRecordsFolderMap.get(tenantDomain);
        if (inboundTransferRecordsFolder == null) {
            log.debug((Object)("Trying to find transfer records folder: " + this.inboundTransferRecordsPath));
            ResultSet rs = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", this.inboundTransferRecordsPath);
            if (rs.length() > 0) {
                inboundTransferRecordsFolder = rs.getNodeRef(0);
                this.inboundTransferRecordsFolderMap.put(tenantDomain, inboundTransferRecordsFolder);
                log.debug((Object)("Found inbound transfer records folder: " + inboundTransferRecordsFolder));
            } else {
                throw new TransferException(MSG_INBOUND_TRANSFER_FOLDER_NOT_FOUND, new Object[]{this.inboundTransferRecordsPath});
            }
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSSZ");
        String timeNow = format.format(new Date());
        QName recordName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)timeNow);
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(ContentModel.PROP_NAME, timeNow);
        props.put(TransferModel.PROP_PROGRESS_POSITION, 0);
        props.put(TransferModel.PROP_PROGRESS_ENDPOINT, 1);
        props.put(TransferModel.PROP_TRANSFER_STATUS, TransferProgress.Status.PRE_COMMIT.toString());
        log.debug((Object)("Creating transfer record with name: " + timeNow));
        ChildAssociationRef assoc = this.nodeService.createNode(inboundTransferRecordsFolder, ContentModel.ASSOC_CONTAINS, recordName, TransferModel.TYPE_TRANSFER_RECORD, props);
        log.debug((Object)("<-createTransferRecord: " + assoc.getChildRef()));
        return assoc.getChildRef();
    }

    public void end(final String transferId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request to end transfer " + transferId));
        }
        if (transferId == null) {
            throw new IllegalArgumentException("transferId = null");
        }
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                @Override
                public NodeRef execute() throws Throwable {
                    NodeRef lockId = RepoTransferReceiverImpl.this.getLockNode();
                    if (lockId != null) {
                        if (!RepoTransferReceiverImpl.this.testLockedTransfer(lockId, transferId)) {
                            throw new TransferException(RepoTransferReceiverImpl.MSG_NOT_LOCK_OWNER, new Object[]{transferId});
                        }
                        log.debug((Object)("Deleting lock node :" + lockId));
                        RepoTransferReceiverImpl.this.nodeService.deleteNode(lockId);
                        log.debug((Object)("Lock deleted :" + lockId));
                    }
                    return null;
                }
            }, false, true);
            NodeRef tempStoreNode = null;
            try {
                log.debug((Object)"Deleting temporary store node...");
                tempStoreNode = this.getTempFolder(transferId);
                this.nodeService.deleteNode(tempStoreNode);
                log.debug((Object)"Deleted temporary store node.");
            }
            catch (Exception ex) {
                log.warn((Object)("Failed to delete temp store node for transfer id " + transferId + "\nTemp store noderef = " + tempStoreNode));
            }
            File stagingFolder = null;
            try {
                log.debug((Object)("delete staging folder " + transferId));
                stagingFolder = this.getStagingFolder(transferId);
                this.deleteFile(stagingFolder);
                log.debug((Object)"Staging folder deleted");
            }
            catch (Exception ex) {
                log.warn((Object)("Failed to delete staging folder for transfer id " + transferId + "\nStaging folder = " + stagingFolder.toString()));
            }
            Set<NodeRef> createdNodes = Collections.emptySet();
            Set<NodeRef> updatedNodes = Collections.emptySet();
            Set<NodeRef> deletedNodes = Collections.emptySet();
            ChangeCapturingProgressMonitor.TransferChangesRecord changesRecord = this.progressMonitor.removeChangeRecord(transferId);
            if (changesRecord != null) {
                createdNodes = new HashSet<NodeRef>(changesRecord.getCreatedNodes());
                updatedNodes = new HashSet<NodeRef>(changesRecord.getUpdatedNodes());
                deletedNodes = new HashSet<NodeRef>(changesRecord.getDeletedNodes());
            }
            TransferServicePolicies.OnEndInboundTransferPolicy onEndPolicy = this.onEndInboundTransferDelegate.get(TransferModel.TYPE_TRANSFER_RECORD);
            onEndPolicy.onEndInboundTransfer(transferId, createdNodes, updatedNodes, deletedNodes);
        }
        catch (TransferException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransferException(MSG_ERROR_WHILE_ENDING_TRANSFER, new Object[]{transferId}, ex);
        }
    }

    public void cancel(String transferId) throws TransferException {
        TransferProgress progress = this.getProgressMonitor().getProgress(transferId);
        this.getProgressMonitor().updateStatus(transferId, TransferProgress.Status.CANCELLED);
        if (progress.getStatus().equals((Object)TransferProgress.Status.PRE_COMMIT)) {
            this.end(transferId);
        }
    }

    public void prepare(String transferId) throws TransferException {
    }

    private void deleteFile(File file) {
        File[] fileList;
        if (file.isDirectory() && (fileList = file.listFiles()) != null) {
            for (File currentFile : fileList) {
                this.deleteFile(currentFile);
            }
        }
        file.delete();
    }

    private NodeRef getLockNode() {
        NodeRef lockFolder = this.getLockFolder();
        List assocs = this.nodeService.getChildAssocs(lockFolder, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)LOCK_QNAME);
        NodeRef lockId = assocs.size() == 0 ? null : ((ChildAssociationRef)assocs.get(0)).getChildRef();
        return lockId;
    }

    private boolean testLockedTransfer(NodeRef lockId, String transferId) {
        if (lockId == null) {
            throw new IllegalArgumentException("lockId = null");
        }
        if (transferId == null) {
            throw new IllegalArgumentException("transferId = null");
        }
        String currentTransferId = (String)((Object)this.nodeService.getProperty(lockId, TransferModel.PROP_TRANSFER_ID));
        return transferId.equals(currentTransferId);
    }

    public void nudgeLock(final String transferId) throws TransferException {
        if (transferId == null) {
            throw new IllegalArgumentException("transferId = null");
        }
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                NodeRef lockId = RepoTransferReceiverImpl.this.getLockNode();
                if (!RepoTransferReceiverImpl.this.testLockedTransfer(lockId, transferId)) {
                    throw new TransferException(RepoTransferReceiverImpl.MSG_NOT_LOCK_OWNER);
                }
                RepoTransferReceiverImpl.this.nodeService.setProperty(lockId, ContentModel.PROP_NAME, (Serializable)((Object)RepoTransferReceiverImpl.LOCK_FILE_NAME));
                return null;
            }
        }, false, true);
    }

    public void saveSnapshot(String transferId, InputStream openStream) throws TransferException {
        this.nudgeLock(transferId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Saving snapshot for transferId =" + transferId));
        }
        File snapshotFile = new File(this.getStagingFolder(transferId), SNAPSHOT_FILE_NAME);
        try {
            if (snapshotFile.createNewFile()) {
                FileCopyUtils.copy((InputStream)openStream, (OutputStream)new FileOutputStream(snapshotFile));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saved snapshot for transferId =" + transferId));
            }
        }
        catch (Exception ex) {
            throw new TransferException(MSG_ERROR_WHILE_STAGING_SNAPSHOT, new Object[]{transferId}, ex);
        }
    }

    public void saveContent(String transferId, String contentFileId, InputStream contentStream) throws TransferException {
        this.nudgeLock(transferId);
        File stagedFile = new File(this.getStagingFolder(transferId), contentFileId);
        try {
            if (stagedFile.createNewFile()) {
                FileCopyUtils.copy((InputStream)contentStream, (OutputStream)new BufferedOutputStream(new FileOutputStream(stagedFile)));
            }
        }
        catch (Exception ex) {
            throw new TransferException(MSG_ERROR_WHILE_STAGING_CONTENT, new Object[]{transferId, contentFileId}, ex);
        }
    }

    public void commitAsync(String transferId) {
        this.nudgeLock(transferId);
        this.progressMonitor.updateStatus(transferId, TransferProgress.Status.COMMIT_REQUESTED);
        Action commitAction = this.actionService.createAction("commit-transfer");
        commitAction.setParameterValue("transfer-id", (Serializable)((Object)transferId));
        commitAction.setExecuteAsynchronously(true);
        this.actionService.executeAction(commitAction, new NodeRef(transferId));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered transfer commit for asynchronous execution: " + transferId));
        }
    }

    /*
     * Loose catch block
     */
    public void commit(final String transferId) throws TransferException {
        block14: {
            boolean rulesEnabled;
            block13: {
                block12: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Committing transferId=" + transferId));
                    }
                    rulesEnabled = this.ruleService.isEnabled();
                    this.ruleService.disableRules();
                    this.nudgeLock(transferId);
                    this.progressMonitor.updateStatus(transferId, TransferProgress.Status.COMMITTING);
                    RetryingTransactionHelper.RetryingTransactionCallback<Object> commitWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Object execute() throws Throwable {
                            AlfrescoTransactionSupport.bindListener(new TransferCommitTransactionListener(transferId, RepoTransferReceiverImpl.this));
                            List<TransferManifestProcessor> commitProcessors = RepoTransferReceiverImpl.this.manifestProcessorFactory.getCommitProcessors(RepoTransferReceiverImpl.this, transferId);
                            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                            SAXParser parser = saxParserFactory.newSAXParser();
                            File snapshotFile = RepoTransferReceiverImpl.this.getSnapshotFile(transferId);
                            if (snapshotFile.exists()) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Processing manifest file:" + snapshotFile.getAbsolutePath()));
                                }
                                for (TransferManifestProcessor processor : commitProcessors) {
                                    Object var9_8;
                                    XMLTransferManifestReader reader = new XMLTransferManifestReader(processor);
                                    RepoTransferReceiverImpl.this.behaviourFilter.disableAllBehaviours();
                                    try {
                                        parser.parse(snapshotFile, (DefaultHandler)reader);
                                        var9_8 = null;
                                        RepoTransferReceiverImpl.this.behaviourFilter.enableAllBehaviours();
                                    }
                                    catch (Throwable throwable) {
                                        var9_8 = null;
                                        RepoTransferReceiverImpl.this.behaviourFilter.enableAllBehaviours();
                                        throw throwable;
                                    }
                                    RepoTransferReceiverImpl.this.nudgeLock(transferId);
                                    parser.reset();
                                }
                            } else {
                                RepoTransferReceiverImpl.this.progressMonitor.logException(transferId, "Unable to start commit. No snapshot file received", (Throwable)((Object)new TransferException(RepoTransferReceiverImpl.MSG_NO_SNAPSHOT_RECEIVED, new Object[]{transferId})));
                            }
                            return null;
                        }
                    };
                    this.transactionService.getRetryingTransactionHelper().doInTransaction(commitWork, false, true);
                    Throwable error = this.progressMonitor.getProgress(transferId).getError();
                    if (error != null) {
                        if (TransferException.class.isAssignableFrom(error.getClass())) {
                            throw (TransferException)((Object)error);
                        }
                        throw new TransferException(MSG_ERROR_WHILE_COMMITTING_TRANSFER, new Object[]{transferId}, error);
                    }
                    if (!log.isDebugEnabled()) break block12;
                    log.debug((Object)("Commit success transferId=" + transferId));
                }
                Object var6_6 = null;
                if (!rulesEnabled) break block13;
                this.ruleService.enableRules();
            }
            try {
                this.end(transferId);
            }
            catch (Exception ex) {
                log.error((Object)("Failed to clean up transfer. Lock may still be in place: " + transferId), (Throwable)ex);
            }
            break block14;
            {
                catch (Exception ex) {
                    if (TransferException.class.isAssignableFrom(ex.getClass())) {
                        throw (TransferException)((Object)ex);
                    }
                    throw new TransferException(MSG_ERROR_WHILE_COMMITTING_TRANSFER, ex);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (rulesEnabled) {
                    this.ruleService.enableRules();
                }
                try {
                    this.end(transferId);
                }
                catch (Exception ex) {
                    log.error((Object)("Failed to clean up transfer. Lock may still be in place: " + transferId), (Throwable)ex);
                }
                throw throwable;
            }
        }
    }

    public TransferProgress getStatus(String transferId) throws TransferException {
        return this.getProgressMonitor().getProgress(transferId);
    }

    private File getSnapshotFile(String transferId) {
        return new File(this.getStagingFolder(transferId), SNAPSHOT_FILE_NAME);
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setTransferLockFolderPath(String transferLockFolderPath) {
        this.transferLockFolderPath = transferLockFolderPath;
    }

    public void setTransferTempFolderPath(String transferTempFolderPath) {
        this.transferTempFolderPath = transferTempFolderPath;
    }

    public void setRootStagingDirectory(String rootStagingDirectory) {
        this.rootStagingDirectory = rootStagingDirectory;
    }

    public void setInboundTransferRecordsPath(String inboundTransferRecordsPath) {
        this.inboundTransferRecordsPath = inboundTransferRecordsPath;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setManifestProcessorFactory(ManifestProcessorFactory manifestProcessorFactory) {
        this.manifestProcessorFactory = manifestProcessorFactory;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public TransferProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(TransferProgressMonitor progressMonitor) {
        this.progressMonitor = new ChangeCapturingProgressMonitor(progressMonitor);
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public RuleService getRuleService() {
        return this.ruleService;
    }

    public void generateRequsite(String transferId, OutputStream out) throws TransferException {
        log.debug((Object)("Generate Requsite for transfer:" + transferId));
        try {
            File snapshotFile = this.getSnapshotFile(transferId);
            if (snapshotFile.exists()) {
                log.debug((Object)"snapshot does exist");
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                SAXParser parser = saxParserFactory.newSAXParser();
                OutputStreamWriter dest = new OutputStreamWriter(out, "UTF-8");
                XMLTransferRequsiteWriter writer = new XMLTransferRequsiteWriter(dest);
                TransferManifestProcessor processor = this.manifestProcessorFactory.getRequsiteProcessor(this, transferId, writer);
                XMLTransferManifestReader reader = new XMLTransferManifestReader(processor);
                parser.parse(snapshotFile, (DefaultHandler)reader);
                dest.flush();
            }
            log.debug((Object)("Generate Requsite done transfer:" + transferId));
        }
        catch (Exception ex) {
            if (TransferException.class.isAssignableFrom(ex.getClass())) {
                throw (TransferException)((Object)ex);
            }
            throw new TransferException(MSG_ERROR_WHILE_GENERATING_REQUISITE, ex);
        }
    }

    public InputStream getTransferReport(String transferId) {
        return this.progressMonitor.getLogInputStream(transferId);
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public PolicyComponent getPolicyComponent() {
        return this.policyComponent;
    }

    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean isNewNode) {
        log.debug((Object)"on create child association to transferred node");
        String localRepositoryId = this.descriptorService.getCurrentRepositoryDescriptor().getId();
        this.alienProcessor.onCreateChild(childAssocRef, localRepositoryId, isNewNode);
    }

    public void beforeDeleteNode(NodeRef deletedNodeRef) {
        log.debug((Object)"on delete node - need to check for transferred node");
        this.alienProcessor.beforeDeleteAlien(deletedNodeRef, null);
    }

    public void onRestoreNode(ChildAssociationRef childAssocRef) {
        log.debug((Object)"on restore node");
        log.debug((Object)("restoredAssocRef:" + childAssocRef));
        this.alienProcessor.afterMoveAlien(childAssocRef);
    }

    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        log.debug((Object)"onMoveNode");
        log.debug((Object)("oldChildAssocRef:" + oldChildAssocRef));
        log.debug((Object)("newChildAssocRef:" + newChildAssocRef));
        this.alienProcessor.beforeDeleteAlien(newChildAssocRef.getChildRef(), oldChildAssocRef);
        this.alienProcessor.afterMoveAlien(newChildAssocRef);
    }

    public CopyBehaviourCallback onCopyTransferred(QName classRef, CopyDetails copyDetails) {
        return TransferredAspectCopyBehaviourCallback.INSTANCE;
    }

    public CopyBehaviourCallback onCopyAlien(QName classRef, CopyDetails copyDetails) {
        return AlienAspectCopyBehaviourCallback.INSTANCE;
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public DescriptorService getDescriptorService() {
        return this.descriptorService;
    }

    public void setAlienProcessor(AlienProcessor alienProcessor) {
        this.alienProcessor = alienProcessor;
    }

    public AlienProcessor getAlienProcessor() {
        return this.alienProcessor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlienAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new AlienAspectCopyBehaviourCallback();

        private AlienAspectCopyBehaviourCallback() {
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            return Collections.emptyMap();
        }

        @Override
        public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
            return !classQName.equals((Object)TransferModel.ASPECT_ALIEN);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransferredAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new TransferredAspectCopyBehaviourCallback();

        private TransferredAspectCopyBehaviourCallback() {
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            return Collections.emptyMap();
        }

        @Override
        public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
            return !classQName.equals((Object)TransferModel.ASPECT_TRANSFERRED);
        }
    }

    public class AsyncCommitCommand
    implements Runnable {
        private String transferId;
        private String runAsUser;

        public AsyncCommitCommand(String transferId) {
            this.transferId = transferId;
            this.runAsUser = AuthenticationUtil.getFullyAuthenticatedUser();
        }

        public void run() {
            AuthenticationUtil.RunAsWork<Object> actionRunAs = new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    return RepoTransferReceiverImpl.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        @Override
                        public Object execute() {
                            RepoTransferReceiverImpl.this.commit(AsyncCommitCommand.this.transferId);
                            return null;
                        }
                    }, false, true);
                }
            };
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)actionRunAs, (String)this.runAsUser);
        }
    }
}

