/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transfer.RepoTransferReceiverImpl;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.repo.transfer.TransferProgressMonitor;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNode;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.repo.transfer.manifest.XMLTransferManifestWriter;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.transfer.TransferException;
import org.alfresco.service.cmr.transfer.TransferProgress;
import org.alfresco.service.cmr.transfer.TransferServicePolicies;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.filters.StringInputStream;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepoTransferReceiverImplTest
extends BaseAlfrescoSpringTest {
    private static int fileCount = 0;
    private static final Log log = LogFactory.getLog(RepoTransferReceiverImplTest.class);
    private RepoTransferReceiverImpl receiver;
    private SearchService searchService;
    private String dummyContent;
    private byte[] dummyContentBytes;
    private NodeRef guestHome;
    private PolicyComponent policyComponent;

    public void runBare() throws Throwable {
        this.preventTransaction();
        super.runBare();
    }

    protected void onSetUp() throws Exception {
        super.onSetUp();
        System.out.println("java.io.tmpdir == " + System.getProperty("java.io.tmpdir"));
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.receiver = (RepoTransferReceiverImpl)this.getApplicationContext().getBean("transferReceiver");
        this.policyComponent = (PolicyComponent)this.getApplicationContext().getBean("policyComponent");
        this.searchService = (SearchService)this.getApplicationContext().getBean("searchService");
        this.dummyContent = "This is some dummy content.";
        this.dummyContentBytes = this.dummyContent.getBytes("UTF-8");
        this.setTransactionDefinition((TransactionDefinition)new DefaultTransactionDefinition(3));
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.startNewTransaction();
        String guestHomeQuery = "/app:company_home/app:guest_home";
        ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
        RepoTransferReceiverImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
        this.guestHome = guestHomeResult.getNodeRef(0);
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDelete() {
        ChildAssociationRef childAssoc;
        this.setDefaultRollback(false);
        String uuid = GUID.generate();
        this.startNewTransaction();
        try {
            ResultSet rs = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", "/app:company_home");
            RepoTransferReceiverImplTest.assertEquals((int)1, (int)rs.length());
            NodeRef companyHome = rs.getNodeRef(0);
            HashMap<QName, String> props = new HashMap<QName, String>();
            props.put(ContentModel.PROP_NAME, uuid);
            childAssoc = this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)uuid), ContentModel.TYPE_CONTENT, props);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            this.nodeService.deleteNode(childAssoc.getChildRef());
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            log.debug((Object)"Test that original node no longer exists...");
            RepoTransferReceiverImplTest.assertFalse((boolean)this.nodeService.exists(childAssoc.getChildRef()));
            log.debug((Object)"PASS - Original node no longer exists.");
            NodeRef archiveNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, childAssoc.getChildRef().getId());
            log.debug((Object)"Test that archive node exists...");
            RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(archiveNodeRef));
            log.debug((Object)"PASS - Archive node exists.");
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartAndEnd() throws Exception {
        log.info((Object)"testStartAndEnd");
        this.startNewTransaction();
        try {
            String transferId = this.receiver.start();
            System.out.println("TransferId == " + transferId);
            File stagingFolder = this.receiver.getStagingFolder(transferId);
            RepoTransferReceiverImplTest.assertTrue((boolean)this.receiver.getStagingFolder(transferId).exists());
            try {
                this.receiver.start();
                RepoTransferReceiverImplTest.fail((String)"Successfully started twice!");
            }
            catch (TransferException ex) {
                // empty catch block
            }
            try {
                this.receiver.end(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate()).toString());
                RepoTransferReceiverImplTest.fail((String)"Successfully ended with transfer id that doesn't own lock.");
            }
            catch (TransferException transferException) {
                // empty catch block
            }
            this.receiver.end(transferId);
            RepoTransferReceiverImplTest.assertFalse((boolean)stagingFolder.exists());
            this.receiver.end(this.receiver.start());
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSaveContent() throws Exception {
        log.info((Object)"testSaveContent");
        this.startNewTransaction();
        try {
            String transferId = this.receiver.start();
            try {
                String contentId = "mytestcontent";
                this.receiver.saveContent(transferId, contentId, new ByteArrayInputStream(this.dummyContentBytes));
                File contentFile = new File(this.receiver.getStagingFolder(transferId), contentId);
                RepoTransferReceiverImplTest.assertTrue((boolean)contentFile.exists());
                RepoTransferReceiverImplTest.assertEquals((long)this.dummyContentBytes.length, (long)contentFile.length());
                Object var5_4 = null;
                this.receiver.end(transferId);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.receiver.end(transferId);
                throw throwable;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSaveSnapshot() throws Exception {
        log.info((Object)"testSaveSnapshot");
        this.startNewTransaction();
        try {
            block4: {
                String transferId = this.receiver.start();
                File snapshotFile = null;
                try {
                    TransferManifestNormalNode node = this.createContentNode(transferId);
                    ArrayList<TransferManifestNode> nodes = new ArrayList<TransferManifestNode>();
                    nodes.add(node);
                    String snapshot = this.createSnapshot(nodes);
                    this.receiver.saveSnapshot(transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
                    File stagingFolder = this.receiver.getStagingFolder(transferId);
                    snapshotFile = new File(stagingFolder, "snapshot.xml");
                    RepoTransferReceiverImplTest.assertTrue((boolean)snapshotFile.exists());
                    RepoTransferReceiverImplTest.assertEquals((long)snapshot.getBytes("UTF-8").length, (long)snapshotFile.length());
                    Object var8_7 = null;
                    this.receiver.end(transferId);
                    if (snapshotFile == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    this.receiver.end(transferId);
                    if (snapshotFile == null) throw throwable;
                    RepoTransferReceiverImplTest.assertFalse((boolean)snapshotFile.exists());
                    throw throwable;
                }
                RepoTransferReceiverImplTest.assertFalse((boolean)snapshotFile.exists());
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicCommit() throws Exception {
        log.info((Object)"testBasicCommit");
        this.startNewTransaction();
        TransferManifestNormalNode node = null;
        try {
            String transferId = this.receiver.start();
            try {
                node = this.createContentNode(transferId);
                ArrayList<TransferManifestNode> nodes = new ArrayList<TransferManifestNode>();
                nodes.add(node);
                String snapshot = this.createSnapshot(nodes);
                this.receiver.saveSnapshot(transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
                this.receiver.saveContent(transferId, node.getUuid(), new ByteArrayInputStream(this.dummyContentBytes));
                this.receiver.commit(transferId);
            }
            catch (Exception ex) {
                this.receiver.end(transferId);
                throw ex;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(node.getNodeRef()));
            this.nodeService.deleteNode(node.getNodeRef());
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoreComplexCommit() throws Exception {
        log.info((Object)"testMoreComplexCommit");
        ArrayList<TransferManifestNode> nodes = new ArrayList<TransferManifestNode>();
        TransferManifestNormalNode node1 = null;
        TransferManifestNormalNode node2 = null;
        TransferManifestNormalNode node3 = null;
        TransferManifestNormalNode node4 = null;
        TransferManifestNormalNode node5 = null;
        TransferManifestNormalNode node6 = null;
        TransferManifestNormalNode node7 = null;
        TransferManifestNormalNode node8 = null;
        TransferManifestNormalNode node9 = null;
        TransferManifestNormalNode node10 = null;
        TransferManifestNormalNode node11 = null;
        TransferManifestNormalNode node12 = null;
        String transferId = null;
        this.startNewTransaction();
        try {
            transferId = this.receiver.start();
            node1 = this.createContentNode(transferId);
            nodes.add(node1);
            node2 = this.createContentNode(transferId);
            nodes.add(node2);
            node3 = this.createContentNode(transferId);
            nodes.add(node3);
            node4 = this.createContentNode(transferId);
            nodes.add(node4);
            node5 = this.createContentNode(transferId);
            nodes.add(node5);
            node6 = this.createContentNode(transferId);
            nodes.add(node6);
            node7 = this.createContentNode(transferId);
            nodes.add(node7);
            node8 = this.createFolderNode(transferId);
            nodes.add(node8);
            node9 = this.createFolderNode(transferId);
            nodes.add(node9);
            node10 = this.createFolderNode(transferId);
            nodes.add(node10);
            node11 = this.createFolderNode(transferId);
            nodes.add(node11);
            node12 = this.createFolderNode(transferId);
            nodes.add(node12);
            this.associatePeers(node1, node2);
            this.moveNode(node2, node11);
            String snapshot = this.createSnapshot(nodes);
            this.receiver.saveSnapshot(transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
            for (TransferManifestNode node : nodes) {
                this.receiver.saveContent(transferId, node.getUuid(), new ByteArrayInputStream(this.dummyContentBytes));
            }
            this.receiver.commit(transferId);
            Object var19_18 = null;
            this.receiver.end(transferId);
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            this.receiver.end(transferId);
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.getAspects(node1.getNodeRef()).contains(ContentModel.ASPECT_ATTACHABLE));
            RepoTransferReceiverImplTest.assertFalse((boolean)this.nodeService.getSourceAssocs(node2.getNodeRef(), (QNamePattern)ContentModel.ASSOC_ATTACHMENTS).isEmpty());
            for (TransferManifestNode node : nodes) {
                RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(node.getNodeRef()));
            }
            Object var21_21 = null;
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodeDeleteAndRestore() throws Exception {
        ArgumentCaptor deletedNodesCaptor;
        ArgumentCaptor updatedNodesCaptor;
        ArgumentCaptor createdNodesCaptor;
        ArgumentCaptor transferIdCaptor;
        String snapshot;
        TransferServicePolicies.OnEndInboundTransferPolicy mockedPolicyHandler = (TransferServicePolicies.OnEndInboundTransferPolicy)Mockito.mock(TransferServicePolicies.OnEndInboundTransferPolicy.class);
        this.policyComponent.bindClassBehaviour(TransferServicePolicies.OnEndInboundTransferPolicy.QNAME, TransferModel.TYPE_TRANSFER_RECORD, (Behaviour)new JavaBehaviour(mockedPolicyHandler, "onEndInboundTransfer", Behaviour.NotificationFrequency.EVERY_EVENT));
        log.info((Object)"testNodeDeleteAndRestore");
        this.setDefaultRollback(true);
        this.startNewTransaction();
        String transferId = this.receiver.start();
        ArrayList<TransferManifestNode> nodes = new ArrayList<TransferManifestNode>();
        TransferManifestNormalNode node1 = this.createContentNode(transferId);
        nodes.add(node1);
        TransferManifestNormalNode node2 = this.createContentNode(transferId);
        nodes.add(node2);
        TransferManifestNormalNode node3 = this.createContentNode(transferId);
        nodes.add(node3);
        TransferManifestNormalNode node4 = this.createContentNode(transferId);
        nodes.add(node4);
        TransferManifestNormalNode node5 = this.createContentNode(transferId);
        nodes.add(node5);
        TransferManifestNormalNode node6 = this.createContentNode(transferId);
        nodes.add(node6);
        TransferManifestNormalNode node7 = this.createContentNode(transferId);
        nodes.add(node7);
        TransferManifestNormalNode node8 = this.createFolderNode(transferId);
        nodes.add(node8);
        TransferManifestNormalNode node9 = this.createFolderNode(transferId);
        nodes.add(node9);
        TransferManifestNormalNode node10 = this.createFolderNode(transferId);
        nodes.add(node10);
        TransferManifestNormalNode node11 = this.createFolderNode(transferId);
        nodes.add(node11);
        TransferManifestNormalNode node12 = this.createFolderNode(transferId);
        nodes.add(node12);
        this.associatePeers(node1, node2);
        this.moveNode(node2, node11);
        TransferManifestDeletedNode deletedNode8 = this.createDeletedNode(node8);
        TransferManifestDeletedNode deletedNode2 = this.createDeletedNode(node2);
        TransferManifestDeletedNode deletedNode11 = this.createDeletedNode(node11);
        this.endTransaction();
        this.setDefaultRollback(false);
        this.startNewTransaction();
        try {
            snapshot = this.createSnapshot(nodes);
            log.debug((Object)snapshot);
            this.receiver.saveSnapshot(transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
            for (TransferManifestNode node : nodes) {
                this.receiver.saveContent(transferId, node.getUuid(), new ByteArrayInputStream(this.dummyContentBytes));
            }
            this.receiver.commit(transferId);
            RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.getAspects(node1.getNodeRef()).contains(ContentModel.ASPECT_ATTACHABLE));
            RepoTransferReceiverImplTest.assertFalse((boolean)this.nodeService.getSourceAssocs(node2.getNodeRef(), (QNamePattern)ContentModel.ASSOC_ATTACHMENTS).isEmpty());
            transferIdCaptor = ArgumentCaptor.forClass(String.class);
            createdNodesCaptor = ArgumentCaptor.forClass(Set.class);
            updatedNodesCaptor = ArgumentCaptor.forClass(Set.class);
            deletedNodesCaptor = ArgumentCaptor.forClass(Set.class);
            ((TransferServicePolicies.OnEndInboundTransferPolicy)Mockito.verify((Object)mockedPolicyHandler, (VerificationMode)Mockito.times((int)1))).onEndInboundTransfer((String)transferIdCaptor.capture(), (Set)createdNodesCaptor.capture(), (Set)updatedNodesCaptor.capture(), (Set)deletedNodesCaptor.capture());
            RepoTransferReceiverImplTest.assertEquals((String)transferId, (String)((String)transferIdCaptor.getValue()));
            Set capturedCreatedNodes = (Set)createdNodesCaptor.getValue();
            RepoTransferReceiverImplTest.assertEquals((int)nodes.size(), (int)capturedCreatedNodes.size());
            for (TransferManifestNode node : nodes) {
                RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(node.getNodeRef()));
                RepoTransferReceiverImplTest.assertTrue((boolean)capturedCreatedNodes.contains(node.getNodeRef()));
            }
            Object var28_29 = null;
        }
        catch (Throwable throwable) {
            Object var28_30 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        Mockito.reset((Object[])new TransferServicePolicies.OnEndInboundTransferPolicy[]{mockedPolicyHandler});
        this.startNewTransaction();
        try {
            transferId = this.receiver.start();
            snapshot = this.createSnapshot(Arrays.asList(deletedNode8, deletedNode2, deletedNode11));
            log.debug((Object)snapshot);
            this.receiver.saveSnapshot(transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
            this.receiver.commit(transferId);
            transferIdCaptor = ArgumentCaptor.forClass(String.class);
            createdNodesCaptor = ArgumentCaptor.forClass(Set.class);
            updatedNodesCaptor = ArgumentCaptor.forClass(Set.class);
            deletedNodesCaptor = ArgumentCaptor.forClass(Set.class);
            ((TransferServicePolicies.OnEndInboundTransferPolicy)Mockito.verify((Object)mockedPolicyHandler, (VerificationMode)Mockito.times((int)1))).onEndInboundTransfer((String)transferIdCaptor.capture(), (Set)createdNodesCaptor.capture(), (Set)updatedNodesCaptor.capture(), (Set)deletedNodesCaptor.capture());
            RepoTransferReceiverImplTest.assertEquals((String)transferId, (String)((String)transferIdCaptor.getValue()));
            Set capturedDeletedNodes = (Set)deletedNodesCaptor.getValue();
            RepoTransferReceiverImplTest.assertEquals((int)3, (int)capturedDeletedNodes.size());
            RepoTransferReceiverImplTest.assertTrue((boolean)capturedDeletedNodes.contains(deletedNode8.getNodeRef()));
            RepoTransferReceiverImplTest.assertTrue((boolean)capturedDeletedNodes.contains(deletedNode2.getNodeRef()));
            RepoTransferReceiverImplTest.assertTrue((boolean)capturedDeletedNodes.contains(deletedNode11.getNodeRef()));
            Object var30_32 = null;
        }
        catch (Throwable throwable) {
            Object var30_33 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            log.debug((Object)"Test success of transfer...");
            TransferProgress progress = this.receiver.getProgressMonitor().getProgress(transferId);
            RepoTransferReceiverImplTest.assertEquals((Object)((Object)TransferProgress.Status.COMPLETE), (Object)((Object)progress.getStatus()));
            NodeRef archiveNode8 = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, node8.getNodeRef().getId());
            NodeRef archiveNode2 = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, node2.getNodeRef().getId());
            NodeRef archiveNode11 = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, node11.getNodeRef().getId());
            RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(archiveNode8));
            RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.hasAspect(archiveNode8, ContentModel.ASPECT_ARCHIVED));
            log.debug((Object)("Successfully tested existence of archive node: " + archiveNode8));
            RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(archiveNode2));
            RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.hasAspect(archiveNode2, ContentModel.ASPECT_ARCHIVED));
            log.debug((Object)("Successfully tested existence of archive node: " + archiveNode2));
            RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(archiveNode11));
            RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.hasAspect(archiveNode11, ContentModel.ASPECT_ARCHIVED));
            log.debug((Object)("Successfully tested existence of archive node: " + archiveNode11));
            log.debug((Object)"Successfully tested existence of all archive nodes");
            log.debug((Object)("Testing existence of original node: " + node8.getNodeRef()));
            RepoTransferReceiverImplTest.assertFalse((boolean)this.nodeService.exists(node8.getNodeRef()));
            log.debug((Object)("Testing existence of original node: " + node2.getNodeRef()));
            RepoTransferReceiverImplTest.assertFalse((boolean)this.nodeService.exists(node2.getNodeRef()));
            log.debug((Object)("Testing existence of original node: " + node11.getNodeRef()));
            RepoTransferReceiverImplTest.assertFalse((boolean)this.nodeService.exists(node11.getNodeRef()));
            log.debug((Object)"Successfully tested non-existence of all original nodes");
            log.debug((Object)("Progress indication: " + progress.getCurrentPosition() + "/" + progress.getEndPosition()));
            Object var32_35 = null;
        }
        catch (Throwable throwable) {
            Object var32_36 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        System.out.println("Now try to restore orphan node 2.");
        Mockito.reset((Object[])new TransferServicePolicies.OnEndInboundTransferPolicy[]{mockedPolicyHandler});
        String errorMsgId = null;
        this.startNewTransaction();
        try {
            try {
                transferId = this.receiver.start();
                String snapshot2 = this.createSnapshot(Arrays.asList(node2));
                log.debug((Object)snapshot2);
                this.receiver.saveSnapshot(transferId, (InputStream)new StringInputStream(snapshot2, "UTF-8"));
                this.receiver.saveContent(transferId, node2.getUuid(), new ByteArrayInputStream(this.dummyContentBytes));
                try {
                    this.receiver.commit(transferId);
                    RepoTransferReceiverImplTest.fail((String)"Expected an exception");
                }
                catch (TransferException ex) {
                    errorMsgId = ex.getMsgId();
                    ArgumentCaptor transferIdCaptor2 = ArgumentCaptor.forClass(String.class);
                    ArgumentCaptor createdNodesCaptor2 = ArgumentCaptor.forClass(Set.class);
                    ArgumentCaptor updatedNodesCaptor2 = ArgumentCaptor.forClass(Set.class);
                    ArgumentCaptor deletedNodesCaptor2 = ArgumentCaptor.forClass(Set.class);
                    ((TransferServicePolicies.OnEndInboundTransferPolicy)Mockito.verify((Object)mockedPolicyHandler, (VerificationMode)Mockito.times((int)1))).onEndInboundTransfer((String)transferIdCaptor2.capture(), (Set)createdNodesCaptor2.capture(), (Set)updatedNodesCaptor2.capture(), (Set)deletedNodesCaptor2.capture());
                    RepoTransferReceiverImplTest.assertEquals((String)transferId, (String)((String)transferIdCaptor2.getValue()));
                    RepoTransferReceiverImplTest.assertTrue((boolean)((Set)createdNodesCaptor2.getValue()).isEmpty());
                    RepoTransferReceiverImplTest.assertTrue((boolean)((Set)updatedNodesCaptor2.getValue()).isEmpty());
                    RepoTransferReceiverImplTest.assertTrue((boolean)((Set)deletedNodesCaptor2.getValue()).isEmpty());
                }
                Object var34_38 = null;
            }
            catch (Exception ex) {
                this.receiver.end(transferId);
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var34_39 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            TransferProgress progress = this.receiver.getProgressMonitor().getProgress(transferId);
            RepoTransferReceiverImplTest.assertEquals((Object)((Object)TransferProgress.Status.ERROR), (Object)((Object)progress.getStatus()));
            log.debug((Object)("Progress indication: " + progress.getCurrentPosition() + "/" + progress.getEndPosition()));
            RepoTransferReceiverImplTest.assertNotNull((String)"Progress error", (Object)progress.getError());
            RepoTransferReceiverImplTest.assertTrue((boolean)(progress.getError() instanceof Exception));
            RepoTransferReceiverImplTest.assertTrue((String)errorMsgId, (boolean)errorMsgId.contains("orphan"));
            Object var36_41 = null;
        }
        catch (Throwable throwable) {
            Object var36_42 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testJira_ALF_2772() throws Exception {
        String snapshot;
        this.setDefaultRollback(true);
        this.startNewTransaction();
        String transferId = this.receiver.start();
        TransferManifestNormalNode node1 = this.createContentNode(transferId);
        TransferManifestNormalNode node2 = this.createContentNode(transferId);
        TransferManifestNormalNode node11 = this.createFolderNode(transferId);
        this.associatePeers(node1, node2);
        this.moveNode(node2, node11);
        TransferManifestDeletedNode deletedNode11 = this.createDeletedNode(node11);
        this.endTransaction();
        ArrayList<TransferManifestNode> nodes = new ArrayList<TransferManifestNode>();
        nodes.add(node11);
        this.setDefaultRollback(false);
        this.startNewTransaction();
        try {
            snapshot = this.createSnapshot(nodes);
            log.debug((Object)snapshot);
            this.receiver.saveSnapshot(transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
            for (TransferManifestNode node : nodes) {
                this.receiver.saveContent(transferId, node.getUuid(), new ByteArrayInputStream(this.dummyContentBytes));
            }
            this.receiver.commit(transferId);
            for (TransferManifestNode node : nodes) {
                RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(node.getNodeRef()));
            }
            Object var11_11 = null;
            this.receiver.end(transferId);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.receiver.end(transferId);
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            transferId = this.receiver.start();
            snapshot = this.createSnapshot(Arrays.asList(deletedNode11));
            log.debug((Object)snapshot);
            this.receiver.saveSnapshot(transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
            this.receiver.commit(transferId);
            Object var13_14 = null;
            this.receiver.end(transferId);
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.receiver.end(transferId);
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            log.debug((Object)"Test success of transfer...");
            TransferProgress progress = this.receiver.getProgressMonitor().getProgress(transferId);
            RepoTransferReceiverImplTest.assertEquals((Object)((Object)TransferProgress.Status.COMPLETE), (Object)((Object)progress.getStatus()));
            NodeRef archivedNodeRef = new NodeRef(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE, deletedNode11.getNodeRef().getId());
            RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(archivedNodeRef));
            RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.hasAspect(archivedNodeRef, ContentModel.ASPECT_ARCHIVED));
            log.debug((Object)("Successfully tested existence of archive node: " + deletedNode11.getNodeRef()));
            log.debug((Object)"Successfully tested existence of all archive nodes");
            log.debug((Object)("Testing existence of original node: " + node11.getNodeRef()));
            RepoTransferReceiverImplTest.assertFalse((boolean)this.nodeService.exists(node11.getNodeRef()));
            log.debug((Object)"Successfully tested non-existence of all original nodes");
            log.debug((Object)("Progress indication: " + progress.getCurrentPosition() + "/" + progress.getEndPosition()));
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
        this.startNewTransaction();
        try {
            try {
                transferId = this.receiver.start();
                snapshot = this.createSnapshot(Arrays.asList(node2, node11));
                log.debug((Object)snapshot);
                this.receiver.saveSnapshot(transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
                this.receiver.saveContent(transferId, node2.getUuid(), new ByteArrayInputStream(this.dummyContentBytes));
                this.receiver.commit(transferId);
            }
            catch (Exception ex) {
                RepoTransferReceiverImplTest.fail((String)("Test of ALF-2772 failed: " + ex.getMessage()));
                Object var17_21 = null;
                this.receiver.end(transferId);
                this.endTransaction();
                return;
            }
            Object var17_20 = null;
            this.receiver.end(transferId);
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            this.receiver.end(transferId);
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncCommit() throws Exception {
        log.info((Object)"testAsyncCommit");
        this.setDefaultRollback(false);
        this.startNewTransaction();
        String transferId = this.receiver.start();
        this.endTransaction();
        this.startNewTransaction();
        ArrayList<TransferManifestNode> nodes = new ArrayList<TransferManifestNode>();
        TransferManifestNormalNode node1 = this.createContentNode(transferId);
        nodes.add(node1);
        TransferManifestNormalNode node2 = this.createContentNode(transferId);
        nodes.add(node2);
        TransferManifestNormalNode node3 = this.createContentNode(transferId);
        nodes.add(node3);
        TransferManifestNormalNode node4 = this.createContentNode(transferId);
        nodes.add(node4);
        TransferManifestNormalNode node5 = this.createContentNode(transferId);
        nodes.add(node5);
        TransferManifestNormalNode node6 = this.createContentNode(transferId);
        nodes.add(node6);
        TransferManifestNormalNode node7 = this.createContentNode(transferId);
        nodes.add(node7);
        TransferManifestNormalNode node8 = this.createFolderNode(transferId);
        nodes.add(node8);
        TransferManifestNormalNode node9 = this.createFolderNode(transferId);
        nodes.add(node9);
        TransferManifestNormalNode node10 = this.createFolderNode(transferId);
        nodes.add(node10);
        TransferManifestNormalNode node11 = this.createFolderNode(transferId);
        nodes.add(node11);
        TransferManifestNormalNode node12 = this.createFolderNode(transferId);
        nodes.add(node12);
        this.associatePeers(node1, node2);
        this.moveNode(node2, node11);
        this.endTransaction();
        String snapshot = this.createSnapshot(nodes);
        this.startNewTransaction();
        this.receiver.saveSnapshot(transferId, (InputStream)new StringInputStream(snapshot, "UTF-8"));
        this.endTransaction();
        for (TransferManifestNode node : nodes) {
            this.startNewTransaction();
            this.receiver.saveContent(transferId, node.getUuid(), new ByteArrayInputStream(this.dummyContentBytes));
            this.endTransaction();
        }
        this.startNewTransaction();
        this.receiver.commitAsync(transferId);
        this.endTransaction();
        log.debug((Object)"Posted request for commit");
        TransferProgressMonitor progressMonitor = this.receiver.getProgressMonitor();
        TransferProgress progress = null;
        while (progress == null || !TransferProgress.getTerminalStatuses().contains((Object)progress.getStatus())) {
            Thread.sleep(500L);
            this.startNewTransaction();
            progress = progressMonitor.getProgress(transferId);
            this.endTransaction();
            log.debug((Object)("Progress indication: " + (Object)((Object)progress.getStatus()) + ": " + progress.getCurrentPosition() + "/" + progress.getEndPosition()));
        }
        RepoTransferReceiverImplTest.assertEquals((Object)((Object)TransferProgress.Status.COMPLETE), (Object)((Object)progress.getStatus()));
        this.startNewTransaction();
        try {
            RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.getAspects(node1.getNodeRef()).contains(ContentModel.ASPECT_ATTACHABLE));
            RepoTransferReceiverImplTest.assertFalse((boolean)this.nodeService.getSourceAssocs(node2.getNodeRef(), (QNamePattern)ContentModel.ASSOC_ATTACHMENTS).isEmpty());
            for (TransferManifestNode node : nodes) {
                RepoTransferReceiverImplTest.assertTrue((boolean)this.nodeService.exists(node.getNodeRef()));
            }
            Object var21_20 = null;
        }
        catch (Throwable throwable) {
            Object var21_21 = null;
            this.endTransaction();
            throw throwable;
        }
        this.endTransaction();
    }

    private TransferManifestDeletedNode createDeletedNode(TransferManifestNode nodeToDelete) {
        TransferManifestDeletedNode deletedNode = new TransferManifestDeletedNode();
        deletedNode.setNodeRef(nodeToDelete.getNodeRef());
        deletedNode.setParentPath(nodeToDelete.getParentPath());
        deletedNode.setPrimaryParentAssoc(nodeToDelete.getPrimaryParentAssoc());
        deletedNode.setUuid(nodeToDelete.getUuid());
        return deletedNode;
    }

    private void moveNode(TransferManifestNormalNode childNode, TransferManifestNormalNode newParent) {
        List<ChildAssociationRef> currentParents = childNode.getParentAssocs();
        ArrayList<ChildAssociationRef> newParents = new ArrayList<ChildAssociationRef>();
        for (ChildAssociationRef parent : currentParents) {
            if (!parent.isPrimary()) {
                newParents.add(parent);
                continue;
            }
            ChildAssociationRef newPrimaryAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, newParent.getNodeRef(), parent.getQName(), parent.getChildRef(), true, -1);
            newParents.add(newPrimaryAssoc);
            childNode.setPrimaryParentAssoc(newPrimaryAssoc);
            Path newParentPath = new Path();
            newParentPath.append(newParent.getParentPath());
            newParentPath.append((Path.Element)new Path.ChildAssocElement(newParent.getPrimaryParentAssoc()));
            childNode.setParentPath(newParentPath);
        }
        childNode.setParentAssocs(newParents);
    }

    private void associatePeers(TransferManifestNormalNode source, TransferManifestNormalNode target) {
        Set<QName> aspects;
        List<AssociationRef> currentRefereePeers;
        List<AssociationRef> currentReferencedPeers = source.getTargetAssocs();
        if (currentReferencedPeers == null) {
            currentReferencedPeers = new ArrayList<AssociationRef>();
            source.setTargetAssocs(currentReferencedPeers);
        }
        if ((currentRefereePeers = target.getSourceAssocs()) == null) {
            currentRefereePeers = new ArrayList<AssociationRef>();
            target.setSourceAssocs(currentRefereePeers);
        }
        if ((aspects = source.getAspects()) == null) {
            aspects = new HashSet<QName>();
            source.setAspects(aspects);
        }
        aspects.add(ContentModel.ASPECT_ATTACHABLE);
        AssociationRef newAssoc = new AssociationRef(null, source.getNodeRef(), ContentModel.ASSOC_ATTACHMENTS, target.getNodeRef());
        currentRefereePeers.add(newAssoc);
        currentReferencedPeers.add(newAssoc);
    }

    private String createSnapshot(List<TransferManifestNode> nodes) throws Exception {
        XMLTransferManifestWriter manifestWriter = new XMLTransferManifestWriter();
        StringWriter output = new StringWriter();
        manifestWriter.startTransferManifest(output);
        TransferManifestHeader header = new TransferManifestHeader();
        header.setCreatedDate(new Date());
        header.setNodeCount(nodes.size());
        header.setRepositoryId("repo 1");
        manifestWriter.writeTransferManifestHeader(header);
        for (TransferManifestNode node : nodes) {
            manifestWriter.writeTransferManifestNode(node);
        }
        manifestWriter.endTransferManifest();
        return output.toString();
    }

    private TransferManifestNormalNode createContentNode(String transferId) throws Exception {
        TransferManifestNormalNode node = new TransferManifestNormalNode();
        String uuid = GUID.generate();
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, uuid);
        node.setNodeRef(nodeRef);
        node.setUuid(uuid);
        byte[] dummyContent = "This is some dummy content.".getBytes("UTF-8");
        node.setType(ContentModel.TYPE_CONTENT);
        NodeRef parentFolder = this.guestHome;
        String nodeName = uuid + ".testnode" + this.getNameSuffix();
        ArrayList<ChildAssociationRef> parents = new ArrayList<ChildAssociationRef>();
        ChildAssociationRef primaryAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, parentFolder, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)nodeName), node.getNodeRef(), true, -1);
        parents.add(primaryAssoc);
        node.setParentAssocs(parents);
        node.setParentPath(this.nodeService.getPath(parentFolder));
        node.setPrimaryParentAssoc(primaryAssoc);
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        props.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)uuid));
        props.put(ContentModel.PROP_NAME, (Serializable)((Object)nodeName));
        ContentData contentData = new ContentData("/" + uuid, "text/plain", (long)dummyContent.length, "UTF-8");
        props.put(ContentModel.PROP_CONTENT, (Serializable)contentData);
        node.setProperties(props);
        return node;
    }

    private TransferManifestNormalNode createFolderNode(String transferId) throws Exception {
        NodeRef guestHome;
        TransferManifestNormalNode node = new TransferManifestNormalNode();
        String uuid = GUID.generate();
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, uuid);
        node.setNodeRef(nodeRef);
        node.setUuid(uuid);
        node.setType(ContentModel.TYPE_FOLDER);
        String guestHomeQuery = "/app:company_home/app:guest_home";
        ResultSet guestHomeResult = this.searchService.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "xpath", guestHomeQuery);
        RepoTransferReceiverImplTest.assertEquals((String)"", (int)1, (int)guestHomeResult.length());
        NodeRef parentFolder = guestHome = guestHomeResult.getNodeRef(0);
        String nodeName = uuid + ".folder" + this.getNameSuffix();
        ArrayList<ChildAssociationRef> parents = new ArrayList<ChildAssociationRef>();
        ChildAssociationRef primaryAssoc = new ChildAssociationRef(ContentModel.ASSOC_CONTAINS, parentFolder, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)nodeName), node.getNodeRef(), true, -1);
        parents.add(primaryAssoc);
        node.setParentAssocs(parents);
        node.setParentPath(this.nodeService.getPath(parentFolder));
        node.setPrimaryParentAssoc(primaryAssoc);
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        props.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)uuid));
        props.put(ContentModel.PROP_NAME, (Serializable)((Object)nodeName));
        node.setProperties(props);
        return node;
    }

    private String getNameSuffix() {
        return "" + fileCount++;
    }
}

