/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer.manifest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transfer.manifest.TestTransferManifestProcessor;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNode;
import org.alfresco.repo.transfer.manifest.TransferManifestNodeFactoryImpl;
import org.alfresco.repo.transfer.manifest.TransferManifestNodeHelper;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.repo.transfer.manifest.XMLTransferManifestReader;
import org.alfresco.repo.transfer.manifest.XMLTransferManifestWriter;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.transfer.TransferService;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.TempFileProvider;
import org.xml.sax.helpers.DefaultHandler;

public class ManifestIntegrationTest
extends BaseAlfrescoSpringTest {
    private TransferService transferService;
    private PermissionService permissionService;
    private ContentService contentService;

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.transferService = (TransferService)this.applicationContext.getBean("TransferService");
        this.contentService = (ContentService)this.applicationContext.getBean("ContentService");
        this.permissionService = (PermissionService)this.applicationContext.getBean("PermissionService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSnapshot() throws Exception {
        String snapshotMe;
        block8: {
            String CONTENT_STRING = "hello world";
            Locale CONTENT_LOCALE = Locale.TAIWAN;
            String CONTENT_TITLE = "the title";
            String CONTENT_NAME = "&the name <\\*";
            String CONTENT_ASSOC_NAME = "&hell+-1we";
            snapshotMe = "snapshotMe";
            String title = "title";
            String description = "description";
            String endpointProtocol = "http";
            String endpointHost = "localhost";
            int endpointPort = 8080;
            String endpointPath = "rhubarb";
            String username = "admin";
            char[] password = "password".toCharArray();
            HashMap<NodeRef, TransferManifestNode> sentNodes = new HashMap<NodeRef, TransferManifestNode>();
            TransferManifestNodeFactoryImpl nodeFactory = new TransferManifestNodeFactoryImpl();
            nodeFactory.setNodeService(this.nodeService);
            nodeFactory.setPermissionService(this.permissionService);
            TransferTarget target = this.transferService.createAndSaveTransferTarget(snapshotMe, title, description, endpointProtocol, endpointHost, endpointPort, endpointPath, username, password);
            File snapshotFile = null;
            try {
                ChildAssociationRef child = this.nodeService.createNode(target.getNodeRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)CONTENT_ASSOC_NAME), ContentModel.TYPE_CONTENT);
                NodeRef childNodeRef = child.getChildRef();
                ContentWriter writer = this.contentService.getWriter(childNodeRef, ContentModel.PROP_CONTENT, true);
                writer.setLocale(CONTENT_LOCALE);
                writer.putContent(CONTENT_STRING);
                this.nodeService.setProperty(childNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)CONTENT_TITLE));
                this.nodeService.setProperty(childNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)CONTENT_NAME));
                snapshotFile = TempFileProvider.createTempFile((String)"xxx", (String)".xml");
                FileWriter snapshotWriter = new FileWriter(snapshotFile);
                HashSet<NodeRef> nodes = new HashSet<NodeRef>();
                nodes.add(this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE));
                nodes.add(target.getNodeRef());
                nodes.add(childNodeRef);
                XMLTransferManifestWriter formatter = new XMLTransferManifestWriter();
                TransferManifestHeader header = new TransferManifestHeader();
                header.setNodeCount(nodes.size());
                header.setCreatedDate(new Date());
                formatter.startTransferManifest(snapshotWriter);
                formatter.writeTransferManifestHeader(header);
                for (NodeRef nodeRef : nodes) {
                    TransferManifestNode node = nodeFactory.createTransferManifestNode(nodeRef, null);
                    formatter.writeTransferManifestNode(node);
                    sentNodes.put(nodeRef, node);
                }
                formatter.endTransferManifest();
                snapshotWriter.close();
                ManifestIntegrationTest.outputFile(snapshotFile);
                TestTransferManifestProcessor processor = new TestTransferManifestProcessor();
                XMLTransferManifestReader reader = new XMLTransferManifestReader(processor);
                SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                SAXParser parser = saxParserFactory.newSAXParser();
                parser.parse(snapshotFile, (DefaultHandler)reader);
                ManifestIntegrationTest.assertEquals((String)"did not get back the same number of nodes", (int)nodes.size(), (int)processor.getNodes().size());
                ManifestIntegrationTest.assertNotNull((String)"header is null", (Object)processor.getHeader());
                for (NodeRef nodeId : nodes) {
                    System.out.println("Processing node:" + nodeId);
                    TransferManifestNormalNode readNode = (TransferManifestNormalNode)processor.getNodes().get(nodeId);
                    TransferManifestNormalNode writeNode = (TransferManifestNormalNode)sentNodes.get(nodeId);
                    ManifestIntegrationTest.assertNotNull((String)"readNode is null", (Object)readNode);
                    ManifestIntegrationTest.assertNotNull((String)"writeNode is null", (Object)writeNode);
                    ManifestIntegrationTest.assertEquals((String)"type is different", (Object)writeNode.getType(), (Object)readNode.getType());
                    ManifestIntegrationTest.assertEquals((String)"nodeRef is different", (Object)writeNode.getNodeRef(), (Object)readNode.getNodeRef());
                    ManifestIntegrationTest.assertEquals((String)"parent node ref is different", (Object)writeNode.getPrimaryParentAssoc(), (Object)readNode.getPrimaryParentAssoc());
                    if (writeNode.getParentPath() != null) {
                        ManifestIntegrationTest.assertEquals((String)"parent path is different", (String)writeNode.getParentPath().toString(), (String)readNode.getParentPath().toString());
                    }
                    ManifestIntegrationTest.assertEquals((String)"aspects array different size", (int)writeNode.getAspects().size(), (int)readNode.getAspects().size());
                    for (QName aspect : writeNode.getAspects()) {
                        ManifestIntegrationTest.assertTrue((String)"missing aspect", (boolean)readNode.getAspects().contains(aspect));
                    }
                    ManifestIntegrationTest.assertEquals((String)"properties array different size", (int)writeNode.getProperties().size(), (int)readNode.getProperties().size());
                    for (QName prop : writeNode.getProperties().keySet()) {
                        ManifestIntegrationTest.assertTrue((String)"missing property", (boolean)readNode.getProperties().containsKey(prop));
                    }
                    ManifestIntegrationTest.assertEquals((String)"child assocs different", (int)writeNode.getChildAssocs().size(), (int)readNode.getChildAssocs().size());
                    ManifestIntegrationTest.assertEquals((String)"parent assocs different", (int)writeNode.getParentAssocs().size(), (int)readNode.getParentAssocs().size());
                    ManifestIntegrationTest.assertEquals((String)"source assocs different", (int)writeNode.getSourceAssocs().size(), (int)readNode.getSourceAssocs().size());
                    ManifestIntegrationTest.assertEquals((String)"target assocs different", (int)writeNode.getTargetAssocs().size(), (int)readNode.getTargetAssocs().size());
                    if (!readNode.getNodeRef().equals((Object)childNodeRef)) continue;
                    ContentData data = (ContentData)readNode.getProperties().get(ContentModel.PROP_CONTENT);
                    ManifestIntegrationTest.assertEquals((String)"content data wrong size", (long)data.getSize(), (long)CONTENT_STRING.length());
                    ManifestIntegrationTest.assertEquals((String)"content locale wrong", (Object)data.getLocale(), (Object)CONTENT_LOCALE);
                    String childTitle = (String)((Object)readNode.getProperties().get(ContentModel.PROP_TITLE));
                    ManifestIntegrationTest.assertEquals((String)"content title wrong", (String)childTitle, (String)CONTENT_TITLE);
                    String childName = (String)((Object)readNode.getProperties().get(ContentModel.PROP_NAME));
                    ManifestIntegrationTest.assertEquals((String)"content name wrong", (String)childName, (String)CONTENT_NAME);
                    ManifestIntegrationTest.assertTrue((String)"one parent assoc", (readNode.getParentAssocs().size() == 1 ? 1 : 0) != 0);
                    ManifestIntegrationTest.assertTrue((String)"isPrimary", (boolean)readNode.getParentAssocs().get(0).isPrimary());
                    ManifestIntegrationTest.assertEquals((String)"parent q name", (Object)readNode.getParentAssocs().get(0).getQName(), (Object)QName.createQName((String)CONTENT_ASSOC_NAME));
                    ManifestIntegrationTest.assertEquals((String)"parent type q name", (Object)readNode.getParentAssocs().get(0).getTypeQName(), (Object)ContentModel.ASSOC_CONTAINS);
                    ManifestIntegrationTest.assertEquals((String)"child node ref", (Object)readNode.getParentAssocs().get(0).getChildRef(), (Object)childNodeRef);
                    ManifestIntegrationTest.assertEquals((String)"parent node ref", (Object)readNode.getParentAssocs().get(0).getParentRef(), (Object)target.getNodeRef());
                    ManifestIntegrationTest.assertTrue((String)"zero child assoc", (readNode.getChildAssocs().size() == 0 ? 1 : 0) != 0);
                    ManifestIntegrationTest.assertEquals((Object)readNode.getParentAssocs().get(0), (Object)TransferManifestNodeHelper.getPrimaryParentAssoc(readNode));
                    Set<ContentData> content = TransferManifestNodeHelper.getContentData(readNode);
                    ManifestIntegrationTest.assertEquals((String)"content not found", (int)content.size(), (int)1);
                }
                Object var39_38 = null;
                if (snapshotFile == null) break block8;
                snapshotFile.delete();
            }
            catch (Throwable throwable) {
                Object var39_39 = null;
                if (snapshotFile != null) {
                    snapshotFile.delete();
                }
                this.transferService.deleteTransferTarget(snapshotMe);
                throw throwable;
            }
            {
            }
        }
        this.transferService.deleteTransferTarget(snapshotMe);
    }

    private static void outputFile(File file) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String s = reader.readLine();
        while (s != null) {
            System.out.println(s);
            s = reader.readLine();
        }
    }
}

