/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.version.BaseVersionStoreTest;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.Version2ServiceImpl;
import org.alfresco.repo.version.VersionableAspect;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionServiceImplTest
extends BaseVersionStoreTest {
    private static Log logger = LogFactory.getLog(VersionServiceImplTest.class);
    private static final String UPDATED_VALUE_1 = "updatedValue1";
    private static final String UPDATED_VALUE_2 = "updatedValue2";
    private static final String UPDATED_VALUE_3 = "updatedValue3";
    private static final String UPDATED_CONTENT_1 = "updatedContent1";
    private static final String UPDATED_CONTENT_2 = "updatedContent2";
    private static final String PWD_A = "passA";
    private static final String USER_NAME_A = "userA";

    public void testSetup() {
    }

    public void testCreateIntialVersion() {
        NodeRef versionableNode = this.createNewVersionableNode();
        this.createVersion(versionableNode);
    }

    public void testCreateManyVersionsSameWorkspace() {
        NodeRef versionableNode = this.createNewVersionableNode();
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
        VersionHistory vh = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNotNull((Object)vh);
        VersionServiceImplTest.assertEquals((int)3, (int)vh.getAllVersions().size());
    }

    public void testCreateManyVersionsWithNullVersionProperties() {
        this.versionProperties = null;
        NodeRef versionableNode = this.createNewVersionableNode();
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
        VersionHistory vh = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNotNull((Object)vh);
        VersionServiceImplTest.assertEquals((int)3, (int)vh.getAllVersions().size());
    }

    public void testCreateInitialVersionWhenNotVersionable() {
        NodeRef node = this.createNewNode();
        this.createVersion(node);
    }

    public void testVersioningChildren() {
        NodeRef versionableNode = this.createNewVersionableNode();
        String expectedVersionLabel = this.peekNextVersionLabel(versionableNode, this.versionProperties);
        long beforeVersionTime = ((Date)this.nodeService.getProperty(versionableNode, ContentModel.PROP_CREATED)).getTime();
        Collection<Version> versions = this.versionService.createVersion(versionableNode, this.versionProperties, true);
        this.CheckVersionCollection(expectedVersionLabel, beforeVersionTime, versions);
    }

    public void testVersioningManyNodes() {
        NodeRef versionableNode = this.createNewVersionableNode();
        String expectedVersionLabel = this.peekNextVersionLabel(versionableNode, this.versionProperties);
        long beforeVersionTime = ((Date)this.nodeService.getProperty(versionableNode, ContentModel.PROP_CREATED)).getTime();
        Collection<Version> versions = this.versionService.createVersion(this.versionableNodes.values(), (Map<String, Serializable>)this.versionProperties);
        this.CheckVersionCollection(expectedVersionLabel, beforeVersionTime, versions);
    }

    private void CheckVersionCollection(String expectedVersionLabel, long beforeVersionTime, Collection<Version> versions) {
        for (Version version : versions) {
            String frozenNodeId = null;
            if (this.versionService.getVersionStoreReference().getIdentifier().equals("version2Store")) {
                frozenNodeId = ((NodeRef)version.getVersionProperty("frozenNodeRef")).getId();
            } else if (this.versionService.getVersionStoreReference().getIdentifier().equals("lightWeightVersionStore")) {
                frozenNodeId = (String)((Object)version.getVersionProperty("frozenNodeId"));
            }
            VersionServiceImplTest.assertNotNull((String)"Unable to retrieve the frozen node id from the created version.", (Object)frozenNodeId);
            NodeRef originalNodeRef = (NodeRef)this.versionableNodes.get(frozenNodeId);
            VersionServiceImplTest.assertNotNull((String)"The versionable node ref that relates to the frozen node id can not be found.", (Object)originalNodeRef);
            this.checkNewVersion(beforeVersionTime, expectedVersionLabel, version, originalNodeRef);
        }
    }

    private void CheckVersionHistory(VersionHistory vh, List<Version> expectedVersions) {
        if (vh == null) {
            VersionServiceImplTest.assertNull(expectedVersions);
        } else {
            Iterator<Version> itr = expectedVersions.iterator();
            for (Version version : vh.getAllVersions()) {
                Version expectedVersion = itr.next();
                VersionServiceImplTest.assertEquals((String)version.getVersionLabel(), (String)expectedVersion.getVersionLabel());
                VersionServiceImplTest.assertEquals((Object)version.getFrozenStateNodeRef(), (Object)expectedVersion.getFrozenStateNodeRef());
            }
            VersionServiceImplTest.assertFalse((boolean)itr.hasNext());
        }
    }

    public void testNoVersionHistory() {
        NodeRef nodeRef = this.createNewVersionableNode();
        VersionHistory vh = this.versionService.getVersionHistory(nodeRef);
        VersionServiceImplTest.assertNull((Object)vh);
    }

    public void testGetVersionHistorySameWorkspace() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version1 = this.addToVersionHistory(versionableNode, null);
        Version version2 = this.addToVersionHistory(versionableNode, version1);
        Version version3 = this.addToVersionHistory(versionableNode, version2);
        Version version4 = this.addToVersionHistory(versionableNode, version3);
        this.addToVersionHistory(versionableNode, version4);
    }

    private Version addToVersionHistory(NodeRef versionableNode, Version parentVersion) {
        Version createdVersion = this.createVersion(versionableNode);
        VersionHistory vh = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNotNull((String)"The version history should not be null since we know we have versioned this node.", (Object)vh);
        if (parentVersion == null) {
            Version root = vh.getRootVersion();
            VersionServiceImplTest.assertNotNull((String)"The root version should never be null, since every version history ust have a root version.", (Object)root);
            VersionServiceImplTest.assertEquals((String)createdVersion.getVersionLabel(), (String)root.getVersionLabel());
        }
        Version version = vh.getVersion(createdVersion.getVersionLabel());
        VersionServiceImplTest.assertNotNull((Object)version);
        VersionServiceImplTest.assertEquals((String)createdVersion.getVersionLabel(), (String)version.getVersionLabel());
        Collection<Version> suc = vh.getSuccessors(version);
        VersionServiceImplTest.assertNotNull(suc);
        VersionServiceImplTest.assertEquals((int)0, (int)suc.size());
        Version pre = vh.getPredecessor(version);
        if (parentVersion == null) {
            VersionServiceImplTest.assertNull((Object)pre);
        } else {
            VersionServiceImplTest.assertNotNull((Object)pre);
            VersionServiceImplTest.assertEquals((String)parentVersion.getVersionLabel(), (String)pre.getVersionLabel());
        }
        if (parentVersion != null) {
            Collection<Version> parentSuc = vh.getSuccessors(parentVersion);
            VersionServiceImplTest.assertNotNull(parentSuc);
            VersionServiceImplTest.assertEquals((int)1, (int)parentSuc.size());
            Version tempVersion = (Version)parentSuc.toArray()[0];
            VersionServiceImplTest.assertEquals((String)version.getVersionLabel(), (String)tempVersion.getVersionLabel());
        }
        return createdVersion;
    }

    public void testRevert() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Set origAspects = this.dbNodeService.getAspects(versionableNode);
        Version version1 = this.createVersion(versionableNode);
        this.dbNodeService.setProperty(versionableNode, PROP_1, (Serializable)((Object)UPDATED_VALUE_1));
        this.dbNodeService.setProperty(versionableNode, PROP_2, null);
        ContentWriter contentWriter = this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
        VersionServiceImplTest.assertNotNull((Object)contentWriter);
        contentWriter.putContent(UPDATED_CONTENT_1);
        this.dbNodeService.addAspect(versionableNode, ApplicationModel.ASPECT_SIMPLE_WORKFLOW, null);
        Set origAspects2 = this.dbNodeService.getAspects(versionableNode);
        Version version2 = this.createVersion(versionableNode);
        this.dbNodeService.setProperty(versionableNode, PROP_1, (Serializable)((Object)UPDATED_VALUE_2));
        this.dbNodeService.setProperty(versionableNode, PROP_2, (Serializable)((Object)UPDATED_VALUE_3));
        this.dbNodeService.setProperty(versionableNode, PROP_3, null);
        ContentWriter contentWriter2 = this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
        VersionServiceImplTest.assertNotNull((Object)contentWriter2);
        contentWriter2.putContent(UPDATED_CONTENT_2);
        String versionLabel = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        this.versionService.revert(versionableNode);
        VersionServiceImplTest.assertEquals((Object)versionLabel, (Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertEquals((Object)UPDATED_VALUE_1, (Object)this.dbNodeService.getProperty(versionableNode, PROP_1));
        VersionServiceImplTest.assertNull((Object)this.dbNodeService.getProperty(versionableNode, PROP_2));
        VersionServiceImplTest.assertEquals((Object)"value3", (Object)this.dbNodeService.getProperty(versionableNode, PROP_3));
        ContentReader contentReader1 = this.contentService.getReader(versionableNode, ContentModel.PROP_CONTENT);
        VersionServiceImplTest.assertNotNull((Object)contentReader1);
        VersionServiceImplTest.assertEquals((String)UPDATED_CONTENT_1, (String)contentReader1.getContentString());
        Set aspects1 = this.dbNodeService.getAspects(versionableNode);
        VersionServiceImplTest.assertEquals((int)aspects1.size(), (int)origAspects2.size());
        this.versionService.revert(versionableNode, version1);
        VersionServiceImplTest.assertEquals((Object)versionLabel, (Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertEquals((Object)"value1", (Object)this.dbNodeService.getProperty(versionableNode, PROP_1));
        VersionServiceImplTest.assertEquals((Object)"value2", (Object)this.dbNodeService.getProperty(versionableNode, PROP_2));
        VersionServiceImplTest.assertEquals((Object)"value3", (Object)this.dbNodeService.getProperty(versionableNode, PROP_3));
        ContentReader contentReader2 = this.contentService.getReader(versionableNode, ContentModel.PROP_CONTENT);
        VersionServiceImplTest.assertNotNull((Object)contentReader2);
        VersionServiceImplTest.assertEquals((String)"This is the versioned test content.", (String)contentReader2.getContentString());
        Set aspects2 = this.dbNodeService.getAspects(versionableNode);
        VersionServiceImplTest.assertEquals((int)aspects2.size(), (int)origAspects.size());
        VersionServiceImplTest.assertEquals((Object)versionLabel, (Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
    }

    public void testRestore() {
        try {
            this.versionService.restore(new NodeRef(this.testStoreRef, "123"), this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNode"));
            VersionServiceImplTest.fail((String)"An exception should have been raised since this node has no version history.");
        }
        catch (VersionServiceException exception) {
            // empty catch block
        }
        NodeRef versionableNode = this.createNewVersionableNode();
        Set origAspects = this.dbNodeService.getAspects(versionableNode);
        try {
            this.versionService.restore(versionableNode, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNode"));
            VersionServiceImplTest.fail((String)"An exception should have been raised since this node exists and you can't restore a node that exists.");
        }
        catch (VersionServiceException exception) {
            // empty catch block
        }
        this.versionService.createVersion(versionableNode, null);
        this.dbNodeService.deleteNode(versionableNode);
        VersionServiceImplTest.assertFalse((boolean)this.dbNodeService.exists(versionableNode));
        NodeRef restoredNode = this.versionService.restore(versionableNode, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNode"));
        VersionServiceImplTest.assertNotNull((Object)restoredNode);
        VersionServiceImplTest.assertTrue((boolean)this.dbNodeService.exists(restoredNode));
        VersionServiceImplTest.assertEquals((Object)"value1", (Object)this.dbNodeService.getProperty(restoredNode, PROP_1));
        VersionServiceImplTest.assertEquals((Object)"value2", (Object)this.dbNodeService.getProperty(restoredNode, PROP_2));
        VersionServiceImplTest.assertEquals((Object)"value3", (Object)this.dbNodeService.getProperty(restoredNode, PROP_3));
        ContentReader contentReader2 = this.contentService.getReader(restoredNode, ContentModel.PROP_CONTENT);
        VersionServiceImplTest.assertNotNull((Object)contentReader2);
        VersionServiceImplTest.assertEquals((String)"This is the versioned test content.", (String)contentReader2.getContentString());
        Set aspects2 = this.dbNodeService.getAspects(restoredNode);
        VersionServiceImplTest.assertEquals((int)aspects2.size(), (int)origAspects.size());
    }

    public void testDeleteVersionHistory() {
        NodeRef versionableNode = this.createNewVersionableNode();
        VersionHistory versionHistory1 = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNull((Object)versionHistory1);
        this.createVersion(versionableNode);
        Version version1 = this.createVersion(versionableNode);
        String versionLabel1 = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertNotNull((Object)versionLabel1);
        VersionServiceImplTest.assertEquals((String)version1.getVersionLabel(), (String)versionLabel1);
        VersionHistory versionHistory2 = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNotNull((Object)versionHistory2);
        VersionServiceImplTest.assertEquals((int)2, (int)versionHistory2.getAllVersions().size());
        this.versionService.deleteVersionHistory(versionableNode);
        VersionHistory versionHistory3 = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNull((Object)versionHistory3);
        String versionLabel2 = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertNull((Object)versionLabel2);
        this.createVersion(versionableNode);
        Version version2 = this.createVersion(versionableNode);
        VersionHistory versionHistory4 = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNotNull((Object)versionHistory4);
        VersionServiceImplTest.assertEquals((int)2, (int)versionHistory4.getAllVersions().size());
        String versionLabel3 = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertNotNull((Object)versionLabel3);
        VersionServiceImplTest.assertEquals((String)version2.getVersionLabel(), (String)versionLabel3);
    }

    public void testDeleteVersion() {
        NodeRef versionableNode = this.createNewVersionableNode();
        VersionHistory versionHistory = this.versionService.getVersionHistory(versionableNode);
        this.CheckVersionHistory(versionHistory, null);
        String versionLabel = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertNull((Object)versionLabel);
        Version version = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertNull((Object)version);
        Version version0 = this.createVersion(versionableNode);
        Version version1 = this.createVersion(versionableNode);
        String versionLabel1 = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertEquals((String)"1.1", (String)versionLabel1);
        VersionServiceImplTest.assertEquals((String)version1.getVersionLabel(), (String)versionLabel1);
        ArrayList<Version> expectedVersions = new ArrayList<Version>(2);
        expectedVersions.add(version1);
        expectedVersions.add(version0);
        versionHistory = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
        this.CheckVersionHistory(versionHistory, expectedVersions);
        Version currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)currentVersion.getVersionLabel(), (String)version1.getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)currentVersion.getFrozenStateNodeRef(), (Object)version1.getFrozenStateNodeRef());
        Version version2 = this.createVersion(versionableNode);
        Version version3 = this.createVersion(versionableNode);
        String versionLabel3 = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertEquals((String)"1.3", (String)versionLabel3);
        VersionServiceImplTest.assertEquals((String)version3.getVersionLabel(), (String)versionLabel3);
        expectedVersions = new ArrayList(4);
        expectedVersions.add(version3);
        expectedVersions.add(version2);
        expectedVersions.add(version1);
        expectedVersions.add(version0);
        versionHistory = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)4, (int)versionHistory.getAllVersions().size());
        this.CheckVersionHistory(versionHistory, expectedVersions);
        currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)currentVersion.getVersionLabel(), (String)version3.getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)currentVersion.getFrozenStateNodeRef(), (Object)version3.getFrozenStateNodeRef());
        this.versionService.deleteVersion(versionableNode, version2);
        this.versionService.deleteVersion(versionableNode, version0);
        expectedVersions = new ArrayList(2);
        expectedVersions.add(version3);
        expectedVersions.add(version1);
        versionHistory = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
        this.CheckVersionHistory(versionHistory, expectedVersions);
        currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)currentVersion.getVersionLabel(), (String)version3.getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)currentVersion.getFrozenStateNodeRef(), (Object)version3.getFrozenStateNodeRef());
        this.versionService.deleteVersion(versionableNode, version3);
        expectedVersions = new ArrayList(1);
        expectedVersions.add(version1);
        versionHistory = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
        this.CheckVersionHistory(versionHistory, expectedVersions);
        currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)currentVersion.getVersionLabel(), (String)version1.getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)currentVersion.getFrozenStateNodeRef(), (Object)version1.getFrozenStateNodeRef());
        Version version4 = this.createVersion(versionableNode);
        expectedVersions = new ArrayList(2);
        expectedVersions.add(version4);
        expectedVersions.add(version1);
        versionHistory = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
        this.CheckVersionHistory(versionHistory, expectedVersions);
        currentVersion = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertEquals((String)currentVersion.getVersionLabel(), (String)version4.getVersionLabel());
        VersionServiceImplTest.assertEquals((Object)currentVersion.getFrozenStateNodeRef(), (Object)version4.getFrozenStateNodeRef());
        this.versionService.deleteVersion(versionableNode, version1);
        this.versionService.deleteVersion(versionableNode, version4);
        versionHistory = this.versionService.getVersionHistory(versionableNode);
        this.CheckVersionHistory(versionHistory, null);
        versionLabel = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertNull((Object)versionLabel);
        version = this.versionService.getCurrentVersion(versionableNode);
        VersionServiceImplTest.assertNull((Object)version);
    }

    public void testAutoVersionOnInitialVersionOn() {
        final NodeRef versionableNode = this.createNewVersionableNode();
        this.setComplete();
        this.endTransaction();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                ContentWriter contentWriter = VersionServiceImplTest.this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
                Assert.assertNotNull((Object)contentWriter);
                contentWriter.putContent(VersionServiceImplTest.UPDATED_CONTENT_1);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
    }

    public void testAutoVersionOff() {
        final NodeRef versionableNode = this.createNewVersionableNode();
        this.dbNodeService.setProperty(versionableNode, ContentModel.PROP_AUTO_VERSION, (Serializable)Boolean.valueOf(false));
        this.setComplete();
        this.endTransaction();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                ContentWriter contentWriter = VersionServiceImplTest.this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
                Assert.assertNotNull((Object)contentWriter);
                contentWriter.putContent(VersionServiceImplTest.UPDATED_CONTENT_1);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
    }

    public void testInitialVersionOff() {
        HashMap<QName, Boolean> props = new HashMap<QName, Boolean>();
        props.put(ContentModel.PROP_INITIAL_VERSION, false);
        HashMap<QName, String> props2 = new HashMap<QName, String>();
        props2.put(ContentModel.PROP_NAME, "test.txt");
        final NodeRef nodeRef = this.dbNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNode2"), TEST_TYPE_QNAME, props2).getChildRef();
        this.dbNodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, props);
        this.setComplete();
        this.endTransaction();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(nodeRef);
                Assert.assertNull((Object)versionHistory);
                return null;
            }
        });
    }

    public void testAddRemoveVersionableAspect() {
        HashMap<QName, String> props2 = new HashMap<QName, String>();
        props2.put(ContentModel.PROP_NAME, "test.txt");
        final NodeRef nodeRef = this.dbNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNode2"), TEST_TYPE_QNAME, props2).getChildRef();
        this.dbNodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        this.setComplete();
        this.endTransaction();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(nodeRef);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.dbNodeService.removeAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(nodeRef);
                Assert.assertNull((Object)versionHistory);
                VersionServiceImplTest.this.dbNodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(nodeRef);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
    }

    public void testAutoRemovalOfVersionHistory() {
        StoreRef spacesStoreRef = new StoreRef("workspace", "SpacesStore");
        NodeRef root = this.dbNodeService.getRootNode(spacesStoreRef);
        HashMap<QName, String> props2 = new HashMap<QName, String>();
        props2.put(ContentModel.PROP_NAME, "test-" + GUID.generate() + ".txt");
        final NodeRef nodeRef = this.dbNodeService.createNode(root, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}MyVersionableNode2"), ContentModel.TYPE_CONTENT, props2).getChildRef();
        this.dbNodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        this.setComplete();
        this.endTransaction();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(nodeRef);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.dbNodeService.deleteNode(nodeRef);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                NodeRef archivedNodeRef = VersionServiceImplTest.this.nodeArchiveService.getArchivedNode(nodeRef);
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(archivedNodeRef);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.dbNodeService.deleteNode(archivedNodeRef);
                return null;
            }
        });
        this.txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                NodeRef archivedNodeRef = VersionServiceImplTest.this.nodeArchiveService.getArchivedNode(nodeRef);
                VersionHistory versionHistory12 = VersionServiceImplTest.this.versionService.getVersionHistory(nodeRef);
                Assert.assertNull((Object)versionHistory12);
                VersionHistory versionHistory23 = VersionServiceImplTest.this.versionService.getVersionHistory(archivedNodeRef);
                Assert.assertNull((Object)versionHistory23);
                return null;
            }
        });
    }

    public void testAutoVersionOnUpdatePropsOnly() {
        final NodeRef versionableNode = this.createNewVersionableNode();
        this.dbNodeService.setProperty(versionableNode, ContentModel.PROP_AUTO_VERSION_PROPS, (Serializable)Boolean.valueOf(true));
        this.setComplete();
        this.endTransaction();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_AUTHOR, (Serializable)((Object)"ano author 1"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
        this.startNewTransaction();
        final NodeRef versionableNode2 = this.createNewVersionableNode();
        this.dbNodeService.setProperty(versionableNode2, ContentModel.PROP_AUTO_VERSION_PROPS, (Serializable)Boolean.valueOf(false));
        this.setComplete();
        this.endTransaction();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode2);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode2, ContentModel.PROP_AUTHOR, (Serializable)((Object)"ano author 2"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode2);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
    }

    public void testAutoVersionOnUpdatePropsOnlyWithExcludes() {
        final NodeRef versionableNode = this.createNewVersionableNode();
        this.dbNodeService.setProperty(versionableNode, ContentModel.PROP_AUTO_VERSION_PROPS, (Serializable)Boolean.valueOf(true));
        this.setComplete();
        this.endTransaction();
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_AUTHOR, (Serializable)((Object)"ano author 1"));
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"description 1"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
        VersionableAspect versionableAspect = (VersionableAspect)this.applicationContext.getBean("versionableAspect");
        ArrayList<String> excludedOnUpdateProps = new ArrayList<String>(1);
        excludedOnUpdateProps.add(ContentModel.PROP_AUTHOR.toPrefixString());
        versionableAspect.setExcludedOnUpdateProps(excludedOnUpdateProps);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_AUTHOR, (Serializable)((Object)"ano author 2"));
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"description 2"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                VersionServiceImplTest.this.nodeService.setProperty(versionableNode, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"description 3"));
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)3, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
    }

    public void testAR807() {
        QName prop = QName.createQName((String)"http://www.alfresco.org/test/versionstorebasetest/1.0", (String)"intProp");
        ChildAssociationRef childAssociation = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/versionstorebasetest/1.0", (String)"integerTest"), TEST_TYPE_QNAME);
        NodeRef newNode = childAssociation.getChildRef();
        this.nodeService.setProperty(newNode, prop, (Serializable)Integer.valueOf(1));
        Serializable editionCode = this.nodeService.getProperty(newNode, prop);
        VersionServiceImplTest.assertEquals(editionCode.getClass(), Integer.class);
        HashMap<String, Serializable> versionProps = new HashMap<String, Serializable>(1);
        versionProps.put("versionType", (Serializable)((Object)VersionType.MAJOR));
        Version version = this.versionService.createVersion(newNode, versionProps);
        NodeRef versionNodeRef = version.getFrozenStateNodeRef();
        VersionServiceImplTest.assertNotNull((Object)versionNodeRef);
        Serializable editionCodeArchive = this.nodeService.getProperty(versionNodeRef, prop);
        VersionServiceImplTest.assertEquals(editionCodeArchive.getClass(), Integer.class);
    }

    public void testHasPermission() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        if (!this.authenticationDAO.userExists(USER_NAME_A)) {
            this.authenticationService.createAuthentication(USER_NAME_A, PWD_A.toCharArray());
        }
        this.permissionService.setPermission(this.rootNodeRef, "GROUP_EVERYONE", "Read", true);
        this.permissionService.setInheritParentPermissions(this.rootNodeRef, true);
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version = this.createVersion(versionableNode, this.versionProperties);
        NodeRef versionNodeRef = version.getFrozenStateNodeRef();
        VersionServiceImplTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(versionNodeRef, "Read"));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NAME_A);
        VersionServiceImplTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(versionNodeRef, "Read"));
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.permissionService.setInheritParentPermissions(versionableNode, false);
        VersionServiceImplTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(versionNodeRef, "Read"));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NAME_A);
        VersionServiceImplTest.assertEquals((Object)AccessStatus.DENIED, (Object)this.permissionService.hasPermission(versionNodeRef, "Read"));
    }

    public void testALF_3962() {
        NodeRef versionableNode = this.createNode(true, QName.createQName((String)"http://www.alfresco.org/model/action/1.0", (String)"action"));
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
        Collection<Version> versions = this.versionService.getVersionHistory(versionableNode).getAllVersions();
        for (Version version : versions) {
            NodeRef versionNodeRef = new NodeRef("workspace", version.getFrozenStateNodeRef().getStoreRef().getIdentifier(), version.getFrozenStateNodeRef().getId());
            this.dbNodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_VERSION_LABEL, (Serializable)((Object)"0"));
        }
        this.nodeService.setProperty(versionableNode, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)"0"));
        this.versionService.createVersion(versionableNode, (Map<String, Serializable>)this.versionProperties);
        versions = this.versionService.getVersionHistory(versionableNode).getAllVersions();
        for (Version version : versions) {
            VersionServiceImplTest.assertFalse((boolean)version.getVersionLabel().equals("0"));
        }
        VersionServiceImplTest.assertFalse((boolean)this.nodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL).toString().equals("0"));
    }

    public static void main(String ... args) {
        try {
            VersionServiceImplTest.doMain(args);
            System.exit(1);
        }
        catch (Throwable e) {
            logger.error((Object)e);
            System.exit(1);
        }
    }

    private static void doMain(String ... args) {
        long start;
        if (args.length != 1) {
            System.out.println("Usage: VersionServiceImplTest fileCount");
            System.exit(1);
        }
        int fileCount = Integer.parseInt(args[0]);
        ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        FileFolderService fileFolderService = serviceRegistry.getFileFolderService();
        NodeService nodeService = serviceRegistry.getNodeService();
        VersionService versionService = serviceRegistry.getVersionService();
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        authenticationComponent.setSystemUserAsCurrentUser();
        Version2ServiceImpl version2ServiceImpl = (Version2ServiceImpl)ctx.getBean("versionService");
        version2ServiceImpl.setOnlyUseDeprecatedV1(true);
        System.out.println("Using: " + versionService.getVersionStoreReference());
        StoreRef storeRef = new StoreRef("test", "VersionServiceImplTest-main-" + System.currentTimeMillis());
        if (!nodeService.exists(storeRef)) {
            nodeService.createStore(storeRef.getProtocol(), storeRef.getIdentifier());
        }
        NodeRef rootNodeRef = nodeService.getRootNode(storeRef);
        NodeRef folderNodeRef = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"test", (String)"versionMain"), ContentModel.TYPE_FOLDER).getChildRef();
        int count = 0;
        long lastReport = start = System.currentTimeMillis();
        for (int i = 0; i < fileCount; ++i) {
            fileFolderService.create(folderNodeRef, "file-" + i, ContentModel.TYPE_CONTENT);
            ++count;
            long now = System.currentTimeMillis();
            if (now - lastReport <= 10000L) continue;
            long delta = now - start;
            double average = (double)delta / (double)count;
            System.out.println("File Creation: \n   Count:        " + count + " of " + fileCount + "\n" + "   Average (ms): " + average);
            lastReport = now;
        }
        List<FileInfo> files = fileFolderService.listFiles(folderNodeRef);
        count = 0;
        lastReport = start = System.currentTimeMillis();
        for (FileInfo fileInfo : files) {
            NodeRef nodeRef = fileInfo.getNodeRef();
            versionService.createVersion(nodeRef, null);
            ++count;
            long now = System.currentTimeMillis();
            if (now - lastReport <= 10000L) continue;
            long delta = now - start;
            double average = (double)delta / (double)count;
            System.out.println("Version: \n   Count:        " + count + " of " + fileCount + "\n" + "   Average (ms): " + average);
            lastReport = now;
        }
        System.out.println("Finished: " + fileCount);
    }
}

