/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.repo.version.VersionModel;
import org.alfresco.repo.version.common.VersionHistoryImpl;
import org.alfresco.repo.version.common.VersionImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionDoesNotExistException;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.util.TempFileProvider;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class VersionHistoryImplTest
extends TestCase {
    private Version rootVersion = null;
    private Version childVersion1 = null;
    private Version childVersion2 = null;
    public static final String DESERIALIZE_V22SP4 = "classpath:version-history/VersionHistoryImplTest-testSerialize-V2.2.4.bin";
    public static final String DESERIALIZE_V310_DEV = "classpath:version-history/VersionHistoryImplTest-testSerialize-V3.1.0-dev.bin";
    public static final String DESERIALIZE_V310 = "classpath:version-history/VersionHistoryImplTest-testSerialize-V3.1.0.bin";

    protected void setUp() throws Exception {
        super.setUp();
        NodeRef nodeRef = new NodeRef(new StoreRef("workspace", "test"), "test");
        HashMap<String, Serializable> versionProperties1 = new HashMap<String, Serializable>();
        versionProperties1.put("versionLabel", (Serializable)((Object)"1"));
        versionProperties1.put(VersionModel.PROP_CREATED_DATE, new Date());
        versionProperties1.put("testProperty", (Serializable)((Object)"testValue"));
        this.rootVersion = new VersionImpl(versionProperties1, nodeRef);
        HashMap<String, Serializable> versionProperties2 = new HashMap<String, Serializable>();
        versionProperties2.put("versionLabel", (Serializable)((Object)"2"));
        versionProperties2.put(VersionModel.PROP_CREATED_DATE, new Date());
        versionProperties2.put("testProperty", (Serializable)((Object)"testValue"));
        this.childVersion1 = new VersionImpl(versionProperties2, nodeRef);
        HashMap<String, Serializable> versionProperties3 = new HashMap<String, Serializable>();
        versionProperties3.put("versionLabel", (Serializable)((Object)"3"));
        versionProperties3.put(VersionModel.PROP_CREATED_DATE, new Date());
        versionProperties3.put("testProperty", (Serializable)((Object)"testValue"));
        this.childVersion2 = new VersionImpl(versionProperties3, nodeRef);
    }

    public void testConstructor() {
        this.testContructorImpl();
    }

    private VersionHistoryImpl testContructorImpl() {
        VersionHistoryImpl vh = new VersionHistoryImpl(this.rootVersion);
        VersionHistoryImplTest.assertNotNull((Object)vh);
        return vh;
    }

    public void testRootVersionSpecified() {
        try {
            new VersionHistoryImpl(null);
            VersionHistoryImplTest.fail();
        }
        catch (VersionServiceException versionServiceException) {
            // empty catch block
        }
    }

    public void testGetRootVersion() {
        VersionHistoryImpl vh = this.testContructorImpl();
        Version rootVersion = vh.getRootVersion();
        VersionHistoryImplTest.assertNotNull((Object)rootVersion);
        VersionHistoryImplTest.assertEquals((Object)rootVersion, (Object)this.rootVersion);
    }

    public void testGetAllVersions() {
        VersionHistoryImpl vh = this.testAddVersionImpl();
        Collection<Version> allVersions = vh.getAllVersions();
        VersionHistoryImplTest.assertNotNull(allVersions);
        VersionHistoryImplTest.assertEquals((int)3, (int)allVersions.size());
    }

    public void testAddVersion() {
        this.testAddVersionImpl();
    }

    private VersionHistoryImpl testAddVersionImpl() {
        VersionHistoryImpl vh = this.testContructorImpl();
        Version rootVersion = vh.getRootVersion();
        vh.addVersion(this.childVersion1, rootVersion);
        vh.addVersion(this.childVersion2, rootVersion);
        return vh;
    }

    public void testGetPredecessor() {
        VersionHistoryImpl vh = this.testAddVersionImpl();
        Version version1 = vh.getPredecessor(this.childVersion1);
        VersionHistoryImplTest.assertEquals((String)version1.getVersionLabel(), (String)this.rootVersion.getVersionLabel());
        Version version2 = vh.getPredecessor(this.childVersion2);
        VersionHistoryImplTest.assertEquals((String)version2.getVersionLabel(), (String)this.rootVersion.getVersionLabel());
        Version version3 = vh.getPredecessor(this.rootVersion);
        VersionHistoryImplTest.assertNull((Object)version3);
        try {
            Version version4 = vh.getPredecessor(null);
            VersionHistoryImplTest.assertNull((Object)version4);
        }
        catch (Exception exception) {
            VersionHistoryImplTest.fail((String)"Should continue by returning null.");
        }
    }

    public void testGetSuccessors() {
        VersionHistoryImpl vh = this.testAddVersionImpl();
        Collection<Version> versions1 = vh.getSuccessors(this.rootVersion);
        VersionHistoryImplTest.assertNotNull(versions1);
        VersionHistoryImplTest.assertEquals((int)versions1.size(), (int)2);
        for (Version version : versions1) {
            String versionLabel = version.getVersionLabel();
            if (versionLabel == "2" || versionLabel == "3") continue;
            VersionHistoryImplTest.fail((String)"There is a version in this collection that should not be here.");
        }
        Collection<Version> versions2 = vh.getSuccessors(this.childVersion1);
        VersionHistoryImplTest.assertNotNull(versions2);
        VersionHistoryImplTest.assertTrue((boolean)versions2.isEmpty());
        Collection<Version> versions3 = vh.getSuccessors(this.childVersion2);
        VersionHistoryImplTest.assertNotNull(versions3);
        VersionHistoryImplTest.assertTrue((boolean)versions3.isEmpty());
    }

    public void testGetVersion() {
        VersionHistoryImpl vh = this.testAddVersionImpl();
        Version version1 = vh.getVersion("1");
        VersionHistoryImplTest.assertEquals((String)version1.getVersionLabel(), (String)this.rootVersion.getVersionLabel());
        Version version2 = vh.getVersion("2");
        VersionHistoryImplTest.assertEquals((String)version2.getVersionLabel(), (String)this.childVersion1.getVersionLabel());
        Version version3 = vh.getVersion("3");
        VersionHistoryImplTest.assertEquals((String)version3.getVersionLabel(), (String)this.childVersion2.getVersionLabel());
        try {
            vh.getVersion("invalidLabel");
            VersionHistoryImplTest.fail((String)"An exception should have been thrown if the version can not be retrieved.");
        }
        catch (VersionDoesNotExistException exception) {
            System.out.println("Error message: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSerialize() throws Exception {
        VersionHistoryImpl vhObj;
        File file = TempFileProvider.createTempFile((String)this.getName(), (String)".bin");
        System.out.println("Test " + this.getName() + " writing to " + file.getPath());
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(file));
        VersionHistoryImpl vh = this.testAddVersionImpl();
        try {
            os.writeObject(vh);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                os.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            os.close();
        }
        catch (Throwable e) {}
        ObjectInputStream is = new ObjectInputStream(new FileInputStream(file));
        try {
            vhObj = (VersionHistoryImpl)is.readObject();
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {
                is.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            is.close();
        }
        catch (Throwable e) {}
        VersionHistoryImplTest.assertNotNull((Object)vhObj);
        VersionHistoryImplTest.assertNotNull((String)"No root version", (Object)vhObj.getRootVersion());
        VersionHistoryImplTest.assertEquals((String)"Deserialized object does not match original", (Object)vh.getRootVersion().getFrozenStateNodeRef(), (Object)vhObj.getRootVersion().getFrozenStateNodeRef());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeserializeV22SP4() throws Exception {
        String[] resourceLocations;
        for (String resourceLocation : resourceLocations = new String[]{DESERIALIZE_V22SP4, DESERIALIZE_V310_DEV, DESERIALIZE_V310}) {
            Throwable e2;
            Object var10_9;
            Resource resource = new DefaultResourceLoader().getResource(resourceLocation);
            VersionHistoryImplTest.assertNotNull((String)("Unable to find " + resourceLocation), (Object)resource);
            VersionHistoryImplTest.assertTrue((String)("Unable to find " + resourceLocation), (boolean)resource.exists());
            ObjectInputStream is = new ObjectInputStream(resource.getInputStream());
            try {
                VersionHistoryImpl vhObj = (VersionHistoryImpl)is.readObject();
                var10_9 = null;
            }
            catch (Throwable throwable) {
                var10_9 = null;
                try {
                    is.close();
                }
                catch (Throwable e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (Throwable e2) {}
        }
    }
}

