/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;

public class WorkflowServiceImplTest
extends BaseSpringTest {
    WorkflowService workflowService;
    NodeService nodeService;

    protected void onSetUpInTransaction() throws Exception {
        this.workflowService = (WorkflowService)this.applicationContext.getBean(ServiceRegistry.WORKFLOW_SERVICE.getLocalName());
        this.nodeService = (NodeService)this.applicationContext.getBean(ServiceRegistry.NODE_SERVICE.getLocalName());
        AuthenticationComponent auth = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        auth.setSystemUserAsCurrentUser();
    }

    public void testGetWorkflowDefinitions() {
        List<WorkflowDefinition> workflowDefs = this.workflowService.getDefinitions();
        WorkflowServiceImplTest.assertNotNull(workflowDefs);
        WorkflowServiceImplTest.assertTrue((workflowDefs.size() > 0 ? 1 : 0) != 0);
    }

    public void testStartWorkflow() {
        List<WorkflowDefinition> workflowDefs = this.workflowService.getDefinitions();
        WorkflowServiceImplTest.assertNotNull(workflowDefs);
        WorkflowServiceImplTest.assertTrue((workflowDefs.size() > 0 ? 1 : 0) != 0);
        WorkflowDefinition workflowDef = workflowDefs.get(0);
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.id, null);
        WorkflowServiceImplTest.assertNotNull((Object)path);
        WorkflowServiceImplTest.assertTrue((boolean)path.active);
        WorkflowServiceImplTest.assertNotNull((Object)path.node);
        WorkflowServiceImplTest.assertNotNull((Object)path.instance);
        WorkflowServiceImplTest.assertEquals((String)workflowDef.id, (String)path.instance.definition.id);
    }

    public void testWorkflowPackage() {
        NodeRef nodeRef = this.workflowService.createPackage(null);
        WorkflowServiceImplTest.assertNotNull((Object)nodeRef);
        WorkflowServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, WorkflowModel.ASPECT_WORKFLOW_PACKAGE));
    }

    public void testQueryTasks() {
        WorkflowTaskQuery filter = new WorkflowTaskQuery();
        filter.setTaskName(QName.createQName((String)"{http://www.alfresco.org/model/wcmworkflow/1.0}submitpendingTask"));
        filter.setTaskState(WorkflowTaskState.COMPLETED);
        HashMap<QName, Object> taskProps = new HashMap<QName, Object>();
        taskProps.put(QName.createQName((String)"{http://www.alfresco.org/model/bpm/1.0}workflowDescription"), "Test5");
        filter.setTaskCustomProps(taskProps);
        filter.setProcessId("jbpm$48");
        filter.setProcessName(QName.createQName((String)"{http://www.alfresco.org/model/wcmworkflow/1.0}submit"));
        HashMap<QName, Object> procProps = new HashMap<QName, Object>();
        procProps.put(QName.createQName((String)"{http://www.alfresco.org/model/bpm/1.0}workflowDescription"), "Test5");
        procProps.put(QName.createQName((String)"companyhome"), new NodeRef("workspace://SpacesStore/3df8a9d0-ff04-11db-98da-a3c3f3149ea5"));
        filter.setProcessCustomProps(procProps);
        filter.setOrderBy(new WorkflowTaskQuery.OrderBy[]{WorkflowTaskQuery.OrderBy.TaskName_Asc, WorkflowTaskQuery.OrderBy.TaskState_Asc});
        List<WorkflowTask> tasks = this.workflowService.queryTasks(filter);
        System.out.println("Found " + tasks.size() + " tasks.");
        for (WorkflowTask task : tasks) {
            System.out.println(task.toString());
        }
    }

    public void testAssociateWorkflowPackage() {
        NodeRef rootRef = this.nodeService.getRootNode(new StoreRef("workspace", "SpacesStore"));
        NodeRef nodeRef = this.workflowService.createPackage(null);
        WorkflowServiceImplTest.assertNotNull((Object)nodeRef);
        WorkflowServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, WorkflowModel.ASPECT_WORKFLOW_PACKAGE));
        ChildAssociationRef childAssoc = this.nodeService.createNode(rootRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)"test"), ContentModel.TYPE_CONTENT, null);
        List<WorkflowInstance> exisingInstances = this.workflowService.getWorkflowsForContent(childAssoc.getChildRef(), true);
        int size = 0;
        if (exisingInstances != null) {
            size = exisingInstances.size();
        }
        this.nodeService.addChild(nodeRef, childAssoc.getChildRef(), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"cm", (String)"test123"));
        List<WorkflowDefinition> workflowDefs = this.workflowService.getDefinitions();
        WorkflowServiceImplTest.assertNotNull(workflowDefs);
        WorkflowServiceImplTest.assertTrue((workflowDefs.size() > 0 ? 1 : 0) != 0);
        WorkflowDefinition workflowDef = workflowDefs.get(0);
        HashMap<QName, Serializable> parameters = new HashMap<QName, Serializable>();
        parameters.put(WorkflowModel.ASSOC_PACKAGE, (Serializable)nodeRef);
        WorkflowPath path = this.workflowService.startWorkflow(workflowDef.id, parameters);
        WorkflowServiceImplTest.assertNotNull((Object)path);
        WorkflowServiceImplTest.assertTrue((boolean)path.active);
        WorkflowServiceImplTest.assertNotNull((Object)path.node);
        WorkflowServiceImplTest.assertNotNull((Object)path.instance);
        WorkflowServiceImplTest.assertEquals((String)workflowDef.id, (String)path.instance.definition.id);
        String workflowDefId = (String)((Object)this.nodeService.getProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_DEFINITION_ID));
        WorkflowServiceImplTest.assertEquals((String)workflowDefId, (String)workflowDef.id);
        String workflowDefName = (String)((Object)this.nodeService.getProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_DEFINITION_NAME));
        WorkflowServiceImplTest.assertEquals((String)workflowDefName, (String)workflowDef.name);
        String workflowInstanceId = (String)((Object)this.nodeService.getProperty(nodeRef, WorkflowModel.PROP_WORKFLOW_INSTANCE_ID));
        WorkflowServiceImplTest.assertEquals((String)workflowInstanceId, (String)path.instance.id);
        List<WorkflowInstance> instances = this.workflowService.getWorkflowsForContent(childAssoc.getChildRef(), true);
        WorkflowServiceImplTest.assertNotNull(instances);
        WorkflowServiceImplTest.assertEquals((int)(size + 1), (int)instances.size());
        for (WorkflowInstance instance : instances) {
            boolean fNew = true;
            Iterator<WorkflowInstance> i$ = exisingInstances.iterator();
            if (i$.hasNext()) {
                WorkflowInstance exisingInstance = i$.next();
                fNew = !instance.id.equals(exisingInstance.id);
            }
            if (!fNew) continue;
            WorkflowServiceImplTest.assertEquals((String)instance.id, (String)path.instance.id);
        }
        List<WorkflowInstance> completedInstances = this.workflowService.getWorkflowsForContent(childAssoc.getChildRef(), false);
        WorkflowServiceImplTest.assertNotNull(completedInstances);
        WorkflowServiceImplTest.assertEquals((int)0, (int)completedInstances.size());
    }

    public void testGetWorkflowTaskDefinitions() {
        List<WorkflowDefinition> workflowDefs = this.workflowService.getDefinitions();
        WorkflowServiceImplTest.assertNotNull(workflowDefs);
        WorkflowServiceImplTest.assertTrue((workflowDefs.size() > 0 ? 1 : 0) != 0);
        for (WorkflowDefinition workflowDef : workflowDefs) {
            List<WorkflowTaskDefinition> workflowTaskDefs = this.workflowService.getTaskDefinitions(workflowDef.getId());
            WorkflowServiceImplTest.assertNotNull(workflowTaskDefs);
            WorkflowServiceImplTest.assertTrue((workflowTaskDefs.size() > 0 ? 1 : 0) != 0);
        }
    }
}

