/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.alfresco.repo.workflow.jbpm.AlfrescoJavaScript;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.repo.workflow.jbpm.JBPMSpringActionHandler;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.dom4j.Element;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.instantiation.FieldInstantiator;
import org.springframework.beans.factory.BeanFactory;

public class ForEachFork
extends JBPMSpringActionHandler {
    private static final long serialVersionUID = 4643103713602441652L;
    private ServiceRegistry services;
    private Element foreach;
    private String var;

    protected void initialiseHandler(BeanFactory factory) {
        this.services = (ServiceRegistry)factory.getBean("ServiceRegistry");
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        if (this.foreach == null) {
            throw new WorkflowException("forEach has not been provided");
        }
        ArrayList<Object> forEachColl = null;
        String forEachCollStr = this.foreach.getTextTrim();
        if (forEachCollStr != null) {
            if (forEachCollStr.startsWith("#{")) {
                String expression = forEachCollStr.substring(2, forEachCollStr.length() - 1);
                Object eval = AlfrescoJavaScript.executeScript(executionContext, this.services, expression, null);
                if (eval == null) {
                    throw new WorkflowException("forEach expression '" + forEachCollStr + "' evaluates to null");
                }
                if (eval instanceof String) {
                    String[] forEachStrs = ((String)eval).trim().split(",");
                    forEachColl = new ArrayList<Object>(forEachStrs.length);
                    for (String forEachStr : forEachStrs) {
                        forEachColl.add(forEachStr);
                    }
                } else if (eval instanceof Serializable[]) {
                    Serializable[] nodes = (Serializable[])eval;
                    forEachColl = new ArrayList(nodes.length);
                    for (Serializable node : nodes) {
                        if (!(node instanceof NodeRef)) continue;
                        forEachColl.add(new JBPMNode((NodeRef)node, this.services));
                    }
                } else if (eval instanceof Collection) {
                    forEachColl = (List)eval;
                }
            }
        } else {
            forEachColl = (ArrayList<Object>)FieldInstantiator.getValue(List.class, (Element)this.foreach);
        }
        if (this.var == null || this.var.length() == 0) {
            throw new WorkflowException("forEach variable name has not been provided");
        }
        Token rootToken = executionContext.getToken();
        Node node = executionContext.getNode();
        ArrayList<ForkedTransition> forkTransitions = new ArrayList<ForkedTransition>();
        for (int i = 0; i < node.getLeavingTransitions().size(); ++i) {
            Transition transition = (Transition)node.getLeavingTransitions().get(i);
            for (int iVar = 0; iVar < forEachColl.size(); ++iVar) {
                String tokenName = this.getTokenName(rootToken, transition.getName(), iVar);
                Token loopToken = new Token(rootToken, tokenName);
                loopToken.setTerminationImplicit(true);
                executionContext.getJbpmContext().getSession().save((Object)loopToken);
                ExecutionContext newExecutionContext = new ExecutionContext(loopToken);
                newExecutionContext.getContextInstance().createVariable(this.var, forEachColl.get(iVar), loopToken);
                ForkedTransition forkTransition = new ForkedTransition();
                forkTransition.executionContext = newExecutionContext;
                forkTransition.transition = transition;
                forkTransitions.add(forkTransition);
            }
        }
        for (ForkedTransition forkTransition : forkTransitions) {
            node.leave(forkTransition.executionContext, forkTransition.transition);
        }
    }

    protected String getTokenName(Token parent, String transitionName, int loopIndex) {
        String tokenName = null;
        if (transitionName != null && transitionName.length() > 0) {
            if (!parent.hasChild(transitionName)) {
                tokenName = transitionName;
            } else {
                int i = 2;
                tokenName = transitionName + Integer.toString(i);
                while (parent.hasChild(tokenName)) {
                    tokenName = transitionName + Integer.toString(++i);
                }
            }
        } else {
            int size = parent.getChildren() != null ? parent.getChildren().size() + 1 : 1;
            tokenName = "FOREACHFORK" + Integer.toString(size);
        }
        return tokenName + "." + loopIndex;
    }

    private class ForkedTransition {
        private ExecutionContext executionContext;
        private Transition transition;

        private ForkedTransition() {
        }
    }
}

