/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jbpm;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.workflow.jbpm.JBPMNode;
import org.alfresco.repo.workflow.jbpm.JBPMNodeList;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.jbpm.context.exe.converter.SerializableToByteArrayConverter;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springmodules.workflow.jbpm31.JbpmFactoryLocator;

public class NodeListConverter
extends SerializableToByteArrayConverter {
    private static final long serialVersionUID = 1L;
    private static BeanFactoryLocator jbpmFactoryLocator = new JbpmFactoryLocator();

    public boolean supports(Object value) {
        if (value == null) {
            return true;
        }
        return value.getClass() == JBPMNodeList.class;
    }

    public Object convert(Object o) {
        Object converted = null;
        if (o != null) {
            JBPMNodeList nodes = (JBPMNodeList)o;
            ArrayList<NodeRef> values = new ArrayList<NodeRef>(nodes.size());
            for (JBPMNode node : nodes) {
                values.add(node.getNodeRef());
            }
            converted = super.convert(values);
        }
        return converted;
    }

    public Object revert(Object o) {
        JBPMNodeList reverted = null;
        if (o != null) {
            List nodeRefs = (List)super.revert(o);
            BeanFactoryReference factory = jbpmFactoryLocator.useBeanFactory(null);
            ServiceRegistry serviceRegistry = (ServiceRegistry)factory.getFactory().getBean("ServiceRegistry");
            JBPMNodeList nodes = new JBPMNodeList();
            for (NodeRef nodeRef : nodeRefs) {
                nodes.add(new JBPMNode(nodeRef, serviceRegistry));
            }
            reverted = nodes;
        }
        return reverted;
    }
}

