/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.security;

import java.util.Set;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.service.Auditable;
import org.alfresco.service.PublicService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicService
public interface AuthenticationService {
    @Auditable(parameters={"userName"})
    public boolean getAuthenticationEnabled(String var1) throws AuthenticationException;

    @Auditable(parameters={"userName", "password"}, recordable={true, false})
    public void authenticate(String var1, char[] var2) throws AuthenticationException;

    @Auditable
    public void authenticateAsGuest() throws AuthenticationException;

    @Auditable
    public boolean guestUserAuthenticationAllowed();

    @Auditable(parameters={"userName"})
    public boolean authenticationExists(String var1);

    @Auditable
    public String getCurrentUserName() throws AuthenticationException;

    @Auditable(parameters={"userName"})
    public void invalidateUserSession(String var1) throws AuthenticationException;

    @Auditable(parameters={"ticket"}, recordable={false})
    public void invalidateTicket(String var1) throws AuthenticationException;

    @Auditable(parameters={"ticket"}, recordable={false})
    public void validate(String var1) throws AuthenticationException;

    @Auditable
    public String getCurrentTicket();

    @Auditable
    public String getNewTicket();

    @Auditable
    public void clearCurrentSecurityContext();

    @Auditable
    public boolean isCurrentUserTheSystemUser();

    @Auditable
    public Set<String> getDomains();

    @Auditable
    public Set<String> getDomainsThatAllowUserCreation();

    @Auditable
    public Set<String> getDomainsThatAllowUserDeletion();

    @Auditable
    public Set<String> getDomiansThatAllowUserPasswordChanges();

    @Auditable
    public Set<String> getDefaultAdministratorUserNames();

    @Auditable
    public Set<String> getDefaultGuestUserNames();
}

