/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import junit.framework.TestCase;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public abstract class BaseAlfrescoTestCase
extends TestCase {
    protected ApplicationContext ctx;
    protected ServiceRegistry serviceRegistry;
    protected NodeService nodeService;
    protected ContentService contentService;
    protected AuthenticationComponent authenticationComponent;
    protected StoreRef storeRef;
    protected NodeRef rootNodeRef;
    protected ActionService actionService;
    protected TransactionService transactionService;

    protected void setUpContext() {
        this.ctx = ApplicationContextHelper.getApplicationContext();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setUpContext();
        this.serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.nodeService = this.serviceRegistry.getNodeService();
        this.contentService = this.serviceRegistry.getContentService();
        this.authenticationComponent = (AuthenticationComponent)this.ctx.getBean("authenticationComponent");
        this.actionService = (ActionService)this.ctx.getBean("actionService");
        this.transactionService = this.serviceRegistry.getTransactionService();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
    }

    protected void tearDown() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        super.tearDown();
    }
}

