/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.encoding;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.alfresco.encoding.CharactersetFinder;
import org.alfresco.service.cmr.repository.MimetypeService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentCharsetFinder {
    private Charset defaultCharset = Charset.defaultCharset();
    private MimetypeService mimetypeService;
    private List<CharactersetFinder> charactersetFinders;

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = Charset.forName(defaultCharset);
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setCharactersetFinders(List<CharactersetFinder> charactersetFinders) {
        this.charactersetFinders = charactersetFinders;
    }

    public Charset getCharset(InputStream is, String mimetype) {
        CharactersetFinder finder;
        if (mimetype == null) {
            return this.defaultCharset;
        }
        if (!this.mimetypeService.isText(mimetype)) {
            return this.defaultCharset;
        }
        Charset charset = null;
        Iterator<CharactersetFinder> i$ = this.charactersetFinders.iterator();
        while (i$.hasNext() && (charset = (finder = i$.next()).detectCharset(is)) == null) {
        }
        if (charset == null) {
            return this.defaultCharset;
        }
        return charset;
    }
}

