/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.analysis.AnalysisException;
import org.alfresco.repo.search.impl.lucene.analysis.MLTokenDuplicator;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.springframework.extensions.surf.util.I18NUtil;

public class MLAnalayser
extends Analyzer {
    private static Log s_logger = LogFactory.getLog(MLAnalayser.class);
    private DictionaryService dictionaryService;
    private HashMap<Locale, Analyzer> analysers = new HashMap();
    private MLAnalysisMode mlAnalaysisMode;

    public MLAnalayser(DictionaryService dictionaryService, MLAnalysisMode mlAnalaysisMode) {
        this.dictionaryService = dictionaryService;
        this.mlAnalaysisMode = mlAnalaysisMode;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        if (!(reader instanceof BufferedReader)) {
            BufferedReader breader = new BufferedReader(reader);
            try {
                if (!breader.markSupported()) {
                    throw new AnalysisException("Multilingual tokenisation requires a reader that supports marks and reset");
                }
                breader.mark(100);
                StringBuilder builder = new StringBuilder();
                if (breader.read() == 0) {
                    char c;
                    String language = "";
                    String country = "";
                    String varient = "";
                    int count = 0;
                    while ((c = (char)breader.read()) != '\u0000') {
                        if (count++ > 99) {
                            breader.reset();
                            return this.getDefaultAnalyser().tokenStream(fieldName, (Reader)breader);
                        }
                        if (c == '_') {
                            if (language.length() == 0) {
                                language = builder.toString();
                            } else if (country.length() == 0) {
                                country = builder.toString();
                            } else if (varient.length() == 0) {
                                varient = builder.toString();
                            } else {
                                breader.reset();
                                return this.getDefaultAnalyser().tokenStream(fieldName, (Reader)breader);
                            }
                            builder = new StringBuilder();
                            continue;
                        }
                        builder.append(c);
                    }
                    if (builder.length() > 0) {
                        if (language.length() == 0) {
                            language = builder.toString();
                        } else if (country.length() == 0) {
                            country = builder.toString();
                        } else if (varient.length() == 0) {
                            varient = builder.toString();
                        } else {
                            breader.reset();
                            return this.getDefaultAnalyser().tokenStream(fieldName, (Reader)breader);
                        }
                    }
                    Locale locale = new Locale(language, country, varient);
                    return new MLTokenDuplicator(this.getAnalyser(locale).tokenStream(fieldName, (Reader)breader), locale, breader, this.mlAnalaysisMode);
                }
                breader.reset();
                return this.getDefaultAnalyser().tokenStream(fieldName, (Reader)breader);
            }
            catch (IOException io) {
                try {
                    breader.reset();
                }
                catch (IOException e) {
                    throw new AnalysisException("Failed to reset buffered reader - token stream will be invalid", e);
                }
                return this.getDefaultAnalyser().tokenStream(fieldName, (Reader)breader);
            }
        }
        throw new AnalysisException("Multilingual tokenisation requires a buffered reader");
    }

    private Analyzer getDefaultAnalyser() {
        return this.getAnalyser(I18NUtil.getLocale());
    }

    private Analyzer getAnalyser(Locale locale) {
        Analyzer analyser = this.analysers.get(locale);
        if (analyser == null) {
            analyser = this.findAnalyser(locale);
        }
        return analyser;
    }

    private Analyzer findAnalyser(Locale locale) {
        Analyzer analyser = this.loadAnalyzer(locale);
        this.analysers.put(locale, analyser);
        return analyser;
    }

    private Analyzer loadAnalyzer(Locale locale) {
        DataTypeDefinition dataType = this.dictionaryService.getDataType(DataTypeDefinition.TEXT);
        String analyserClassName = dataType.getAnalyserClassName(locale);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Loading " + analyserClassName + " for " + locale));
        }
        try {
            Class<?> clazz = Class.forName(analyserClassName);
            Analyzer analyser = (Analyzer)clazz.newInstance();
            return analyser;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + dataType.getName() + " using " + analyserClassName);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + dataType.getName() + " using " + analyserClassName);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + dataType.getName() + " using " + analyserClassName);
        }
    }
}

