/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.search;

import java.io.Serializable;
import java.util.List;
import org.alfresco.service.Auditable;
import org.alfresco.service.PublicService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.XPathException;
import org.alfresco.service.cmr.search.QueryParameter;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicService
public interface SearchService {
    public static final String LANGUAGE_LUCENE = "lucene";
    public static final String LANGUAGE_XPATH = "xpath";
    public static final String LANGUAGE_JCR_XPATH = "jcr-xpath";
    public static final String LANGUAGE_FTS_ALFRESCO = "fts-alfresco";
    public static final String LANGUAGE_CMIS_STRICT = "cmis-strict";
    public static final String LANGUAGE_CMIS_ALFRESCO = "cmis-alfresco";

    @Auditable(parameters={"store", "language", "query"})
    public ResultSet query(StoreRef var1, String var2, String var3);

    @Auditable(parameters={"store", "language", "query", "queryParameterDefinitions"})
    public ResultSet query(StoreRef var1, String var2, String var3, QueryParameterDefinition[] var4);

    @Auditable(parameters={"store", "queryId", "queryParameters"})
    public ResultSet query(StoreRef var1, QName var2, QueryParameter[] var3);

    @Auditable(parameters={"searchParameters"})
    public ResultSet query(SearchParameters var1);

    @Auditable(parameters={"contextNodeRef", "xpath", "parameters", "namespacePrefixResolver", "followAllParentLinks"}, recordable={true, true, true, false, true})
    public List<NodeRef> selectNodes(NodeRef var1, String var2, QueryParameterDefinition[] var3, NamespacePrefixResolver var4, boolean var5) throws InvalidNodeRefException, XPathException;

    @Auditable(parameters={"contextNodeRef", "xpath", "parameters", "namespacePrefixResolver", "followAllParentLinks", "language"}, recordable={true, true, true, false, true, true})
    public List<NodeRef> selectNodes(NodeRef var1, String var2, QueryParameterDefinition[] var3, NamespacePrefixResolver var4, boolean var5, String var6) throws InvalidNodeRefException, XPathException;

    @Auditable(parameters={"contextNodeRef", "xpath", "parameters", "namespacePrefixResolver", "followAllParentLinks"}, recordable={true, true, true, false, true})
    public List<Serializable> selectProperties(NodeRef var1, String var2, QueryParameterDefinition[] var3, NamespacePrefixResolver var4, boolean var5) throws InvalidNodeRefException, XPathException;

    @Auditable(parameters={"contextNodeRef", "xpath", "parameters", "namespacePrefixResolver", "followAllParentLinks", "language"}, recordable={true, true, true, false, true, true})
    public List<Serializable> selectProperties(NodeRef var1, String var2, QueryParameterDefinition[] var3, NamespacePrefixResolver var4, boolean var5, String var6) throws InvalidNodeRefException, XPathException;

    @Auditable(parameters={"nodeRef", "propertyQName", "googleLikePattern"})
    public boolean contains(NodeRef var1, QName var2, String var3) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef", "propertyQName", "googleLikePattern", "defaultOperator"})
    public boolean contains(NodeRef var1, QName var2, String var3, SearchParameters.Operator var4) throws InvalidNodeRefException;

    @Auditable(parameters={"nodeRef", "propertyQName", "sqlLikePattern", "includeFTS"})
    public boolean like(NodeRef var1, QName var2, String var3, boolean var4) throws InvalidNodeRefException;
}

