/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.security;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AuthorityType {
    ADMIN{

        public boolean isFixedString() {
            return true;
        }

        public String getFixedString() {
            return "ROLE_ADMINISTRATOR";
        }

        public boolean isPrefixed() {
            return false;
        }

        public String getPrefixString() {
            return "";
        }

        public int getOrderPosition() {
            return 0;
        }
    }
    ,
    EVERYONE{

        public boolean isFixedString() {
            return true;
        }

        public String getFixedString() {
            return "GROUP_EVERYONE";
        }

        public boolean isPrefixed() {
            return false;
        }

        public String getPrefixString() {
            return "";
        }

        public int getOrderPosition() {
            return 1;
        }
    }
    ,
    OWNER{

        public boolean isFixedString() {
            return true;
        }

        public String getFixedString() {
            return "ROLE_OWNER";
        }

        public boolean isPrefixed() {
            return false;
        }

        public String getPrefixString() {
            return "";
        }

        public int getOrderPosition() {
            return 2;
        }
    }
    ,
    GUEST{

        public boolean isFixedString() {
            return true;
        }

        public String getFixedString() {
            return "ROLE_GUEST";
        }

        public boolean isPrefixed() {
            return false;
        }

        public String getPrefixString() {
            return "";
        }

        public int getOrderPosition() {
            return 3;
        }
    }
    ,
    GROUP{

        public boolean isFixedString() {
            return false;
        }

        public String getFixedString() {
            return "";
        }

        public boolean isPrefixed() {
            return true;
        }

        public String getPrefixString() {
            return "GROUP_";
        }

        public int getOrderPosition() {
            return 4;
        }
    }
    ,
    ROLE{

        public boolean isFixedString() {
            return false;
        }

        public String getFixedString() {
            return "";
        }

        public boolean isPrefixed() {
            return true;
        }

        public String getPrefixString() {
            return "ROLE_";
        }

        public int getOrderPosition() {
            return 5;
        }
    }
    ,
    USER{

        public boolean isFixedString() {
            return false;
        }

        public String getFixedString() {
            return "";
        }

        public boolean isPrefixed() {
            return false;
        }

        public String getPrefixString() {
            return "";
        }

        public int getOrderPosition() {
            return 6;
        }
    }
    ,
    WILDCARD{

        public boolean isFixedString() {
            return false;
        }

        public String getFixedString() {
            return "";
        }

        public boolean isPrefixed() {
            return false;
        }

        public String getPrefixString() {
            return "";
        }

        public int getOrderPosition() {
            return 7;
        }
    };


    public abstract boolean isFixedString();

    public abstract String getFixedString();

    public abstract boolean isPrefixed();

    public abstract String getPrefixString();

    public abstract int getOrderPosition();

    public boolean equals(String authority) {
        return this.equals((Object)AuthorityType.getAuthorityType(authority));
    }

    public static AuthorityType getAuthorityType(String authority) {
        AuthorityType authorityType;
        if (null == authority) {
            authorityType = WILDCARD;
        } else {
            if (authority.equals("ROLE_ADMINISTRATOR")) {
                authorityType = ADMIN;
            }
            authorityType = authority.equals("GROUP_EVERYONE") ? EVERYONE : (authority.equals("ROLE_OWNER") ? OWNER : (authority.equalsIgnoreCase("ROLE_GUEST") ? GUEST : (authority.startsWith("GROUP_") ? GROUP : (authority.startsWith("ROLE_") ? ROLE : USER))));
        }
        return authorityType;
    }
}

