/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.core.convert.support.GenericConversionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectToCollectionConverter
implements ConditionalGenericConverter {
    private final GenericConversionService conversionService;

    public ObjectToCollectionConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Collection.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService.canConvert(sourceType, targetType.getElementTypeDescriptor());
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        Collection target = CollectionFactory.createCollection(targetType.getType(), 1);
        TypeDescriptor targetElementType = targetType.getElementTypeDescriptor();
        if (targetElementType == TypeDescriptor.NULL || sourceType.isAssignableTo(targetElementType)) {
            target.add(source);
        } else {
            GenericConverter converter = this.conversionService.getConverter(sourceType, targetElementType);
            if (converter == null) {
                throw new ConverterNotFoundException(sourceType, targetElementType);
            }
            target.add(ConversionUtils.invokeConverter(converter, source, sourceType, targetElementType));
        }
        return target;
    }
}

