/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.server;

import java.io.IOException;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.jk.core.JkHandler;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;
import org.apache.jk.server.JkMain;

public class JkCoyoteHandler
extends JkHandler
implements ProtocolHandler {
    protected static Log log = LogFactory.getLog(JkCoyoteHandler.class);
    private boolean paused = false;
    int epNote;
    Adapter adapter;
    protected JkMain jkMain = null;
    boolean started = false;

    public void setProperty(String name, String value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("setProperty " + name + " " + value));
        }
        this.getJkMain().setProperty(name, value);
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public Iterator getAttributeNames() {
        return this.properties.keySet().iterator();
    }

    public void setAttribute(String name, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setAttribute " + name + " " + value));
        }
        if (value instanceof String) {
            this.setProperty(name, (String)value);
        }
    }

    public Object getAttribute(String name) {
        return this.getJkMain().getProperty(name);
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public JkMain getJkMain() {
        if (this.jkMain == null) {
            this.jkMain = new JkMain();
            this.jkMain.setWorkerEnv(this.wEnv);
        }
        return this.jkMain;
    }

    public void init() {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.wEnv == null) {
            this.wEnv = this.getJkMain().getWorkerEnv();
            this.wEnv.addHandler("container", this);
        }
        try {
            this.getJkMain().init();
        }
        catch (Exception ex) {
            log.error((Object)"Error during init", (Throwable)ex);
        }
    }

    public void start() {
        try {
            if (this.oname != null && this.getJkMain().getDomain() == null) {
                try {
                    ObjectName jkmainOname = new ObjectName(this.oname.getDomain() + ":type=JkMain");
                    Registry.getRegistry(null, null).registerComponent((Object)this.getJkMain(), jkmainOname, "JkMain");
                }
                catch (Exception e) {
                    log.error((Object)("Error registering jkmain " + e));
                }
            }
            this.getJkMain().start();
        }
        catch (Exception ex) {
            log.error((Object)"Error during startup", (Throwable)ex);
        }
    }

    public void pause() throws Exception {
        if (!this.paused) {
            this.paused = true;
            this.getJkMain().pause();
        }
    }

    public void resume() throws Exception {
        if (this.paused) {
            this.paused = false;
            this.getJkMain().resume();
        }
    }

    public void destroy() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.getJkMain().stop();
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        if (ep.isLogTimeEnabled()) {
            ep.setLong(1, System.currentTimeMillis());
        }
        Request req = ep.getRequest();
        Response res = req.getResponse();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invoke " + req + " " + res + " " + req.requestURI().toString()));
        }
        res.setNote(this.epNote, (Object)ep);
        ep.setStatus(1);
        RequestInfo rp = req.getRequestProcessor();
        rp.setStage(3);
        try {
            this.adapter.service(req, res);
        }
        catch (Exception ex) {
            log.info((Object)("Error servicing request " + req), (Throwable)ex);
        }
        if (ep.getStatus() != 2) {
            res.finish();
        }
        req.recycle();
        req.updateCounters();
        res.recycle();
        ep.recycle();
        if (ep.getStatus() == 3) {
            return 2;
        }
        ep.setStatus(0);
        rp.setStage(6);
        return 0;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName oname) throws Exception {
        this.name = "container";
        return super.preRegister(server, oname);
    }
}

